/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.docker;

import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.remoteRunRuntime.WrappedNotFoundException;
import com.intellij.docker.utils.RemoteDockerRuntimeUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerUtil;
import com.jetbrains.cidr.cpp.toolchains.docker.host.DockerHostBase;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.system.TarUtil;
import com.jetbrains.cidr.system.downloading.Downloader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0014J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0014J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/docker/DockerDownloader;", "Lcom/jetbrains/cidr/system/downloading/Downloader;", "machine", "Lcom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostBase;", "<init>", "(Lcom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostBase;)V", "downloadFile", "Ljava/nio/file/Path;", "remotePath", "", "localRoot", "downloadFolderWithResolvedSymlinks", "downloadImpl", "localPath", "intellij.clion.docker"})
@SourceDebugExtension(value={"SMAP\nDockerDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerDownloader.kt\ncom/jetbrains/cidr/cpp/toolchains/docker/DockerDownloader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n13#2:80\n*S KotlinDebug\n*F\n+ 1 DockerDownloader.kt\ncom/jetbrains/cidr/cpp/toolchains/docker/DockerDownloader\n*L\n42#1:80\n*E\n"})
public final class DockerDownloader
extends Downloader {
    @NotNull
    private final DockerHostBase<?> machine;

    public DockerDownloader(@NotNull DockerHostBase<?> machine) {
        Intrinsics.checkNotNullParameter(machine, (String)"machine");
        this.machine = machine;
    }

    @Nullable
    protected Path downloadFile(@NotNull String remotePath, @NotNull String localRoot) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
            Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
            String[] stringArray = new String[]{localRoot, RemoteUtil.suggestLocalPathName((String)remotePath)};
            String string = FileUtil.join((String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
            String downloadLocation = string;
            try {
                return this.downloadImpl(remotePath, downloadLocation);
            }
            catch (WrappedNotFoundException e) {
                CidrDockerUtil.LOG.warn("File not found: " + remotePath, (Throwable)e);
            }
            catch (Exception e) {
                if (e instanceof ControlFlowException) break block3;
                CidrDockerUtil.LOG.error("Download failed: " + remotePath, (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    protected Path downloadFolderWithResolvedSymlinks(@NotNull String remotePath, @NotNull String localRoot) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DockerDownloader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("DockerDownloader does not support downloadFolderWithResolvedSymlinks, falling back to downloadFile");
        return this.downloadFile(remotePath, localRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path downloadImpl(String remotePath, String localPath) throws ExecutionException, IOException, ServerRuntimeException {
        RemoteDockerRuntime dockerRuntime = CidrDockerUtil.getDockerRuntime(this.machine.getCredentialsHolder());
        String[] stringArray = new String[]{"/bin/true"};
        DockerAgentDeploymentConfigImpl config = CidrDockerUtil.getConfig(dockerRuntime, null, this.machine).withCommand(stringArray);
        RemoteDockerApplicationRuntime applicationRuntime = RemoteDockerApplicationRuntime.create((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)((DockerAgentDeploymentConfig)config));
        File localFilePath = new File(localPath);
        AtomicBoolean success = new AtomicBoolean();
        try {
            DockerAgentContainer dockerAgentContainer = applicationRuntime.getAgentContainer();
            Intrinsics.checkNotNullExpressionValue((Object)dockerAgentContainer, (String)"getAgentContainer(...)");
            RemoteDockerRuntimeUtil.download((DockerAgentContainer)dockerAgentContainer, (String)remotePath, (String)this.machine.getCredentialsHolder().getAccountName(), arg_0 -> DockerDownloader.downloadImpl$lambda$1(arg_0 -> DockerDownloader.downloadImpl$lambda$0(success, localFilePath, arg_0), arg_0));
        }
        finally {
            applicationRuntime.removeContainerWithVolumes();
        }
        if (success.get()) {
            return localFilePath.toPath();
        }
        return null;
    }

    private static final Unit downloadImpl$lambda$0(AtomicBoolean $success, File $localFilePath, File file) {
        $success.set(TarUtil.decompress((File)file, (File)$localFilePath.getParentFile()));
        return Unit.INSTANCE;
    }

    private static final void downloadImpl$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

