/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.docker;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.cpp.execution.debugger.CLionDebuggerKind;
import com.jetbrains.cidr.cpp.execution.debugger.backend.CLionGDBDriverConfiguration;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbWithGdbServerProcess;
import com.jetbrains.cidr.cpp.execution.remote.CLionRemoteExecutionHelperKt;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerBundle;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerProcessBuilder;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.TrivialRunParameters;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.remote.CidrRemoteDebugParameters;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0002\u001a$\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a8\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"PORT_SETTINGS_ID", "", "getGdbPort", "", "createGdbServerProcess", "Lcom/intellij/execution/process/BaseProcessHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "port", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "createGdbClientProcess", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/GdbWithGdbServerProcess;", "file", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "consoleBuilder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "intellij.clion.docker"})
public final class RunRosettaGDBExtensionKt {
    @NotNull
    private static final String PORT_SETTINGS_ID = "clion.docker.rosetta.gdb.port";

    private static final int getGdbPort() throws ExecutionException {
        int port = AdvancedSettings.Companion.getInt(PORT_SETTINGS_ID);
        if (port != -1) {
            return port;
        }
        try {
            return NetUtils.findAvailableSocketPort();
        }
        catch (IOException e) {
            throw new ExecutionException(CidrDockerBundle.message("rosetta.message.cannot.find.port", new Object[0]), (Throwable)e);
        }
    }

    private static final BaseProcessHandler<?> createGdbServerProcess(GeneralCommandLine commandLine, int port, CidrToolEnvironment environment) throws ExecutionException {
        environment.prepare(commandLine, CidrToolEnvironment.PrepareFor.RUN);
        CidrProcessBuilder cidrProcessBuilder = environment.getHostMachine().createProcessBuilder();
        Intrinsics.checkNotNull((Object)cidrProcessBuilder, (String)"null cannot be cast to non-null type com.jetbrains.cidr.cpp.toolchains.docker.DockerProcessBuilder");
        DockerProcessBuilder builder = (DockerProcessBuilder)cidrProcessBuilder;
        String string = "%d:%d";
        Object[] objectArray = new Object[]{port, port};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return builder.withPortBinding(string2).withEnvVar("ROSETTA_DEBUGSERVER_PORT", String.valueOf(port)).withRunDebugEnvSetup(true).build(commandLine);
    }

    private static final GdbWithGdbServerProcess createGdbClientProcess(Path file, int port, Project project, XDebugSession session, TextConsoleBuilder consoleBuilder, CidrToolEnvironment environment) throws ExecutionException {
        String string = "%s:%d";
        Object[] objectArray = new Object[]{NetUtils.getLocalHostString(), port};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        CidrRemoteDebugParameters parameters = new CidrRemoteDebugParameters(string2, ((Object)file).toString(), null, CLionRemoteExecutionHelperKt.getPathMappings((CidrToolEnvironment)environment), 0, null, 52, null);
        OSType oSType = OSType.getCurrent();
        Intrinsics.checkNotNullExpressionValue((Object)oSType, (String)"getCurrent(...)");
        CPPToolchains.Toolchain toolchain = CLionDebuggerKind.Bundled.GDB.INSTANCE.getOrCreateDebuggerToolchain(oSType);
        CLionGDBDriverConfiguration configuration = new CLionGDBDriverConfiguration(project, toolchain, false, false, 12, null);
        TrivialRunParameters runParameters = new TrivialRunParameters((DebuggerDriverConfiguration)configuration, configuration.createInstaller(new GeneralCommandLine()), null, 4, null);
        return (GdbWithGdbServerProcess)com.intellij.openapi.progress.CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GdbWithGdbServerProcess>, Object>(runParameters, parameters, session, consoleBuilder, null){
            int label;
            final /* synthetic */ TrivialRunParameters $runParameters;
            final /* synthetic */ CidrRemoteDebugParameters $parameters;
            final /* synthetic */ XDebugSession $session;
            final /* synthetic */ TextConsoleBuilder $consoleBuilder;
            {
                this.$runParameters = $runParameters;
                this.$parameters = $parameters;
                this.$session = $session;
                this.$consoleBuilder = $consoleBuilder;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GdbWithGdbServerProcess>, Object>(this.$runParameters, this.$parameters, this.$session, this.$consoleBuilder, null){
                            int label;
                            final /* synthetic */ TrivialRunParameters $runParameters;
                            final /* synthetic */ CidrRemoteDebugParameters $parameters;
                            final /* synthetic */ XDebugSession $session;
                            final /* synthetic */ TextConsoleBuilder $consoleBuilder;
                            {
                                this.$runParameters = $runParameters;
                                this.$parameters = $parameters;
                                this.$session = $session;
                                this.$consoleBuilder = $consoleBuilder;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        return new GdbWithGdbServerProcess((RunParameters)this.$runParameters, this.$parameters, this.$session, this.$consoleBuilder);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super GdbWithGdbServerProcess> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super GdbWithGdbServerProcess> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static final /* synthetic */ int access$getGdbPort() {
        return RunRosettaGDBExtensionKt.getGdbPort();
    }

    public static final /* synthetic */ BaseProcessHandler access$createGdbServerProcess(GeneralCommandLine commandLine, int port, CidrToolEnvironment environment) {
        return RunRosettaGDBExtensionKt.createGdbServerProcess(commandLine, port, environment);
    }

    public static final /* synthetic */ GdbWithGdbServerProcess access$createGdbClientProcess(Path file, int port, Project project, XDebugSession session, TextConsoleBuilder consoleBuilder, CidrToolEnvironment environment) {
        return RunRosettaGDBExtensionKt.createGdbClientProcess(file, port, project, session, consoleBuilder, environment);
    }
}

