/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.cpp.execution.docker.RosettaGDBExtensionUsageCollector;
import com.jetbrains.cidr.cpp.execution.docker.RunRosettaGDBExtensionKt;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbWithGdbServerProcess;
import com.jetbrains.cidr.cpp.toolchains.CPPDebugger;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerUtil;
import com.jetbrains.cidr.cpp.toolchains.docker.host.DockerHostLocal;
import com.jetbrains.cidr.execution.CidrRunConfigurationExtensionBase;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCRunConfiguration;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007H\u0016JH\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/cpp/execution/docker/RunRosettaGDBExtension;", "Lcom/jetbrains/cidr/execution/CidrRunConfigurationExtensionBase;", "<init>", "()V", "isEnabledFor", "", "applicableConfiguration", "Lcom/jetbrains/cidr/lang/workspace/OCRunConfiguration;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "isApplicableFor", "configuration", "createDebugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Ljava/nio/file/Path;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "parameters", "Lcom/jetbrains/cidr/execution/RunParameters;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "consoleBuilder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "isEmulatedTerminal", "intellij.clion.docker"})
@SourceDebugExtension(value={"SMAP\nRunRosettaGDBExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunRosettaGDBExtension.kt\ncom/jetbrains/cidr/cpp/execution/docker/RunRosettaGDBExtension\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,177:1\n19#2:178\n19#2:179\n*S KotlinDebug\n*F\n+ 1 RunRosettaGDBExtension.kt\ncom/jetbrains/cidr/cpp/execution/docker/RunRosettaGDBExtension\n*L\n66#1:178\n78#1:179\n*E\n"})
public final class RunRosettaGDBExtension
extends CidrRunConfigurationExtensionBase {
    public boolean isEnabledFor(@NotNull OCRunConfiguration<?, ?> applicableConfiguration, @NotNull CidrToolEnvironment environment, @Nullable RunnerSettings runnerSettings) {
        Object object;
        boolean userRequestedRosettaGDB;
        CPPEnvironment cPPEnvironment;
        Intrinsics.checkNotNullParameter(applicableConfiguration, (String)"applicableConfiguration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (!Registry.Companion.is("clion.docker.rosetta.extension.enabled")) {
            return false;
        }
        CidrToolEnvironment $this$asSafely$iv = environment;
        boolean $i$f$asSafely = false;
        CidrToolEnvironment cidrToolEnvironment = $this$asSafely$iv;
        if (!(cidrToolEnvironment instanceof CPPEnvironment)) {
            cidrToolEnvironment = null;
        }
        if ((cPPEnvironment = (CPPEnvironment)cidrToolEnvironment) == null || (cPPEnvironment = cPPEnvironment.getToolchain()) == null) {
            return false;
        }
        CPPEnvironment toolchain = cPPEnvironment;
        boolean isDocker = toolchain.getToolSetKind() == CPPToolSet.Kind.DOCKER;
        boolean bl = userRequestedRosettaGDB = isDocker && toolchain.getDebuggerKind() == CPPDebugger.Kind.BUNDLED_GDB;
        if (!userRequestedRosettaGDB) {
            if (isDocker) {
                RosettaGDBExtensionUsageCollector.ENABLED.log((Object)false, (Object)false);
            }
            return false;
        }
        Object $this$asSafely$iv2 = ((CPPEnvironment)environment).getHostMachine();
        boolean $i$f$asSafely2 = false;
        Object object2 = $this$asSafely$iv2;
        if (!(object2 instanceof DockerHostLocal)) {
            object2 = null;
        }
        DockerHostLocal dockerHostLocal = (DockerHostLocal)object2;
        if (dockerHostLocal == null) {
            return false;
        }
        DockerHostLocal machine = dockerHostLocal;
        $this$asSafely$iv2 = this;
        try {
            RunRosettaGDBExtension $this$isEnabledFor_u24lambda_u240 = (RunRosettaGDBExtension)((Object)$this$asSafely$iv2);
            boolean bl2 = false;
            object = Result.constructor-impl((Object)DockerUtil.getImageArch((DockerCloudConfiguration)CidrDockerUtil.getDockerRuntime(machine.getCredentialsHolder()).getAccount(), (String)machine.getCredentialsHolder().getImageName()));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        $this$asSafely$iv2 = object;
        String imageArch = (String)(Result.isFailure-impl((Object)$this$asSafely$iv2) ? null : $this$asSafely$iv2);
        boolean useRosettaGDB = Intrinsics.areEqual((Object)imageArch, (Object)"amd64");
        RosettaGDBExtensionUsageCollector.ENABLED.log((Object)true, (Object)useRosettaGDB);
        return useRosettaGDB;
    }

    public boolean isApplicableFor(@NotNull OCRunConfiguration<?, ?> configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        return true;
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull Project project, @NotNull Path file, @NotNull GeneralCommandLine commandLine, @NotNull CidrToolEnvironment environment, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, boolean isEmulatedTerminal) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)consoleBuilder, (String)"consoleBuilder");
        ThreadingAssertions.assertBackgroundThread();
        int port = RunRosettaGDBExtensionKt.access$getGdbPort();
        BaseProcessHandler dockerProcess = RunRosettaGDBExtensionKt.access$createGdbServerProcess(commandLine, port, environment);
        GdbWithGdbServerProcess clientProcess = RunRosettaGDBExtensionKt.access$createGdbClientProcess(file, port, project, session, consoleBuilder, environment);
        clientProcess.installServerProcess(dockerProcess);
        return (XDebugProcess)clientProcess;
    }
}

