/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.ClasspathModificationTracker;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.run.ConsoleRunContextParametersTuner;
import com.intellij.database.run.EelDatabaseHelperKt;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.project.Project;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.util.PathsList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dataSource/EelParametersTuner;", "Lcom/intellij/database/run/ConsoleRunContextParametersTuner;", "<init>", "()V", "tuneParams", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "params", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "Companion", "intellij.database.connectivity"})
public final class EelParametersTuner
implements ConsoleRunContextParametersTuner {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void tuneParams(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull SimpleJavaParameters params) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        PathsList pathsList = params.getClassPath();
        Intrinsics.checkNotNullExpressionValue((Object)pathsList, (String)"getClassPath(...)");
        Companion.transferPathListIfNeeded(project, pathsList, dataSource, true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dataSource/EelParametersTuner$Companion;", "", "<init>", "()V", "transferPathListIfNeeded", "", "project", "Lcom/intellij/openapi/project/Project;", "list", "Lcom/intellij/util/PathsList;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "withPrefix", "", "copyIfNeeded", "", "stringPath", "classpathDir", "Ljava/nio/file/Path;", "modificationService", "Lcom/intellij/database/dataSource/ClasspathModificationTracker;", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nEelParametersTuner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelParametersTuner.kt\ncom/intellij/database/dataSource/EelParametersTuner$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1869#2,2:46\n1869#2,2:48\n*S KotlinDebug\n*F\n+ 1 EelParametersTuner.kt\ncom/intellij/database/dataSource/EelParametersTuner$Companion\n*L\n27#1:46,2\n31#1:48,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void transferPathListIfNeeded(@NotNull Project project, @NotNull PathsList list, @NotNull LocalDataSource dataSource, boolean withPrefix) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            if (!DatabaseArtifactContext.Companion.getInstance(project, dataSource).useEel()) {
                return;
            }
            ClasspathModificationTracker modificationService = ClasspathModificationTracker.Companion.getInstance();
            Path classpathDir = EelDatabaseHelperKt.getClassPathDir(project);
            List toRemove = new ArrayList();
            List toAdd = new ArrayList();
            List list2 = list.getPathList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPathList(...)");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                toAdd.add(Companion.copyIfNeeded(it, classpathDir, modificationService, withPrefix));
                toRemove.add(it);
            }
            $this$forEach$iv = toRemove;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String p0 = (String)element$iv;
                boolean bl = false;
                list.remove(p0);
            }
            list.addAll(toAdd);
        }

        public static /* synthetic */ void transferPathListIfNeeded$default(Companion companion, Project project, PathsList pathsList, LocalDataSource localDataSource, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            companion.transferPathListIfNeeded(project, pathsList, localDataSource, bl);
        }

        private final String copyIfNeeded(String stringPath, Path classpathDir, ClasspathModificationTracker modificationService, boolean withPrefix) {
            Path path;
            Path expectedPath;
            block6: {
                Path path2;
                block5: {
                    path2 = Path.of(stringPath, new String[0]);
                    expectedPath = classpathDir.resolve(path2.getFileName());
                    if (!Files.exists(expectedPath, new LinkOption[0])) break block5;
                    Intrinsics.checkNotNull((Object)path2);
                    if (!modificationService.checkAndUpdate(path2)) break block6;
                }
                Intrinsics.checkNotNull((Object)path2);
                Intrinsics.checkNotNull((Object)expectedPath);
                EelPathUtils.transferLocalContentToRemote$default((Path)path2, (EelPathUtils.TransferTarget)((EelPathUtils.TransferTarget)new EelPathUtils.TransferTarget.Explicit(expectedPath)), null, (int)4, null);
            }
            if (withPrefix) {
                path = expectedPath;
            } else {
                Intrinsics.checkNotNull((Object)expectedPath);
                path = EelNioBridgeServiceKt.asEelPath((Path)expectedPath);
            }
            return ((Object)path).toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

