/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.lang.modulemap.psi.ModuleMapFileReference;
import com.jetbrains.cidr.lang.modulemap.psi.impl.ModuleMapFilePsiReference;
import com.jetbrains.cidr.lang.modulemap.psi.impl.ModuleMapPsiElementImpl;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/psi/impl/ModuleMapFileReferenceMixin;", "Lcom/jetbrains/cidr/lang/modulemap/psi/impl/ModuleMapPsiElementImpl;", "Lcom/jetbrains/cidr/lang/modulemap/psi/ModuleMapFileReference;", "Lcom/jetbrains/cidr/lang/modulemap/psi/impl/ModuleMapFilePsiReference;", "node", "Lcom/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "getTargetFilePath", "", "resolve", "Lcom/jetbrains/cidr/lang/modulemap/psi/ModuleMapFile;", "findTargetFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getElement", "Lcom/intellij/psi/PsiElement;", "getCanonicalText", "handleElementRename", "newElementName", "bindToElement", "element", "isReferenceTo", "", "isSoft", "getReference", "intellij.cidr.modulemap.language"})
public abstract class ModuleMapFileReferenceMixin
extends ModuleMapPsiElementImpl
implements ModuleMapFileReference,
ModuleMapFilePsiReference {
    public ModuleMapFileReferenceMixin(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    @Override
    @NotNull
    public String getTargetFilePath() {
        PsiElement psiElement = this.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFileName(...)");
        PsiElement filePathPSI = psiElement;
        String string = filePathPSI.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)"\""), (CharSequence)"\"");
    }

    @Override
    @Nullable
    public ModuleMapFile resolve() {
        VirtualFile virtualFile = this.findTargetFile(this.getTargetFilePath());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile targetFile = virtualFile;
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(targetFile);
        return psiFile instanceof ModuleMapFile ? (ModuleMapFile)psiFile : null;
    }

    private final VirtualFile findTargetFile(String filePath) {
        if (FileUtil.isAbsolute((String)filePath)) {
            return VfsUtil.findFile((Path)Path.of(filePath, new String[0]), (boolean)false);
        }
        PsiDirectory psiDirectory = this.getContainingFile().getParent();
        if (psiDirectory == null || (psiDirectory = psiDirectory.getVirtualFile()) == null) {
            return null;
        }
        PsiDirectory currentDir = psiDirectory;
        String[] stringArray = new String[]{filePath};
        return VfsUtil.findRelativeFile((VirtualFile)currentDir, (String[])stringArray);
    }

    @NotNull
    public TextRange getRangeInElement() {
        String text = this.getText();
        Intrinsics.checkNotNull((Object)text);
        int startOffset = StringsKt.startsWith$default((String)text, (String)"\"", (boolean)false, (int)2, null) ? 1 : 0;
        int endOffset = StringsKt.endsWith$default((String)text, (String)"\"", (boolean)false, (int)2, null) ? text.length() - 1 : text.length();
        return new TextRange(startOffset, endOffset);
    }

    @NotNull
    public PsiElement getElement() {
        return this;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        throw new IncorrectOperationException();
    }

    @NotNull
    public PsiElement bindToElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        throw new IncorrectOperationException();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof ModuleMapFile && Intrinsics.areEqual((Object)this.resolve(), (Object)element);
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @Nullable
    public ModuleMapFilePsiReference getReference() {
        return this;
    }
}

