/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestIndexProvider;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsAndGeneratorFramework;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestConstants;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestElements;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrGoogleTestFramework
extends CidrTestWithScopeElementsAndGeneratorFramework {
    private static final OCSymbolKind[] DECL_KINDS = new OCSymbolKind[]{OCSymbolKind.GLOBAL_VARIABLE, OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION, OCSymbolKind.TYPEDEF};

    public static CidrGoogleTestFramework getInstance() {
        return (CidrGoogleTestFramework)CidrGoogleTestFramework.getInstance(CidrGoogleTestFramework.class);
    }

    public CidrGoogleTestFramework() {
        super("Google Test", new Class[]{OCMacroCall.class, OCStruct.class, OCFunctionDefinition.class, OCDeclarator.class});
        this.myDeclaratorKinds = DECL_KINDS;
    }

    @RequiresReadLock
    @NotNull
    protected CidrTestFrameworkVersion createFrameworkVersionDirectly(@NotNull PsiFile file) {
        if (file == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.softAssertReadAccess();
        CidrTestFrameworkVersion cidrTestFrameworkVersion = CidrGoogleTestFramework.getFrameworkVersionUsingImportedMacro((PsiFile)file, (String)"GTEST_TEST");
        if (cidrTestFrameworkVersion == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(1);
        }
        return cidrTestFrameworkVersion;
    }

    public boolean isTestMacroCandidate(@NotNull PsiElement element, @NotNull Set<String> testMacroNames) {
        if (element == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(2);
        }
        if (testMacroNames == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(3);
        }
        return element instanceof OCMacroCall && PsiTreeUtil.getParentOfType((PsiElement)element, OCFunctionDeclaration.class) == null;
    }

    @NotNull
    public String getPatternSeparatorInCommandLine() {
        return ":";
    }

    @NonNls
    @NotNull
    public String getProtocolPrefix() {
        return "gtest://";
    }

    @Nullable
    protected CidrTestScopeElement extractTest(@NotNull PsiElement element) {
        if (element == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(4);
        }
        return this.getTestObjectFromTestHolder(element, CidrGoogleTestConstants.GOOGLE_TEST_MACRO_NAMES);
    }

    @Contract(value="null, null, _ -> false")
    public boolean isTestClassOrStruct(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project) {
        if (project == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(5);
        }
        return this.standardProbe(symbol, element, OCStruct.class, project, new OCSymbolKind[]{OCSymbolKind.STRUCT});
    }

    @Contract(value="null, null, _ -> false")
    public boolean isTestMethodOrFunction(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project) {
        if (project == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(6);
        }
        return this.standardProbe(symbol, element, OCFunctionDefinition.class, project, new OCSymbolKind[]{OCSymbolKind.FUNCTION_DECLARATION});
    }

    @Nullable
    public CidrTestScopeElement generateVirtualTestScopeElement(String suitePath, String testPath, @NotNull String testSource) {
        if (testSource == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(7);
        }
        return "gtest".equals(testSource) ? CidrGoogleTestElements.createTestScopeElementForSuiteAndTest((String)suitePath, (String)testPath) : null;
    }

    @NotNull
    protected Map<String, CidrTestScopeElement> createTestObjectsDirectly(@NotNull PsiFile file) {
        if (file == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(8);
        }
        Map map = CidrTestIndexProvider.INSTANCE.gatherTestLinks(file, "gtest");
        if (map == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(9);
        }
        return map;
    }

    @NotNull
    public CidrTestScopeElement createTestScopeElementForSuiteAndTest(@Nullable String suiteName, @Nullable String testName) {
        CidrTestScopeElement cidrTestScopeElement = CidrGoogleTestElements.createTestScopeElementForSuiteAndTest((String)suiteName, (String)testName);
        if (cidrTestScopeElement == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(10);
        }
        return cidrTestScopeElement;
    }

    @NotNull
    public Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> getGenerator() {
        Function function = CidrGoogleTestElements.getGenerator();
        if (function == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(11);
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestFramework";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMacroNames";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestFramework";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrameworkVersionDirectly";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestObjectsDirectly";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestScopeElementForSuiteAndTest";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFrameworkVersionDirectly";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTestMacroCandidate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractTest";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTestClassOrStruct";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTestMethodOrFunction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateVirtualTestScopeElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTestObjectsDirectly";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

