/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.asm.debugger;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.execution.debugger.CidrDisasmRegisterProvider;
import com.jetbrains.cidr.lang.asm.psi.AsmFile;
import com.jetbrains.cidr.lang.asm.psi.AsmInstruction;
import com.jetbrains.cidr.lang.asm.psi.AsmRegister;
import com.jetbrains.cidr.lang.asm.psi.AsmSymbol;
import com.jetbrains.cidr.lang.asm.psi.AsmTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrAsmRegisterProvider
implements CidrDisasmRegisterProvider {
    public boolean canProvideRegisters(@NotNull PsiFile file) {
        if (file == null) {
            CidrAsmRegisterProvider.$$$reportNull$$$0(0);
        }
        return file instanceof AsmFile;
    }

    @NotNull
    public List<CidrDisasmRegisterProvider.CidrRegisterInfo> getRegisters(@NotNull PsiFile file, int line) {
        if (file == null) {
            CidrAsmRegisterProvider.$$$reportNull$$$0(1);
        }
        ArrayList<CidrDisasmRegisterProvider.CidrRegisterInfo> result = new ArrayList<CidrDisasmRegisterProvider.CidrRegisterInfo>();
        Document doc = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (doc == null) {
            List<CidrDisasmRegisterProvider.CidrRegisterInfo> list = Collections.emptyList();
            if (list == null) {
                CidrAsmRegisterProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        int offset = doc.getLineEndOffset(line);
        HashSet<String> registerNames = new HashSet<String>();
        int lineCount = 0;
        for (PsiElement element = file.findElementAt(offset); element != null; element = element.getPrevSibling()) {
            if (element instanceof PsiWhiteSpace && element.textContains('\n')) {
                ++lineCount;
            }
            if (element.getNode().getElementType() == AsmTypes.LABEL || lineCount > 50) break;
            CidrAsmRegisterProvider.collectRegisters(doc, element, registerNames, result);
        }
        ArrayList<CidrDisasmRegisterProvider.CidrRegisterInfo> arrayList = result;
        if (arrayList == null) {
            CidrAsmRegisterProvider.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static void collectRegisters(@NotNull Document doc, @Nullable PsiElement element, @NotNull Set<String> processedRegisterNames, @NotNull List<CidrDisasmRegisterProvider.CidrRegisterInfo> result) {
        if (doc == null) {
            CidrAsmRegisterProvider.$$$reportNull$$$0(4);
        }
        if (processedRegisterNames == null) {
            CidrAsmRegisterProvider.$$$reportNull$$$0(5);
        }
        if (result == null) {
            CidrAsmRegisterProvider.$$$reportNull$$$0(6);
        }
        if (element instanceof AsmInstruction) {
            int instrOffset = element.getTextRange().getStartOffset();
            int instrLine = doc.getLineNumber(instrOffset);
            for (AsmRegister reg : PsiTreeUtil.findChildrenOfType((PsiElement)element, AsmRegister.class)) {
                String regName = CidrAsmRegisterProvider.getRegisterName(reg);
                if (regName == null || !processedRegisterNames.add(regName)) continue;
                result.add(new CidrDisasmRegisterProvider.CidrRegisterInfo(regName, instrLine));
            }
            for (AsmSymbol symbol : PsiTreeUtil.findChildrenOfType((PsiElement)element, AsmSymbol.class)) {
                String symbolName = symbol.getText();
                if (symbolName == null || !processedRegisterNames.add(symbolName)) continue;
                result.add(new CidrDisasmRegisterProvider.CidrRegisterInfo(symbolName, instrLine));
            }
        }
    }

    @Nullable
    private static String getRegisterName(@NotNull AsmRegister register) {
        ASTNode node;
        if (register == null) {
            CidrAsmRegisterProvider.$$$reportNull$$$0(7);
        }
        return (node = register.getNode().findChildByType(AsmTypes.IDENTIFIER)) != null ? node.getText() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/asm/debugger/CidrAsmRegisterProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedRegisterNames";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "register";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/asm/debugger/CidrAsmRegisterProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProvideRegisters";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRegisters";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectRegisters";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRegisterName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

