/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.qt.python;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.util.QualifiedName;
import com.intellij.qt.common.QtPathProvider;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyQtPathProvider
implements QtPathProvider {
    @Override
    @Nullable
    public Path findQtTool(@NotNull Project project, @NotNull VirtualFile file, @NotNull String toolName) {
        if (project == null) {
            PyQtPathProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PyQtPathProvider.$$$reportNull$$$0(1);
        }
        if (toolName == null) {
            PyQtPathProvider.$$$reportNull$$$0(2);
        }
        return PyQtPathProvider.findQtToolImpl(ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project), toolName);
    }

    @Override
    @Nullable
    public Path findQtTool(@NotNull Project project, @NotNull String toolName) {
        Module[] allModules;
        if (project == null) {
            PyQtPathProvider.$$$reportNull$$$0(3);
        }
        if (toolName == null) {
            PyQtPathProvider.$$$reportNull$$$0(4);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : allModules = moduleManager.getModules()) {
            Path toolPath;
            if (!module.isLoaded() || PythonSdkUtil.findPythonSdk((Module)module) == null || (toolPath = PyQtPathProvider.findQtToolImpl(module, "designer")) == null) continue;
            return toolPath;
        }
        return null;
    }

    @Nullable
    public static Path findQtToolImpl(@Nullable Module module, String toolName) {
        if (SystemInfo.isWindows) {
            if (module == null) {
                return null;
            }
            Sdk sdk = PythonSdkUtil.findPythonSdk((Module)module);
            if (sdk == null) {
                return null;
            }
            return (Path)ReadAction.compute(() -> {
                Path tool = PyQtPathProvider.findToolInPackage(toolName, module, "PySide6");
                if (tool != null) {
                    return tool;
                }
                tool = PyQtPathProvider.findToolInPackage(toolName, module, "PySide2");
                if (tool != null) {
                    return tool;
                }
                tool = PyQtPathProvider.findToolInPackage(toolName, module, "PyQt4");
                if (tool != null) {
                    return tool;
                }
                return PyQtPathProvider.findToolInPackage(toolName, module, "PySide");
            });
        }
        return null;
    }

    @Nullable
    private static Path findToolInPackage(String toolName, Module module, String name) {
        List results = PyResolveImportUtil.resolveQualifiedName((QualifiedName)QualifiedName.fromDottedString((String)name), (PyQualifiedNameResolveContext)PyResolveImportUtil.fromModule((Module)module));
        return StreamEx.of((Collection)results).select(PsiDirectory.class).map(directory -> directory.getVirtualFile().findChild(toolName + ".exe")).nonNull().map(VirtualFile::toNioPath).findFirst().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "toolName";
                break;
            }
        }
        objectArray[1] = "com/intellij/qt/python/PyQtPathProvider";
        objectArray[2] = "findQtTool";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

