/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.compdb.wizard;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.CidrProjectOpenProcessor;
import com.jetbrains.cidr.ProjectOpenFileHelper;
import com.jetbrains.cidr.ProjectOpenHelper;
import com.jetbrains.cidr.cpp.compdb.CompDBBundle;
import com.jetbrains.cidr.cpp.compdb.CompDBLog;
import com.jetbrains.cidr.cpp.compdb.CompDBUtil;
import com.jetbrains.cidr.cpp.compdb.CompDBUtilKt;
import com.jetbrains.cidr.cpp.compdb.wizard.OpenProjectSpec;
import com.jetbrains.cidr.external.system.fus.CidrExternalUsageUtil;
import java.io.File;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/wizard/CompDBProjectOpenProcessor;", "Lcom/jetbrains/cidr/CidrProjectOpenProcessor;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "canOpenProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "openProjectAsync", "Lcom/intellij/openapi/project/Project;", "virtualFile", "projectToClose", "forceOpenInNewFrame", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "Companion", "intellij.clion.compdb"})
public final class CompDBProjectOpenProcessor
extends CidrProjectOpenProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<OpenProjectSpec> DATA_KEY;
    @NotNull
    private static final ProjectOpenFileHelper<OpenProjectSpec> helper;

    public CompDBProjectOpenProcessor() {
        super((ProjectOpenHelper)helper);
    }

    @NotNull
    public String getName() {
        String string = CompDBBundle.message("external.system.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean canOpenProject(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = helper.findSupportedSubFile(file);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile databaseFile = virtualFile;
        return super.canOpenProject(databaseFile);
    }

    @Nullable
    public Object openProjectAsync(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, @NotNull Continuation<? super Project> $completion) {
        VirtualFile virtualFile2 = helper.findSupportedSubFile(virtualFile);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile database = virtualFile2;
        CompDBLog.INSTANCE.getLOG().assertTrue(!database.isDirectory());
        Project existingProject = helper.openExistingProjectInDirectory(database, projectToClose, forceOpenInNewFrame);
        if (existingProject != null) {
            return existingProject;
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)database);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
        OpenProjectSpec spec = new OpenProjectSpec(file);
        Project project = ProjectOpenHelper.openProject$default((ProjectOpenHelper)((ProjectOpenHelper)helper), (VirtualFile)database, (Project)projectToClose, (boolean)forceOpenInNewFrame, (Object)spec, null, (int)16, null);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        CidrExternalUsageUtil.INSTANCE.logProjectCreated(CompDBUtilKt.getID(), project2);
        VirtualFile externalProjectPath = database.getParent();
        Intrinsics.checkNotNull((Object)externalProjectPath);
        CompDBUtil.INSTANCE.linkCompDBProject(project2, externalProjectPath);
        return project2;
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Nodes.Project;
    }

    static {
        Key key = Key.create((String)"COMP_DB_TO_OPEN_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DATA_KEY = key;
        helper = new ProjectOpenFileHelper(CollectionsKt.listOf((Object)"compile_commands.json"), DATA_KEY);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/wizard/CompDBProjectOpenProcessor$Companion;", "", "<init>", "()V", "DATA_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/cidr/cpp/compdb/wizard/OpenProjectSpec;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "helper", "Lcom/jetbrains/cidr/ProjectOpenFileHelper;", "getHelper", "()Lcom/jetbrains/cidr/ProjectOpenFileHelper;", "intellij.clion.compdb"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProjectOpenFileHelper<OpenProjectSpec> getHelper() {
            return helper;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

