/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.compdb;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.compdb.CompDBBundle;
import com.jetbrains.cidr.cpp.compdb.CompDBLog;
import com.jetbrains.cidr.cpp.compdb.CompDBUtil;
import com.jetbrains.cidr.cpp.compdb.CompDBUtilKt;
import com.jetbrains.cidr.cpp.compdb.project.CompDBProjectResolver;
import com.jetbrains.cidr.cpp.compdb.project.CompDBStateData;
import com.jetbrains.cidr.cpp.compdb.settings.CompDBLocalSettings;
import com.jetbrains.cidr.cpp.compdb.settings.CompDBProjectSettings;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.external.system.model.ExternalModule;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspace;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.project.workspace.WorkspaceWithEnvironment;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="CompDBWorkspace")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J \u0010\u0017\u001a\u0004\u0018\u00010\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0014\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/CompDBWorkspace;", "Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace;", "Lcom/jetbrains/cidr/project/workspace/WorkspaceWithEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "clientKey", "", "getClientKey", "()Ljava/lang/String;", "createEnvironment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "toolchainNameOrNullForDefault", "problems", "Lcom/jetbrains/cidr/toolchains/EnvironmentProblems;", "checkIfFunctional", "", "onMissingToolchain", "Ljava/lang/Runnable;", "environment", "getEnvironment", "()Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "checkInitialState", "", "externalModuleNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/jetbrains/cidr/external/system/model/ExternalModule;", "", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "Companion", "intellij.clion.compdb"})
@SourceDebugExtension(value={"SMAP\nCompDBWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompDBWorkspace.kt\ncom/jetbrains/cidr/cpp/compdb/CompDBWorkspace\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1869#2,2:137\n1869#2,2:139\n*S KotlinDebug\n*F\n+ 1 CompDBWorkspace.kt\ncom/jetbrains/cidr/cpp/compdb/CompDBWorkspace\n*L\n76#1:137,2\n87#1:139,2\n*E\n"})
public final class CompDBWorkspace
extends ExternalWorkspace
implements WorkspaceWithEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CompDBWorkspace(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    public String getClientKey() {
        String string = CompDBUtilKt.getID().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return string;
    }

    @Nullable
    public CPPEnvironment createEnvironment(@Nullable Project project, @Nullable String toolchainNameOrNullForDefault, @NotNull EnvironmentProblems problems, boolean checkIfFunctional, @Nullable Runnable onMissingToolchain) {
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        return CPPToolchains.createCPPEnvironment((Project)project, (File)this.getProjectPath().toFile(), (String)toolchainNameOrNullForDefault, (EnvironmentProblems)problems, (boolean)checkIfFunctional, (Runnable)onMissingToolchain);
    }

    @NotNull
    public final CPPEnvironment getEnvironment() {
        CompDBLocalSettings localSettings = CompDBLocalSettings.Companion.getInstance(this.myProject);
        EnvironmentProblems environmentProblems = new EnvironmentProblems();
        CPPEnvironment environment = this.createEnvironment(this.myProject, localSettings.getToolchainName(), environmentProblems, false, null);
        environmentProblems.throwAsExecutionException();
        if (environment == null) {
            throw new ExecutionException(CompDBBundle.message("error.no.environment", new Object[0]));
        }
        return environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkInitialState() {
        ExternalSystemProgressNotificationManager notificationManager;
        var listener2 = new ExternalSystemTaskNotificationListener(){
            private final Set<String> alreadyRefreshed;
            {
                Set set = ConcurrentCollectionFactory.createConcurrentSet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
                this.alreadyRefreshed = set;
            }

            public final Set<String> getAlreadyRefreshed() {
                return this.alreadyRefreshed;
            }

            public void onStart(String projectPath, ExternalSystemTaskId taskId) {
                Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
                Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
                if (Intrinsics.areEqual((Object)CompDBUtilKt.getID(), (Object)taskId.getProjectSystemId()) && taskId.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
                    this.alreadyRefreshed.add(projectPath);
                }
            }
        };
        ExternalSystemProgressNotificationManager externalSystemProgressNotificationManager = notificationManager = ExternalSystemProgressNotificationManager.getInstance();
        if (externalSystemProgressNotificationManager != null) {
            externalSystemProgressNotificationManager.addNotificationListener(listener2);
        }
        try {
            CPPEnvironment environment = this.getEnvironment();
            Collection modules = ExternalWorkspace.Companion.findExternalModuleNodes(this.getProject());
            Iterable $this$forEach$iv = modules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DataNode it = (DataNode)element$iv;
                boolean bl = false;
                String pathToRefresh = this.checkInitialState((DataNode<ExternalModule>)it, environment);
                if (pathToRefresh == null || listener2.getAlreadyRefreshed().contains(pathToRefresh)) continue;
                CompDBUtil.INSTANCE.markProjectDirty(this.getProject(), pathToRefresh);
            }
        }
        catch (ExecutionException ex) {
            CompDBLog.INSTANCE.getLOG().debug("Initial state check: can't create environment");
            CompDBLog.INSTANCE.getLOG().debug((Throwable)ex);
            Iterable $this$forEach$iv = CompDBUtil.INSTANCE.linkedProjectSettings(this.getProject());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompDBProjectSettings it = (CompDBProjectSettings)((Object)element$iv);
                boolean bl = false;
                if (listener2.getAlreadyRefreshed().contains(it.getExternalProjectPath())) continue;
                Project project = this.getProject();
                String string = it.getExternalProjectPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalProjectPath(...)");
                CompDBUtil.INSTANCE.markProjectDirty(project, string);
            }
        }
        finally {
            ExternalSystemProgressNotificationManager externalSystemProgressNotificationManager2 = notificationManager;
            if (externalSystemProgressNotificationManager2 != null) {
                externalSystemProgressNotificationManager2.removeNotificationListener(listener2);
            }
        }
    }

    private final String checkInitialState(DataNode<ExternalModule> externalModuleNode, CPPEnvironment environment) {
        DataNode ideaModule = ExternalSystemApiUtil.findParent(externalModuleNode, (Key)ProjectKeys.MODULE);
        CompDBLog.INSTANCE.getLOG().assertTrue(ideaModule != null);
        DataNode compDBStateNode = ExternalSystemApiUtil.find(externalModuleNode, CompDBStateData.Companion.getCOMPDB_STATE_DATA_KEY());
        if (compDBStateNode == null) {
            CompDBLog.INSTANCE.getLOG().debug("Initial state check: no previously created state");
            DataNode dataNode = ideaModule;
            Intrinsics.checkNotNull((Object)dataNode);
            return ((ModuleData)dataNode.getData()).getLinkedExternalProjectPath();
        }
        DataNode<CompDBStateData> newCompDBStateNode = CompDBProjectResolver.Companion.createStateData(environment);
        if (!Intrinsics.areEqual(newCompDBStateNode, (Object)compDBStateNode)) {
            if (CompDBLog.INSTANCE.getLOG().isDebugEnabled()) {
                CompDBLog.INSTANCE.getLOG().debug(StringsKt.trimMargin$default((String)("\n          |Initial state check: state changed\n          |Old: " + compDBStateNode.getData() + "\n          |New: " + newCompDBStateNode.getData()), null, (int)1, null));
            }
            DataNode dataNode = ideaModule;
            Intrinsics.checkNotNull((Object)dataNode);
            return ((ModuleData)dataNode.getData()).getLinkedExternalProjectPath();
        }
        return null;
    }

    @NotNull
    public List<CidrToolEnvironment> getEnvironment() {
        List list;
        try {
            list = CollectionsKt.listOf((Object)this.getEnvironment());
        }
        catch (ExecutionException ex) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @JvmStatic
    @NotNull
    public static final CompDBWorkspace getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/CompDBWorkspace$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/cidr/cpp/compdb/CompDBWorkspace;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceAsync", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clion.compdb"})
    @SourceDebugExtension(value={"SMAP\nCompDBWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompDBWorkspace.kt\ncom/jetbrains/cidr/cpp/compdb/CompDBWorkspace$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,136:1\n30#2,2:137\n75#2:139\n*S KotlinDebug\n*F\n+ 1 CompDBWorkspace.kt\ncom/jetbrains/cidr/cpp/compdb/CompDBWorkspace$Companion\n*L\n124#1:137,2\n125#1:139\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CompDBWorkspace getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CompDBWorkspace> serviceClass$iv = CompDBWorkspace.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CompDBWorkspace)((Object)object);
        }

        @Nullable
        public final Object getInstanceAsync(@NotNull Project project, @NotNull Continuation<? super CompDBWorkspace> $completion) {
            ComponentManager $this$serviceAsync$iv = (ComponentManager)project;
            boolean $i$f$serviceAsync = false;
            Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            return ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(CompDBWorkspace.class, $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

