/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.util;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"computeHash", "", "path", "Ljava/nio/file/Path;", "intellij.cidr.util"})
@SourceDebugExtension(value={"SMAP\nCidrFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrFileUtil.kt\ncom/jetbrains/cidr/util/CidrFileUtilKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,34:1\n608#2:35\n1321#2,2:36\n*S KotlinDebug\n*F\n+ 1 CidrFileUtil.kt\ncom/jetbrains/cidr/util/CidrFileUtilKt\n*L\n23#1:35\n23#1:36,2\n*E\n"})
public final class CidrFileUtilKt {
    @NotNull
    public static final String computeHash(@NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Hasher hasher = Hashing.sha256().newHasher();
        Intrinsics.checkNotNullExpressionValue((Object)hasher, (String)"newHasher(...)");
        Hasher hasher2 = hasher;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Sequence $this$sortedBy$iv = PathsKt.walk((Path)path, (PathWalkOption[])new PathWalkOption[0]);
            boolean $i$f$sortedBy = false;
            Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(path){
                final /* synthetic */ Path $path$inlined;
                {
                    this.$path$inlined = path;
                }

                public final int compare(T a, T b) {
                    Path it = (Path)a;
                    boolean bl = false;
                    Comparable comparable = PathsKt.relativeTo((Path)it, (Path)this.$path$inlined);
                    it = (Path)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)PathsKt.relativeTo((Path)it, (Path)this.$path$inlined));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                Path relativePath = PathsKt.relativeTo((Path)it, (Path)path);
                hasher2.putString((CharSequence)((Object)relativePath).toString(), Charsets.UTF_8);
                byte[] byArray = Files.readAllBytes(it);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                hasher2.putBytes(byArray);
            }
        } else {
            byte[] byArray = Files.readAllBytes(path);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            Hasher hasher3 = hasher2.putBytes(byArray);
            Intrinsics.checkNotNull((Object)hasher3);
        }
        String string = hasher2.hash().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

