/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.httpClient.execution.RestClientResponse;
import com.intellij.httpClient.execution.adapters.HttpClientBasicHeader;
import com.intellij.httpClient.execution.adapters.HttpClientContentType;
import com.intellij.httpClient.execution.common.CommonClientResponse;
import com.intellij.httpClient.execution.common.CommonClientResponseBody;
import com.intellij.httpClient.http.request.run.HttpClientExternal;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientSession {
    public final HttpClientExternal client;
    public final HttpResponseHeaders headers;
    public final HttpResponseContentType contentType;
    public final CommonClientResponseBody content;
    public final int statusCode;

    public HttpClientSession(@NotNull HttpClientExternal client, @NotNull HttpResponseHeaders headers2, @NotNull HttpResponseContentType contentType, @NotNull CommonClientResponseBody content2, int statusCode) {
        if (client == null) {
            HttpClientSession.$$$reportNull$$$0(0);
        }
        if (headers2 == null) {
            HttpClientSession.$$$reportNull$$$0(1);
        }
        if (contentType == null) {
            HttpClientSession.$$$reportNull$$$0(2);
        }
        if (content2 == null) {
            HttpClientSession.$$$reportNull$$$0(3);
        }
        this.client = client;
        this.headers = headers2;
        this.contentType = contentType;
        this.content = content2;
        this.statusCode = statusCode;
    }

    @NotNull
    public static HttpClientSession create(@NotNull Project project, @NotNull CommonClientResponse response2) {
        if (project == null) {
            HttpClientSession.$$$reportNull$$$0(4);
        }
        if (response2 == null) {
            HttpClientSession.$$$reportNull$$$0(5);
        }
        if (response2 instanceof RestClientResponse) {
            HttpClientSession httpClientSession = HttpClientSession.createFromRestClientResponse(project, (RestClientResponse)response2);
            if (httpClientSession == null) {
                HttpClientSession.$$$reportNull$$$0(6);
            }
            return httpClientSession;
        }
        HttpClientSession httpClientSession = HttpClientSession.createFromCommonClientResponse(project, response2);
        if (httpClientSession == null) {
            HttpClientSession.$$$reportNull$$$0(7);
        }
        return httpClientSession;
    }

    private static HttpClientSession createFromRestClientResponse(@NotNull Project project, @NotNull RestClientResponse response2) {
        if (project == null) {
            HttpClientSession.$$$reportNull$$$0(8);
        }
        if (response2 == null) {
            HttpClientSession.$$$reportNull$$$0(9);
        }
        HttpClientExternal client = new HttpClientExternal(project);
        HttpResponseHeaders headers2 = new HttpResponseHeaders(response2.getAllHeaders().toArray(HttpClientBasicHeader.EMPTY_ARRAY));
        HttpClientContentType type = response2.getContentType();
        Charset charset = type.getCharset();
        HttpResponseContentType contentType = new HttpResponseContentType(type.getMimeType(), charset != null ? charset.name() : "");
        return new HttpClientSession(client, headers2, contentType, response2.getBody(), response2.getStatusLine().getStatusCode());
    }

    private static HttpClientSession createFromCommonClientResponse(@NotNull Project project, @NotNull CommonClientResponse response2) {
        if (project == null) {
            HttpClientSession.$$$reportNull$$$0(10);
        }
        if (response2 == null) {
            HttpClientSession.$$$reportNull$$$0(11);
        }
        HttpClientExternal client = new HttpClientExternal(project);
        HttpResponseHeaders headers2 = new HttpResponseHeaders(HttpClientBasicHeader.EMPTY_ARRAY);
        HttpResponseContentType contentType = new HttpResponseContentType("application/json", "");
        return new HttpClientSession(client, headers2, contentType, response2.getBody(), 207);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpClientSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpClientSession";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFromRestClientResponse";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFromCommonClientResponse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }

    public static class HttpResponseHeaders {
        private static final String EMPTY_HEADERS = "Empty";
        public HttpClientBasicHeader[] headers;

        public HttpResponseHeaders(HttpClientBasicHeader[] headers2) {
            this.headers = headers2;
        }

        @Nullable
        public String valueOf(@NotNull String name) {
            if (name == null) {
                HttpResponseHeaders.$$$reportNull$$$0(0);
            }
            for (HttpClientBasicHeader header : this.headers) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)header.getName(), (CharSequence)name)) continue;
                return header.getValue();
            }
            return null;
        }

        @Nullable
        public List<String> valuesOf(@NotNull String name) {
            if (name == null) {
                HttpResponseHeaders.$$$reportNull$$$0(1);
            }
            ArrayList<String> values = new ArrayList<String>();
            for (HttpClientBasicHeader header : this.headers) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)header.getName(), (CharSequence)name)) continue;
                values.add(header.getValue());
            }
            return values;
        }

        public String toString() {
            if (this.headers.length == 0) {
                return EMPTY_HEADERS;
            }
            return Stream.of(this.headers).map(header -> header.getName() + ": " + header.getValue()).collect(Collectors.joining("\n"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "name";
            objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpClientSession$HttpResponseHeaders";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valueOf";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valuesOf";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class HttpResponseContentType {
        public String mimeType;
        public String charset;

        public HttpResponseContentType(String mimeType, String charset) {
            this.mimeType = mimeType;
            this.charset = charset;
        }

        public String toString() {
            return this.mimeType + "; charset=" + this.charset;
        }
    }
}

