/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.resharper.cpp.assist.utils;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.resharper.cpp.assist.utils.StringUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001+B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u00bf\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2$\u0010\f\u001a \u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\r2y\u0010\u0011\u001au\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000f0\u0012j\u0002`\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ.\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bJ&\u0010!\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000fJ0\u0010$\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000fH\u0002J\u0016\u0010'\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)J\u0016\u0010*\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/resharper/cpp/assist/utils/TypingAssistUtils;", "", "<init>", "()V", "TAB_COMMAND_ID", "", "handleTabOrTabLeftPressed", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "indentLineFromBlock", "Lkotlin/Function4;", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "", "", "indentSingleLine", "Lkotlin/Function5;", "Lkotlin/ParameterName;", "name", "settings", "columnCount", "caretPosition", "", "textBefore", "Lcom/intellij/resharper/cpp/assist/utils/IndentSingleLineHandler;", "tabOnSelectionProcessing", "Lcom/intellij/resharper/cpp/assist/utils/TypingAssistUtils$TabOnSelectionProcessing;", "decreaseIndentOnSingleLine", "formatterSettings", "colCount", "textBeforeCaret", "decreaseIndentOnLineFromBlockSelection", "indent", "lineStartOffset", "decreaseIndent", "indentToDelete", "offset", "isCaretOnIndenting", "selection", "Lcom/intellij/openapi/util/TextRange;", "getTextBeforeCaret", "TabOnSelectionProcessing", "intellij.resharper.cpp.assist"})
@SourceDebugExtension(value={"SMAP\nTypingAssistUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypingAssistUtils.kt\ncom/intellij/resharper/cpp/assist/utils/TypingAssistUtils\n+ 2 LanguageAgnosticHelpers.kt\ncom/intellij/resharper/cpp/assist/utils/LanguageAgnosticHelpersKt\n+ 3 actions.kt\ncom/intellij/openapi/command/ActionsKt\n*L\n1#1,180:1\n27#2,8:181\n35#2:191\n11#3,2:189\n*S KotlinDebug\n*F\n+ 1 TypingAssistUtils.kt\ncom/intellij/resharper/cpp/assist/utils/TypingAssistUtils\n*L\n64#1:181,8\n64#1:191\n64#1:189,2\n*E\n"})
public final class TypingAssistUtils {
    @NotNull
    public static final TypingAssistUtils INSTANCE = new TypingAssistUtils();
    @NotNull
    private static final String TAB_COMMAND_ID = "Tab";

    private TypingAssistUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean handleTabOrTabLeftPressed(@NotNull Project project, @NotNull Editor editor, @NotNull Function4<? super CommonCodeStyleSettings.IndentOptions, ? super String, ? super Editor, ? super Integer, Unit> indentLineFromBlock, @NotNull Function5<? super CommonCodeStyleSettings.IndentOptions, ? super Integer, ? super Integer, ? super CharSequence, ? super Editor, Integer> indentSingleLine, @NotNull TabOnSelectionProcessing tabOnSelectionProcessing) {
        void name$iv$iv;
        void project$iv$iv;
        void project$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(indentLineFromBlock, (String)"indentLineFromBlock");
        Intrinsics.checkNotNullParameter(indentSingleLine, (String)"indentSingleLine");
        Intrinsics.checkNotNullParameter((Object)((Object)tabOnSelectionProcessing), (String)"tabOnSelectionProcessing");
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caret = caretModel;
        Ref.ObjectRef singleSelectionRange = new Ref.ObjectRef();
        TextRange textRange = caret.getPrimaryCaret().getSelectionRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getSelectionRange(...)");
        singleSelectionRange.element = textRange;
        boolean multipleSelection = selectionModel2.getBlockSelectionStarts().length > 1;
        Ref.ObjectRef textBeforeCaret = new Ref.ObjectRef();
        textBeforeCaret.element = multipleSelection ? (CharSequence)"" : this.getTextBeforeCaret(editor, (TextRange)singleSelectionRange.element);
        switch (WhenMappings.$EnumSwitchMapping$0[tabOnSelectionProcessing.ordinal()]) {
            case 1: {
                String string = "not implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            case 2: {
                break;
            }
            case 3: {
                String string = "not implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean blockSelection = false;
        if (tabOnSelectionProcessing == TabOnSelectionProcessing.RESHARPER_HEURISTIC && !StringsKt.isBlank((CharSequence)((CharSequence)textBeforeCaret.element))) {
            return false;
        }
        PsiFile sourceFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getSettings((Editor)editor).getIndentOptionsByFile(sourceFile);
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptionsByFile(...)");
        CommonCodeStyleSettings.IndentOptions formatterSettings = indentOptions;
        if (tabOnSelectionProcessing == TabOnSelectionProcessing.RESHARPER_HEURISTIC && formatterSettings.USE_TAB_CHARACTER && formatterSettings.TAB_SIZE != formatterSettings.INDENT_SIZE) {
            return false;
        }
        Ref.IntRef caretOffset = new Ref.IntRef();
        caretOffset.element = -1;
        Project project2 = project;
        String name$iv = TAB_COMMAND_ID;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        Ref.ObjectRef result$iv = new Ref.ObjectRef();
        void var20_22 = project$iv;
        String string = name$iv;
        Object groupId$iv$iv = groupId$iv;
        boolean $i$f$executeCommand2 = false;
        CommandProcessor.getInstance().executeCommand((Project)project$iv$iv, new Runnable(result$iv, blockSelection, caret, editor, singleSelectionRange, textBeforeCaret, formatterSettings, caretOffset, indentSingleLine){
            final /* synthetic */ Ref.ObjectRef $result$inlined;
            final /* synthetic */ boolean $blockSelection$inlined;
            final /* synthetic */ CaretModel $caret$inlined;
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ Ref.ObjectRef $singleSelectionRange$inlined;
            final /* synthetic */ Ref.ObjectRef $textBeforeCaret$inlined;
            final /* synthetic */ CommonCodeStyleSettings.IndentOptions $formatterSettings$inlined;
            final /* synthetic */ Ref.IntRef $caretOffset$inlined;
            final /* synthetic */ Function5 $indentSingleLine$inlined;
            {
                this.$result$inlined = objectRef;
                this.$blockSelection$inlined = bl;
                this.$caret$inlined = caretModel;
                this.$editor$inlined = editor;
                this.$singleSelectionRange$inlined = objectRef2;
                this.$textBeforeCaret$inlined = objectRef3;
                this.$formatterSettings$inlined = indentOptions;
                this.$caretOffset$inlined = intRef;
                this.$indentSingleLine$inlined = function5;
            }

            public final void run() {
                boolean bl = false;
                Ref.ObjectRef objectRef = this.$result$inlined;
                boolean bl2 = false;
                if (this.$blockSelection$inlined) {
                    String string = "not implemented";
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                this.$caret$inlined.getCurrentCaret().removeSelection();
                EditorUtil.fillVirtualSpaceUntilCaret((Editor)this.$editor$inlined);
                TextRange textRange = this.$caret$inlined.getPrimaryCaret().getSelectionRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getSelectionRange(...)");
                this.$singleSelectionRange$inlined.element = textRange;
                this.$textBeforeCaret$inlined.element = TypingAssistUtils.INSTANCE.getTextBeforeCaret(this.$editor$inlined, (TextRange)this.$singleSelectionRange$inlined.element);
                int colCount = StringUtil.INSTANCE.expandTabsAndCountColumns((CharSequence)this.$textBeforeCaret$inlined.element, 0, this.$formatterSettings$inlined.TAB_SIZE);
                this.$caretOffset$inlined.element = ((Number)this.$indentSingleLine$inlined.invoke((Object)this.$formatterSettings$inlined, (Object)colCount, (Object)this.$editor$inlined.getCaretModel().getOffset(), this.$textBeforeCaret$inlined.element, (Object)this.$editor$inlined)).intValue();
                if (this.$caretOffset$inlined.element != -1) {
                    this.$editor$inlined.getCaretModel().moveToOffset(this.$caretOffset$inlined.element);
                }
                objectRef.element = Unit.INSTANCE;
            }
        }, (String)name$iv$iv, groupId$iv$iv);
        Intrinsics.checkNotNull((Object)result$iv.element);
        return true;
    }

    public final int decreaseIndentOnSingleLine(@NotNull CommonCodeStyleSettings.IndentOptions formatterSettings, int colCount, int caretPosition, @NotNull CharSequence textBeforeCaret, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)formatterSettings, (String)"formatterSettings");
        Intrinsics.checkNotNullParameter((Object)textBeforeCaret, (String)"textBeforeCaret");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int indentSize = formatterSettings.USE_TAB_CHARACTER ? formatterSettings.TAB_SIZE : formatterSettings.INDENT_SIZE;
        int columnsToRemove = colCount % indentSize;
        if (columnsToRemove == 0) {
            columnsToRemove = indentSize;
        }
        return this.decreaseIndent(textBeforeCaret, columnsToRemove, formatterSettings, editor, caretPosition);
    }

    public final void decreaseIndentOnLineFromBlockSelection(@NotNull CommonCodeStyleSettings.IndentOptions formatterSettings, @NotNull String indent, @NotNull Editor editor, int lineStartOffset) {
        Intrinsics.checkNotNullParameter((Object)formatterSettings, (String)"formatterSettings");
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int lastTabPosition = StringsKt.lastIndexOf$default((CharSequence)indent, (char)'\t', (int)0, (boolean)false, (int)6, null);
        if (formatterSettings.USE_TAB_CHARACTER && lastTabPosition != -1) {
            int endPos = lastTabPosition + 1;
            int lastTabPosition2 = lastTabPosition == 0 ? -1 : StringsKt.lastIndexOf$default((CharSequence)indent, (char)'\t', (int)(lastTabPosition - 1), (boolean)false, (int)4, null);
            int startPos = lastTabPosition - lastTabPosition2 <= formatterSettings.TAB_SIZE ? lastTabPosition2 + 1 : lastTabPosition2 + 1 + (lastTabPosition - lastTabPosition2 - 1) / formatterSettings.TAB_SIZE * formatterSettings.TAB_SIZE;
            editor.getDocument().deleteString(lineStartOffset + startPos, lineStartOffset + endPos);
        } else {
            int indentToDelete = formatterSettings.INDENT_SIZE;
            this.decreaseIndent(indent, indentToDelete, formatterSettings, editor, lineStartOffset + indent.length());
        }
    }

    private final int decreaseIndent(CharSequence indent, int indentToDelete, CommonCodeStyleSettings.IndentOptions formatterSettings, Editor editor, int offset) {
        int i;
        int tabSize = formatterSettings.TAB_SIZE;
        int newPos = StringUtil.INSTANCE.expandTabsAndCountColumns(indent, 0, tabSize) - indentToDelete;
        if (newPos < 0) {
            newPos = 0;
        }
        int column = 0;
        for (i = 0; i < indent.length(); ++i) {
            char c = indent.charAt(i);
            int prevColumn = column++;
            if (c == '\t') {
                column += tabSize - column % tabSize;
            }
            if (column == newPos) {
                ++i;
                break;
            }
            if (column <= newPos) continue;
            column = prevColumn;
            break;
        }
        int putBack = column < newPos ? newPos - column : 0;
        editor.getDocument().replaceString(offset - indent.length() + i, offset, (CharSequence)StringsKt.repeat((CharSequence)" ", (int)putBack));
        return offset - indent.length() + i + putBack;
    }

    public final boolean isCaretOnIndenting(@NotNull Editor editor, @NotNull TextRange selection) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        CharSequence textBeforeCaret = this.getTextBeforeCaret(editor, selection);
        return StringsKt.isBlank((CharSequence)textBeforeCaret);
    }

    @NotNull
    public final CharSequence getTextBeforeCaret(@NotNull Editor editor, @NotNull TextRange selection) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        TextRange selectionTextRange = selection;
        int startOffset = selectionTextRange.getStartOffset();
        int endOffset = selectionTextRange.getEndOffset();
        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
        LogicalPosition selectionStartCoords = logicalPosition;
        LogicalPosition logicalPosition2 = editor.offsetToLogicalPosition(endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition2, (String)"offsetToLogicalPosition(...)");
        LogicalPosition selectionEndCoords = logicalPosition2;
        if (selectionStartCoords.line != selectionEndCoords.line) {
            return ".";
        }
        if (!selectionTextRange.isEmpty()) {
            startOffset = endOffset;
        }
        int lineStartOffset = document2.getLineStartOffset(selectionStartCoords.line);
        return document2.getImmutableCharSequence().subSequence(lineStartOffset, startOffset);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/resharper/cpp/assist/utils/TypingAssistUtils$TabOnSelectionProcessing;", "", "<init>", "(Ljava/lang/String;I)V", "INDENT_SELECTION", "OVERWRITE_SELECTION", "RESHARPER_HEURISTIC", "intellij.resharper.cpp.assist"})
    public static final class TabOnSelectionProcessing
    extends Enum<TabOnSelectionProcessing> {
        public static final /* enum */ TabOnSelectionProcessing INDENT_SELECTION = new TabOnSelectionProcessing();
        public static final /* enum */ TabOnSelectionProcessing OVERWRITE_SELECTION = new TabOnSelectionProcessing();
        public static final /* enum */ TabOnSelectionProcessing RESHARPER_HEURISTIC = new TabOnSelectionProcessing();
        private static final /* synthetic */ TabOnSelectionProcessing[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TabOnSelectionProcessing[] values() {
            return (TabOnSelectionProcessing[])$VALUES.clone();
        }

        public static TabOnSelectionProcessing valueOf(String value) {
            return Enum.valueOf(TabOnSelectionProcessing.class, value);
        }

        @NotNull
        public static EnumEntries<TabOnSelectionProcessing> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = tabOnSelectionProcessingArray = new TabOnSelectionProcessing[]{TabOnSelectionProcessing.INDENT_SELECTION, TabOnSelectionProcessing.OVERWRITE_SELECTION, TabOnSelectionProcessing.RESHARPER_HEURISTIC};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TabOnSelectionProcessing.values().length];
            try {
                nArray[TabOnSelectionProcessing.INDENT_SELECTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TabOnSelectionProcessing.OVERWRITE_SELECTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TabOnSelectionProcessing.RESHARPER_HEURISTIC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

