/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.resharper.cpp.assist;

import com.intellij.psi.tree.IElementType;
import com.intellij.resharper.cpp.assist.CppLexerTokenUtilsKt;
import com.intellij.resharper.cpp.assist.CppMinimalSeparator;
import com.intellij.resharper.cpp.lexer.CppInnerLexer;
import com.intellij.resharper.cpp.lexer.CppLexerTokenKind;
import com.intellij.resharper.cpp.lexer.CppLexerTokenNodeTypes;
import com.intellij.resharper.cpp.lexer.CppTokenNodeType;
import com.intellij.resharper.cpp.lexer.CppTokenNodeTypes;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/resharper/cpp/assist/CppMinimalSeparatorUtils;", "", "<init>", "()V", "getMinimalSeparator", "Lcom/intellij/resharper/cpp/assist/CppMinimalSeparator;", "leftToken", "Lcom/intellij/psi/tree/IElementType;", "rightToken", "tokensNeedSeparator", "", "intellij.resharper.cpp.assist"})
public final class CppMinimalSeparatorUtils {
    @NotNull
    public static final CppMinimalSeparatorUtils INSTANCE = new CppMinimalSeparatorUtils();

    private CppMinimalSeparatorUtils() {
    }

    @NotNull
    public final CppMinimalSeparator getMinimalSeparator(@NotNull IElementType leftToken, @Nullable IElementType rightToken) {
        Intrinsics.checkNotNullParameter((Object)leftToken, (String)"leftToken");
        if (rightToken == null) {
            return CppMinimalSeparator.NOT_REQUIRED;
        }
        if (CppLexerTokenUtilsKt.isWhitespace(leftToken) || CppLexerTokenUtilsKt.isWhitespace(rightToken) || leftToken == CppTokenNodeTypes.Companion.getUE_ATTRIBUTE_QUOTE() || rightToken == CppTokenNodeTypes.Companion.getUE_ATTRIBUTE_QUOTE() || leftToken == CppTokenNodeTypes.Companion.getCONDITIONALLY_NOT_COMPILED_CODE() || rightToken == CppTokenNodeTypes.Companion.getCONDITIONALLY_NOT_COMPILED_CODE()) {
            return CppMinimalSeparator.NOT_REQUIRED;
        }
        if (leftToken != CppLexerTokenNodeTypes.Companion.getNEW_LINE() && CppLexerTokenNodeTypes.Companion.getDIRECTIVES().contains(rightToken) || leftToken == CppTokenNodeTypes.Companion.getEND_OF_DIRECTIVE_CONTENT() && rightToken != CppLexerTokenNodeTypes.Companion.getNEW_LINE()) {
            return CppMinimalSeparator.NEW_LINE;
        }
        if (leftToken == CppTokenNodeTypes.Companion.getLTEQGT()) {
            return CppMinimalSeparator.NOT_REQUIRED;
        }
        if (leftToken == CppLexerTokenNodeTypes.Companion.getGTGT()) {
            if (rightToken == CppLexerTokenNodeTypes.Companion.getEQ() || rightToken == CppLexerTokenNodeTypes.Companion.getEQEQ()) {
                return CppMinimalSeparator.SPACE;
            }
            return CppMinimalSeparator.NOT_REQUIRED;
        }
        if (leftToken != CppLexerTokenNodeTypes.Companion.getNEW_LINE() && this.tokensNeedSeparator(leftToken, rightToken)) {
            return leftToken == CppLexerTokenNodeTypes.Companion.getEOL_COMMENT() ? CppMinimalSeparator.NEW_LINE : CppMinimalSeparator.SPACE;
        }
        return CppMinimalSeparator.NOT_REQUIRED;
    }

    private final boolean tokensNeedSeparator(IElementType leftToken, IElementType rightToken) {
        boolean bl;
        String tok1 = CppMinimalSeparatorUtils.tokensNeedSeparator$tokenRepresentation(leftToken);
        String tok2 = CppMinimalSeparatorUtils.tokensNeedSeparator$tokenRepresentation(rightToken);
        CppInnerLexer lexer = new CppInnerLexer(tok1 + tok2);
        lexer.start();
        if (lexer.getTokenEnd() != tok1.length()) {
            return true;
        }
        lexer.advance();
        boolean bl2 = bl = lexer.getTokenType() != CppLexerTokenKind.EOF;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return lexer.getTokenType() == CppLexerTokenKind.EOF;
    }

    private static final String tokensNeedSeparator$tokenRepresentation(IElementType $this$tokensNeedSeparator_u24tokenRepresentation) {
        Object object = $this$tokensNeedSeparator_u24tokenRepresentation instanceof CppTokenNodeType ? (CppTokenNodeType)$this$tokensNeedSeparator_u24tokenRepresentation : null;
        if (object == null || (object = object.getTokenRepresentation()) == null) {
            String string = $this$tokensNeedSeparator_u24tokenRepresentation.toString();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        }
        return object;
    }
}

