/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.projectStatus;

import com.intellij.clion.projectStatus.notifications.NotificationType;
import com.intellij.clion.projectStatus.notifications.ProjectNotification;
import com.intellij.clion.projectStatus.widget.Status;
import com.intellij.clion.projectStatus.widget.WidgetStatus;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\b\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"isProjectAwareFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "isCodeFragment", "isWidgetEnabled", "isExternalFileOrSingleFile", "convertStatus", "Lcom/intellij/clion/projectStatus/notifications/ProjectNotification;", "status", "Lcom/intellij/clion/projectStatus/widget/WidgetStatus;", "updateStatus", "", "intellij.clion.projectStatus"})
public final class ProjectStatusHelperKt {
    @RequiresReadLock
    public static final boolean isProjectAwareFile(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return LanguageUtils.Companion.getInstance().isSupportedFile(file) && !ProjectFileIndex.getInstance((Project)project).isExcluded(file) && !ScratchUtil.isScratch((VirtualFile)file) && !ProjectStatusHelperKt.isCodeFragment(file, project);
    }

    private static final boolean isCodeFragment(VirtualFile file, Project project) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return false;
        }
        PsiFile psi = psiFile;
        return InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)psi) != null;
    }

    public static final boolean isWidgetEnabled() {
        return Registry.Companion.is("ide.widget.project.status");
    }

    public static final boolean isExternalFileOrSingleFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
        VirtualFile contentRoot = rootManager.getFileIndex().getContentRootForFile(file);
        return contentRoot == null || Intrinsics.areEqual((Object)contentRoot, (Object)file) && rootManager.getContentRoots().length == 1;
    }

    @Nullable
    public static final ProjectNotification convertStatus(@Nullable WidgetStatus status) {
        NotificationType notificationType;
        if (status == null) {
            return null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[status.getStatus().ordinal()]) {
            case 1: {
                notificationType = NotificationType.Warning;
                break;
            }
            case 2: {
                notificationType = NotificationType.Info;
                break;
            }
            default: {
                return null;
            }
        }
        NotificationType notificationStatus = notificationType;
        return new ProjectNotification(notificationStatus, status.getDescription(), status.getKind());
    }

    public static final void updateStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EditorNotifications.getInstance((Project)project).updateAllNotifications();
        CidrWorkspaceManager.Companion.getInstance(project).notifyCidrWorkspaceInstantaneousStateChanged();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.Warning.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.Info.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

