/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.boost;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrBeforeTestRunTaskProvider;
import com.jetbrains.cidr.execution.testing.CidrTestListParserAndHolder;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationEditorWithLWValidation;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import com.jetbrains.cidr.execution.testing.boost.BoostTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestCommandLineState;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestConsoleProperties;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestNode;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBoostTestRunConfigurationData
extends CidrTestRunConfigurationData<CidrTestRunConfiguration>
implements CidrBeforeTestRunTaskProvider.CidrTestConfigurationNeedBeforeRunTask,
CidrTestListParserAndHolder<CidrBoostTestNode> {
    public static final Function<CidrTestRunConfiguration, CidrTestRunConfigurationData> FACTORY = CidrBoostTestRunConfigurationData::new;
    @NlsSafe
    public static final String FRAMEWORK_ID = "Boost Test";
    private volatile transient CidrBoostTestNode myTestRoot;
    @NonNls
    private static final String ROOT_NAME = "Root";

    public CidrBoostTestRunConfigurationData(@NotNull CidrTestRunConfiguration configuration) {
        if (configuration == null) {
            CidrBoostTestRunConfigurationData.$$$reportNull$$$0(0);
        }
        super(configuration);
        this.myTestRoot = null;
    }

    @NotNull
    protected String formatTestMethod() {
        assert (this.myTestName != null);
        String string = this.myTestName;
        if (string == null) {
            CidrBoostTestRunConfigurationData.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void checkData() throws RuntimeConfigurationException {
        Project project = this.myConfiguration.getProject();
        if (this.myTestMode == CidrTestRunConfigurationData.Mode.PATTERN || this.myTestSuite == null || CidrTestRunConfigurationEditorWithLWValidation.isLWValidationOn((Project)project)) {
            return;
        }
        if (((Boolean)OCTestExecution.executeWithCachedValuesFast(() -> BoostTestLanguageSupport.getInstance().hasTestElement(project, this.myTestSuite, this.myTestName))).booleanValue()) {
            return;
        }
        String errorMessage = this.myTestName == null ? CidrExecutionBundle.message((String)"test.suiteNotFound", (Object[])new Object[]{this.myTestSuite}) : CidrExecutionBundle.message((String)"test.testNotFound", (Object[])new Object[]{this.myTestName});
        throw new RuntimeConfigurationError(errorMessage);
    }

    @Nullable
    public String getTestingFrameworkId() {
        return FRAMEWORK_ID;
    }

    public CidrCommandLineState createState(@NotNull ExecutionEnvironment env, @NotNull Executor executor, @Nullable CidrTestScope failedTests) {
        if (env == null) {
            CidrBoostTestRunConfigurationData.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            CidrBoostTestRunConfigurationData.$$$reportNull$$$0(3);
        }
        return new CidrBoostTestCommandLineState<CidrTestRunConfiguration>(this.myConfiguration, this.myConfiguration.createLauncher(env), failedTests, env, executor);
    }

    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor, @NotNull ExecutionTarget target) {
        if (executor == null) {
            CidrBoostTestRunConfigurationData.$$$reportNull$$$0(4);
        }
        if (target == null) {
            CidrBoostTestRunConfigurationData.$$$reportNull$$$0(5);
        }
        return new CidrBoostTestConsoleProperties((RunConfiguration)this.myConfiguration, executor, target);
    }

    @NotNull
    public synchronized List<CidrBoostTestNode> getTestListCopy() {
        List<CidrBoostTestNode> list = this.myTestRoot == null ? Collections.emptyList() : Collections.singletonList(this.myTestRoot.clone());
        if (list == null) {
            CidrBoostTestRunConfigurationData.$$$reportNull$$$0(6);
        }
        return list;
    }

    public synchronized void clean() {
        this.myTestRoot = null;
    }

    @Nullable
    private CidrBoostTestNode parseOutputToNodes(@NotNull String programOutputWithListOfTests) {
        List<String> filters;
        if (programOutputWithListOfTests == null) {
            CidrBoostTestRunConfigurationData.$$$reportNull$$$0(7);
        }
        if ((filters = this.createFilters()) == null) {
            return null;
        }
        CidrBoostTestNode root = null;
        Stack<CidrBoostTestNode> testUnits = new Stack<CidrBoostTestNode>();
        CidrBoostTestNode node = null;
        for (String line : StringUtil.splitByLines((String)programOutputWithListOfTests)) {
            block6: for (Tag tag : Tag.values()) {
                Matcher matcher = tag.myTagPattern.matcher(line);
                if (!matcher.matches()) continue;
                switch (tag.ordinal()) {
                    case 0: {
                        String meta = matcher.group(1);
                        List metas = StringUtil.split((String)meta, (String)"|");
                        String testUnitName = (String)metas.get(0);
                        node = new CidrBoostTestNode(testUnitName, metas);
                        if (!node.nodeWithLocationInSources() && testUnits.empty()) {
                            root = node;
                            continue block6;
                        }
                        if (!node.nodeWithLocationInSources()) continue block6;
                        if (testUnits.empty()) {
                            root = new CidrBoostTestNode(ROOT_NAME, Collections.singletonList(ROOT_NAME));
                            testUnits.push(root);
                        }
                        CidrBoostTestNode parent = (CidrBoostTestNode)testUnits.peek();
                        node.setParent(parent);
                        if (!CidrBoostTestRunConfigurationData.filter(filters, node)) continue block6;
                        parent.addChild(node);
                        continue block6;
                    }
                    case 1: {
                        if (node == null) continue block6;
                        testUnits.push(node);
                        continue block6;
                    }
                    case 2: {
                        if (testUnits.empty()) continue block6;
                        testUnits.pop();
                    }
                }
            }
        }
        return root;
    }

    @Nullable
    private List<String> createFilters() {
        String decodedCommandLinePattern = this.getCommandLineTestPattern();
        if (decodedCommandLinePattern == null) {
            return null;
        }
        if (decodedCommandLinePattern.isEmpty() || decodedCommandLinePattern.equals("*")) {
            return Collections.emptyList();
        }
        if (StringUtil.indexOfAny((String)decodedCommandLinePattern, (String)"+!*,@") == -1) {
            return StringUtil.split((String)decodedCommandLinePattern, (String)":");
        }
        return null;
    }

    private static boolean filter(@NotNull List<String> filters, @NotNull CidrBoostTestNode name) {
        if (filters == null) {
            CidrBoostTestRunConfigurationData.$$$reportNull$$$0(8);
        }
        if (name == null) {
            CidrBoostTestRunConfigurationData.$$$reportNull$$$0(9);
        }
        if (filters.isEmpty()) {
            return true;
        }
        for (String easyFilter : filters) {
            if (!CidrBoostTestRunConfigurationData.check(easyFilter, name.getPath())) continue;
            return true;
        }
        return false;
    }

    private static boolean check(@NotNull String name1, @NotNull String name2) {
        if (name1 == null) {
            CidrBoostTestRunConfigurationData.$$$reportNull$$$0(10);
        }
        if (name2 == null) {
            CidrBoostTestRunConfigurationData.$$$reportNull$$$0(11);
        }
        return name2.startsWith(name1) || name1.startsWith(name2);
    }

    public synchronized void parse(@NotNull ProcessOutput output) {
        if (output == null) {
            CidrBoostTestRunConfigurationData.$$$reportNull$$$0(12);
        }
        try {
            this.myTestRoot = this.parseOutputToNodes(output.getStderr());
        }
        catch (Throwable e) {
            CidrTestLog.LOG.error("Unsupported DOT boost output", e, new String[]{output.getStderr()});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostTestRunConfigurationData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "programOutputWithListOfTests";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostTestRunConfigurationData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTestMethod";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestListCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseOutputToNodes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6 -> new IllegalStateException(string);
        };
    }

    static enum Tag {
        TEST_INFO("[^\\[ ]+\\[.*label=\"([^\"]*)\"];"),
        LEVEL_START("\\{"),
        LEVEL_END("\\}");

        public Pattern myTagPattern;

        private Tag(String pattern) {
            if (pattern == null) {
                Tag.$$$reportNull$$$0(0);
            }
            this.myTagPattern = Pattern.compile(pattern);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/jetbrains/cidr/execution/testing/boost/CidrBoostTestRunConfigurationData$Tag", "<init>"));
        }
    }
}

