/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.boost;

import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.GeneralIdBasedToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.testing.CidrFromTagInLineToGeneralTestEventsConverter;
import com.jetbrains.cidr.execution.testing.CidrMetaParam;
import com.jetbrains.cidr.execution.testing.CidrTestEventProcessor;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBoostOutputToGeneralTestEventsConverter
extends CidrFromTagInLineToGeneralTestEventsConverter {
    @RegExp
    private static final String TEST_TIME = "(?:; testing time: (\\d+.+))?\n";
    String myPrevLineLocation;
    boolean myFirstSuiteIsModule;
    boolean myInitialized;
    private final String myTargetName;
    private final List<CidrBoostTestNode> myInfos;

    public CidrBoostOutputToGeneralTestEventsConverter(@NotNull @NonNls String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull ExecutionConsole console, @Nullable List<CidrBoostTestNode> infos, @Nullable @NonNls String targetName) {
        if (testFrameworkName == null) {
            CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(0);
        }
        if (consoleProperties == null) {
            CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(1);
        }
        if (console == null) {
            CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(2);
        }
        super(testFrameworkName, consoleProperties, new CidrTestEventProcessor("boost"), console);
        this.myPrevLineLocation = null;
        this.myFirstSuiteIsModule = true;
        this.myInitialized = false;
        this.myInfos = infos;
        this.myTargetName = targetName;
    }

    protected synchronized void setupTestTree(@NotNull GeneralTestEventsProcessor processor) {
        if (processor == null) {
            CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(3);
        }
        if (this.myInfos == null || this.myInfos.isEmpty()) {
            return;
        }
        for (CidrBoostTestNode rootNode : this.myInfos) {
            rootNode.applyRecursively(testUnitNode -> {
                if (testUnitNode.nodeWithLocationInSources() && testUnitNode.getParent() != null) {
                    String parentPath = testUnitNode.getParent().getPath();
                    String name = testUnitNode.getName();
                    Object parentId = parentPath.isEmpty() ? "0" : "0/" + parentPath;
                    String nodeId = (String)parentId + "/" + name;
                    String location = "boost://" + (String)(parentPath.isEmpty() ? name : parentPath + "/" + name);
                    processor.onSuiteTreeNodeAdded(!testUnitNode.isTest(), name, location, CidrMetaParam.serialize((Pair[])new Pair[]{Pair.pair((Object)"target", (Object)this.myTargetName)}), nodeId, (String)parentId);
                }
            });
        }
        processor.onBuildTreeEnded();
    }

    protected void processLine(@NotNull Key outputType, @NotNull @NlsSafe String text) {
        if (outputType == null) {
            CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(4);
        }
        if (text == null) {
            CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(5);
        }
        if (ProcessOutputType.isStderr((Key)outputType) && text.startsWith("*** ")) {
            this.myFinalTestReport = text;
            return;
        }
        CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr<Tag> tag = Tag.parse(text);
        GeneralTestEventsProcessor processor = this.getProcessor();
        if (tag == null) {
            String testName = this.myTestNameStack.isEmpty() ? "" : (String)this.myTestNameStack.peek();
            String nodeId = this.getCurrentNodeId();
            if (nodeId.equals("0")) {
                processor.onUncapturedOutput(text, outputType);
                return;
            }
            this.process(ProcessOutputType.isStdout((Key)outputType) ? this.myEventProcessor.testStdOut(testName, nodeId, outputType, text) : this.myEventProcessor.testErrOut(testName, nodeId, outputType, text));
            return;
        }
        Tag etag = (Tag)((Object)tag.getTag());
        Runnable init = () -> {
            processor.onTestsReporterAttached();
            this.setupRootNode(processor);
            processor.onUncapturedOutput(String.format("Entering test module %s\n", tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME)), ProcessOutputTypes.STDOUT);
            this.myInitialized = true;
        };
        Runnable done = () -> processor.onUncapturedOutput(String.format("Leaving test module %s\n", tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME)), ProcessOutputTypes.STDOUT);
        switch (etag.ordinal()) {
            case 11: {
                this.myPrevLineLocation = text;
                break;
            }
            case 0: {
                this.myFirstSuiteIsModule = false;
                init.run();
                break;
            }
            case 2: {
                if (this.myFirstSuiteIsModule && !this.myInitialized) {
                    init.run();
                    break;
                }
            }
            case 5: {
                String nodeName = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME);
                String parentId = this.getCurrentNodeId();
                this.myTestNameStack.push((Object)nodeName);
                this.myTestResultStack.push((Object)CidrFromTagInLineToGeneralTestEventsConverter.TestResult.create((boolean)true, (int)0));
                String nodeId = this.getCurrentNodeId();
                String location = this.getLocationFromId();
                String metainfo = this.createMetainfo(tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.LINE_NUM));
                this.process(etag == Tag.TEST_START ? this.myEventProcessor.testStarted(nodeName, parentId, nodeId, location, metainfo) : this.myEventProcessor.suiteStarted(nodeName, parentId, nodeId, location, metainfo));
                break;
            }
            case 4: 
            case 7: {
                List path;
                String attrName = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME);
                if (attrName == null || (path = StringUtil.split((String)attrName, (String)"/")).isEmpty()) break;
                String nodeName = (String)path.get(path.size() - 1);
                String parentId = this.getCurrentNodeId();
                this.myTestNameStack.push((Object)nodeName);
                String nodeId = this.getCurrentNodeId();
                String location = this.getLocationFromId();
                this.myTestNameStack.pop();
                String metainfo = this.createMetainfo(tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.LINE_NUM));
                ArrayList msgs = new ArrayList();
                msgs.addAll(etag == Tag.TEST_SKIPPED ? this.myEventProcessor.testStarted(nodeName, parentId, nodeId, location, metainfo) : this.myEventProcessor.suiteStarted(nodeName, parentId, nodeId, location, metainfo));
                msgs.addAll(this.myEventProcessor.testUnitIgnore(nodeName, nodeId, text));
                this.process(msgs);
                break;
            }
            case 1: {
                done.run();
                break;
            }
            case 3: {
                SMTestProxy suiteId;
                if (processor instanceof GeneralIdBasedToSMTRunnerEventsConvertor && (suiteId = ((GeneralIdBasedToSMTRunnerEventsConvertor)processor).findProxyById(this.getCurrentNodeId())) != null) {
                    CidrBoostOutputToGeneralTestEventsConverter.fixIgnoredState((GeneralTestEventsProcessor)processor, (SMTestProxy)suiteId, node -> !node.wasLaunched(), node -> CidrBoostOutputToGeneralTestEventsConverter.getNodeId(node), (boolean)false);
                }
                if (this.myFirstSuiteIsModule && this.myTestNameStack.isEmpty()) {
                    done.run();
                    break;
                }
            }
            case 6: {
                String nodeName = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME);
                long durationInMs = CidrBoostOutputToGeneralTestEventsConverter.getTimeInMs((String)tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME));
                String nodeId = this.getCurrentNodeId();
                if (!this.myTestNameStack.isEmpty()) {
                    this.myTestNameStack.pop();
                }
                boolean succeeded = ((CidrFromTagInLineToGeneralTestEventsConverter.TestResult)this.myTestResultStack.pop()).success;
                if (!this.myTestResultStack.isEmpty()) {
                    ((CidrFromTagInLineToGeneralTestEventsConverter.TestResult)this.myTestResultStack.peek()).update(succeeded, durationInMs);
                }
                this.process(etag == Tag.TEST_END ? this.myEventProcessor.testFinished(nodeName, nodeId, String.valueOf(durationInMs), succeeded) : this.myEventProcessor.suiteFinished(nodeName, nodeId));
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                if (!this.myTestResultStack.isEmpty()) {
                    ((CidrFromTagInLineToGeneralTestEventsConverter.TestResult)this.myTestResultStack.peek()).update(false, 0L);
                }
                ((GeneralIdBasedToSMTRunnerEventsConvertor)processor).onError(this.getCurrentNodeId(), "", StringUtil.notNullize((String)this.myPrevLineLocation) + text, false);
            }
        }
        if (etag != Tag.PURE_LOCATION) {
            this.myPrevLineLocation = null;
        }
    }

    private void setupRootNode(@NotNull GeneralTestEventsProcessor processor) {
        if (processor == null) {
            CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(6);
        }
        processor.onRootPresentationAdded(this.myTargetName, null, "boost://CIDRRerun?" + this.createMetainfo(""));
    }

    @NotNull
    private String createMetainfo(@Nullable String line) {
        String string = CidrMetaParam.serialize((Pair[])new Pair[]{Pair.pair((Object)"target", (Object)this.myTargetName), Pair.pair((Object)"line", (Object)line)});
        if (string == null) {
            CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static String getNodeId(@NotNull SMTestProxy node) {
        String locationURL;
        if (node == null) {
            CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(8);
        }
        if ((locationURL = node.getLocationUrl()) != null && locationURL.startsWith("boost://")) {
            return "0/" + locationURL.substring("boost://".length());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostOutputToGeneralTestEventsConverter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostOutputToGeneralTestEventsConverter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createMetainfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupTestTree";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processLine";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupRootNode";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNodeId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    static enum Tag {
        MODULE_START("Entering test module \"(.+)\"\n"),
        MODULE_END("Leaving test module \"(.+)\"(?:; testing time: (\\d+.+))?\n"),
        SUITE_START("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?Entering test suite \"(.*)\"\n"),
        SUITE_END("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?Leaving test suite \"(.*)\"(?:; testing time: (\\d+.+))?\n"),
        SUITE_SKIPPED("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?Test suite \"(.*)\" is skipped because (.*)\n"),
        TEST_START("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?Entering test case \"(.*)\"\n"),
        TEST_END("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?Leaving test case \"(.*)\"(?:; testing time: (\\d+.+))?\n"),
        TEST_SKIPPED("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?Test case \"(.*)\" is skipped because (.*)\n"),
        EXCEPTION("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?last checkpoint: \"(.*)\" entry."),
        FATAL_ERROR("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?fatal error: in \"(.*)\": (.*)\n"),
        ERROR("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?error: in \"(.*)\": (.*)\n"),
        PURE_LOCATION("((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: $");

        private final Pattern myTagPattern;

        private Tag(String pattern) {
            if (pattern == null) {
                Tag.$$$reportNull$$$0(0);
            }
            this.myTagPattern = Pattern.compile(pattern);
        }

        @Nullable
        public static CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr<Tag> parse(@NotNull String line) {
            if (line == null) {
                Tag.$$$reportNull$$$0(1);
            }
            for (Tag tag : Tag.values()) {
                Matcher matcher = tag.myTagPattern.matcher(line);
                if (!matcher.find()) continue;
                HashMap<CidrFromTagInLineToGeneralTestEventsConverter.Attr, String> attrs = new HashMap<CidrFromTagInLineToGeneralTestEventsConverter.Attr, String>();
                switch (tag.ordinal()) {
                    case 1: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME, matcher.group(2));
                    }
                    case 0: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(1));
                        break;
                    }
                    case 3: 
                    case 6: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME, matcher.group(4));
                    }
                    case 2: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.SOURCE_PATH, matcher.group(1));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.LINE_NUM, matcher.group(2));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(3));
                        break;
                    }
                    case 9: 
                    case 10: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.SOURCE_PATH, matcher.group(1));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.LINE_NUM, matcher.group(2));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(3));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE, matcher.group(4));
                        break;
                    }
                    case 11: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.SOURCE_PATH, matcher.group(1));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.LINE_NUM, matcher.group(2));
                    }
                }
                return new CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr((Object)tag, attrs);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostOutputToGeneralTestEventsConverter$Tag";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parse";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

