/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.core.postprocessing;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.clones.configuration.RestrictedDuplicateScope;
import com.jetbrains.clones.structures.TextClone;
import com.jetbrains.clones.structures.TextFragment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u0010J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/clones/core/postprocessing/DuplicatesScopeFilter;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "findModule", "Lcom/intellij/openapi/module/Module;", "fragment", "Lcom/jetbrains/clones/structures/TextFragment;", "isTestSource", "", "textFragment", "restrict", "Lcom/jetbrains/clones/structures/TextClone;", "clone", "scope", "Lcom/jetbrains/clones/configuration/RestrictedDuplicateScope;", "filterByFileType", "", "restrictToDependedModules", "restrictToSameModule", "restrictToSameFile", "intellij.platform.duplicatesDetector"})
@SourceDebugExtension(value={"SMAP\nDuplicatesScopeFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicatesScopeFilter.kt\ncom/jetbrains/clones/core/postprocessing/DuplicatesScopeFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n774#2:66\n865#2,2:67\n774#2:70\n865#2,2:71\n774#2:73\n865#2,2:74\n774#2:76\n865#2,2:77\n1#3:69\n*S KotlinDebug\n*F\n+ 1 DuplicatesScopeFilter.kt\ncom/jetbrains/clones/core/postprocessing/DuplicatesScopeFilter\n*L\n37#1:66\n37#1:67,2\n48#1:70\n48#1:71,2\n55#1:73\n55#1:74,2\n61#1:76\n61#1:77,2\n*E\n"})
public final class DuplicatesScopeFilter {
    @NotNull
    private final Project project;

    public DuplicatesScopeFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final Module findModule(TextFragment fragment) {
        return ModuleUtil.findModuleForFile((VirtualFile)fragment.getFile(), (Project)this.project);
    }

    private final boolean isTestSource(TextFragment textFragment) {
        return ProjectFileIndex.getInstance((Project)this.project).isInTestSourceContent(textFragment.getFile());
    }

    @Nullable
    public final TextClone restrict(@NotNull TextClone clone, @NotNull RestrictedDuplicateScope scope) {
        TextClone textClone;
        Intrinsics.checkNotNullParameter((Object)clone, (String)"clone");
        Intrinsics.checkNotNullParameter((Object)((Object)scope), (String)"scope");
        switch (WhenMappings.$EnumSwitchMapping$0[scope.ordinal()]) {
            case 1: {
                textClone = this.restrictToDependedModules(clone);
                break;
            }
            case 2: {
                textClone = this.restrictToSameModule(clone);
                break;
            }
            case 3: {
                textClone = this.restrictToSameFile(clone);
                break;
            }
            case 4: {
                List<TextFragment> list = this.filterByFileType(clone);
                if (list == null) {
                    return null;
                }
                List<TextFragment> duplicates = list;
                textClone = new TextClone(clone.getMain(), duplicates);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return textClone;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<TextFragment> filterByFileType(@NotNull TextClone clone) {
        List list;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)clone, (String)"clone");
        FileType fileType = clone.getMain().getFile().getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        FileType fileType2 = fileType;
        Iterable $this$filter$iv = clone.getDuplicates();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextFragment it = (TextFragment)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getFile().getFileType(), (Object)fileType2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        return !((Collection)it).isEmpty() ? list : null;
    }

    /*
     * WARNING - void declaration
     */
    private final TextClone restrictToDependedModules(TextClone clone) {
        void $this$filterTo$iv$iv;
        List list = this.filterByFileType(clone);
        if (list == null) {
            return null;
        }
        List duplicates = list;
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(this.project);
        Module module = this.findModule(clone.getMain());
        if (module == null) {
            return null;
        }
        Module mainModule = module;
        Iterable $this$filter$iv = duplicates;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextFragment it = (TextFragment)element$iv$iv;
            boolean bl = false;
            if (!DuplicatesScopeFilter.restrictToDependedModules$areModulesDepended(moduleManager, mainModule, this.findModule(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        duplicates = (List)destination$iv$iv;
        return !((Collection)duplicates).isEmpty() ? new TextClone(clone.getMain(), duplicates) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final TextClone restrictToSameModule(TextClone clone) {
        void $this$filterTo$iv$iv;
        List list = this.filterByFileType(clone);
        if (list == null) {
            return null;
        }
        List duplicates = list;
        Module module = this.findModule(clone.getMain());
        if (module == null) {
            return null;
        }
        Module mainModule = module;
        Iterable $this$filter$iv = duplicates;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextFragment it = (TextFragment)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)mainModule, (Object)this.findModule(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        duplicates = (List)destination$iv$iv;
        return !((Collection)duplicates).isEmpty() ? new TextClone(clone.getMain(), duplicates) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final TextClone restrictToSameFile(TextClone clone) {
        void $this$filterTo$iv$iv;
        TextFragment main2 = clone.getMain();
        Iterable $this$filter$iv = clone.getDuplicates();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextFragment it = (TextFragment)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getFile(), (Object)main2.getFile())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List duplicates = (List)destination$iv$iv;
        return !((Collection)duplicates).isEmpty() ? new TextClone(main2, duplicates) : null;
    }

    private static final boolean restrictToDependedModules$areModulesDepended(ModuleManager moduleManager, Module first, Module second) {
        if (first == null || second == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)first, (Object)second) || moduleManager.isModuleDependent(first, second) || moduleManager.isModuleDependent(second, first);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RestrictedDuplicateScope.values().length];
            try {
                nArray[RestrictedDuplicateScope.DEPENDED_MODULES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestrictedDuplicateScope.SAME_MODULE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestrictedDuplicateScope.SAME_FILE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestrictedDuplicateScope.EVERYWHERE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

