/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.zephyr.binding;

import com.intellij.dts.api.DtsTreeSearchKt;
import com.intellij.dts.lang.psi.DtsNode;
import com.intellij.dts.lang.psi.DtsProperty;
import com.intellij.dts.lang.psi.DtsPsiUtilKt;
import com.intellij.dts.util.DtsTreeUtil;
import com.intellij.dts.zephyr.DtsZephyrProvider;
import com.intellij.dts.zephyr.binding.DtsZephyrBinding;
import com.intellij.dts.zephyr.binding.DtsZephyrBindingSerachKt;
import com.intellij.dts.zephyr.binding.DtsZephyrBundledBindings;
import com.intellij.dts.zephyr.binding.DtsZephyrPropertyBinding;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/dts/zephyr/binding/DtsZephyrBindingProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "provider", "Lcom/intellij/dts/zephyr/DtsZephyrProvider;", "getProvider", "()Lcom/intellij/dts/zephyr/DtsZephyrProvider;", "getBindings", "", "Lcom/intellij/dts/zephyr/binding/DtsZephyrBinding;", "compatible", "", "getBinding", "node", "Lcom/intellij/dts/lang/psi/DtsNode;", "", "getAllBindings", "Companion", "intellij.dts"})
public final class DtsZephyrBindingProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public DtsZephyrBindingProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final DtsZephyrProvider getProvider() {
        return DtsZephyrProvider.Companion.of(this.project);
    }

    @NotNull
    public final Collection<DtsZephyrBinding> getBindings(@NotNull String compatible) {
        Intrinsics.checkNotNullParameter((Object)compatible, (String)"compatible");
        Collection collection = this.getProvider().getBindings().get((Object)compatible);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        return collection;
    }

    @Nullable
    public final DtsZephyrBinding getBinding(@NotNull DtsNode node, @NotNull List<String> compatible) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(compatible, (String)"compatible");
        return DtsZephyrBindingSerachKt.searchBinding(this.getProvider().getBindings(), node, compatible);
    }

    @Nullable
    public final DtsZephyrBinding getBinding(@NotNull DtsNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getBinding(node, DtsPsiUtilKt.getDtsCompatibleStrings(node));
    }

    @NotNull
    public final Collection<DtsZephyrBinding> getAllBindings() {
        Collection collection = this.getProvider().getBindings().values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        return collection;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\u0010\u0010\b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/dts/zephyr/binding/DtsZephyrBindingProvider$Companion;", "", "<init>", "()V", "of", "Lcom/intellij/dts/zephyr/binding/DtsZephyrBindingProvider;", "project", "Lcom/intellij/openapi/project/Project;", "bindingFor", "Lcom/intellij/dts/zephyr/binding/DtsZephyrBinding;", "node", "Lcom/intellij/dts/lang/psi/DtsNode;", "fallbackBinding", "", "Lcom/intellij/dts/zephyr/binding/DtsZephyrPropertyBinding;", "property", "Lcom/intellij/dts/lang/psi/DtsProperty;", "intellij.dts"})
    @SourceDebugExtension(value={"SMAP\nDtsZephyrBindingProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtsZephyrBindingProvider.kt\ncom/intellij/dts/zephyr/binding/DtsZephyrBindingProvider$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,63:1\n30#2,2:64\n*S KotlinDebug\n*F\n+ 1 DtsZephyrBindingProvider.kt\ncom/intellij/dts/zephyr/binding/DtsZephyrBindingProvider$Companion\n*L\n16#1:64,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DtsZephyrBindingProvider of(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DtsZephyrBindingProvider> serviceClass$iv = DtsZephyrBindingProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DtsZephyrBindingProvider)object;
        }

        @Nullable
        public final DtsZephyrBinding bindingFor(@NotNull DtsNode node, boolean fallbackBinding) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Project project = node.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            DtsZephyrBindingProvider provider = this.of(project);
            DtsZephyrBinding nodeBinding2 = (DtsZephyrBinding)DtsTreeSearchKt.dtsSearch$default(node, false, null, (Function1)new Function1<DtsNode, DtsZephyrBinding>((Object)provider){

                public final DtsZephyrBinding invoke(DtsNode p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((DtsZephyrBindingProvider)this.receiver).getBinding(p0);
                }
            }, 2, null);
            if (nodeBinding2 != null || !fallbackBinding) {
                return nodeBinding2;
            }
            return DtsZephyrBundledBindings.Companion.getInstance().getBinding("fallback");
        }

        public static /* synthetic */ DtsZephyrBinding bindingFor$default(Companion companion, DtsNode dtsNode, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.bindingFor(dtsNode, bl);
        }

        @Nullable
        public final DtsZephyrPropertyBinding bindingFor(@NotNull DtsProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            DtsNode dtsNode = DtsTreeUtil.INSTANCE.parentNode(property);
            if (dtsNode == null) {
                return null;
            }
            DtsNode parent = dtsNode;
            Object object = com.intellij.dts.zephyr.binding.DtsZephyrBindingProvider$Companion.bindingFor$default(this, parent, false, 2, null);
            return object != null && (object = ((DtsZephyrBinding)object).getProperties()) != null ? (DtsZephyrPropertyBinding)object.get(property.getDtsName()) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

