/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.util;

import com.intellij.dts.cmake.DtsCMakeUtil;
import com.intellij.dts.lang.DtsTokenSets;
import com.intellij.dts.lang.psi.DtsTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\nJ(\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u0005J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\u0004\b\u0000\u0010\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00150\u0017J+\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u001c\"\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u001dJ)\u0010\u001e\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u001c\"\u00020\n\u00a2\u0006\u0002\u0010\u001dJ\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0018\u0010!\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001b\u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0005H\u0082\u0010J(\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010 \u001a\u00020\u00052\b\b\u0002\u0010$\u001a\u00020\u0005\u00a8\u0006%"}, d2={"Lcom/intellij/dts/util/DtsUtil;", "", "<init>", "()V", "isCMakeAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "splitName", "Lkotlin/Pair;", "", "name", "children", "Lkotlin/sequences/Sequence;", "Lcom/intellij/psi/PsiElement;", "element", "forward", "unfiltered", "isProductiveElement", "singleResult", "", "T", "callback", "Lkotlin/Function0;", "findFileAndRefresh", "Lcom/intellij/openapi/vfs/VirtualFile;", "first", "more", "", "(Ljava/lang/String;[Ljava/lang/String;)Lcom/intellij/openapi/vfs/VirtualFile;", "findFile", "nextElement", "filter", "validLeaf", "nextLeaf", "iterateLeafs", "strict", "intellij.dts"})
@SourceDebugExtension(value={"SMAP\nDtsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtsUtil.kt\ncom/intellij/dts/util/DtsUtil\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,154:1\n170#2,6:155\n*S KotlinDebug\n*F\n+ 1 DtsUtil.kt\ncom/intellij/dts/util/DtsUtil\n*L\n33#1:155,6\n*E\n"})
public final class DtsUtil {
    @NotNull
    public static final DtsUtil INSTANCE = new DtsUtil();

    private DtsUtil() {
    }

    public final boolean isCMakeAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DtsCMakeUtil.Companion.isCMakeAvailable(project);
    }

    @NotNull
    public final Pair<String, String> splitName(@NotNull String name) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"@", (boolean)false, (int)2, null)) {
            int n;
            block4: {
                CharSequence $this$indexOfLast$iv = name;
                boolean $i$f$indexOfLast = false;
                int n2 = $this$indexOfLast$iv.length() + -1;
                if (0 <= n2) {
                    do {
                        int index$iv = n2--;
                        char it = $this$indexOfLast$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(it == '@')) continue;
                        n = index$iv;
                        break block4;
                    } while (0 <= n2);
                }
                n = -1;
            }
            int splitIndex = n;
            String string = name.substring(0, splitIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String actualName = string;
            String string2 = name.substring(splitIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String unitAddress = string2;
            pair = new Pair((Object)actualName, (Object)unitAddress);
        } else {
            pair = new Pair((Object)name, null);
        }
        return pair;
    }

    @NotNull
    public final Sequence<PsiElement> children(@NotNull PsiElement element, boolean forward, boolean unfiltered) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (forward) {
            psiElement = element.getFirstChild();
        } else {
            psiElement = element.getLastChild();
            if (psiElement == null) {
                return SequencesKt.emptySequence();
            }
        }
        PsiElement start = psiElement;
        Intrinsics.checkNotNull((Object)start);
        Sequence siblings = PsiTreeUtilKt.siblings$default((PsiElement)start, (boolean)forward, (boolean)false, (int)2, null);
        if (unfiltered) {
            return siblings;
        }
        return SequencesKt.filter((Sequence)siblings, (Function1)((Function1)new Function1<PsiElement, Boolean>((Object)this){

            public final Boolean invoke(PsiElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return DtsUtil.access$isProductiveElement((DtsUtil)this.receiver, p0);
            }
        }));
    }

    public static /* synthetic */ Sequence children$default(DtsUtil dtsUtil, PsiElement psiElement, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return dtsUtil.children(psiElement, bl, bl2);
    }

    private final boolean isProductiveElement(PsiElement element) {
        IElementType type = PsiTreeUtilKt.getElementType((PsiElement)element);
        return !Intrinsics.areEqual((Object)type, (Object)TokenType.WHITE_SPACE) && !DtsTokenSets.INSTANCE.getComments().contains(type) && !Intrinsics.areEqual((Object)type, (Object)DtsTypes.INCLUDE_STATEMENT) && !Intrinsics.areEqual((Object)type, (Object)DtsTypes.PP_STATEMENT);
    }

    @NotNull
    public final <T> List<T> singleResult(@NotNull Function0<? extends T> callback) {
        List<Object> list;
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Object result = callback.invoke();
        if (result == null) {
            List list2 = Collections.emptyList();
            Intrinsics.checkNotNull(list2);
            list = list2;
        } else {
            List<Object> list3 = Collections.singletonList(result);
            Intrinsics.checkNotNull(list3);
            list = list3;
        }
        return list;
    }

    @RequiresReadLockAbsence
    @Nullable
    public final VirtualFile findFileAndRefresh(@NotNull String first, String ... more) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)more, (String)"more");
        ThreadingAssertions.assertNoReadAccess();
        try {
            virtualFile = VfsUtil.findFile((Path)Path.of(first, Arrays.copyOf(more, more.length)), (boolean)true);
        }
        catch (InvalidPathException invalidPathException) {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Nullable
    public final VirtualFile findFile(@NotNull String first, String ... more) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)more, (String)"more");
        try {
            virtualFile = VfsUtil.findFile((Path)Path.of(first, Arrays.copyOf(more, more.length)), (boolean)false);
        }
        catch (InvalidPathException invalidPathException) {
            virtualFile = null;
        }
        return virtualFile;
    }

    private final PsiElement nextElement(PsiElement element, boolean filter) {
        PsiElement nextSibling;
        PsiElement firstChild;
        boolean notEmpty;
        boolean valid = !filter || this.isProductiveElement(element);
        boolean bl = notEmpty = element.getTextLength() != 0;
        if (valid && notEmpty && (firstChild = element.getFirstChild()) != null) {
            return firstChild;
        }
        PsiElement psiElement = nextSibling = element.getNextSibling();
        if (psiElement != null) {
            return psiElement;
        }
        PsiElement parent = PsiTreeUtil.findFirstParent((PsiElement)element, arg_0 -> DtsUtil.nextElement$lambda$1(DtsUtil::nextElement$lambda$0, arg_0));
        if (!(parent instanceof PsiFile)) {
            PsiElement psiElement2 = parent;
            return psiElement2 != null ? psiElement2.getNextSibling() : null;
        }
        return null;
    }

    private final boolean validLeaf(PsiElement element, boolean filter) {
        boolean valid = !filter || this.isProductiveElement(element);
        boolean notEmpty = element.getTextLength() != 0;
        boolean isLeaf = element.getFirstChild() == null;
        return valid && notEmpty && isLeaf;
    }

    private final PsiElement nextLeaf(PsiElement element, boolean filter) {
        DtsUtil dtsUtil = this;
        while (dtsUtil.nextElement(element, filter) != null) {
            PsiElement next;
            if (dtsUtil.validLeaf(next, filter)) {
                return next;
            }
            DtsUtil dtsUtil2 = dtsUtil;
            boolean bl = filter;
            dtsUtil = dtsUtil2;
            element = next;
            filter = bl;
        }
        return null;
    }

    @NotNull
    public final Sequence<PsiElement> iterateLeafs(@NotNull PsiElement element, boolean filter, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super PsiElement>, Continuation<? super Unit>, Object>(strict, element, filter, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ boolean $strict;
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ boolean $filter;
            {
                this.$strict = $strict;
                this.$element = $element;
                this.$filter = $filter;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = current = this.$strict != false || DtsUtil.access$validLeaf(DtsUtil.INSTANCE, this.$element, this.$filter) == false ? DtsUtil.access$nextLeaf(DtsUtil.INSTANCE, this.$element, this.$filter) : this.$element;
lbl7:
                        // 2 sources

                        while (current != null) {
                            this.L$0 = $this$sequence;
                            this.L$1 = current;
                            this.label = 1;
                            v1 = $this$sequence.yield((Object)current, (Continuation)this);
                            if (v1 == var4_3) {
                                return var4_3;
                            }
                            ** GOTO lbl20
                        }
                        break;
                    }
                    case 1: {
                        current = (PsiElement)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl20:
                        // 2 sources

                        current = DtsUtil.access$nextLeaf(DtsUtil.INSTANCE, current, this.$filter);
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super PsiElement> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static /* synthetic */ Sequence iterateLeafs$default(DtsUtil dtsUtil, PsiElement psiElement, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return dtsUtil.iterateLeafs(psiElement, bl, bl2);
    }

    private static final boolean nextElement$lambda$0(PsiElement it) {
        return it.getNextSibling() != null || it instanceof PsiFile;
    }

    private static final boolean nextElement$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isProductiveElement(DtsUtil $this, PsiElement element) {
        return $this.isProductiveElement(element);
    }

    public static final /* synthetic */ boolean access$validLeaf(DtsUtil $this, PsiElement element, boolean filter) {
        return $this.validLeaf(element, filter);
    }

    public static final /* synthetic */ PsiElement access$nextLeaf(DtsUtil $this, PsiElement element, boolean filter) {
        return $this.nextLeaf(element, filter);
    }
}

