/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.util;

import com.intellij.dts.DtsBundle;
import com.intellij.dts.api.DtsPath;
import com.intellij.dts.highlighting.DtsHighlightAnnotator;
import com.intellij.dts.highlighting.DtsTextAttributes;
import com.intellij.dts.lang.DtsLanguage;
import com.intellij.dts.lang.psi.DtsNode;
import com.intellij.dts.lang.psi.DtsPHandle;
import com.intellij.dts.util.DtsAnnotation;
import com.intellij.dts.util.DtsAnnotationHolder;
import com.intellij.dts.util.DtsAnnotationHolderIterator;
import com.intellij.dts.util.DtsUtil;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.richcopy.HtmlSyntaxInfoUtil;
import com.intellij.openapi.editor.richcopy.SyntaxInfoBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u000e\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u001d\u0010\u0013\u001a\u00020\u00142\u0015\u0010\u0015\u001a\u00110\u0005\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0005J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#J\u001d\u0010$\u001a\u00020\u00142\u0015\u0010\u0015\u001a\u00110\u0005\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018J\u0013\u0010%\u001a\u00020\u00142\u000b\u0010\u0012\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000fJ\u0013\u0010&\u001a\u00020\u00142\u000b\u0010\u0012\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000fJ\u001f\u0010'\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u000f2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u001d\u0010*\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000f2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u001b\u0010+\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)2\u000b\u0010\u0012\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/dts/util/DtsHtmlChunk;", "", "<init>", "()V", "BINDING_HTML_TAG", "", "BINDING_PARAGRAPH_HTML_TAG", "bindingEndOfLineRx", "Lkotlin/text/Regex;", "bindingLineBrakeRx", "highlightAnnotator", "Lcom/intellij/dts/highlighting/DtsHighlightAnnotator;", "dtsKeywords", "", "styledSpan", "Lcom/intellij/openapi/util/NlsSafe;", "attr", "Lcom/intellij/dts/highlighting/DtsTextAttributes;", "text", "definitionName", "Lcom/intellij/openapi/util/text/HtmlChunk;", "key", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.DtsBundle", "propertyName", "name", "nodeName", "pHandle", "handle", "Lcom/intellij/dts/lang/psi/DtsPHandle;", "node", "element", "Lcom/intellij/dts/lang/psi/DtsNode;", "path", "Lcom/intellij/dts/api/DtsPath;", "bundle", "string", "int", "tryParseDtsToHtml", "project", "Lcom/intellij/openapi/project/Project;", "bindingHtml", "binding", "intellij.dts"})
@SourceDebugExtension(value={"SMAP\nDtsHtmlChunk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtsHtmlChunk.kt\ncom/intellij/dts/util/DtsHtmlChunk\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,271:1\n774#2:272\n865#2,2:273\n1563#2:275\n1634#2,2:276\n1761#2,3:278\n1636#2:281\n*S KotlinDebug\n*F\n+ 1 DtsHtmlChunk.kt\ncom/intellij/dts/util/DtsHtmlChunk\n*L\n94#1:272\n94#1:273,2\n204#1:275\n204#1:276,2\n209#1:278,3\n204#1:281\n*E\n"})
public final class DtsHtmlChunk {
    @NotNull
    public static final DtsHtmlChunk INSTANCE = new DtsHtmlChunk();
    @NotNull
    private static final String BINDING_HTML_TAG = "!!html";
    @NotNull
    private static final String BINDING_PARAGRAPH_HTML_TAG = "!!phtml";
    @NotNull
    private static final Regex bindingEndOfLineRx = new Regex("\\s*\\n\\s*");
    @NotNull
    private static final Regex bindingLineBrakeRx = new Regex("\\s*\\n\\s*\\n");
    @NotNull
    private static final DtsHighlightAnnotator highlightAnnotator = new DtsHighlightAnnotator();
    @NotNull
    private static final List<String> dtsKeywords;

    private DtsHtmlChunk() {
    }

    private final String styledSpan(DtsTextAttributes attr, String text2) {
        return QuickDocHighlightingHelper.getStyledFragment((String)text2, (TextAttributesKey)attr.getAttribute());
    }

    @NotNull
    public final HtmlChunk definitionName(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        HtmlChunk[] htmlChunkArray = new HtmlChunk[]{this.bundle(key), HtmlChunk.text((String)": ")};
        HtmlChunk.Element element = HtmlChunk.fragment((HtmlChunk[])htmlChunkArray).bold();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"bold(...)");
        return (HtmlChunk)element;
    }

    @NotNull
    public final HtmlChunk propertyName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        HtmlChunk htmlChunk = HtmlChunk.raw((String)this.styledSpan(DtsTextAttributes.PROPERTY_NAME, name));
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"raw(...)");
        return htmlChunk;
    }

    @NotNull
    public final HtmlChunk nodeName(@NotNull String nodeName) {
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Pair<String, String> pair = DtsUtil.INSTANCE.splitName(nodeName);
        String name = (String)pair.component1();
        String addr = (String)pair.component2();
        if (addr == null) {
            HtmlChunk htmlChunk = HtmlChunk.raw((String)this.styledSpan(DtsTextAttributes.NODE_NAME, name));
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"raw(...)");
            return htmlChunk;
        }
        HtmlChunk[] htmlChunkArray = new HtmlChunk[]{HtmlChunk.raw((String)this.styledSpan(DtsTextAttributes.NODE_NAME, name)), HtmlChunk.text((String)"@"), HtmlChunk.raw((String)this.styledSpan(DtsTextAttributes.NODE_UNIT_ADDR, addr))};
        HtmlChunk htmlChunk = HtmlChunk.fragment((HtmlChunk[])htmlChunkArray);
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"fragment(...)");
        return htmlChunk;
    }

    /*
     * WARNING - void declaration
     */
    private final HtmlChunk pHandle(DtsPHandle handle) {
        PsiElement path;
        HtmlBuilder builder = new HtmlBuilder();
        builder.append("&");
        PsiElement label = handle.getDtsPHandleLabel();
        if (label != null) {
            String string = label.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            builder.appendRaw(this.styledSpan(DtsTextAttributes.LABEL, string));
        }
        if ((path = handle.getDtsPHandlePath()) != null) {
            void $this$filterTo$iv$iv;
            builder.append("{");
            String string = path.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String[] stringArray = new String[]{"/"};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List segments = (List)destination$iv$iv;
            for (String segment : segments) {
                builder.append("/");
                builder.append(this.nodeName(segment));
            }
            if (segments.isEmpty()) {
                builder.append("/");
            }
            builder.append("}");
        }
        HtmlChunk htmlChunk = builder.toFragment();
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"toFragment(...)");
        return htmlChunk;
    }

    @NotNull
    public final HtmlChunk node(@NotNull DtsNode element) {
        HtmlChunk htmlChunk;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DtsNode dtsNode = element;
        if (dtsNode instanceof DtsNode.Root) {
            HtmlChunk htmlChunk2 = HtmlChunk.text((String)"/");
            htmlChunk = htmlChunk2;
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk2, (String)"text(...)");
        } else if (dtsNode instanceof DtsNode.Sub) {
            htmlChunk = this.nodeName(((DtsNode.Sub)element).getDtsName());
        } else if (dtsNode instanceof DtsNode.Ref) {
            htmlChunk = this.pHandle(((DtsNode.Ref)element).getDtsHandle());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return htmlChunk;
    }

    @NotNull
    public final HtmlChunk path(@NotNull DtsPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        HtmlBuilder builder = new HtmlBuilder();
        for (String segment : path.getSegments()) {
            builder.append("/");
            builder.append(this.nodeName(segment));
        }
        if (path.getSegments().isEmpty()) {
            builder.append("/");
        }
        HtmlChunk htmlChunk = builder.toFragment();
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"toFragment(...)");
        return htmlChunk;
    }

    @NotNull
    public final HtmlChunk bundle(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        HtmlChunk htmlChunk = HtmlChunk.raw((String)DtsBundle.Companion.message(key, new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"raw(...)");
        return htmlChunk;
    }

    @NotNull
    public final HtmlChunk string(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        HtmlChunk htmlChunk = HtmlChunk.raw((String)this.styledSpan(DtsTextAttributes.STRING, text2));
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"raw(...)");
        return htmlChunk;
    }

    @NotNull
    public final HtmlChunk int(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        HtmlChunk htmlChunk = HtmlChunk.raw((String)this.styledSpan(DtsTextAttributes.NUMBER, text2));
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"raw(...)");
        return htmlChunk;
    }

    private final String tryParseDtsToHtml(Project project, String text2) {
        PsiFile fakePsiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("comment.dtsi", (Language)DtsLanguage.INSTANCE, (CharSequence)((Object)StringsKt.trim((CharSequence)text2)).toString(), false, false);
        JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)fakePsiFile)).traverse().filter(arg_0 -> DtsHtmlChunk.tryParseDtsToHtml$lambda$1(arg_0 -> DtsHtmlChunk.tryParseDtsToHtml$lambda$0(fakePsiFile, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        JBIterable errors = jBIterable;
        if (errors.isNotEmpty()) {
            return null;
        }
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)fakePsiFile, true);
        DtsAnnotationHolder holder = new DtsAnnotationHolder();
        fakePsiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(holder){
            final /* synthetic */ DtsAnnotationHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (!(element instanceof CompositeElement)) {
                    DtsHtmlChunk.access$getHighlightAnnotator$p().annotate(element, this.$holder);
                }
                super.visitElement(element);
            }
        });
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getSchemeForCurrentUITheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        CharSequence charSequence = HtmlSyntaxInfoUtil.getHtmlContent((PsiFile)fakePsiFile, (CharSequence)fakePsiFile.getText(), (SyntaxInfoBuilder.RangeIterator)new DtsAnnotationHolderIterator((Iterable<DtsAnnotation>)holder.getAnnotations(), scheme), (EditorColorsScheme)scheme, (int)0, (int)fakePsiFile.getText().length());
        if (charSequence == null) {
            return null;
        }
        CharSequence content = charSequence;
        return "<code>" + content + "</code>";
    }

    /*
     * Unable to fully structure code
     */
    private final String bindingHtml(Project project, String text) {
        if (StringsKt.startsWith$default((String)text, (String)"!!html", (boolean)false, (int)2, null)) {
            return StringsKt.trim((CharSequence)StringsKt.removePrefix((String)text, (CharSequence)"!!html")).toString();
        }
        var4_3 = StringsKt.trim((CharSequence)text).toString();
        var5_4 = DtsHtmlChunk.bindingLineBrakeRx;
        var6_5 = 0;
        paragraphs = var5_4.split(var4_3, var6_5);
        $this$map$iv = paragraphs;
        $i$f$map = false;
        var7_7 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            block11: {
                block9: {
                    block10: {
                        var12_12 = (String)item$iv$iv;
                        var21_24 = destination$iv$iv;
                        $i$a$-map-DtsHtmlChunk$bindingHtml$html$1 = false;
                        if (!StringsKt.startsWith$default((String)paragraph, (String)"!!phtml", (boolean)false, (int)2, null)) break block10;
                        var14_14 = StringsKt.trim((CharSequence)StringsKt.removePrefix((String)paragraph, (CharSequence)"!!phtml")).toString();
                        var15_16 = DtsHtmlChunk.bindingEndOfLineRx;
                        var16_17 = " ";
                        v0 = var15_16.replace(var14_14, var16_17);
                        break block11;
                    }
                    if (StringsKt.contains$default((CharSequence)((CharSequence)paragraph), (CharSequence)";", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                    $this$any$iv = DtsHtmlChunk.dtsKeywords;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v1 = false;
                    } else {
                        for (E element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            $i$a$-any-DtsHtmlChunk$bindingHtml$html$1$couldBeDtsCode$1 = false;
                            if (!StringsKt.contains$default((CharSequence)((CharSequence)paragraph), (CharSequence)it, (boolean)false, (int)2, null)) continue;
                            v1 = true;
                            break block9;
                        }
                        v1 = false;
                    }
                }
                if (v1) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = couldBeDtsCode = false;
                }
                if (couldBeDtsCode && (html = DtsHtmlChunk.INSTANCE.tryParseDtsToHtml(project, (String)paragraph)) != null) {
                    v0 = html;
                } else {
                    var16_19 = (CharSequence)paragraph;
                    var17_20 = DtsHtmlChunk.bindingEndOfLineRx;
                    var18_21 = " ";
                    v3 = StringUtil.escapeXmlEntities((String)var17_20.replace(var16_19, var18_21));
                    v0 = v3;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"escapeXmlEntities(...)");
                }
            }
            var21_24.add(v0);
        }
        html = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)html, (CharSequence)"<br/><br/>", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final HtmlChunk binding(@NotNull Project project, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        HtmlChunk htmlChunk = HtmlChunk.raw((String)this.bindingHtml(project, text2));
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"raw(...)");
        return htmlChunk;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean tryParseDtsToHtml$lambda$0(PsiFile $fakePsiFile, PsiElement it) {
        if (!(it instanceof PsiErrorElement)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)((PsiErrorElement)it).getText(), (Object)"...")) return false;
        int n = PsiTreeUtilKt.getStartOffset((PsiElement)it);
        Intrinsics.checkNotNull((Object)$fakePsiFile);
        if (n == PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)$fakePsiFile))) return false;
        return true;
    }

    private static final boolean tryParseDtsToHtml$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ DtsHighlightAnnotator access$getHighlightAnnotator$p() {
        return highlightAnnotator;
    }

    static {
        Object[] objectArray = new String[]{"#include", "#define", "/include/", "/dts-v1/", "/plugin/", "/memreserve/", "/delete-node/", "/delete-property/", "/omit-if-no-ref/"};
        dtsKeywords = CollectionsKt.listOf((Object[])objectArray);
    }
}

