/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.settings;

import com.intellij.dts.DtsBundle;
import com.intellij.dts.settings.BoardComboBox;
import com.intellij.dts.settings.DtsSettings;
import com.intellij.dts.settings.DtsSettingsConfigurable;
import com.intellij.dts.settings.DtsSettingsDisabler;
import com.intellij.dts.settings.DtsSettingsInputStatus;
import com.intellij.dts.settings.RootComboBox;
import com.intellij.dts.util.DtsUtil;
import com.intellij.dts.util.Either;
import com.intellij.dts.zephyr.DtsZephyrFileUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J+\u0010\n\u001a\u001d\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\r\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J+\u0010\u0010\u001a\u001d\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\r\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/dts/settings/DtsSettingsConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "state", "Lcom/intellij/dts/settings/DtsSettings$State;", "enableSync", "", "validateRoot", "Lcom/intellij/dts/util/Either;", "", "Lorg/jetbrains/annotations/Nls;", "Lcom/intellij/dts/settings/Result;", "path", "validateBoard", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "createActualPanel", "apply", "", "intellij.dts"})
public final class DtsSettingsConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    private final Project project;
    @NotNull
    private final DtsSettings.State state;
    private final boolean enableSync;

    public DtsSettingsConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(DtsBundle.Companion.message("settings.name", new Object[0]), "devitree.zephyr.settings", "com.intellij.dts.settings.DtsSettingsConfigurable");
        this.project = project;
        this.state = DtsSettings.Companion.of(this.project).getState();
        this.enableSync = DtsUtil.INSTANCE.isCMakeAvailable(this.project);
    }

    private final Either<String, String> validateRoot(String path) {
        if (StringsKt.isBlank((CharSequence)path)) {
            VirtualFile virtualFile = DtsZephyrFileUtil.INSTANCE.searchForRoot(this.project);
            if (virtualFile == null) {
                return new Either.Left<String>(DtsBundle.Companion.message("settings.zephyr.root.not_found", new Object[0]));
            }
            VirtualFile root = virtualFile;
            return new Either.Right<String>(root.getPath());
        }
        VirtualFile virtualFile = DtsUtil.INSTANCE.findFileAndRefresh(path, new String[0]);
        if (virtualFile == null) {
            return new Either.Left<String>(DtsBundle.Companion.message("settings.zephyr.root.not_found", new Object[0]));
        }
        VirtualFile root = virtualFile;
        if (!DtsZephyrFileUtil.INSTANCE.isValid(root)) {
            return new Either.Left<String>(DtsBundle.Companion.message("settings.zephyr.root.invalid", new Object[0]));
        }
        return new Either.Right<String>(path);
    }

    private final Either<String, String> validateBoard(String path) {
        return DtsUtil.INSTANCE.findFileAndRefresh(path, new String[0]) == null ? (Either)new Either.Left<String>(DtsBundle.Companion.message("settings.zephyr.board.not_found", new Object[0])) : (Either)new Either.Right<String>(path);
    }

    @NotNull
    public DialogPanel createPanel() {
        if (DtsSettingsDisabler.Companion.shouldBeDisabled$intellij_dts(this.project)) {
            return BuilderKt.panel(DtsSettingsConfigurable::createPanel$lambda$0);
        }
        return this.createActualPanel();
    }

    private final DialogPanel createActualPanel() {
        return BuilderKt.panel(arg_0 -> DtsSettingsConfigurable.createActualPanel$lambda$0(this, arg_0));
    }

    public void apply() {
        super.apply();
        DtsSettings.Companion.of(this.project).update((Function1<? super DtsSettings.State, Unit>)((Function1)arg_0 -> DtsSettingsConfigurable.apply$lambda$0(this, arg_0)));
    }

    private static final Unit createPanel$lambda$0(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, DtsSettingsConfigurable::createPanel$lambda$0$0, (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JBPanelWithEmptyText jBPanelWithEmptyText = new JBPanelWithEmptyText().withEmptyText(DtsBundle.Companion.message("settings.are.not.available.for.this.project", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)jBPanelWithEmptyText, (String)"withEmptyText(...)");
        $this$row.cell((JComponent)jBPanelWithEmptyText).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createActualPanel$lambda$0(DtsSettingsConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        JCheckBox syncInput = ComponentsKt.CheckBox$default((String)DtsBundle.Companion.message("settings.zephyr.sync_with_cmake", new Object[0]), (boolean)false, null, (int)6, null);
        syncInput.setEnabled(this$0.enableSync);
        RootComboBox rootInput = new RootComboBox(this$0.getDisposable());
        BoardComboBox boardInput = new BoardComboBox(this$0.getDisposable(), this$0.state.getZephyrBoard());
        Disposable disposable = this$0.getDisposable();
        DtsSettingsInputStatus<String, String> rootStatus2 = new DtsSettingsInputStatus<String, String>(rootInput, this$0, disposable){
            final /* synthetic */ RootComboBox $rootInput;
            final /* synthetic */ DtsSettingsConfigurable this$0;
            {
                this.$rootInput = $rootInput;
                this.this$0 = $receiver;
                super($super_call_param$1);
                this.setEnabled(false);
            }

            protected String readState() {
                String state = this.$rootInput.getText();
                if (StringsKt.isBlank((CharSequence)state)) {
                    this.$rootInput.setEmptyText(DtsBundle.Companion.message("settings.zephyr.root.detecting.ongoing", new Object[0]));
                } else {
                    this.$rootInput.setEmptyText("");
                }
                return state;
            }

            protected Either<String, String> performCheck(String state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                return DtsSettingsConfigurable.access$validateRoot(this.this$0, state);
            }

            protected ValidationInfo evaluate(String state, Either<String, String> result) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter(result, (String)"result");
                if (StringsKt.isBlank((CharSequence)state)) {
                    result.fold(arg_0 -> createActualPanel.1.rootStatus.1.evaluate$lambda$0(this.$rootInput, arg_0), arg_0 -> createActualPanel.1.rootStatus.1.evaluate$lambda$1(this.$rootInput, arg_0));
                }
                return super.evaluate(state, result);
            }

            private static final Unit evaluate$lambda$0(RootComboBox $rootInput, String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                $rootInput.setEmptyText(DtsBundle.Companion.message("settings.zephyr.root.detecting.failed", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final Unit evaluate$lambda$1(RootComboBox $rootInput, String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object[] objectArray = new Object[]{it};
                $rootInput.setEmptyText(DtsBundle.Companion.message("settings.zephyr.root.detecting.success", objectArray));
                return Unit.INSTANCE;
            }
        };
        Disposable disposable2 = this$0.getDisposable();
        DtsSettingsInputStatus<String, String> boardStatus2 = new DtsSettingsInputStatus<String, String>(boardInput, this$0, disposable2){
            final /* synthetic */ BoardComboBox $boardInput;
            final /* synthetic */ DtsSettingsConfigurable this$0;
            {
                this.$boardInput = $boardInput;
                this.this$0 = $receiver;
                super($super_call_param$1);
                this.setEnabled(false);
            }

            protected String readState() {
                return this.$boardInput.getText();
            }

            protected Either<String, String> performCheck(String state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                return DtsSettingsConfigurable.access$validateBoard(this.this$0, state);
            }
        };
        Disposable disposable3 = this$0.getDisposable();
        DtsSettingsInputStatus<String, List<? extends String>> updateBoardList2 = new DtsSettingsInputStatus<String, List<? extends String>>(rootInput, this$0, boardInput, syncInput, disposable3){
            final /* synthetic */ RootComboBox $rootInput;
            final /* synthetic */ DtsSettingsConfigurable this$0;
            final /* synthetic */ BoardComboBox $boardInput;
            final /* synthetic */ JCheckBox $syncInput;
            {
                this.$rootInput = $rootInput;
                this.this$0 = $receiver;
                this.$boardInput = $boardInput;
                this.$syncInput = $syncInput;
                super($super_call_param$1);
            }

            protected String readState() {
                return this.$rootInput.getText();
            }

            protected Either<String, List<String>> performCheck(String state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                return DtsSettingsConfigurable.access$validateRoot(this.this$0, state).mapRight(createActualPanel.1.updateBoardList.1::performCheck$lambda$0);
            }

            protected ValidationInfo evaluate(String state, Either<String, ? extends List<String>> result) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter(result, (String)"result");
                result.fold(arg_0 -> createActualPanel.1.updateBoardList.1.evaluate$lambda$1(this.$boardInput, arg_0), arg_0 -> createActualPanel.1.updateBoardList.1.evaluate$lambda$2(this.$boardInput, this.$syncInput, arg_0));
                return super.evaluate(state, result);
            }

            private static final List performCheck$lambda$0(String rootPath) {
                Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
                return SequencesKt.toList(DtsZephyrFileUtil.INSTANCE.getAllBoardDirs(DtsUtil.INSTANCE.findFileAndRefresh(rootPath, new String[0])));
            }

            private static final Unit evaluate$lambda$1(BoardComboBox $boardInput, String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                $boardInput.setEnabled(false);
                $boardInput.clearBoards();
                return Unit.INSTANCE;
            }

            private static final Unit evaluate$lambda$2(BoardComboBox $boardInput, JCheckBox $syncInput, List boards) {
                Intrinsics.checkNotNullParameter((Object)boards, (String)"boards");
                $boardInput.setEnabled(!$syncInput.isSelected());
                $boardInput.setBoards(boards);
                return Unit.INSTANCE;
            }
        };
        Panel.group$default((Panel)$this$panel, (String)DtsBundle.Companion.message("settings.zephyr.group", new Object[0]), (boolean)false, arg_0 -> DtsSettingsConfigurable.createActualPanel$lambda$0$0(syncInput, this$0, rootInput, boardInput, arg_0), (int)2, null);
        rootStatus2.installOn((JComponent)((Object)rootInput));
        rootInput.onTextChanged((Function0<Unit>)((Function0)new Function0<Unit>((Object)rootStatus2){

            public final void invoke() {
                (this.receiver).check();
            }
        }));
        rootInput.onFocusLost((Function0<Unit>)((Function0)new Function0<Unit>((Object)rootStatus2){

            public final void invoke() {
                (this.receiver).enableAndCheck();
            }
        }));
        boardStatus2.installOn((JComponent)((Object)boardInput));
        boardInput.onTextChanged((Function0<Unit>)((Function0)new Function0<Unit>((Object)boardStatus2){

            public final void invoke() {
                (this.receiver).check();
            }
        }));
        boardInput.onFocusLost((Function0<Unit>)((Function0)new Function0<Unit>((Object)boardStatus2){

            public final void invoke() {
                (this.receiver).enableAndCheck();
            }
        }));
        rootInput.onTextChanged((Function0<Unit>)((Function0)new Function0<Unit>((Object)updateBoardList2){

            public final void invoke() {
                (this.receiver).check();
            }
        }));
        syncInput.addChangeListener(arg_0 -> DtsSettingsConfigurable.createActualPanel$lambda$0$1(syncInput, rootInput, boardInput, updateBoardList2, arg_0));
        rootStatus2.check();
        updateBoardList2.check();
        if (syncInput.isSelected()) {
            rootInput.setEnabled(false);
            boardInput.setEnabled(false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createActualPanel$lambda$0$0(JCheckBox $syncInput, DtsSettingsConfigurable this$0, RootComboBox $rootInput, BoardComboBox $boardInput, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> DtsSettingsConfigurable.createActualPanel$lambda$0$0$0($syncInput, this$0, arg_0), (int)1, null);
        $this$group.row(DtsBundle.Companion.message("settings.zephyr.root", new Object[0]) + ":", arg_0 -> DtsSettingsConfigurable.createActualPanel$lambda$0$0$1($rootInput, this$0, arg_0));
        $this$group.row(DtsBundle.Companion.message("settings.zephyr.board", new Object[0]) + ":", arg_0 -> DtsSettingsConfigurable.createActualPanel$lambda$0$0$2($boardInput, this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createActualPanel$lambda$0$0$0(JCheckBox $syncInput, DtsSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$syncInput).bind(DtsSettingsConfigurable::createActualPanel$lambda$0$0$0$0, (arg_0, arg_1) -> DtsSettingsConfigurable.createActualPanel$lambda$0$0$0$1(this$0, arg_0, arg_1), MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.state){

            public Object get() {
                return ((DtsSettings.State)this.receiver).getZephyrCMakeSync();
            }

            public void set(Object value) {
                ((DtsSettings.State)this.receiver).setZephyrCMakeSync((Boolean)value);
            }
        })));
        return Unit.INSTANCE;
    }

    private static final boolean createActualPanel$lambda$0$0$0$0(JCheckBox input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return input.isSelected();
    }

    private static final Unit createActualPanel$lambda$0$0$0$1(DtsSettingsConfigurable this$0, JCheckBox input, boolean value) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        input.setSelected(value && this$0.enableSync);
        return Unit.INSTANCE;
    }

    private static final Unit createActualPanel$lambda$0$0$1(RootComboBox $rootInput, DtsSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)((Object)$rootInput)).resizableColumn().bind(DtsSettingsConfigurable::createActualPanel$lambda$0$0$1$0, DtsSettingsConfigurable::createActualPanel$lambda$0$0$1$1, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.state){

            public Object get() {
                return ((DtsSettings.State)this.receiver).getZephyrRoot();
            }

            public void set(Object value) {
                ((DtsSettings.State)this.receiver).setZephyrRoot((String)value);
            }
        }))).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final String createActualPanel$lambda$0$0$1$0(RootComboBox input) {
        Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"input");
        return input.getText();
    }

    private static final Unit createActualPanel$lambda$0$0$1$1(RootComboBox input, String value) {
        Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"input");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        input.setText(value);
        return Unit.INSTANCE;
    }

    private static final Unit createActualPanel$lambda$0$0$2(BoardComboBox $boardInput, DtsSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)((Object)$boardInput)).resizableColumn().bind(DtsSettingsConfigurable::createActualPanel$lambda$0$0$2$0, DtsSettingsConfigurable::createActualPanel$lambda$0$0$2$1, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.state){

            public Object get() {
                return ((DtsSettings.State)this.receiver).getZephyrBoard();
            }

            public void set(Object value) {
                ((DtsSettings.State)this.receiver).setZephyrBoard((String)value);
            }
        }))).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final String createActualPanel$lambda$0$0$2$0(BoardComboBox input) {
        Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"input");
        return input.getText();
    }

    private static final Unit createActualPanel$lambda$0$0$2$1(BoardComboBox input, String value) {
        Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"input");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        input.setText(value);
        return Unit.INSTANCE;
    }

    private static final void createActualPanel$lambda$0$1(JCheckBox $syncInput, RootComboBox $rootInput, BoardComboBox $boardInput, createActualPanel.1.updateBoardList.1 $updateBoardList, ChangeEvent it) {
        if ($syncInput.isSelected()) {
            $rootInput.setEnabled(false);
            $boardInput.setEnabled(false);
        } else {
            $rootInput.setEnabled(!$syncInput.isSelected());
            $updateBoardList.check();
        }
    }

    private static final Unit apply$lambda$0(DtsSettingsConfigurable this$0, DtsSettings.State $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        $this$update.setZephyrRoot(this$0.state.getZephyrRoot());
        $this$update.setZephyrBoard(this$0.state.getZephyrBoard());
        $this$update.setZephyrCMakeSync(this$0.state.getZephyrCMakeSync());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Either access$validateRoot(DtsSettingsConfigurable $this, String path) {
        return $this.validateRoot(path);
    }

    public static final /* synthetic */ Either access$validateBoard(DtsSettingsConfigurable $this, String path) {
        return $this.validateBoard(path);
    }
}

