/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.settings;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.dts.DtsBundle;
import com.intellij.dts.lang.DtsLanguage;
import com.intellij.dts.settings.DtsCodeStyleSettings;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/dts/settings/DtsLangCodeStyleSettingsProvider;", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider;", "<init>", "()V", "getLanguage", "Lcom/intellij/lang/Language;", "getIndentOptionsEditor", "Lcom/intellij/application/options/IndentOptionsEditor;", "customizeDefaults", "", "commonSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "indentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "customizeSettings", "consumer", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsCustomizable;", "settingsType", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider$SettingsType;", "customizeSpacingSettings", "customizeWrappingSettings", "customizeBlankLinesSettings", "getCodeSample", "", "usesCommonKeepLineBreaks", "", "intellij.dts"})
public final class DtsLangCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        return DtsLanguage.INSTANCE;
    }

    @NotNull
    public IndentOptionsEditor getIndentOptionsEditor() {
        return (IndentOptionsEditor)new SmartIndentOptionsEditor();
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        Intrinsics.checkNotNullParameter((Object)commonSettings, (String)"commonSettings");
        Intrinsics.checkNotNullParameter((Object)indentOptions, (String)"indentOptions");
        indentOptions.USE_TAB_CHARACTER = true;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        switch (WhenMappings.$EnumSwitchMapping$0[settingsType.ordinal()]) {
            case 1: {
                this.customizeSpacingSettings(consumer);
                break;
            }
            case 2: {
                this.customizeWrappingSettings(consumer);
                break;
            }
            case 3: {
                this.customizeBlankLinesSettings(consumer);
            }
        }
    }

    private final void customizeSpacingSettings(CodeStyleSettingsCustomizable consumer) {
        String[] stringArray = new String[]{"SPACE_AROUND_ASSIGNMENT_OPERATORS", "SPACE_AROUND_RELATIONAL_OPERATORS", "SPACE_AROUND_BITWISE_OPERATORS", "SPACE_AROUND_ADDITIVE_OPERATORS", "SPACE_AROUND_MULTIPLICATIVE_OPERATORS", "SPACE_AROUND_SHIFT_OPERATORS", "SPACE_AROUND_LOGICAL_OPERATORS", "SPACE_WITHIN_BRACKETS", "SPACE_WITHIN_PARENTHESES", "SPACE_AFTER_COMMA", "SPACE_BEFORE_COMMA"};
        consumer.showStandardOptions(stringArray);
        consumer.renameStandardOption("SPACE_AROUND_ASSIGNMENT_OPERATORS", DtsBundle.Companion.message("settings.style.space_around_assignment_operators", new Object[0]));
        consumer.renameStandardOption("SPACE_AROUND_SHIFT_OPERATORS", DtsBundle.Companion.message("settings.style.space_around_shift_operators", new Object[0]));
        consumer.renameStandardOption("SPACE_WITHIN_BRACKETS", DtsBundle.Companion.message("settings.style.space_within_brackets", new Object[0]));
        consumer.renameStandardOption("SPACE_WITHIN_PARENTHESES", DtsBundle.Companion.message("settings.style.space_within_parentheses", new Object[0]));
        CodeStyleSettingsCustomizableOptions codeStyleSettingsCustomizableOptions = CodeStyleSettingsCustomizableOptions.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettingsCustomizableOptions, (String)"getInstance(...)");
        CodeStyleSettingsCustomizableOptions options = codeStyleSettingsCustomizableOptions;
        consumer.showCustomOption(DtsCodeStyleSettings.class, "SPACE_WITHIN_ANGULAR_BRACKETS", DtsBundle.Companion.message("settings.style.space_within_angular_brackets", new Object[0]), options.SPACES_WITHIN, new Object[0]);
        consumer.showCustomOption(DtsCodeStyleSettings.class, "SPACE_WITHIN_EMPTY_NODE", DtsBundle.Companion.message("settings.style.space_within_empty_node", new Object[0]), options.SPACES_WITHIN, new Object[0]);
        consumer.showCustomOption(DtsCodeStyleSettings.class, "SPACE_BETWEEN_BYTES", DtsBundle.Companion.message("settings.style.space_between_bytes", new Object[0]), options.SPACES_OTHER, new Object[0]);
        consumer.showCustomOption(DtsCodeStyleSettings.class, "SPACE_AFTER_LABEL", DtsBundle.Companion.message("settings.style.space_after_label", new Object[0]), options.SPACES_OTHER, new Object[0]);
    }

    private final void customizeWrappingSettings(CodeStyleSettingsCustomizable consumer) {
        String alignmentGroup = DtsBundle.Companion.message("settings.group.alignment", new Object[0]);
        String[] stringArray = new String[]{"WRAP_ON_TYPING", "KEEP_LINE_BREAKS", "WRAP_LONG_LINES"};
        consumer.showStandardOptions(stringArray);
        consumer.showCustomOption(DtsCodeStyleSettings.class, "ALIGN_PROPERTY_ASSIGNMENT", DtsBundle.Companion.message("settings.style.align_property_assignment", new Object[0]), alignmentGroup, new Object[0]);
        consumer.showCustomOption(DtsCodeStyleSettings.class, "ALIGN_PROPERTY_VALUES", DtsBundle.Companion.message("settings.style.align_property_values", new Object[0]), alignmentGroup, new Object[0]);
    }

    private final void customizeBlankLinesSettings(CodeStyleSettingsCustomizable consumer) {
        String[] stringArray = new String[]{"KEEP_BLANK_LINES_IN_CODE", "KEEP_LINE_BREAKS"};
        consumer.showStandardOptions(stringArray);
        CodeStyleSettingsCustomizableOptions codeStyleSettingsCustomizableOptions = CodeStyleSettingsCustomizableOptions.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettingsCustomizableOptions, (String)"getInstance(...)");
        CodeStyleSettingsCustomizableOptions options = codeStyleSettingsCustomizableOptions;
        consumer.showCustomOption(DtsCodeStyleSettings.class, "MAX_BLANK_LINES_BETWEEN_PROPERTIES", DtsBundle.Companion.message("settings.style.blank_lines_between_properties", new Object[0]) + ":", options.BLANK_LINES_KEEP, new Object[0]);
        consumer.showCustomOption(DtsCodeStyleSettings.class, "MIN_BLANK_LINES_BETWEEN_PROPERTIES", DtsBundle.Companion.message("settings.style.blank_lines_between_properties", new Object[0]) + ":", options.BLANK_LINES, new Object[0]);
        consumer.showCustomOption(DtsCodeStyleSettings.class, "MAX_BLANK_LINES_BETWEEN_NODES", DtsBundle.Companion.message("settings.style.blank_lines_between_nodes", new Object[0]) + ":", options.BLANK_LINES_KEEP, new Object[0]);
        consumer.showCustomOption(DtsCodeStyleSettings.class, "MIN_BLANK_LINES_BETWEEN_NODES", DtsBundle.Companion.message("settings.style.blank_lines_between_nodes", new Object[0]) + ":", options.BLANK_LINES, new Object[0]);
    }

    @NotNull
    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        return switch (WhenMappings.$EnumSwitchMapping$0[settingsType.ordinal()]) {
            case 1 -> "\n/dts-v1/;\n\n/ {\n    list = \"value1\", \"value2\";\n    cells = <0x1 0x2 0x3>;\n    bytes = [010203];\n    empty = <>, [];\n    expr = <((1 + 2) * 3 << 4 & 5) (0 || 1 ? 2 : 3)>;\n\n    label: node { };\n};\n";
            case 4 -> "\n/dts-v1/;\n\n/ {\n    property = \"value\";\n\n    node {\n        property = \"value\",\n        \"continuation\";\n\n        subNode {\n            property = \"value\";\n        };\n    };\n};\n";
            case 2 -> "\n/dts-v1/;\n\n/ {\n    property = \"value\";\n\n    list = \"value1\",\n    \"value2\";\n    \n    array = <0x00000000\n    0x00000000>;\n};\n";
            case 3 -> "\n/dts-v1/;\n/ {\n    property1 = \"value\";\n    property2 = \"value\";\n    node1 {};\n    node2 {};\n}; \n";
            default -> "\n/dts-v1/;\n\n/ {\n    list = \"value1\", \"value2\";\n    cells = <0x1 0x2 0x3>;\n    bytes = [010203];\n    empty = <>, [];\n    expr = <((1 + 2) * 3 << 4 & 5) (0 || 1 ? 2 : 3)>;\n\n    label: node { };\n};\n";
        };
    }

    public boolean usesCommonKeepLineBreaks() {
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LanguageCodeStyleSettingsProvider.SettingsType.values().length];
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

