/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.pp.lang.lexer;

import com.intellij.dts.pp.lang.PpTokenTypes;
import com.intellij.dts.pp.lang.lexer.PpLexer;
import com.intellij.dts.pp.lang.parser.PpAdHocParser;
import com.intellij.dts.pp.lang.psi.PpStatement;
import com.intellij.dts.pp.lang.psi.PpToken;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerUtil;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0014\u0010\u0019\u001a\u00020\u0014*\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0011H\u0004J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005H\u0004J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005H$J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0004J\u0016\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0004J\u001e\u0010#\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/dts/pp/lang/lexer/PpLexerAdapterBase;", "Lcom/intellij/lexer/LookAheadLexer;", "tokenTypes", "Lcom/intellij/dts/pp/lang/PpTokenTypes;", "baseLexer", "Lcom/intellij/lexer/Lexer;", "<init>", "(Lcom/intellij/dts/pp/lang/PpTokenTypes;Lcom/intellij/lexer/Lexer;)V", "getTokenTypes", "()Lcom/intellij/dts/pp/lang/PpTokenTypes;", "ppLexer", "Lcom/intellij/dts/pp/lang/lexer/PpLexer;", "ppParser", "Lcom/intellij/dts/pp/lang/parser/PpAdHocParser;", "currentBuffer", "", "currentStartOffset", "", "currentEndOffset", "start", "", "buffer", "startOffset", "endOffset", "initialState", "restoreState", "state", "lookAhead", "processMarker", "tokenizeStatement", "", "Lcom/intellij/dts/pp/lang/psi/PpToken;", "parseStatement", "Lcom/intellij/dts/pp/lang/psi/PpStatement;", "tokens", "addStatementsTokens", "intellij.dts.pp"})
public abstract class PpLexerAdapterBase
extends LookAheadLexer {
    @NotNull
    private final PpTokenTypes tokenTypes;
    @NotNull
    private final PpLexer ppLexer;
    @NotNull
    private final PpAdHocParser ppParser;
    @NotNull
    private CharSequence currentBuffer;
    private int currentStartOffset;
    private int currentEndOffset;

    public PpLexerAdapterBase(@NotNull PpTokenTypes tokenTypes, @NotNull Lexer baseLexer) {
        Intrinsics.checkNotNullParameter((Object)tokenTypes, (String)"tokenTypes");
        Intrinsics.checkNotNullParameter((Object)baseLexer, (String)"baseLexer");
        super(baseLexer);
        this.tokenTypes = tokenTypes;
        this.ppLexer = new PpLexer(null, this.tokenTypes);
        this.ppParser = new PpAdHocParser(this.tokenTypes);
        this.currentBuffer = "";
    }

    @NotNull
    protected final PpTokenTypes getTokenTypes() {
        return this.tokenTypes;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.currentBuffer = buffer;
        this.currentStartOffset = startOffset;
        this.currentEndOffset = endOffset;
        super.start(buffer, startOffset, endOffset, initialState);
    }

    protected final void restoreState(@NotNull Lexer $this$restoreState, int state) {
        Intrinsics.checkNotNullParameter((Object)$this$restoreState, (String)"<this>");
        $this$restoreState.start(this.currentBuffer, $this$restoreState.getTokenStart(), this.currentEndOffset, state);
    }

    protected final void lookAhead(@NotNull Lexer baseLexer) {
        Intrinsics.checkNotNullParameter((Object)baseLexer, (String)"baseLexer");
        if (!Intrinsics.areEqual((Object)baseLexer.getTokenType(), (Object)this.tokenTypes.getStatementMarker())) {
            this.advanceLexer(baseLexer);
        } else {
            this.processMarker(baseLexer);
        }
    }

    protected abstract void processMarker(@NotNull Lexer var1);

    @NotNull
    protected final List<PpToken> tokenizeStatement(@NotNull Lexer baseLexer) {
        List list;
        Intrinsics.checkNotNullParameter((Object)baseLexer, (String)"baseLexer");
        boolean bl = Intrinsics.areEqual((Object)baseLexer.getTokenType(), (Object)this.tokenTypes.getStatementMarker());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        CharSequence content = LexerUtil.getTokenText((Lexer)baseLexer);
        this.ppLexer.reset(content, 0, content.length(), 0);
        List $this$tokenizeStatement_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl2 = false;
        while (this.ppLexer.advance() != null) {
            IElementType token;
            CharSequence charSequence = this.ppLexer.yytext();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"yytext(...)");
            $this$tokenizeStatement_u24lambda_u240.add(new PpToken(token, charSequence, new TextRange(this.ppLexer.getTokenStart(), this.ppLexer.getTokenEnd())));
        }
        IElementType iElementType = this.tokenTypes.getStatementEnd();
        CharSequence charSequence = "";
        TextRange textRange = TextRange.from((int)content.length(), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
        $this$tokenizeStatement_u24lambda_u240.add(new PpToken(iElementType, charSequence, textRange));
        return CollectionsKt.build((List)list);
    }

    @NotNull
    protected final PpStatement parseStatement(@NotNull List<PpToken> tokens) {
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        return this.ppParser.parse(tokens);
    }

    protected final void addStatementsTokens(int startOffset, @NotNull List<PpToken> tokens) {
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        int offset = 0;
        for (PpToken token : tokens) {
            this.addToken(startOffset + (offset += token.getText().length()), token.getType());
        }
    }
}

