/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.lang.parser;

import com.intellij.dts.lang.DtsFile;
import com.intellij.dts.lang.DtsPpTokenTypes;
import com.intellij.dts.lang.DtsTokenSets;
import com.intellij.dts.lang.lexer.DtsParserLexerAdapter;
import com.intellij.dts.lang.parser.DtsParser;
import com.intellij.dts.lang.psi.DtsTypes;
import com.intellij.dts.lang.stubs.DtsFileStub;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/dts/lang/parser/DtsParserDefinition;", "Lcom/intellij/lang/ParserDefinition;", "<init>", "()V", "createLexer", "Lcom/intellij/lexer/Lexer;", "project", "Lcom/intellij/openapi/project/Project;", "createParser", "Lcom/intellij/lang/PsiParser;", "getFileNodeType", "Lcom/intellij/psi/tree/IFileElementType;", "getCommentTokens", "Lcom/intellij/psi/tree/TokenSet;", "getStringLiteralElements", "createElement", "Lcom/intellij/psi/PsiElement;", "node", "Lcom/intellij/lang/ASTNode;", "createFile", "Lcom/intellij/psi/PsiFile;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "intellij.dts"})
public class DtsParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(@Nullable Project project) {
        return (Lexer)new DtsParserLexerAdapter();
    }

    @NotNull
    public PsiParser createParser(@Nullable Project project) {
        return new DtsParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return (IFileElementType)DtsFileStub.Type.INSTANCE;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread((Object)DtsTokenSets.INSTANCE.getComments().getTypes());
        spreadBuilder.add((Object)DtsTypes.PP_INACTIVE);
        TokenSet tokenSet = TokenSet.create((IElementType[])((IElementType[])spreadBuilder.toArray((Object[])new IElementType[spreadBuilder.size()])));
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return DtsTokenSets.INSTANCE.getStrings();
    }

    @NotNull
    public PsiElement createElement(@Nullable ASTNode node) {
        return DtsPpTokenTypes.INSTANCE.createElement(node);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        String string = viewProvider.getVirtualFile().getExtension();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case -1091287984: {
                    if (!string.equals("overlay")) break;
                    n = 1;
                    break;
                }
                case 3094246: {
                    if (!string.equals("dtsi")) break;
                    n = 2;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    psiFile = (PsiFile)new DtsFile.Overlay(viewProvider);
                    return psiFile;
                }
                case 2: {
                    psiFile = (PsiFile)new DtsFile.Include(viewProvider);
                    return psiFile;
                }
            }
        }
        psiFile = (PsiFile)new DtsFile.Source(viewProvider);
        return psiFile;
    }
}

