/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.dts.inspections.DtsInspectionsUtilKt;
import com.intellij.dts.inspections.DtsUnitNameInspectionKt;
import com.intellij.dts.lang.psi.DtsSubNode;
import com.intellij.dts.lang.psi.DtsVisitorKt;
import com.intellij.dts.util.DtsUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/dts/inspections/DtsUnitNameInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkNodeName", "", "node", "Lcom/intellij/dts/lang/psi/DtsSubNode;", "intellij.dts"})
public final class DtsUnitNameInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return DtsVisitorKt.dtsVisitor(Reflection.getOrCreateKotlinClass(DtsSubNode.class), arg_0 -> DtsUnitNameInspection.buildVisitor$lambda$0(this, holder, arg_0));
    }

    private final void checkNodeName(DtsSubNode node, ProblemsHolder holder) {
        Pair<String, String> pair = DtsUtil.INSTANCE.splitName(node.getDtsName());
        String baseName = (String)pair.component1();
        String addr = (String)pair.component2();
        if (addr == null) {
            return;
        }
        if (StringsKt.startsWith$default((String)addr, (String)"0x", (boolean)false, (int)2, null)) {
            DtsInspectionsUtilKt.registerProblem$default(holder, node, "inspections.unit_name.leading_0x", null, TextRange.from((int)(baseName.length() + 1), (int)addr.length()), null, 20, null);
            return;
        }
        if (DtsUnitNameInspectionKt.access$getLeading0s$p().matchesAt((CharSequence)addr, 0)) {
            DtsInspectionsUtilKt.registerProblem$default(holder, node, "inspections.unit_name.leading_0s", null, TextRange.from((int)(baseName.length() + 1), (int)addr.length()), null, 20, null);
        }
    }

    private static final Unit buildVisitor$lambda$0(DtsUnitNameInspection this$0, ProblemsHolder $holder, DtsSubNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.checkNodeName(it, $holder);
        return Unit.INSTANCE;
    }
}

