/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.dts.api.DtsNodeVisitor;
import com.intellij.dts.api.DtsNodeVisitorKt;
import com.intellij.dts.inspections.DtsInspectionsUtilKt;
import com.intellij.dts.inspections.fixes.DtsCreatePropertyFix;
import com.intellij.dts.lang.DtsFile;
import com.intellij.dts.lang.psi.DtsNode;
import com.intellij.dts.lang.psi.DtsProperty;
import com.intellij.dts.lang.psi.DtsVisitorKt;
import com.intellij.dts.zephyr.binding.DtsZephyrBinding;
import com.intellij.dts.zephyr.binding.DtsZephyrBindingProvider;
import com.intellij.dts.zephyr.binding.DtsZephyrPropertyBinding;
import com.intellij.psi.PsiElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/dts/inspections/DtsRequiredPropertyInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "collectProperties", "", "", "node", "Lcom/intellij/dts/lang/psi/DtsNode;", "checkProperties", "", "intellij.dts"})
@SourceDebugExtension(value={"SMAP\nDtsRequiredPropertyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtsRequiredPropertyInspection.kt\ncom/intellij/dts/inspections/DtsRequiredPropertyInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n774#2:62\n865#2,2:63\n*S KotlinDebug\n*F\n+ 1 DtsRequiredPropertyInspection.kt\ncom/intellij/dts/inspections/DtsRequiredPropertyInspection\n*L\n46#1:62\n46#1:63,2\n*E\n"})
public final class DtsRequiredPropertyInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return DtsVisitorKt.dtsVisitor(Reflection.getOrCreateKotlinClass(DtsNode.class), arg_0 -> DtsRequiredPropertyInspection.buildVisitor$lambda$0(this, holder, arg_0));
    }

    private final Set<String> collectProperties(DtsNode node) {
        Set properties = new LinkedHashSet();
        DtsNodeVisitor visitor2 = new DtsNodeVisitor(properties){
            final /* synthetic */ Set<String> $properties;
            {
                this.$properties = $properties;
            }

            public void visitDelete() {
                this.$properties.clear();
            }

            public void visitProperty(DtsProperty property) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                this.$properties.add(property.getDtsName());
            }

            public void visitDeleteProperty(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                this.$properties.remove(name);
            }
        };
        DtsNodeVisitorKt.dtsAccept$default(node, visitor2, false, false, 2, null);
        return properties;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkProperties(DtsNode node, ProblemsHolder holder) {
        void $this$filterTo$iv$iv;
        Object object = DtsZephyrBindingProvider.Companion.bindingFor(node, false);
        if (object == null || (object = ((DtsZephyrBinding)object).getProperties()) == null) {
            return;
        }
        Object propertyBindings = object;
        Iterable $this$filter$iv = propertyBindings.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DtsZephyrPropertyBinding it = (DtsZephyrPropertyBinding)element$iv$iv;
            boolean bl = false;
            if (!it.getRequired()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List requiredProperties = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (requiredProperties.isEmpty()) {
            return;
        }
        Set<String> declaredProperties = this.collectProperties(node);
        CollectionsKt.removeAll((List)requiredProperties, arg_0 -> DtsRequiredPropertyInspection.checkProperties$lambda$1(declaredProperties, arg_0));
        if (requiredProperties.isEmpty()) {
            return;
        }
        DtsInspectionsUtilKt.registerProblem$default(holder, node, "inspections.required_property.error", CollectionsKt.joinToString$default((Iterable)requiredProperties, null, null, null, (int)0, null, DtsRequiredPropertyInspection::checkProperties$lambda$2, (int)31, null), null, (LocalQuickFix)new DtsCreatePropertyFix(requiredProperties), 8, null);
    }

    private static final Unit buildVisitor$lambda$0(DtsRequiredPropertyInspection this$0, ProblemsHolder $holder, DtsNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.getContainingFile() instanceof DtsFile.Source || node.getContainingFile() instanceof DtsFile.Overlay) {
            this$0.checkProperties(node, $holder);
        }
        return Unit.INSTANCE;
    }

    private static final boolean checkProperties$lambda$1(Set $declaredProperties, DtsZephyrPropertyBinding it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $declaredProperties.contains(it.getName());
    }

    private static final CharSequence checkProperties$lambda$2(DtsZephyrPropertyBinding it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it.getName() + "\"";
    }
}

