/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.dts.inspections.DtsInspectionsUtilKt;
import com.intellij.dts.inspections.DtsLabelNameInspectionKt;
import com.intellij.dts.lang.psi.DtsTypes;
import com.intellij.dts.lang.psi.DtsVisitorKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/dts/inspections/DtsLabelNameInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkLabel", "", "label", "Lcom/intellij/psi/PsiElement;", "intellij.dts"})
public final class DtsLabelNameInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        IElementType iElementType = DtsTypes.LABEL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"LABEL");
        return DtsVisitorKt.dtsVisitor(iElementType, (Function1<? super PsiElement, Unit>)((Function1)arg_0 -> DtsLabelNameInspection.buildVisitor$lambda$0(this, holder, arg_0)));
    }

    private final void checkLabel(PsiElement label, ProblemsHolder holder) {
        String string = label.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        char[] cArray = new char[]{':'};
        String name = StringsKt.trimEnd((String)string, (char[])cArray);
        if (!DtsLabelNameInspectionKt.access$getStartRx$p().matches((CharSequence)StringsKt.substring((String)name, (IntRange)new IntRange(0, 0)))) {
            DtsInspectionsUtilKt.registerProblem$default(holder, label, "inspections.label_name.bad_first_char", Character.valueOf(name.charAt(0)), TextRange.from((int)0, (int)name.length()), null, 16, null);
            return;
        }
        DtsInspectionsUtilKt.firstNotMatching(name, DtsLabelNameInspectionKt.access$getRx$p(), (Function1<? super Character, Unit>)((Function1)arg_0 -> DtsLabelNameInspection.checkLabel$lambda$0(holder, label, name, arg_0)));
    }

    private static final Unit buildVisitor$lambda$0(DtsLabelNameInspection this$0, ProblemsHolder $holder, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.checkLabel(it, $holder);
        return Unit.INSTANCE;
    }

    private static final Unit checkLabel$lambda$0(ProblemsHolder $holder, PsiElement $label, String $name, char it) {
        DtsInspectionsUtilKt.registerProblem$default($holder, $label, "inspections.label_name.bad_char", Character.valueOf(it), TextRange.from((int)0, (int)$name.length()), null, 16, null);
        return Unit.INSTANCE;
    }
}

