/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.dts.inspections.DtsInspectionsUtilKt;
import com.intellij.dts.inspections.fixes.DtsRemovePropertyFix;
import com.intellij.dts.inspections.fixes.DtsRemoveSubNodeFix;
import com.intellij.dts.lang.psi.DtsNode;
import com.intellij.dts.lang.psi.DtsProperty;
import com.intellij.dts.lang.psi.DtsSubNode;
import com.intellij.dts.lang.psi.DtsVisitorKt;
import com.intellij.psi.PsiElementVisitor;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/dts/inspections/DtsDuplicateElementInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkProperties", "", "node", "Lcom/intellij/dts/lang/psi/DtsNode;", "checkSubNodes", "intellij.dts"})
public final class DtsDuplicateElementInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return DtsVisitorKt.dtsVisitor(Reflection.getOrCreateKotlinClass(DtsNode.class), arg_0 -> DtsDuplicateElementInspection.buildVisitor$lambda$0(this, holder, arg_0));
    }

    private final void checkProperties(DtsNode node, ProblemsHolder holder) {
        Set properties = new LinkedHashSet();
        for (DtsProperty property : node.getDtsProperties()) {
            if (properties.add(property.getDtsName())) continue;
            DtsInspectionsUtilKt.registerProblem$default(holder, property, "inspections.duplicate_element.property_error", null, null, (LocalQuickFix)(property.getDtsIsComplete() ? DtsRemovePropertyFix.INSTANCE : null), 12, null);
        }
    }

    private final void checkSubNodes(DtsNode node, ProblemsHolder holder) {
        Set subNodes = new LinkedHashSet();
        for (DtsSubNode subNode : node.getDtsSubNodes()) {
            if (subNodes.add(subNode.getDtsName())) continue;
            DtsInspectionsUtilKt.registerProblem$default(holder, subNode, "inspections.duplicate_element.sub_node_error", null, null, (LocalQuickFix)(subNode.getDtsIsComplete() ? DtsRemoveSubNodeFix.INSTANCE : null), 12, null);
        }
    }

    private static final Unit buildVisitor$lambda$0(DtsDuplicateElementInspection this$0, ProblemsHolder $holder, DtsNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.checkProperties(it, $holder);
        this$0.checkSubNodes(it, $holder);
        return Unit.INSTANCE;
    }
}

