/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.dts.inspections.DtsInspectionsUtilKt;
import com.intellij.dts.lang.psi.DtsContainer;
import com.intellij.dts.lang.psi.DtsStatement;
import com.intellij.dts.lang.psi.DtsVisitorKt;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/dts/inspections/DtsContainerInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkRootContainer", "", "container", "Lcom/intellij/dts/lang/psi/DtsContainer;", "checkNodeContainer", "intellij.dts"})
public final class DtsContainerInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return DtsVisitorKt.dtsVisitor(Reflection.getOrCreateKotlinClass(DtsContainer.class), arg_0 -> DtsContainerInspection.buildVisitor$lambda$0(this, holder, arg_0));
    }

    private final void checkRootContainer(DtsContainer container, ProblemsHolder holder) {
        for (DtsStatement statement : container.getDtsStatements()) {
            if (statement.getDtsAffiliation().isRoot() || statement.getDtsAffiliation().isUnknown()) continue;
            DtsInspectionsUtilKt.registerProblem$default(holder, statement, "inspections.container.message_root", null, null, null, 28, null);
            return;
        }
    }

    private final void checkNodeContainer(DtsContainer container, ProblemsHolder holder) {
        for (DtsStatement statement : container.getDtsStatements()) {
            if (!statement.getDtsAffiliation().isRoot()) continue;
            DtsInspectionsUtilKt.registerProblem$default(holder, statement, "inspections.container.message_node", null, null, null, 28, null);
            return;
        }
    }

    private static final Unit buildVisitor$lambda$0(DtsContainerInspection this$0, ProblemsHolder $holder, DtsContainer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getDtsAffiliation().isRoot()) {
            this$0.checkRootContainer(it, $holder);
        } else if (it.getDtsAffiliation().isNode()) {
            this$0.checkNodeContainer(it, $holder);
        }
        return Unit.INSTANCE;
    }
}

