/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.formatting;

import com.intellij.dts.formatting.DtsIndentingBuilder;
import com.intellij.dts.formatting.DtsSpacingBuilder;
import com.intellij.dts.formatting.DtsWrappingBuilder;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.common.AbstractBlock;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001bH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/dts/formatting/DtsBlock;", "Lcom/intellij/psi/formatter/common/AbstractBlock;", "node", "Lcom/intellij/lang/ASTNode;", "wrappingBuilder", "Lcom/intellij/dts/formatting/DtsWrappingBuilder;", "spacingBuilder", "Lcom/intellij/dts/formatting/DtsSpacingBuilder;", "parent", "<init>", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/dts/formatting/DtsWrappingBuilder;Lcom/intellij/dts/formatting/DtsSpacingBuilder;Lcom/intellij/dts/formatting/DtsBlock;)V", "getSpacing", "Lcom/intellij/formatting/Spacing;", "child1", "Lcom/intellij/formatting/Block;", "child2", "getIndent", "Lcom/intellij/formatting/Indent;", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "", "getDebugName", "", "isLeaf", "", "buildChildren", "", "Companion", "intellij.dts"})
public final class DtsBlock
extends AbstractBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DtsWrappingBuilder wrappingBuilder;
    @NotNull
    private final DtsSpacingBuilder spacingBuilder;
    @Nullable
    private final DtsBlock parent;
    @NotNull
    private static final DtsIndentingBuilder indentingBuilder = new DtsIndentingBuilder();

    public DtsBlock(@NotNull ASTNode node, @NotNull DtsWrappingBuilder wrappingBuilder, @NotNull DtsSpacingBuilder spacingBuilder, @Nullable DtsBlock parent) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)wrappingBuilder, (String)"wrappingBuilder");
        Intrinsics.checkNotNullParameter((Object)spacingBuilder, (String)"spacingBuilder");
        super(node, wrappingBuilder.getWrap((Block)parent, node), wrappingBuilder.getAlignment((Block)parent, node));
        this.wrappingBuilder = wrappingBuilder;
        this.spacingBuilder = spacingBuilder;
        this.parent = parent;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
        return this.spacingBuilder.getSpacing((Block)this, child1, child2);
    }

    @NotNull
    public Indent getIndent() {
        Indent indent = indentingBuilder.getIndenting((Block)this.parent, (Block)this);
        if (indent == null) {
            Indent indent2 = Indent.getNoneIndent();
            indent = indent2;
            Intrinsics.checkNotNullExpressionValue((Object)indent2, (String)"getNoneIndent(...)");
        }
        return indent;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(indentingBuilder.getChildIndenting((Block)this, newChildIndex), null);
    }

    @NotNull
    public String getDebugName() {
        return "Dts" + (this.isLeaf() ? "Leaf" : "") + "Block(" + this.getNode().getElementType() + ")";
    }

    public boolean isLeaf() {
        return this.getNode().getFirstChildNode() == null;
    }

    @NotNull
    protected List<Block> buildChildren() {
        DtsWrappingBuilder childWrappingBuilder = DtsWrappingBuilder.Companion.childBuilder((Block)this, this.wrappingBuilder);
        ASTNode[] aSTNodeArray = this.getNode().getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
        return SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])aSTNodeArray), (Function1)((Function1)new Function1<ASTNode, Boolean>((Object)Companion){

            public final Boolean invoke(ASTNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).isValidForBlock(p0);
            }
        })), arg_0 -> DtsBlock.buildChildren$lambda$0(childWrappingBuilder, this, arg_0)));
    }

    private static final DtsBlock buildChildren$lambda$0(DtsWrappingBuilder $childWrappingBuilder, DtsBlock this$0, ASTNode it) {
        Intrinsics.checkNotNull((Object)it);
        return new DtsBlock(it, $childWrappingBuilder, this$0.spacingBuilder, this$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/dts/formatting/DtsBlock$Companion;", "", "<init>", "()V", "indentingBuilder", "Lcom/intellij/dts/formatting/DtsIndentingBuilder;", "isValidForBlock", "", "node", "Lcom/intellij/lang/ASTNode;", "intellij.dts"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isValidForBlock(@NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (Intrinsics.areEqual((Object)node.getElementType(), (Object)TokenType.WHITE_SPACE)) {
                return false;
            }
            return !node.getTextRange().isEmpty();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

