/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.diagnostics;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.RSyncUtil;
import com.intellij.ssh.rsync.RSyncOptions;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.cpp.diagnostics.CdIndenter;
import com.jetbrains.cidr.cpp.diagnostics.CdToolchainsKt;
import com.jetbrains.cidr.cpp.diagnostics.CppDiagnosticsAction;
import com.jetbrains.cidr.cpp.diagnostics.model.CppEnvironmentInfo;
import com.jetbrains.cidr.cpp.diagnostics.model.DevOptions;
import com.jetbrains.cidr.cpp.diagnostics.model.ExecutableToolInfo;
import com.jetbrains.cidr.cpp.diagnostics.model.PathMappingItem;
import com.jetbrains.cidr.cpp.diagnostics.model.Reportable;
import com.jetbrains.cidr.cpp.diagnostics.model.SystemInfo;
import com.jetbrains.cidr.cpp.diagnostics.model.ToolchainsSection;
import com.jetbrains.cidr.cpp.diagnostics.toolchain.ToolchainDescriptionProvider;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.WorkspaceWithEnvironment;
import com.jetbrains.cidr.system.CidrRSyncUtil;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.MappedHost;
import com.jetbrains.cidr.system.PathMapperWrapper;
import com.jetbrains.cidr.system.RemoteDeployment;
import com.jetbrains.cidr.system.RemoteDeploymentHelper;
import com.jetbrains.cidr.system.RemoteHost;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.toolchains.CidrExecutableTool;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0006\u0010\u0006\u001a\u00020\u0007\u001a\b\u0010\b\u001a\u00020\tH\u0002\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001aO\u0010\u001e\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u00152\b\b\u0001\u0010 \u001a\u00020!2!\u0010\"\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00170#2\b\b\u0002\u0010&\u001a\u00020!H\u0002\u001a\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u000e\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+\u001a\u0018\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120-2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00120-2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "collectToolchains", "Lcom/jetbrains/cidr/cpp/diagnostics/model/ToolchainsSection;", "project", "Lcom/intellij/openapi/project/Project;", "processSystemInfo", "Lcom/jetbrains/cidr/cpp/diagnostics/model/SystemInfo;", "processDevOptions", "Lcom/jetbrains/cidr/cpp/diagnostics/model/DevOptions;", "processRemoteHost", "", "log", "Lcom/jetbrains/cidr/cpp/diagnostics/CdIndenter;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "processCPPEnvironment", "Lcom/jetbrains/cidr/cpp/diagnostics/model/CppEnvironmentInfo;", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "testRemoteHost", "remoteHost", "Lcom/jetbrains/cidr/system/HostMachine;", "checkConnection", "", "processCheck", "checkRemoteFS", "checkRemoteTar", "checkRemoteRsync", "checkRemotePigz", "checkRsyncDownload", "test", "host", "testName", "", "check", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "failStatusMsg", "getCredentials", "Lcom/intellij/remote/RemoteCredentials;", "stackTraceToString", "t", "", "getAllEnvironments", "", "getAllProjectEnvironments", "intellij.clion.diagnostics"})
@SourceDebugExtension(value={"SMAP\nCdToolchains.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CdToolchains.kt\ncom/jetbrains/cidr/cpp/diagnostics/CdToolchainsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CdIndenter.kt\ncom/jetbrains/cidr/cpp/diagnostics/CdIndenter\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,351:1\n1869#2:352\n1563#2:353\n1634#2,3:354\n1870#2:357\n1563#2:367\n1634#2,3:368\n1563#2:372\n1634#2,3:373\n1563#2:376\n1634#2,3:377\n1563#2:380\n1634#2,3:381\n774#2:384\n865#2,2:385\n1617#2,9:387\n1869#2:396\n1870#2:398\n1626#2:399\n1669#2,8:400\n1617#2,9:408\n1869#2:417\n1870#2:419\n1626#2:420\n1374#2:421\n1460#2,5:422\n1617#2,9:427\n1869#2:436\n1870#2:438\n1626#2:439\n1669#2,8:440\n30#3,8:358\n1#4:366\n1#4:397\n1#4:418\n1#4:437\n50#5:371\n13#6:448\n*S KotlinDebug\n*F\n+ 1 CdToolchains.kt\ncom/jetbrains/cidr/cpp/diagnostics/CdToolchainsKt\n*L\n53#1:352\n69#1:353\n69#1:354,3\n53#1:357\n172#1:367\n172#1:368,3\n203#1:372\n203#1:373,3\n328#1:376\n328#1:377,3\n330#1:380\n330#1:381,3\n331#1:384\n331#1:385,2\n332#1:387,9\n332#1:396\n332#1:398\n332#1:399\n340#1:400,8\n346#1:408,9\n346#1:417\n346#1:419\n346#1:420\n347#1:421\n347#1:422,5\n348#1:427,9\n348#1:436\n348#1:438\n348#1:439\n349#1:440,8\n124#1:358,8\n332#1:397\n346#1:418\n348#1:437\n186#1:371\n48#1:448\n*E\n"})
public final class CdToolchainsKt {
    @NotNull
    private static final Logger LOGGER;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ToolchainsSection collectToolchains(@Nullable Project project) {
        SystemInfo system = CdToolchainsKt.processSystemInfo();
        List envs = new ArrayList();
        Iterable $this$forEach$iv = CdToolchainsKt.getAllEnvironments(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CPPEnvironment it = (CPPEnvironment)element$iv;
            boolean bl = false;
            try {
                envs.add(CdToolchainsKt.processCPPEnvironment(it));
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                String string;
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                CPPToolchains.Toolchain tc;
                LOGGER.warn("Failed to get CPPEnvironment to process " + it.getToolchain().getName(), (Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)it.getToolchain(), (String)"getToolchain(...)");
                Intrinsics.checkNotNullExpressionValue((Object)tc.getName(), (String)"getName(...)");
                String string2 = tc.getOSType().toString();
                String string3 = tc.getToolSetKind().toString();
                String string4 = tc.getToolSetPath();
                List list = tc.getToolSetOptions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getToolSetOptions(...)");
                Object[] objectArray = (Object[])list;
                String string5 = string4;
                String string6 = string3;
                String string7 = string2;
                List list2 = envs;
                boolean $i$f$map = false;
                void var18_19 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void opt;
                    CPPToolSet.Option option = (CPPToolSet.Option)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    String string8 = opt.getUniqueID();
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getUniqueID(...)");
                    collection.add(string8);
                }
                collection = (List)destination$iv$iv;
                objectArray = new String[]{"Failed to get CPPEnvironment to process " + it.getToolchain().getName() + ": " + e.getLocalizedMessage(), "Please, see logs for details."};
                String string9 = null;
                String string10 = null;
                List list3 = CollectionsKt.emptyList();
                List list4 = CollectionsKt.emptyList();
                List list5 = CollectionsKt.listOf((Object[])objectArray);
                String string11 = tc.getCustomCXXCompilerPath();
                String string12 = tc.getCustomCCompilerPath();
                Collection<String> collection2 = collection;
                String string13 = string5;
                String string14 = string6;
                String string15 = string7;
                String string16 = string;
                list2.add(new CppEnvironmentInfo(string16, string15, string14, string13, (List<String>)collection2, string12, string11, list5, list4, list3, string10, string9));
            }
        }
        return new ToolchainsSection(system, envs);
    }

    @NotNull
    public static final SystemInfo processSystemInfo() {
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"getInstance(...)");
        ApplicationNamesInfo namesInfo = applicationNamesInfo;
        CPPToolchains cPPToolchains = CPPToolchains.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)cPPToolchains, (String)"getInstance(...)");
        CPPToolchains cppToolchains = cPPToolchains;
        String string = namesInfo.getFullProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullProductName(...)");
        String string2 = appInfo.getBuild().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String string3 = com.intellij.openapi.util.SystemInfo.OS_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"OS_NAME");
        String string4 = com.intellij.openapi.util.SystemInfo.OS_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"OS_VERSION");
        String string5 = com.intellij.openapi.util.SystemInfo.OS_ARCH;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"OS_ARCH");
        CPPToolchains.Toolchain toolchain = cppToolchains.getDefaultToolchain();
        return new SystemInfo(string, string2, string3, string4, string5, toolchain != null ? toolchain.getName() : null, CdToolchainsKt.processDevOptions());
    }

    private static final DevOptions processDevOptions() {
        boolean compressTar = Registry.Companion.is("clion.remote.compress.tar", true);
        int tarTimeout = Registry.Companion.intValue("clion.remote.tar.timeout", 240000);
        boolean resyncSystemCache = Registry.Companion.is("clion.remote.resync.system.cache", false);
        boolean uploadExternalChanges = Registry.Companion.is("clion.remote.upload.external.changes", true);
        return new DevOptions(compressTar, tarTimeout, resyncSystemCache, uploadExternalChanges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void processRemoteHost(@NotNull CdIndenter log, @NotNull CidrToolEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (!environment.getHostMachine().isRemote()) {
            return;
        }
        HostMachine remoteHost = environment.getHostMachine();
        String string = remoteHost.getHostId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostId(...)");
        String hostId = string;
        boolean isWsl = environment instanceof CPPEnvironment && ((CPPEnvironment)environment).getToolSet().isWSL();
        Object[] objectArray = new Object[]{"Remote Host: " + remoteHost.getName() + " (" + hostId + ")", isWsl ? " is WSL" : ""};
        log.put(objectArray);
        CdIndenter this_$iv = log;
        boolean $i$f$scope = false;
        this_$iv.indent();
        try {
            boolean bl = false;
            Intrinsics.checkNotNull((Object)remoteHost);
            CdToolchainsKt.testRemoteHost(log, remoteHost);
            if (environment instanceof CPPEnvironment) {
                CppEnvironmentInfo envInfo = CdToolchainsKt.processCPPEnvironment((CPPEnvironment)environment);
                envInfo.appendTo(log);
            }
        }
        finally {
            this_$iv.unIndent();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final CppEnvironmentInfo processCPPEnvironment(CPPEnvironment environment) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection destination$iv$iv;
        ExecutableToolInfo it;
        List list;
        ProgressManager.checkCanceled();
        CPPToolchains.Toolchain toolchain = environment.getToolchain();
        Intrinsics.checkNotNullExpressionValue((Object)toolchain, (String)"getToolchain(...)");
        CPPToolchains.Toolchain toolchain2 = toolchain;
        HostMachine hostMachine = environment.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"getHostMachine(...)");
        HostMachine hostMachine2 = hostMachine;
        List descriptionExtras = new ArrayList();
        Reportable reportable = ToolchainDescriptionProvider.Companion.describe(toolchain2, hostMachine2);
        if (reportable != null) {
            Reportable section = reportable;
            boolean bl = false;
            CollectionsKt.addAll((Collection)descriptionExtras, (Iterable)StringsKt.lines((CharSequence)section.toText()));
        }
        List $this$processCPPEnvironment_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        ExecutableToolInfo executableToolInfo = CdToolchainsKt.processCPPEnvironment$toolInfo((CidrExecutableTool)environment.getCMake(), "cmake");
        if (executableToolInfo != null) {
            it = executableToolInfo;
            boolean bl2 = false;
            $this$processCPPEnvironment_u24lambda_u241.add(it);
        }
        ExecutableToolInfo executableToolInfo2 = CdToolchainsKt.processCPPEnvironment$toolInfo((CidrExecutableTool)environment.getMake(), "make");
        if (executableToolInfo2 != null) {
            it = executableToolInfo2;
            boolean bl3 = false;
            $this$processCPPEnvironment_u24lambda_u241.add(it);
        }
        ExecutableToolInfo executableToolInfo3 = CdToolchainsKt.processCPPEnvironment$toolInfo((CidrExecutableTool)environment.getGDB(), "cmake");
        if (executableToolInfo3 != null) {
            it = executableToolInfo3;
            boolean bl4 = false;
            $this$processCPPEnvironment_u24lambda_u241.add(it);
        }
        List tools = CollectionsKt.build((List)list);
        List pathMappings = null;
        try {
            if (hostMachine2 instanceof MappedHost) {
                PathMapper pathMapper = ((MappedHost)hostMachine2).getPathMapper();
                Intrinsics.checkNotNullExpressionValue((Object)pathMapper, (String)"getPathMapper(...)");
                PathMapper pathMapper2 = pathMapper;
                if (pathMapper2 instanceof PathMapperWrapper) {
                    PathMapper pathMapper3 = ((PathMapperWrapper)pathMapper2).getOriginal();
                    Intrinsics.checkNotNullExpressionValue((Object)pathMapper3, (String)"getOriginal(...)");
                    pathMapper2 = pathMapper3;
                }
                if (pathMapper2 instanceof PathMappingSettings) {
                    void $this$mapTo$iv$iv2;
                    List list2 = ((PathMappingSettings)pathMapper2).getPathMappings();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPathMappings(...)");
                    Iterable $this$map$iv2 = list2;
                    boolean $i$f$map = false;
                    Iterable bl4 = $this$map$iv2;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it2;
                        PathMappingSettings.PathMapping pathMapping = (PathMappingSettings.PathMapping)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl5 = false;
                        String string = it2.getLocalRoot();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalRoot(...)");
                        String string2 = it2.getRemoteRoot();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRemoteRoot(...)");
                        collection2.add(new PathMappingItem(string, string2));
                    }
                    pathMappings = (List)destination$iv$iv;
                }
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Exception e) {
            Collection $this$map$iv2 = descriptionExtras;
            Object[] $i$f$map = new String[]{"Failed to get path mappings: " + e.getLocalizedMessage(), "Please, see logs for details."};
            CollectionsKt.addAll((Collection)$this$map$iv2, (Iterable)CollectionsKt.listOf((Object[])$i$f$map));
            LOGGER.warn("Failed to get path mappings", (Throwable)e);
        }
        String rootPath = null;
        String headerRootsCache = null;
        boolean $i$f$serviceOrNull = false;
        Application application = ApplicationManager.getApplication();
        if ((application != null ? application.getService(RemoteDeployment.class) : null) != null) {
            String string = RemoteDeploymentHelper.getRootPath((String)hostMachine2.getHostId());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRootPath(...)");
            String root = string;
            if (((CharSequence)root).length() == 0) {
                root = "not specified";
            }
            rootPath = root;
            if (hostMachine2 instanceof RemoteHost) {
                headerRootsCache = ((RemoteHost)hostMachine2).getCacheDirectory().getAbsolutePath();
            }
        }
        String string = toolchain2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string3 = toolchain2.getOSType().toString();
        String string4 = toolchain2.getToolSetKind().toString();
        String string5 = toolchain2.getToolSetPath();
        List list3 = toolchain2.getToolSetOptions();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getToolSetOptions(...)");
        Iterable root = list3;
        String string6 = string5;
        String string7 = string4;
        String string8 = string3;
        String string9 = string;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            CPPToolSet.Option bl5 = (CPPToolSet.Option)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl6 = false;
            String string10 = it3.getUniqueID();
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getUniqueID(...)");
            collection.add(string10);
        }
        collection = (List)destination$iv$iv2;
        String string11 = headerRootsCache;
        String string12 = rootPath;
        List list4 = pathMappings;
        List list5 = tools;
        List list6 = descriptionExtras;
        String string13 = toolchain2.getCustomCXXCompilerPath();
        String string14 = toolchain2.getCustomCCompilerPath();
        Collection<String> collection3 = collection;
        String string15 = string6;
        String string16 = string7;
        String string17 = string8;
        String string18 = string9;
        return new CppEnvironmentInfo(string18, string17, string16, string15, (List<String>)collection3, string14, string13, list6, list5, list4, string12, string11);
    }

    private static final void testRemoteHost(CdIndenter log, HostMachine remoteHost) {
        boolean isConnected2 = CdToolchainsKt.test$default(log, remoteHost, "test connection", testRemoteHost.isConnected.1.INSTANCE, null, 16, null);
        if (isConnected2) {
            CdToolchainsKt.test$default(log, remoteHost, "run remote process", testRemoteHost.1.INSTANCE, null, 16, null);
            CdToolchainsKt.test$default(log, remoteHost, "remote FS", testRemoteHost.2.INSTANCE, null, 16, null);
            CdToolchainsKt.test$default(log, remoteHost, "tar", testRemoteHost.3.INSTANCE, null, 16, null);
            CdToolchainsKt.test(log, remoteHost, "rsync local", (Function1<? super HostMachine, Boolean>)((Function1)arg_0 -> CdToolchainsKt.testRemoteHost$lambda$0(remoteHost, arg_0)), "[NOT CONFIGURED]");
            CdToolchainsKt.test$default(log, remoteHost, "rsync remote", testRemoteHost.5.INSTANCE, null, 16, null);
            CdToolchainsKt.test$default(log, remoteHost, "rsync download", testRemoteHost.6.INSTANCE, null, 16, null);
            CdToolchainsKt.test$default(log, remoteHost, "pigz remote", testRemoteHost.7.INSTANCE, null, 16, null);
        }
    }

    private static final boolean checkConnection(HostMachine remoteHost) {
        return RemoteUtil.checkConnection((RemoteCredentials)CdToolchainsKt.getCredentials(remoteHost));
    }

    private static final boolean processCheck(HostMachine remoteHost) {
        String[] stringArray = new String[]{"pwd"};
        ProcessOutput processOutput = remoteHost.runProcess(new GeneralCommandLine(stringArray), ProgressManager.getInstance().getProgressIndicator(), 5000);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        ProcessOutput output = processOutput;
        return output.getExitCode() == 0 && StringUtil.isNotEmpty((String)output.getStdout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean checkRemoteFS(HostMachine remoteHost) {
        Path path = remoteHost.createTempDirectory("host_info", null);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        Path tmp = path;
        try {
            Path file = Files.createFile(tmp.resolve("file.txt"), new FileAttribute[0]);
            String testString = "Hello, CLion!";
            Intrinsics.checkNotNull((Object)file);
            PathKt.write$default((Path)file, (CharSequence)testString, null, (boolean)false, (int)2, null);
            Path path2 = remoteHost.getPath(((Object)file.toAbsolutePath()).toString(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getPath(...)");
            Path filePath = path2;
            boolean bl = Intrinsics.areEqual((Object)testString, (Object)PathsKt.readText$default((Path)filePath, null, (int)1, null));
            return bl;
        }
        finally {
            PathKt.delete$default((Path)tmp, (boolean)false, (int)1, null);
        }
    }

    private static final boolean checkRemoteTar(HostMachine remoteHost) {
        return RemoteUtil.isTarInstalled(arg_0 -> CdToolchainsKt.checkRemoteTar$lambda$0(remoteHost, arg_0));
    }

    private static final boolean checkRemoteRsync(HostMachine remoteHost) {
        return RemoteUtil.isRsyncInstalled(arg_0 -> CdToolchainsKt.checkRemoteRsync$lambda$0(remoteHost, arg_0));
    }

    private static final boolean checkRemotePigz(HostMachine remoteHost) {
        return RemoteUtil.isPigzInstalled(arg_0 -> CdToolchainsKt.checkRemotePigz$lambda$0(remoteHost, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean checkRsyncDownload(HostMachine remoteHost) throws IOException {
        RemoteCredentials credentials = CdToolchainsKt.getCredentials(remoteHost);
        Path path = remoteHost.createTempDirectory("remote", null);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        Path remote = path;
        File file = FileUtil.createTempDirectory((String)"local", null);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
        File local = file;
        File file2 = FileUtil.createTempFile((String)"log", null);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempFile(...)");
        File logFile = file2;
        try {
            Path file3 = Files.createFile(remote.resolve("file.txt"), new FileAttribute[0]);
            String testString = "Hello, CLion!";
            Intrinsics.checkNotNull((Object)file3);
            PathKt.write$default((Path)file3, (CharSequence)testString, null, (boolean)false, (int)2, null);
            RSyncUtil.downloadFolderWithRSync((String)local.getPath(), (String)((Object)remote).toString(), (RemoteCredentials)credentials, (ProgressIndicator)ProgressManager.getInstance().getProgressIndicator(), (RSyncOptions)new RSyncOptions(null, false, logFile.getPath(), false, null, false, false, 123, null));
            String string = FileUtil.loadFile((File)new File(local, "file.txt"));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(...)");
            String text = string;
            boolean bl = Intrinsics.areEqual((Object)testString, (Object)text);
            return bl;
        }
        finally {
            PathKt.delete$default((Path)remote, (boolean)false, (int)1, null);
            local.delete();
            logFile.delete();
        }
    }

    private static final boolean test(CdIndenter log, HostMachine host, @NonNls String testName, Function1<? super HostMachine, Boolean> check, String failStatusMsg) {
        ProgressManager.checkCanceled();
        boolean status = false;
        try {
            status = (Boolean)check.invoke((Object)host);
            String statusStr = status ? "[OK]" : failStatusMsg;
            Object[] objectArray = new Object[]{statusStr + " " + testName};
            log.put(objectArray);
        }
        catch (Throwable t) {
            Object[] objectArray = new Object[]{"[ERROR] " + testName + "  ==>  ", CdToolchainsKt.stackTraceToString(t)};
            log.put(objectArray);
        }
        return status;
    }

    static /* synthetic */ boolean test$default(CdIndenter cdIndenter, HostMachine hostMachine, String string, Function1 function1, String string2, int n, Object object) {
        if ((n & 0x10) != 0) {
            string2 = "[FAILED]";
        }
        return CdToolchainsKt.test(cdIndenter, hostMachine, string, (Function1<? super HostMachine, Boolean>)function1, string2);
    }

    private static final RemoteCredentials getCredentials(HostMachine remoteHost) {
        RemoteCredentials remoteCredentials = RemoteUtil.getCredentials((HostMachine)remoteHost);
        if (remoteCredentials == null) {
            throw new IllegalStateException("Cannot find credentials by hostId");
        }
        return remoteCredentials;
    }

    @NotNull
    public static final String stackTraceToString(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<CPPEnvironment> getAllEnvironments(Project project) {
        void $this$distinctBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List<CPPEnvironment> projectEnvironments = project == null ? CollectionsKt.emptyList() : CdToolchainsKt.getAllProjectEnvironments(project);
        Iterable $this$map$iv2 = projectEnvironments;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            CPPEnvironment cPPEnvironment = (CPPEnvironment)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getToolchain().getName());
        }
        HashSet toolchainsSet = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        List list = CPPToolchains.getInstance().getToolchains();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getToolchains(...)");
        Iterable $i$f$map22 = list;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CPPToolchains.Toolchain bl = (CPPToolchains.Toolchain)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getName());
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!toolchainsSet.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            CPPEnvironment it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl3 = false;
            if (CPPToolchains.createCPPEnvironment((Project)project, null, (String)it2, (EnvironmentProblems)new EnvironmentProblems(), (boolean)false, null) == null) continue;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            CPPEnvironment it3 = (CPPEnvironment)e$iv;
            boolean bl = false;
            String key$iv = it3.getToolchain().getName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List otherEnvironments = list$iv;
        return CollectionsKt.plus((Collection)projectEnvironments, (Iterable)otherEnvironments);
    }

    private static final List<CPPEnvironment> getAllProjectEnvironments(Project project) {
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        boolean bl;
        WorkspaceWithEnvironment it$iv$iv;
        CidrWorkspace it;
        boolean bl2;
        Object element$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CidrWorkspace.Companion.getInitializedWorkspaces(project);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Object $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (CidrWorkspace)element$iv$iv;
            boolean bl3 = false;
            if ((it instanceof WorkspaceWithEnvironment ? (WorkspaceWithEnvironment)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
            WorkspaceWithEnvironment it2 = (WorkspaceWithEnvironment)element$iv$iv2;
            boolean bl4 = false;
            list$iv$iv = it2.getEnvironment();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Object element$iv$iv$iv = list$iv$iv.next();
            element$iv$iv = element$iv$iv$iv;
            bl2 = false;
            it = (CidrToolEnvironment)element$iv$iv;
            boolean bl5 = false;
            if ((it instanceof CPPEnvironment ? (CPPEnvironment)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            CPPEnvironment it3 = (CPPEnvironment)e$iv;
            boolean bl6 = false;
            String key$iv = it3.getToolchain().getName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    private static final ExecutableToolInfo processCPPEnvironment$toolInfo(CidrExecutableTool tool, String name) {
        String string;
        if (tool == null) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        boolean bl = application != null ? application.isUnitTestMode() : false;
        if (bl) {
            string = null;
        } else {
            String string2;
            try {
                string2 = tool.readVersion();
            }
            catch (ExecutionException executionException) {
                string2 = null;
            }
            string = string2;
        }
        String version = string;
        String string3 = tool.getExecutablePath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getExecutablePath(...)");
        return new ExecutableToolInfo(name, version, string3);
    }

    private static final boolean testRemoteHost$lambda$0(HostMachine $remoteHost, HostMachine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CidrRSyncUtil.canUseRSync((String)$remoteHost.getHostId());
    }

    private static final ProcessOutput checkRemoteTar$lambda$0(HostMachine $remoteHost, GeneralCommandLine cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        return $remoteHost.runProcess(cmd, ProgressManager.getInstance().getProgressIndicator(), 5000);
    }

    private static final ProcessOutput checkRemoteRsync$lambda$0(HostMachine $remoteHost, GeneralCommandLine cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        return $remoteHost.runProcess(cmd, ProgressManager.getInstance().getProgressIndicator(), 5000);
    }

    private static final ProcessOutput checkRemotePigz$lambda$0(HostMachine $remoteHost, GeneralCommandLine cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        return $remoteHost.runProcess(cmd, ProgressManager.getInstance().getProgressIndicator(), 5000);
    }

    public static final /* synthetic */ boolean access$checkConnection(HostMachine remoteHost) {
        return CdToolchainsKt.checkConnection(remoteHost);
    }

    public static final /* synthetic */ boolean access$processCheck(HostMachine remoteHost) {
        return CdToolchainsKt.processCheck(remoteHost);
    }

    public static final /* synthetic */ boolean access$checkRemoteFS(HostMachine remoteHost) {
        return CdToolchainsKt.checkRemoteFS(remoteHost);
    }

    public static final /* synthetic */ boolean access$checkRemoteTar(HostMachine remoteHost) {
        return CdToolchainsKt.checkRemoteTar(remoteHost);
    }

    public static final /* synthetic */ boolean access$checkRemoteRsync(HostMachine remoteHost) {
        return CdToolchainsKt.checkRemoteRsync(remoteHost);
    }

    public static final /* synthetic */ boolean access$checkRsyncDownload(HostMachine remoteHost) {
        return CdToolchainsKt.checkRsyncDownload(remoteHost);
    }

    public static final /* synthetic */ boolean access$checkRemotePigz(HostMachine remoteHost) {
        return CdToolchainsKt.checkRemotePigz(remoteHost);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CppDiagnosticsAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }
}

