/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.SofterReference;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestScopeElementForCacheImpl
extends CidrTestScopeElementImpl {
    protected final VirtualFile myVFile;
    protected final Project myProject;
    protected long myOffsetAsNaturalOrder;
    @Nullable
    protected SofterReference<PsiElement> myPsiElement;

    /*
     * WARNING - void declaration
     */
    public CidrTestScopeElementForCacheImpl(@NotNull PsiFile psiFile, long offsetAsNaturalOrder, @Nullable String suiteName, @Nullable String testName, @Nullable com.intellij.util.Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> function) {
        void factory;
        if (psiFile == null) {
            CidrTestScopeElementForCacheImpl.$$$reportNull$$$0(0);
        }
        super(suiteName, testName, (Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator>)factory);
        this.myVFile = psiFile.getVirtualFile();
        this.myProject = psiFile.getProject();
        this.myOffsetAsNaturalOrder = offsetAsNaturalOrder;
    }

    @Override
    public long getSortIndex() {
        return this.myOffsetAsNaturalOrder;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        PsiElement element;
        if (this.myPsiElement != null) {
            PsiElement element2 = (PsiElement)this.myPsiElement.get();
            if (element2 != null && element2.isValid()) {
                PsiElement psiElement = element2;
                if (psiElement == null) {
                    CidrTestScopeElementForCacheImpl.$$$reportNull$$$0(1);
                }
                return psiElement;
            }
            this.myPsiElement = null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> psiManager.findFile(this.myVFile));
        this.verify(psiFile, this.myVFile);
        assert (psiFile != null);
        if (OCTestExecution.canWaitInThisThread() && (element = (PsiElement)ReadAction.compute(() -> this.getElementSlow(psiFile))) != null) {
            CidrTestLog.LOG.debug("Moved element was found");
            this.myPsiElement = new SofterReference((Object)element);
            PsiElement psiElement = element;
            if (psiElement == null) {
                CidrTestScopeElementForCacheImpl.$$$reportNull$$$0(2);
            }
            return psiElement;
        }
        element = this.findFromOrderInFile(psiFile);
        if (element != null) {
            CidrTestLog.LOG.debug("Element from position");
            PsiElement psiElement = element;
            if (psiElement == null) {
                CidrTestScopeElementForCacheImpl.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        CidrTestLog.LOG.debug("File as element");
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) {
            CidrTestScopeElementForCacheImpl.$$$reportNull$$$0(4);
        }
        return psiFile2;
    }

    @Contract(pure=true)
    @Nullable
    protected PsiElement getElementSlow(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CidrTestScopeElementForCacheImpl.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Contract(pure=true)
    protected PsiElement findFromOrderInFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CidrTestScopeElementForCacheImpl.$$$reportNull$$$0(6);
        }
        return psiFile.findElementAt((int)this.myOffsetAsNaturalOrder);
    }

    protected void verify(@Nullable PsiFile psiFile, @NotNull VirtualFile vFile) {
        if (vFile == null) {
            CidrTestScopeElementForCacheImpl.$$$reportNull$$$0(7);
        }
        if (psiFile == null) {
            CidrTestLog.LOG.error("File not found:", new String[]{vFile.getPath()});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestScopeElementForCacheImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestScopeElementForCacheImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementSlow";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFromOrderInFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "verify";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

