/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.CidrRunConfigurationEditorUtil;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScopeHints;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import com.jetbrains.cidr.lang.ui.OCFieldAdapter;
import com.jetbrains.cidr.lang.ui.OCTextFieldWithSymbolAutoCompletion;
import com.jetbrains.cidr.ui.ComponentRenderer;
import com.jetbrains.cidr.ui.ItemPrinter;
import com.jetbrains.cidr.ui.ItemPrinterKt;
import com.jetbrains.cidr.ui.ItemState;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

public abstract class CidrTestScopeEditor<CONFIGURATION extends RunConfiguration, SUITE>
implements Disposable {
    protected OCTextFieldWithSymbolAutoCompletion<SUITE> mySuiteField;
    protected EditorTextField myPatternField;
    private AsyncProcessIcon myProcessIcon;
    private JLabel myMethodComboLabel;
    private JLabel mySuiteFieldLabel;
    private JLabel myPatternFieldLabel;
    private JLabel mySuitesTipLabel;
    private JRadioButton myRbPattern;
    protected CidrRunConfigurationEditorUtil.ComboBox myMethodCombo;
    private MergingUpdateQueue myQueue;
    private Disposable myFixedSuiteTextLifetime;
    private final AtomicInteger myCheckingCounter;
    private Set<String> mySuiteMethods;
    private final Project myProject;
    private final CidrTestScopeHints myHints;

    public CidrTestScopeEditor(@NotNull Project project, @NotNull CidrTestScopeHints hints) {
        if (project == null) {
            CidrTestScopeEditor.$$$reportNull$$$0(0);
        }
        if (hints == null) {
            CidrTestScopeEditor.$$$reportNull$$$0(1);
        }
        this.myCheckingCounter = new AtomicInteger(0);
        this.mySuiteMethods = Collections.emptySet();
        this.myProject = project;
        this.myHints = hints;
    }

    public void createEditor(@NotNull JPanel p, @NotNull GridBag g) {
        if (p == null) {
            CidrTestScopeEditor.$$$reportNull$$$0(2);
        }
        if (g == null) {
            CidrTestScopeEditor.$$$reportNull$$$0(3);
        }
        this.myQueue = new MergingUpdateQueue("UpdateMethods", 500, false, (JComponent)p, (Disposable)this, (JComponent)p, true);
        this.myFixedSuiteTextLifetime = Disposer.newDisposable((Disposable)this.myQueue);
        this.createTestKindRadioButtons(p, g);
        this.mySuiteFieldLabel = new JLabel(this.myHints.getSuiteFieldLabelName() + ":");
        JPanel childPanel = new JPanel(new GridBagLayout());
        p.add((Component)childPanel, g.nextLine().next().insets(0, 0, 0, 0));
        GridBag childGrid = new GridBag().setDefaultFill(1);
        childPanel.add((Component)this.mySuiteFieldLabel, childGrid.nextLine().next().weightx(0.9));
        this.myProcessIcon = new AsyncProcessIcon("TestCompletion");
        this.myProcessIcon.setVisible(false);
        childPanel.add((Component)this.myProcessIcon, childGrid.next().anchor(22).weightx(0.1));
        this.mySuiteField = this.createSuiteField();
        this.mySuiteField.setPlaceholder((CharSequence)this.myHints.getSuitePlaceholder());
        this.mySuiteField.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                CidrTestScopeEditor.this.scheduleSuiteAndTestsUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/execution/testing/CidrTestScopeEditor$1", "documentChanged"));
            }
        });
        p.add((Component)this.mySuiteField, g.next().coverLine().insets(0, 0, 0, 0));
        this.mySuiteFieldLabel.setLabelFor((Component)this.mySuiteField);
        this.mySuitesTipLabel = new JBLabel(this.myHints.getSuitesTipMessage(), UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER);
        p.add((Component)this.mySuitesTipLabel, g.nextLine().next().next().coverLine().insets((Insets)JBUI.insets((int)-1, (int)10, (int)4, (int)0)));
        this.myMethodCombo = CidrRunConfigurationEditorUtil.createCombo();
        JBInsets i = JBUI.insets((int)-1, (int)-1, (int)12, (int)-1);
        this.myMethodComboLabel = new JLabel(this.myHints.getTestFieldLabelName() + ":");
        p.add((Component)this.myMethodComboLabel, g.nextLine().next().insets((Insets)i));
        p.add((Component)((Object)this.myMethodCombo), g.next().coverLine().insets((Insets)i));
        this.myMethodComboLabel.setLabelFor((Component)((Object)this.myMethodCombo));
        this.myMethodCombo.setRenderer((ListCellRenderer)((Object)this.getRunConfigurationsRenderer()));
        this.myPatternFieldLabel = new JLabel(CidrExecutionBundle.message("test.configuration.pattern", new Object[0]) + ":");
        p.add((Component)this.myPatternFieldLabel, g.nextLine().next());
        this.myPatternField = new EditorTextField();
        this.myPatternField.setPlaceholder((CharSequence)this.myHints.getPatternPlaceholder());
        this.myPatternField.setPreferredWidth(150);
        p.add((Component)this.myPatternField, g.next().coverLine());
        this.myPatternFieldLabel.setLabelFor((Component)this.myPatternField);
    }

    @NotNull
    protected abstract RunConfigurationsRenderer getRunConfigurationsRenderer();

    boolean isChecking() {
        return this.myCheckingCounter.get() > 0;
    }

    private void renderMethodName(@NotNull ComponentRenderer component, @NlsSafe @NotNull String methodName, @NotNull ItemState state) {
        if (component == null) {
            CidrTestScopeEditor.$$$reportNull$$$0(4);
        }
        if (methodName == null) {
            CidrTestScopeEditor.$$$reportNull$$$0(5);
        }
        if (state == null) {
            CidrTestScopeEditor.$$$reportNull$$$0(6);
        }
        if (methodName.isEmpty()) {
            component.appendGrayed(this.myHints.getAllTestsMessage(), state);
        } else if (!this.mySuiteMethods.contains(methodName)) {
            component.appendError(methodName, state);
        } else {
            component.append(methodName);
        }
    }

    protected void scheduleSuiteAndTestsUpdate() {
        this.myQueue.cancelAllUpdates();
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread() && application.isUnitTestMode()) {
            this.myQueue.setPassThrough(false);
        }
        this.myQueue.queue(new Update("go!"){

            public void run() {
                Disposer.dispose((Disposable)CidrTestScopeEditor.this.myFixedSuiteTextLifetime);
                CidrTestScopeEditor.this.myFixedSuiteTextLifetime = Disposer.newDisposable((Disposable)CidrTestScopeEditor.this.myQueue);
                CidrTestScopeEditor.this.runWithCheckingStatus(ReadAction.nonBlocking(() -> OCTestExecution.executeWithCachedValuesFast(CidrTestScopeEditor.this::isValidSuiteName)).expireWith(CidrTestScopeEditor.this.myFixedSuiteTextLifetime).finishOnUiThread(ModalityState.defaultModalityState(), suitesSpecified -> {
                    CidrTestScopeEditor.this.myMethodComboLabel.setEnabled((boolean)suitesSpecified);
                    CidrTestScopeEditor.this.myMethodCombo.setEnabled((boolean)suitesSpecified);
                    CidrTestScopeEditor.this.updateSuiteAndMethodControls();
                }).submit((Executor)AppExecutorUtil.getAppExecutorService()));
            }
        });
    }

    private void runWithCheckingStatus(@NotNull CancellablePromise<?> promise) {
        if (promise == null) {
            CidrTestScopeEditor.$$$reportNull$$$0(7);
        }
        this.myCheckingCounter.incrementAndGet();
        promise.onProcessed(success -> {
            this.myCheckingCounter.decrementAndGet();
            SwingUtilities.invokeLater(() -> this.myMethodCombo.fireSelectedItemChanged());
        });
    }

    protected OCTextFieldWithSymbolAutoCompletion<SUITE> createSuiteField() {
        return OCTextFieldWithSymbolAutoCompletion.create((Project)this.myProject, this.createSuiteAdapter(), null, (OCTextFieldWithSymbolAutoCompletion.ProcessListener)new OCTextFieldWithSymbolAutoCompletion.ProcessListener(){

            public void onStarted() {
                CidrTestScopeEditor.this.myProcessIcon.setVisible(true);
            }

            public void onFinished() {
                CidrTestScopeEditor.this.myProcessIcon.setVisible(false);
            }
        });
    }

    @NotNull
    protected abstract OCFieldAdapter<SUITE> createSuiteAdapter();

    private void createTestKindRadioButtons(@NotNull JPanel p, @NotNull GridBag g) {
        if (p == null) {
            CidrTestScopeEditor.$$$reportNull$$$0(8);
        }
        if (g == null) {
            CidrTestScopeEditor.$$$reportNull$$$0(9);
        }
        JBLabel typeLabel = new JBLabel(ExecutionBundle.message((String)"junit.configuration.configure.junit.test.kind.label", (Object[])new Object[0]));
        p.add((Component)typeLabel, g.nextLine().next());
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton myRbSuiteTest = new JRadioButton();
        myRbSuiteTest.setText(this.myHints.getSuiteFieldLabelName() + " / " + this.myHints.getTestFieldLabelName());
        myRbSuiteTest.setSelected(true);
        this.myRbPattern = new JRadioButton();
        this.myRbPattern.setText(CidrExecutionBundle.message("test.configuration.pattern", new Object[0]));
        buttonGroup.add(myRbSuiteTest);
        buttonGroup.add(this.myRbPattern);
        p.add((Component)myRbSuiteTest, g.next().weightx(0.0).insets((Insets)JBUI.insets((int)0, (int)0, (int)4, (int)10)));
        p.add((Component)this.myRbPattern, g.next().weightx(0.0).insets((Insets)JBUI.insetsBottom((int)4)));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CidrTestScopeEditor.this.changeTestKind();
            }
        };
        myRbSuiteTest.addActionListener(listener);
        this.myRbPattern.addActionListener(listener);
    }

    private void changeTestKind() {
        boolean pattern = this.myRbPattern.isSelected();
        this.mySuiteField.setVisible(!pattern);
        this.mySuiteFieldLabel.setVisible(!pattern);
        this.mySuitesTipLabel.setVisible(!pattern);
        this.myMethodCombo.setVisible(!pattern);
        this.myMethodComboLabel.setVisible(!pattern);
        this.myPatternField.setVisible(pattern);
        this.myPatternFieldLabel.setVisible(pattern);
    }

    private void updateSuiteField() {
        Editor editor = this.mySuiteField.getEditor();
        if (editor == null) {
            return;
        }
        MarkupModel markup = editor.getMarkupModel();
        markup.removeAllHighlighters();
        String suites = this.getTestSuiteText();
        if (suites == null) {
            return;
        }
        this.runWithCheckingStatus(ReadAction.nonBlocking(() -> OCTestExecution.executeWithCachedValuesFast(this::isValidSuiteName)).expireWith(this.myFixedSuiteTextLifetime).finishOnUiThread(ModalityState.defaultModalityState(), isValidSN -> {
            if (!isValidSN.booleanValue()) {
                markup.addRangeHighlighter(CodeInsightColors.ERRORS_ATTRIBUTES, 0, this.mySuiteField.getDocument().getText().length(), 5000, HighlighterTargetArea.EXACT_RANGE);
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService()));
    }

    public abstract boolean isValidSuiteName();

    @NotNull
    protected abstract Set<String> collectSuiteTests();

    protected boolean hasOutOfSuiteTests() {
        return false;
    }

    private void updateMethodCombo() {
        this.updateMethodCombo((String)this.myMethodCombo.getSelectedItem());
    }

    private void updateMethodCombo(@Nullable @NlsSafe String _selectedItem) {
        ArrayList<String> items = new ArrayList<String>(this.mySuiteMethods);
        if (_selectedItem == null || this.getTestSuiteText() == null && !this.hasOutOfSuiteTests()) {
            _selectedItem = "";
        }
        items.add(_selectedItem);
        this.myMethodCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(items, (Object)_selectedItem));
        this.myMethodCombo.setEnabled(false);
        String __selectedItem = _selectedItem;
        this.runWithCheckingStatus(ReadAction.nonBlocking(() -> OCTestExecution.executeWithCachedValuesFast(this::collectSuiteTests)).expireWith(this.myFixedSuiteTextLifetime).finishOnUiThread(ModalityState.defaultModalityState(), suiteMethods -> {
            String selectedItem = __selectedItem;
            this.mySuiteMethods = suiteMethods;
            items.clear();
            items.add("");
            items.addAll(this.mySuiteMethods);
            if (!selectedItem.isEmpty() && !items.contains(selectedItem)) {
                items.add(selectedItem);
            }
            Collections.sort(items);
            if (selectedItem.isEmpty() && !items.isEmpty()) {
                selectedItem = (String)items.get(0);
            }
            this.myMethodCombo.setModel((ComboBoxModel)new CollectionComboBoxModel((List)items, (Object)selectedItem));
            this.myMethodCombo.setEnabled(true);
        }).submit((Executor)AppExecutorUtil.getAppExecutorService()));
    }

    public void dispose() {
        this.mySuiteField.cancelRunningTasks();
        Disposer.dispose((Disposable)this.myQueue);
    }

    public void resetEditorFrom(@NotNull CONFIGURATION selected) {
        if (selected == null) {
            CidrTestScopeEditor.$$$reportNull$$$0(10);
        }
        assert (selected instanceof CidrTestRunConfiguration);
        CidrTestRunConfigurationData<?> delegate = ((CidrTestRunConfiguration)selected).getTestData();
        this.myPatternField.setText(StringUtil.notNullize((String)delegate.getTestPattern()));
        this.myRbPattern.setSelected(delegate.getTestMode() == CidrTestRunConfigurationData.Mode.PATTERN);
        this.mySuiteField.setText(StringUtil.notNullize((String)delegate.getTestSuite()));
        this.updateMethodCombo(StringUtil.notNullize((String)delegate.getTestName()));
        this.changeTestKind();
    }

    public void applyEditorTo(@NotNull CONFIGURATION selected) throws ConfigurationException {
        if (selected == null) {
            CidrTestScopeEditor.$$$reportNull$$$0(11);
        }
        assert (selected instanceof CidrTestRunConfiguration);
        CidrTestRunConfigurationData<?> delegate = ((CidrTestRunConfiguration)selected).getTestData();
        CidrTestRunConfigurationData.Mode mode = this.myRbPattern.isSelected() ? CidrTestRunConfigurationData.Mode.PATTERN : CidrTestRunConfigurationData.Mode.SUITE_TEST;
        delegate.setTestSuite(mode == CidrTestRunConfigurationData.Mode.SUITE_TEST ? this.getTestSuiteText() : null);
        delegate.setTestName(mode == CidrTestRunConfigurationData.Mode.SUITE_TEST ? this.getTestMethodText() : null);
        delegate.setTestPattern(mode == CidrTestRunConfigurationData.Mode.PATTERN ? StringUtil.nullize((String)this.myPatternField.getText().trim()) : null);
        delegate.setTestMode(mode);
    }

    @Nullable
    public String getTestSuiteText() {
        return StringUtil.nullize((String)this.mySuiteField.getText().trim());
    }

    @Nullable
    private String getTestMethodText() {
        return StringUtil.nullize((String)((String)this.myMethodCombo.getSelectedItem()));
    }

    protected void updateSuiteAndMethodControls() {
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        this.updateSuiteField();
        this.updateMethodCombo();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestScopeEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "renderMethodName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithCheckingStatus";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createTestKindRadioButtons";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "applyEditorTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class RunConfigurationsRenderer
    extends CidrRunConfigurationEditorUtil.RunConfigurationsRenderer {
        public RunConfigurationsRenderer(CidrTestScopeEditor this$0, boolean hasTargetsInSeveralProjects) {
            super(hasTargetsInSeveralProjects, new ItemPrinter[]{ItemPrinterKt.printerFor(String.class, this$0::renderMethodName)});
        }
    }
}

