/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestRunConfigurationData<CONFIGURATION extends CidrTestRunConfiguration>
implements JDOMExternalizable,
Cloneable {
    @Nullable
    protected String myTestSuite;
    @Nullable
    protected String myTestName;
    @Nullable
    protected String myTestPattern;
    @Nullable
    private volatile String myCommandLineTestPattern;
    @NotNull
    protected Mode myTestMode;
    @NotNull
    protected CONFIGURATION myConfiguration;

    public abstract void checkData() throws RuntimeConfigurationException;

    public CidrTestRunConfigurationData(@NotNull CONFIGURATION configuration) {
        if (configuration == null) {
            CidrTestRunConfigurationData.$$$reportNull$$$0(0);
        }
        this.myTestMode = Mode.SUITE_TEST;
        this.myConfiguration = configuration;
        assert (!CidrTestRunConfigurationData.isPotentiallyThisCapturing(this.getClass())) : "TestData must not be initialized from an inner/anonymous (non-static) class. Otherwise it will leak in clone() and cause unexpected behavior";
    }

    public static boolean isPotentiallyThisCapturing(@NotNull Class<?> clazz) {
        if (clazz == null) {
            CidrTestRunConfigurationData.$$$reportNull$$$0(1);
        }
        return clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers());
    }

    @Nullable
    public String getTestSuite() {
        return this.myTestSuite;
    }

    public void setTestSuite(@Nullable String testSuite) {
        this.myTestSuite = StringUtil.nullize((String)testSuite, (boolean)true);
    }

    @Nullable
    public String getTestName() {
        return this.myTestName;
    }

    public void setTestName(@Nullable String testName) {
        this.myTestName = StringUtil.nullize((String)testName, (boolean)true);
    }

    @Nullable
    public String getTestPattern() {
        return this.myTestPattern;
    }

    public void setTestPattern(@Nullable String testPattern) {
        this.myTestPattern = testPattern;
    }

    @NotNull
    public Mode getTestMode() {
        Mode mode = this.myTestMode;
        if (mode == null) {
            CidrTestRunConfigurationData.$$$reportNull$$$0(2);
        }
        return mode;
    }

    public void setTestMode(@NotNull Mode mode) {
        if (mode == null) {
            CidrTestRunConfigurationData.$$$reportNull$$$0(3);
        }
        this.myTestMode = mode;
    }

    @NotNull
    @Nls
    public String suggestedName(@Nullable String fallbackName) {
        if (this.myTestSuite != null && this.myTestName != null) {
            String string = this.formatTestMethod();
            if (string == null) {
                CidrTestRunConfigurationData.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (this.myTestMode == Mode.PATTERN) {
            String string = CidrExecutionBundle.message("test.defaultName.pattern", new Object[0]);
            if (string == null) {
                CidrTestRunConfigurationData.$$$reportNull$$$0(5);
            }
            return string;
        }
        String scopeName = this.myTestSuite != null ? this.myTestSuite : fallbackName;
        String string = scopeName == null ? CidrExecutionBundle.message("test.defaultName.allTests", new Object[0]) : CidrExecutionBundle.message("test.defaultName.allTestsIn", scopeName);
        if (string == null) {
            CidrTestRunConfigurationData.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    protected abstract String formatTestMethod();

    public void readExternal(Element element) throws InvalidDataException {
        this.setTestSuite(element.getAttributeValue("TEST_CLASS"));
        this.setTestName(element.getAttributeValue("TEST_METHOD"));
        this.setTestPattern(element.getAttributeValue("TEST_PATTERN"));
        String modeValue = element.getAttributeValue("TEST_MODE");
        this.setTestMode(modeValue == null || modeValue.equals("SUITE_TEST") ? Mode.SUITE_TEST : Mode.PATTERN);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        switch (this.myTestMode.ordinal()) {
            case 0: {
                if (this.myTestSuite != null) {
                    element.setAttribute("TEST_CLASS", this.myTestSuite);
                }
                if (this.myTestName == null) break;
                element.setAttribute("TEST_METHOD", this.myTestName);
                break;
            }
            case 1: {
                if (this.myTestPattern == null) break;
                element.setAttribute("TEST_PATTERN", this.myTestPattern);
            }
        }
        element.setAttribute("TEST_MODE", this.myTestMode.name());
    }

    public CidrTestRunConfigurationData cloneForConfiguration(@NotNull CidrTestRunConfiguration configuration) {
        if (configuration == null) {
            CidrTestRunConfigurationData.$$$reportNull$$$0(7);
        }
        try {
            CidrTestRunConfigurationData result = this.clone();
            result.myConfiguration = configuration;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected CidrTestRunConfigurationData clone() throws CloneNotSupportedException {
        CidrTestRunConfigurationData result = (CidrTestRunConfigurationData)super.clone();
        result.myTestSuite = this.myTestSuite;
        result.myTestName = this.myTestName;
        result.myTestPattern = this.myTestPattern;
        result.myTestMode = this.myTestMode;
        return result;
    }

    public boolean equalTo(@NotNull CidrTestScopeElement scope) {
        if (scope == null) {
            CidrTestRunConfigurationData.$$$reportNull$$$0(8);
        }
        return this.bothAreEmpty(scope) || (scope.isPatternLike() ? this.getTestMode() == Mode.PATTERN && Objects.equals(this.getTestPattern(), scope.getPattern()) : this.getTestMode() == Mode.SUITE_TEST && Objects.equals(this.getTestSuite(), scope.getSuiteName()) && Objects.equals(this.getTestName(), scope.getTestName()));
    }

    protected boolean isEmptyPatternScope(@NotNull CidrTestScopeElement scope) {
        if (scope == null) {
            CidrTestRunConfigurationData.$$$reportNull$$$0(9);
        }
        return scope.isPatternLike() && scope.getPattern().isEmpty();
    }

    protected boolean bothAreEmpty(@NotNull CidrTestScopeElement scope) {
        if (scope == null) {
            CidrTestRunConfigurationData.$$$reportNull$$$0(10);
        }
        if (this.isEmptyPatternScope(scope)) {
            return Objects.equals(this.myConfiguration.getName(), scope.getConfigurationName()) && (Objects.equals(this.getTestPattern(), scope.getPattern()) || this.getTestSuite() == null && this.getTestName() == null);
        }
        return false;
    }

    @Nullable
    public String getCommandLineTestPattern() {
        if (this.myCommandLineTestPattern == null) {
            CidrTestLog.LOG.warn("Seems the `" + CidrExecutionBundle.message("test.before.run", new Object[0]) + "` task was manually removed from `Before launch` list.");
        }
        return this.myCommandLineTestPattern;
    }

    public void setCommandLineTestPattern(@Nullable String commandLineTestPattern) {
        this.myCommandLineTestPattern = commandLineTestPattern;
    }

    @NotNull
    public abstract SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor var1, @NotNull ExecutionTarget var2);

    @NonNls
    @Nullable
    public abstract String getTestingFrameworkId();

    @Nullable
    public abstract CommandLineState createState(@NotNull ExecutionEnvironment var1, @NotNull Executor var2, @Nullable CidrTestScope var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestRunConfigurationData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestRunConfigurationData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMode";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPotentiallyThisCapturing";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTestMode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cloneForConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "equalTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyPatternScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "bothAreEmpty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    public static enum Mode {
        SUITE_TEST,
        PATTERN;

    }
}

