/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.console;

import com.jetbrains.cidr.execution.console.ConsolePathTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0002 !B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u00c6\u0003J=\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/jetbrains/cidr/execution/console/PathCandidate;", "", "path", "", "position", "", "start", "finish", "type", "Lcom/jetbrains/cidr/execution/console/PathCandidate$FilePosition;", "<init>", "(Ljava/lang/String;IIILcom/jetbrains/cidr/execution/console/PathCandidate$FilePosition;)V", "getPath", "()Ljava/lang/String;", "getPosition", "()I", "getStart", "getFinish", "getType", "()Lcom/jetbrains/cidr/execution/console/PathCandidate$FilePosition;", "fullText", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "FilePosition", "Companion", "intellij.cidr.execution"})
public final class PathCandidate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;
    private final int position;
    private final int start;
    private final int finish;
    @Nullable
    private final FilePosition type;
    @NotNull
    private static final String LINE_PATTERN_GROUP_NAME = "linePattern";
    @Language(value="RegExp")
    @NotNull
    private static final String LINE_PATTERN = "(?<linePattern>\\d{1,5})";
    @NotNull
    private static final String COLUMN_PATTERN_GROUP_NAME = "columnPattern";
    @Language(value="RegExp")
    @NotNull
    private static final String COLUMN_PATTERN = "(?<columnPattern>\\d{1,5})";
    @NotNull
    private static final Regex MSVC_LINE_COLUMN_PATTERN = new Regex("\\(" + LINE_PATTERN + "(?:," + COLUMN_PATTERN + ")?\\)");
    @NotNull
    private static final Regex SIMPLE_LINE_COLUMN_PATTERN = new Regex(":" + LINE_PATTERN + "(?::(?:" + COLUMN_PATTERN + ")?)?");

    public PathCandidate(@NotNull String path, int position, int start, int finish, @Nullable FilePosition type) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.position = position;
        this.start = start;
        this.finish = finish;
        this.type = type;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final int getPosition() {
        return this.position;
    }

    public final int getStart() {
        return this.start;
    }

    public final int getFinish() {
        return this.finish;
    }

    @Nullable
    public final FilePosition getType() {
        return this.type;
    }

    @NotNull
    public final String fullText() {
        Object object = this.type;
        if (object == null || (object = ((FilePosition)object).getText()) == null) {
            object = "";
        }
        return this.path + (String)object;
    }

    @NotNull
    public final String component1() {
        return this.path;
    }

    public final int component2() {
        return this.position;
    }

    public final int component3() {
        return this.start;
    }

    public final int component4() {
        return this.finish;
    }

    @Nullable
    public final FilePosition component5() {
        return this.type;
    }

    @NotNull
    public final PathCandidate copy(@NotNull String path, int position, int start, int finish, @Nullable FilePosition type) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new PathCandidate(path, position, start, finish, type);
    }

    public static /* synthetic */ PathCandidate copy$default(PathCandidate pathCandidate, String string, int n, int n2, int n3, FilePosition filePosition, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string = pathCandidate.path;
        }
        if ((n4 & 2) != 0) {
            n = pathCandidate.position;
        }
        if ((n4 & 4) != 0) {
            n2 = pathCandidate.start;
        }
        if ((n4 & 8) != 0) {
            n3 = pathCandidate.finish;
        }
        if ((n4 & 0x10) != 0) {
            filePosition = pathCandidate.type;
        }
        return pathCandidate.copy(string, n, n2, n3, filePosition);
    }

    @NotNull
    public String toString() {
        return "PathCandidate(path=" + this.path + ", position=" + this.position + ", start=" + this.start + ", finish=" + this.finish + ", type=" + this.type + ")";
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = result * 31 + Integer.hashCode(this.position);
        result = result * 31 + Integer.hashCode(this.start);
        result = result * 31 + Integer.hashCode(this.finish);
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PathCandidate)) {
            return false;
        }
        PathCandidate pathCandidate = (PathCandidate)other;
        if (!Intrinsics.areEqual((Object)this.path, (Object)pathCandidate.path)) {
            return false;
        }
        if (this.position != pathCandidate.position) {
            return false;
        }
        if (this.start != pathCandidate.start) {
            return false;
        }
        if (this.finish != pathCandidate.finish) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.type, (Object)pathCandidate.type);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\r8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\r8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/execution/console/PathCandidate$Companion;", "", "<init>", "()V", "retrieveFrom", "", "Lcom/jetbrains/cidr/execution/console/PathCandidate;", "tokens", "Lcom/jetbrains/cidr/execution/console/ConsolePathTokenizer$Token;", "startPosition", "", "token", "LINE_PATTERN_GROUP_NAME", "", "LINE_PATTERN", "COLUMN_PATTERN_GROUP_NAME", "COLUMN_PATTERN", "MSVC_LINE_COLUMN_PATTERN", "Lkotlin/text/Regex;", "SIMPLE_LINE_COLUMN_PATTERN", "intellij.cidr.execution"})
    @SourceDebugExtension(value={"SMAP\nPathCandidate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathCandidate.kt\ncom/jetbrains/cidr/execution/console/PathCandidate$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1374#2:88\n1460#2,5:89\n*S KotlinDebug\n*F\n+ 1 PathCandidate.kt\ncom/jetbrains/cidr/execution/console/PathCandidate$Companion\n*L\n27#1:88\n27#1:89,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<PathCandidate> retrieveFrom(@NotNull List<ConsolePathTokenizer.Token> tokens) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
            int startPosition = 0;
            Iterable $this$flatMap$iv = tokens;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ConsolePathTokenizer.Token it = (ConsolePathTokenizer.Token)element$iv$iv;
                boolean bl = false;
                List<PathCandidate> candidates = Companion.retrieveFrom(startPosition, it);
                startPosition += candidates.size();
                Iterable list$iv$iv = candidates;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final List<PathCandidate> retrieveFrom(int startPosition, ConsolePathTokenizer.Token token) {
            MatchResult matchResult;
            String text = token.getS();
            if (StringsKt.isBlank((CharSequence)text)) {
                return CollectionsKt.listOf((Object)new PathCandidate(token.getS(), startPosition, token.getStart(), token.getEnd(), null));
            }
            int positionInLine = 0;
            List candidates = new ArrayList();
            while (positionInLine < text.length() && ((matchResult = SIMPLE_LINE_COLUMN_PATTERN.find((CharSequence)text, positionInLine)) != null || (matchResult = MSVC_LINE_COLUMN_PATTERN.find((CharSequence)text, positionInLine)) != null)) {
                String pathText;
                MatchResult match = matchResult;
                int previousPositionInLine = positionInLine;
                positionInLine = match.getRange().getLast() + 1;
                Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)PathCandidate.LINE_PATTERN_GROUP_NAME);
                if (object == null || (object = object.getValue()) == null) continue;
                Object linePattern = object;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)PathCandidate.COLUMN_PATTERN_GROUP_NAME);
                String columnPattern = matchGroup != null ? matchGroup.getValue() : null;
                Integer n = StringsKt.toIntOrNull((String)linePattern);
                if (n == null) {
                    continue;
                }
                int line = n;
                String string = columnPattern;
                Integer column = string != null ? StringsKt.toIntOrNull((String)string) : null;
                Intrinsics.checkNotNullExpressionValue((Object)text.substring(previousPositionInLine, match.getRange().getFirst()), (String)"substring(...)");
                PathCandidate pathCandidate = new PathCandidate(pathText, startPosition + candidates.size(), token.getStart() + previousPositionInLine, token.getStart() + match.getRange().getLast() + 1, FilePosition.Companion.create(line, column, match.getValue()));
                candidates.add(pathCandidate);
            }
            if (positionInLine < text.length()) {
                String string = text.substring(positionInLine);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String pathText = string;
                PathCandidate pathCandidate = new PathCandidate(pathText, startPosition + candidates.size(), token.getStart() + positionInLine, token.getEnd(), null);
                candidates.add(pathCandidate);
            }
            return candidates;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J.\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c2\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/execution/console/PathCandidate$FilePosition;", "", "line", "", "column", "text", "", "<init>", "(ILjava/lang/Integer;Ljava/lang/String;)V", "getLine", "()I", "getColumn", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getText", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "(ILjava/lang/Integer;Ljava/lang/String;)Lcom/jetbrains/cidr/execution/console/PathCandidate$FilePosition;", "equals", "", "other", "hashCode", "toString", "Companion", "intellij.cidr.execution"})
    public static final class FilePosition {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int line;
        @Nullable
        private final Integer column;
        @NotNull
        private final String text;

        private FilePosition(int line, Integer column, String text) {
            this.line = line;
            this.column = column;
            this.text = text;
        }

        public final int getLine() {
            return this.line;
        }

        @Nullable
        public final Integer getColumn() {
            return this.column;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final int component1() {
            return this.line;
        }

        @Nullable
        public final Integer component2() {
            return this.column;
        }

        @NotNull
        public final String component3() {
            return this.text;
        }

        private final FilePosition copy(int line, Integer column, String text) {
            return new FilePosition(line, column, text);
        }

        static /* synthetic */ FilePosition copy$default(FilePosition filePosition, int n, Integer n2, String string, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = filePosition.line;
            }
            if ((n3 & 2) != 0) {
                n2 = filePosition.column;
            }
            if ((n3 & 4) != 0) {
                string = filePosition.text;
            }
            return filePosition.copy(n, n2, string);
        }

        @NotNull
        public String toString() {
            return "FilePosition(line=" + this.line + ", column=" + this.column + ", text=" + this.text + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.line);
            result = result * 31 + (this.column == null ? 0 : ((Object)this.column).hashCode());
            result = result * 31 + this.text.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FilePosition)) {
                return false;
            }
            FilePosition filePosition = (FilePosition)other;
            if (this.line != filePosition.line) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.column, (Object)filePosition.column)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.text, (Object)filePosition.text);
        }

        public /* synthetic */ FilePosition(int line, Integer column, String text, DefaultConstructorMarker $constructor_marker) {
            this(line, column, text);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/console/PathCandidate$FilePosition$Companion;", "", "<init>", "()V", "create", "Lcom/jetbrains/cidr/execution/console/PathCandidate$FilePosition;", "parsedLine", "", "parsedColumn", "text", "", "(ILjava/lang/Integer;Ljava/lang/String;)Lcom/jetbrains/cidr/execution/console/PathCandidate$FilePosition;", "intellij.cidr.execution"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final FilePosition create(int parsedLine, @Nullable Integer parsedColumn, @NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return new FilePosition(parsedLine - 1, parsedColumn, text, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

