/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.console;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/execution/console/ConsolePathTokenizer;", "", "offset", "", "s", "", "<init>", "(ILjava/lang/String;)V", "getOffset", "()I", "getS", "()Ljava/lang/String;", "tokens", "", "Lcom/jetbrains/cidr/execution/console/ConsolePathTokenizer$Token;", "getTokens", "()Ljava/util/List;", "Token", "intellij.cidr.execution"})
public final class ConsolePathTokenizer {
    private final int offset;
    @NotNull
    private final String s;
    @NotNull
    private final List<Token> tokens;

    public ConsolePathTokenizer(int offset, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.offset = offset;
        this.s = s;
        List result = new ArrayList();
        int it = 0;
        int tokenStart = 0;
        Character activeQuote = null;
        boolean isEscaped = false;
        block4: while (it < this.s.length()) {
            char currentCharacter = this.s.charAt(it);
            if (isEscaped) {
                isEscaped = false;
                ++it;
                continue;
            }
            switch (currentCharacter) {
                case '\\': {
                    isEscaped = true;
                    ++it;
                    continue block4;
                }
                case '\"': 
                case '\'': {
                    if (activeQuote == null) {
                        activeQuote = Character.valueOf(currentCharacter);
                    } else {
                        char c = currentCharacter;
                        if (activeQuote.charValue() == c) {
                            activeQuote = null;
                        }
                    }
                    ++it;
                    continue block4;
                }
            }
            if (CharsKt.isWhitespace((char)currentCharacter)) {
                if (activeQuote == null && it > tokenStart) {
                    String string = this.s.substring(tokenStart, it);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String candidate = StringsKt.removeSurrounding((String)StringsKt.removeSurrounding((String)string, (CharSequence)"\""), (CharSequence)"'");
                    result.add(new Token(candidate, this.offset + tokenStart, this.offset + it));
                    tokenStart = it + 1;
                }
                result.add(new Token(String.valueOf(currentCharacter), this.offset + it, this.offset + it + 1));
                ++it;
                continue;
            }
            ++it;
        }
        if (tokenStart < this.s.length()) {
            String string = this.s.substring(tokenStart, this.s.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result.add(new Token(StringsKt.removeSurrounding((String)string, (CharSequence)"\""), this.offset + tokenStart, this.offset + this.s.length()));
        }
        this.tokens = result;
    }

    public final int getOffset() {
        return this.offset;
    }

    @NotNull
    public final String getS() {
        return this.s;
    }

    @NotNull
    public final List<Token> getTokens() {
        return this.tokens;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/execution/console/ConsolePathTokenizer$Token;", "", "s", "", "start", "", "end", "<init>", "(Ljava/lang/String;II)V", "getS", "()Ljava/lang/String;", "getStart", "()I", "getEnd", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.cidr.execution"})
    public static final class Token {
        @NotNull
        private final String s;
        private final int start;
        private final int end;

        public Token(@NotNull String s, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.s = s;
            this.start = start;
            this.end = end;
        }

        @NotNull
        public final String getS() {
            return this.s;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        @NotNull
        public final String component1() {
            return this.s;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        @NotNull
        public final Token copy(@NotNull String s, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return new Token(s, start, end);
        }

        public static /* synthetic */ Token copy$default(Token token, String string, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = token.s;
            }
            if ((n3 & 2) != 0) {
                n = token.start;
            }
            if ((n3 & 4) != 0) {
                n2 = token.end;
            }
            return token.copy(string, n, n2);
        }

        @NotNull
        public String toString() {
            return "Token(s=" + this.s + ", start=" + this.start + ", end=" + this.end + ")";
        }

        public int hashCode() {
            int result = this.s.hashCode();
            result = result * 31 + Integer.hashCode(this.start);
            result = result * 31 + Integer.hashCode(this.end);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token = (Token)other;
            if (!Intrinsics.areEqual((Object)this.s, (Object)token.s)) {
                return false;
            }
            if (this.start != token.start) {
                return false;
            }
            return this.end == token.end;
        }
    }
}

