/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.console;

import com.intellij.execution.filters.FileHyperlinkInfoBase;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.idea.AppModeAssertions;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.execution.CidrPathWithOffsetConsoleFilter;
import com.jetbrains.cidr.execution.DimmableFilter;
import com.jetbrains.cidr.execution.console.CidrPathConsoleFilterKt;
import com.jetbrains.cidr.execution.console.ConsolePathTokenizer;
import com.jetbrains.cidr.execution.console.PathCandidate;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.toolchains.CidrFileSeparators;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u0000 G2\u00020\u00012\u00020\u00022\u00020\u0003:\u0004DEFGB#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016JC\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0015H\u0002\u00a2\u0006\u0002\u0010&JV\u0010'\u001a\u00020\u00162\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0 2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020)0 2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020)0 2\u0006\u0010\u001e\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0015H\u0002J:\u0010,\u001a\u00020\u00162\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0 2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u001e\u001a\u00020\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0015H\u0002J \u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001e\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\"\u0010.\u001a\u0004\u0018\u00010%2\u0006\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020!2\u0006\u00101\u001a\u00020\u001aH\u0016J\"\u00102\u001a\u0004\u0018\u00010%2\u0006\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020!2\u0006\u00103\u001a\u000204H\u0002J \u00102\u001a\u0002052\u0006\u00103\u001a\u0002042\u0006\u0010\u0019\u001a\u00020\u001c2\u0006\u00106\u001a\u00020\u001cH\u0014J\u0012\u00107\u001a\u0004\u0018\u0001042\u0006\u00108\u001a\u00020\tH\u0002J$\u00109\u001a\b\u0012\u0004\u0012\u00020)0 2\u0006\u0010\u001e\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0018\u0010:\u001a\u00020;2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020!H\u0014J\u0018\u0010=\u001a\u00020;2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020!H\u0002J\u0010\u0010>\u001a\u00020;2\u0006\u0010<\u001a\u00020!H\u0002J\u0010\u0010?\u001a\u00020;2\u0006\u0010<\u001a\u00020!H\u0002J\u0010\u0010@\u001a\u00020;2\u0006\u0010<\u001a\u00020!H\u0002J\u0012\u0010A\u001a\u0004\u0018\u0001042\u0006\u0010B\u001a\u00020\u001aH\u0002J\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020\u000f0 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilter;", "Lcom/intellij/execution/filters/Filter;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/jetbrains/cidr/execution/DimmableFilter;", "project", "Lcom/intellij/openapi/project/Project;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "baseDir", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;Ljava/nio/file/Path;)V", "dimHighlighting", "", "localPathResolver", "Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilter$PathResolver;", "environmentPathResolver", "testPathResolver", "fastPathConsoleFilter", "Lcom/jetbrains/cidr/execution/CidrPathWithOffsetConsoleFilter;", "detectedDirectories", "", "", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "checkCandidate", "pathResolver", "pathCandidates", "", "Lcom/jetbrains/cidr/execution/console/PathCandidate;", "startPosition", "finishPosition", "results", "Lcom/intellij/execution/filters/Filter$ResultItem;", "(Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilter$PathResolver;Ljava/util/List;IILjava/util/List;)Ljava/lang/Integer;", "detectRecursively", "startCandidates", "Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilter$PathCandidateWithPriority;", "finishCandidates", "startAndFinishCandidates", "runNaiveDetection", "filteredPathCandidatePositions", "getHyperlinkByPath", "startCandidate", "candidateWithPosition", "localPathString", "createHyperlinkInfo", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "column", "fileByIOFile", "nioPath", "retrieveCandidates", "calculatePriority", "Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilter$Priority;", "pathCandidate", "calculatePriorityCommon", "calculatePriorityWindows", "calculatePriorityLinux", "calculatePriorityMacos", "findSingleFileByName", "name", "getPathResolvers", "Priority", "PathCandidateWithPriority", "PathResolver", "Companion", "intellij.cidr.execution"})
@SourceDebugExtension(value={"SMAP\nCidrPathConsoleFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrPathConsoleFilter.kt\ncom/jetbrains/cidr/execution/console/CidrPathConsoleFilter\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,667:1\n140#2:668\n129#2,5:669\n1869#3,2:674\n774#3:676\n865#3,2:677\n1056#3:679\n774#3:680\n865#3,2:681\n1056#3:683\n774#3:684\n865#3,2:685\n774#3:687\n865#3,2:688\n1056#3:690\n1563#3:691\n1634#3,3:692\n1761#3,3:695\n1563#3:698\n1634#3,3:699\n774#3:702\n865#3,2:703\n1068#3:705\n1563#3:706\n1634#3,3:707\n1761#3,3:716\n1761#3,3:719\n1761#3,3:722\n1761#3,3:725\n774#3:732\n865#3,2:733\n1869#3,2:735\n1#4:710\n1104#5,3:711\n12970#6,2:714\n12970#6,2:728\n12970#6,2:730\n*S KotlinDebug\n*F\n+ 1 CidrPathConsoleFilter.kt\ncom/jetbrains/cidr/execution/console/CidrPathConsoleFilter\n*L\n182#1:668\n182#1:669,5\n270#1:674,2\n295#1:676\n295#1:677,2\n295#1:679\n296#1:680\n296#1:681,2\n296#1:683\n305#1:684\n305#1:685,2\n306#1:687\n306#1:688,2\n307#1:690\n315#1:691\n315#1:692,3\n390#1:695,3\n449#1:698\n449#1:699,3\n450#1:702\n450#1:703,2\n451#1:705\n452#1:706\n452#1:707,3\n520#1:716,3\n521#1:719,3\n522#1:722,3\n527#1:725,3\n572#1:732\n572#1:733,2\n103#1:735,2\n510#1:711,3\n516#1:714,2\n543#1:728,2\n550#1:730,2\n*E\n"})
public class CidrPathConsoleFilter
implements Filter,
DumbAware,
DimmableFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final CidrToolEnvironment environment;
    @Nullable
    private final Path baseDir;
    private boolean dimHighlighting;
    @NotNull
    private final PathResolver localPathResolver;
    @Nullable
    private final PathResolver environmentPathResolver;
    @Nullable
    private PathResolver testPathResolver;
    @NotNull
    private final CidrPathWithOffsetConsoleFilter fastPathConsoleFilter;
    @NotNull
    private final List<Path> detectedDirectories;
    private static final long ONE_APPLY_FILTER_TIMEOUT = 1000L;
    @NotNull
    private static final String[] BUILD_SYSTEM_FILES;
    @NotNull
    private static final String[] LINUX_DEFAULT_PATH_PREFIXES;
    @NotNull
    private static final String[] MACOS_DEFAULT_PATH_PREFIXES;
    @NotNull
    private static final Regex WINDOWS_DISK_PREFIX_REGEX;
    @NotNull
    private static final Regex WINDOWS_SERVER_PREFIX_REGEX;
    @NotNull
    private static final Character[] PATH_PUNCTUATION;

    public CidrPathConsoleFilter(@NotNull Project project, @Nullable CidrToolEnvironment environment, @Nullable Path baseDir) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.environment = environment;
        this.baseDir = baseDir;
        this.localPathResolver = new PathResolver(){

            public OS os() {
                OS oS = OS.CURRENT;
                Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"CURRENT");
                return oS;
            }

            public String toLocalPath(String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return path;
            }
        };
        this.environmentPathResolver = this.environment != null && Companion.enabledForEnvironment() ? (PathResolver)new PathResolver(this){
            final /* synthetic */ CidrPathConsoleFilter this$0;
            {
                this.this$0 = $receiver;
            }

            public OS os() {
                OS oS = CidrPathConsoleFilter.access$getEnvironment$p(this.this$0).getHostMachine().getOS();
                Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"getOS(...)");
                return oS;
            }

            public String toLocalPath(String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Path path2 = CidrPathConsoleFilter.access$getBaseDir$p(this.this$0);
                String string = CidrPathConsoleFilter.access$getEnvironment$p(this.this$0).toLocalPath(path2 != null ? path2.toFile() : null, path);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLocalPath(...)");
                return string;
            }

            public HostMachine hostMachine() {
                HostMachine hostMachine = CidrPathConsoleFilter.access$getEnvironment$p(this.this$0).getHostMachine();
                Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"getHostMachine(...)");
                return hostMachine;
            }
        } : null;
        this.fastPathConsoleFilter = new CidrPathWithOffsetConsoleFilter(this.project, this.environment, this.baseDir);
        this.detectedDirectories = new ArrayList();
        if (this.baseDir != null) {
            this.detectedDirectories.add(this.baseDir);
        }
        try {
            String string = System.getProperty("user.home");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            Path path = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            this.detectedDirectories.add(path);
        }
        catch (InvalidPathException invalidPathException) {
        }
    }

    @Override
    public void dimHighlighting() {
        this.dimHighlighting = true;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Filter.Result result = (Filter.Result)ProgressIndicatorUtils.withTimeout((long)1000L, () -> CidrPathConsoleFilter.applyFilter$lambda$0(entireLength, line, this));
        if (result != null) {
            return result;
        }
        if (!Companion.enabledForEnvironment()) {
            return this.fastPathConsoleFilter.applyFilter(line, entireLength);
        }
        return null;
    }

    private final Integer checkCandidate(PathResolver pathResolver, List<PathCandidate> pathCandidates, int startPosition, int finishPosition, List<Filter.ResultItem> results) {
        MatchResult parentDirectoryPrefixMatch;
        String candidateForPath = CollectionsKt.joinToString$default((Iterable)pathCandidates.subList(startPosition, finishPosition), (CharSequence)"", null, null, (int)0, null, CidrPathConsoleFilter::checkCandidate$lambda$0, (int)30, null) + pathCandidates.get(finishPosition).getPath();
        PathCandidate finishCandidate = pathCandidates.get(finishPosition);
        int additionalTokensIndex = finishPosition;
        while (additionalTokensIndex + 1 < pathCandidates.size() && !(!StringsKt.isBlank((CharSequence)pathCandidates.get(additionalTokensIndex + 1).getPath()))) {
            if (pathCandidates.get(additionalTokensIndex + 1).getType() != null) {
                finishCandidate = pathCandidates.get(additionalTokensIndex + 1);
                break;
            }
            ++additionalTokensIndex;
        }
        if (Intrinsics.areEqual((Object)finishCandidate, (Object)pathCandidates.get(finishPosition))) {
            additionalTokensIndex = finishPosition;
        }
        String localPathString = pathResolver.toLocalPath(candidateForPath);
        Filter.ResultItem hyperlink = this.getHyperlinkByPath(pathCandidates.get(startPosition), finishCandidate, localPathString);
        if (hyperlink != null) {
            results.add(hyperlink);
            return additionalTokensIndex;
        }
        if (!StringsKt.isBlank((CharSequence)localPathString) && finishCandidate.getType() == null && ArraysKt.contains((Object[])PATH_PUNCTUATION, (Object)Character.valueOf(StringsKt.last((CharSequence)localPathString)))) {
            CharSequence charSequence;
            block10: {
                String $this$trimEnd$iv = localPathString;
                boolean $i$f$trimEnd = false;
                CharSequence $this$trimEnd$iv$iv = $this$trimEnd$iv;
                boolean $i$f$trimEnd2 = false;
                int n = $this$trimEnd$iv$iv.length() + -1;
                if (0 <= n) {
                    do {
                        int index$iv$iv = n--;
                        char it = $this$trimEnd$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        if (ArraysKt.contains((Object[])PATH_PUNCTUATION, (Object)Character.valueOf(it))) continue;
                        charSequence = $this$trimEnd$iv$iv.subSequence(0, index$iv$iv + 1);
                        break block10;
                    } while (0 <= n);
                }
                charSequence = "";
            }
            String trimmed = ((Object)charSequence).toString();
            Filter.ResultItem trimmedHyperlink = this.getHyperlinkByPath(pathCandidates.get(startPosition), PathCandidate.copy$default(finishCandidate, null, 0, 0, finishCandidate.getFinish() + trimmed.length() - localPathString.length(), null, 23, null), trimmed);
            if (trimmedHyperlink != null) {
                results.add(trimmedHyperlink);
                return additionalTokensIndex;
            }
        }
        if ((parentDirectoryPrefixMatch = Regex.find$default((Regex)pathResolver.getParentDirsPrefix(), (CharSequence)candidateForPath, (int)0, (int)2, null)) != null) {
            String string = candidateForPath.substring(parentDirectoryPrefixMatch.getRange().getLast() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String pathWithoutPrefix = string;
            Filter.ResultItem hyperlinkWithoutPrefix = this.getHyperlinkByPath(pathCandidates.get(startPosition), finishCandidate, pathWithoutPrefix);
            if (hyperlinkWithoutPrefix != null) {
                results.add(hyperlinkWithoutPrefix);
                return additionalTokensIndex;
            }
        }
        return null;
    }

    private final void detectRecursively(List<PathCandidateWithPriority> startCandidates, List<PathCandidateWithPriority> finishCandidates, List<PathCandidateWithPriority> startAndFinishCandidates, PathResolver pathResolver, List<PathCandidate> pathCandidates, List<Filter.ResultItem> results) {
        if (startCandidates.isEmpty() || finishCandidates.isEmpty() || startAndFinishCandidates.isEmpty()) {
            return;
        }
        List alreadyVisitedCombinations = new ArrayList();
        CidrPathConsoleFilter.detectRecursively$checkSubString(alreadyVisitedCombinations, this, pathResolver, pathCandidates, results, startAndFinishCandidates);
    }

    private final void runNaiveDetection(List<Integer> filteredPathCandidatePositions, List<PathCandidate> pathCandidates, PathResolver pathResolver, List<Filter.ResultItem> results) {
        int previousGoodHyperlink = 0;
        previousGoodHyperlink = -1;
        Iterable $this$forEach$iv = filteredPathCandidatePositions;
        boolean $i$f$forEach = false;
        block0: for (Object element$iv : $this$forEach$iv) {
            int index = ((Number)element$iv).intValue();
            boolean bl = false;
            ProgressManager.checkCanceled();
            int it = previousGoodHyperlink + 1;
            while (it <= index) {
                if (StringsKt.isBlank((CharSequence)pathCandidates.get(it).getPath())) {
                    ++it;
                    continue;
                }
                Integer resultOfCheck = this.checkCandidate(pathResolver, pathCandidates, it, index, results);
                if (resultOfCheck != null) {
                    previousGoodHyperlink = resultOfCheck;
                    continue block0;
                }
                ++it;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Filter.Result applyFilter(PathResolver pathResolver, List<PathCandidate> pathCandidates) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$sortedBy$iv;
        void $this$filterTo$iv$iv3;
        Iterable $this$sortedBy$iv2;
        Object element$iv$iv2;
        void $this$filterTo$iv$iv4;
        ProgressManager.checkCanceled();
        List<PathCandidateWithPriority> filteredPathCandidates = this.retrieveCandidates(pathResolver, pathCandidates);
        List results = new ArrayList();
        Iterable $this$filter$iv = filteredPathCandidates;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv4) {
            PathCandidateWithPriority it = (PathCandidateWithPriority)element$iv$iv2;
            boolean bl = false;
            if (!(it.getPriority().getStartPriority() > 0)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv2 = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PathCandidateWithPriority it = (PathCandidateWithPriority)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority().getStartPriority());
                it = (PathCandidateWithPriority)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority().getStartPriority()));
            }
        }), (int)10);
        $i$f$sortedBy = false;
        List startCandidates = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PathCandidateWithPriority it = (PathCandidateWithPriority)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPathCandidate().getPosition());
                it = (PathCandidateWithPriority)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPathCandidate().getPosition()));
            }
        });
        Iterable $this$filter$iv2 = filteredPathCandidates;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv3) {
            PathCandidateWithPriority it = (PathCandidateWithPriority)element$iv$iv3;
            boolean bl = false;
            if (!(it.getPriority().getFinishPriority() > 0)) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$sortedBy2 = false;
        $this$sortedBy$iv = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PathCandidateWithPriority it = (PathCandidateWithPriority)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority().getFinishPriority());
                it = (PathCandidateWithPriority)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority().getFinishPriority()));
            }
        }), (int)10);
        $i$f$sortedBy2 = false;
        List finishCandidates = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PathCandidateWithPriority it = (PathCandidateWithPriority)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPathCandidate().getPosition());
                it = (PathCandidateWithPriority)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPathCandidate().getPosition()));
            }
        });
        Object object = (PathCandidateWithPriority)CollectionsKt.lastOrNull((List)finishCandidates);
        int lastFinishPosition = object != null && (object = ((PathCandidateWithPriority)object).getPathCandidate()) != null ? ((PathCandidate)object).getPosition() : Integer.MAX_VALUE;
        Object object2 = (PathCandidateWithPriority)CollectionsKt.firstOrNull((List)startCandidates);
        int firstStartPosition = object2 != null && (object2 = ((PathCandidateWithPriority)object2).getPathCandidate()) != null ? ((PathCandidate)object2).getPosition() : Integer.MIN_VALUE;
        Iterable $this$filter$iv3 = startCandidates;
        boolean $i$f$filter3 = false;
        element$iv$iv2 = $this$filter$iv3;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv4 : $this$filterTo$iv$iv2) {
            PathCandidateWithPriority it = (PathCandidateWithPriority)element$iv$iv4;
            boolean bl = false;
            if (!(it.getPathCandidate().getPosition() < lastFinishPosition)) continue;
            destination$iv$iv3.add(element$iv$iv4);
        }
        List startElementsWithFinishPotential = (List)destination$iv$iv3;
        Iterable $this$filter$iv4 = finishCandidates;
        boolean $i$f$filter4 = false;
        destination$iv$iv3 = $this$filter$iv4;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo4 = false;
        for (Object element$iv$iv5 : $this$filterTo$iv$iv) {
            PathCandidateWithPriority it = (PathCandidateWithPriority)element$iv$iv5;
            boolean bl = false;
            if (!(it.getPathCandidate().getPosition() > firstStartPosition)) continue;
            destination$iv$iv4.add(element$iv$iv5);
        }
        List finishElementsWithStartPotential = (List)destination$iv$iv4;
        Iterable $this$sortedBy$iv3 = CollectionsKt.plus((Collection)startElementsWithFinishPotential, (Iterable)finishElementsWithStartPotential);
        boolean $i$f$sortedBy3 = false;
        List startAndFinishCandidates = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv3, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PathCandidateWithPriority it = (PathCandidateWithPriority)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPathCandidate().getPosition());
                it = (PathCandidateWithPriority)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPathCandidate().getPosition()));
            }
        });
        if (!((Collection)startCandidates).isEmpty() && !((Collection)finishCandidates).isEmpty() && !((Collection)startAndFinishCandidates).isEmpty()) {
            this.detectRecursively(startCandidates, finishCandidates, startAndFinishCandidates, pathResolver, pathCandidates, results);
        }
        if (results.isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$sortedBy$iv3 = filteredPathCandidates;
            CidrPathConsoleFilter cidrPathConsoleFilter = this;
            boolean $i$f$map = false;
            destination$iv$iv4 = $this$map$iv;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PathCandidateWithPriority bl = (PathCandidateWithPriority)item$iv$iv;
                Collection collection = destination$iv$iv5;
                boolean bl2 = false;
                collection.add(it.getPathCandidate().getPosition());
            }
            cidrPathConsoleFilter.runNaiveDetection((List)destination$iv$iv5, pathCandidates, pathResolver, results);
        }
        return results.isEmpty() ? null : new Filter.Result(results);
    }

    @Nullable
    public Filter.ResultItem getHyperlinkByPath(@NotNull PathCandidate startCandidate, @NotNull PathCandidate candidateWithPosition, @NotNull String localPathString) {
        VirtualFile file;
        block17: {
            VirtualFile virtualFile;
            Path localPath;
            Intrinsics.checkNotNullParameter((Object)startCandidate, (String)"startCandidate");
            Intrinsics.checkNotNullParameter((Object)candidateWithPosition, (String)"candidateWithPosition");
            Intrinsics.checkNotNullParameter((Object)localPathString, (String)"localPathString");
            if (this.localPathResolver.os() != OS.Windows && StringsKt.startsWith$default((String)localPathString, (String)"~", (boolean)false, (int)2, null)) {
                try {
                    String string = System.getProperty("user.home");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
                    var5_4 = string;
                    String[] stringArray = new String[1];
                    Intrinsics.checkNotNullExpressionValue((Object)localPathString.substring(1), (String)"substring(...)");
                    Path path = Paths.get((String)var5_4, Arrays.copyOf(stringArray, stringArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    var5_4 = path;
                }
                catch (InvalidPathException invalidPathException) {
                    return null;
                }
                v2 = var5_4;
            } else {
                try {
                    Path path = Paths.get(localPathString, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    var5_4 = path;
                }
                catch (InvalidPathException invalidPathException) {
                    return null;
                }
                v2 = localPath = var5_4;
            }
            if (localPath.isAbsolute()) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(localPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    this.detectedDirectories.add(localPath);
                    file = this.fileByIOFile(localPath);
                    if (file != null) {
                        return this.createHyperlinkInfo(startCandidate, candidateWithPosition, file);
                    }
                    return null;
                }
                file = this.fileByIOFile(localPath);
                if (file != null) {
                    return this.createHyperlinkInfo(startCandidate, candidateWithPosition, file);
                }
                return null;
            }
            for (Path directory : (Iterable)CollectionsKt.toList((Iterable)this.detectedDirectories)) {
                VirtualFile virtualFile2;
                VirtualFile virtualFile3;
                boolean bl = false;
                Path candidatePath = directory.resolve(localPath);
                Intrinsics.checkNotNull((Object)candidatePath);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(candidatePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    virtualFile3 = null;
                } else {
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    if (Files.isDirectory(candidatePath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                        this.detectedDirectories.add(candidatePath);
                        virtualFile3 = this.fileByIOFile(candidatePath);
                    } else {
                        virtualFile3 = this.fileByIOFile(candidatePath);
                    }
                }
                if ((virtualFile2 = virtualFile3) == null) continue;
                virtualFile = virtualFile2;
                break block17;
            }
            virtualFile = file = null;
        }
        if (file == null) {
            file = this.findSingleFileByName(localPathString);
        }
        if (file != null) {
            return this.createHyperlinkInfo(startCandidate, candidateWithPosition, file);
        }
        return null;
    }

    private final Filter.ResultItem createHyperlinkInfo(PathCandidate startCandidate, PathCandidate candidateWithPosition, VirtualFile file) {
        Object object;
        if (file.isDirectory()) {
            boolean bl;
            Iterable $this$any$iv;
            block8: {
                if (candidateWithPosition.getType() != null) {
                    return null;
                }
                $this$any$iv = BaseProjectDirectories.Companion.getBaseDirectories(this.project);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        VirtualFile it = (VirtualFile)element$iv;
                        boolean bl2 = false;
                        String string = file.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        String string2 = it.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                        if (!StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                $this$any$iv = this.project;
                return new Filter.ResultItem(startCandidate.getStart(), candidateWithPosition.getFinish(), (HyperlinkInfo)new FileHyperlinkInfoBase(file, (Project)$this$any$iv){
                    private final VirtualFile virtualFile;
                    final /* synthetic */ VirtualFile $file;
                    {
                        this.$file = $file;
                        super($super_call_param$1, 0, 0, false, 8, null);
                        this.virtualFile = $file;
                    }

                    protected VirtualFile getVirtualFile() {
                        return this.virtualFile;
                    }

                    public void navigate(Project project) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        ProjectView.getInstance((Project)project).selectCB(null, this.$file, true);
                    }
                });
            }
            return new Filter.ResultItem(startCandidate.getStart(), candidateWithPosition.getFinish(), this.createHyperlinkInfo(file, 0, 0));
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager documentManager = fileDocumentManager;
        Document document = documentManager.getDocument(file);
        if (document == null) {
            Object object2;
            if (!Companion.enabledForBinaryFiles() || !Companion.isMonolith()) {
                return null;
            }
            int n = startCandidate.getStart();
            int n2 = candidateWithPosition.getFinish();
            VirtualFile virtualFile = file.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
            PathCandidate.FilePosition filePosition = candidateWithPosition.getType();
            return new Filter.ResultItem(n, n2, this.createHyperlinkInfo(virtualFile, filePosition != null ? filePosition.getLine() : 0, (object2 = candidateWithPosition.getType()) != null && (object2 = ((PathCandidate.FilePosition)object2).getColumn()) != null ? (Integer)object2 : 0));
        }
        PathCandidate.FilePosition filePosition = candidateWithPosition.getType();
        return new Filter.ResultItem(startCandidate.getStart(), candidateWithPosition.getFinish(), this.createHyperlinkInfo(file, filePosition != null ? filePosition.getLine() : 0, (object = candidateWithPosition.getType()) != null && (object = ((PathCandidate.FilePosition)object).getColumn()) != null ? (Integer)object : 0));
    }

    @NotNull
    protected HyperlinkInfo createHyperlinkInfo(@NotNull VirtualFile file, int line, int column) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (HyperlinkInfo)new OpenFileHyperlinkInfo(this.project, file, line, column);
    }

    private final VirtualFile fileByIOFile(Path nioPath) {
        try {
            return LocalFileSystem.getInstance().findFileByNioFile(nioPath);
        }
        catch (VfsRootAccess.VfsRootAccessNotAllowedError vfsRootAccessNotAllowedError) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<PathCandidateWithPriority> retrieveCandidates(PathResolver pathResolver, List<PathCandidate> pathCandidates) {
        boolean bl;
        Iterable $this$sortedByDescending$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        PathCandidateWithPriority it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = pathCandidates;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PathCandidate pathCandidate = (PathCandidate)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new PathCandidateWithPriority((PathCandidate)((Object)it), this.calculatePriority(pathResolver, (PathCandidate)((Object)it))));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PathCandidateWithPriority)element$iv$iv;
            boolean bl3 = false;
            if (!(it.getPriority().getPrioritySum() > Companion.priorityLimit())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PathCandidateWithPriority it = (PathCandidateWithPriority)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority().getPrioritySum());
                it = (PathCandidateWithPriority)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority().getPrioritySum()));
            }
        });
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PathCandidateWithPriority)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(it);
        }
        List result = (List)destination$iv$iv;
        boolean bl5 = bl = result.size() <= pathCandidates.size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl6 = false;
            String string = "Too many candidates after filtering. retrieveCandidates should only sort by priority and filter them. " + result + ", " + pathCandidates;
            throw new AssertionError((Object)string);
        }
        return result;
    }

    @NotNull
    protected Priority calculatePriority(@NotNull PathResolver pathResolver, @NotNull PathCandidate pathCandidate) {
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        Intrinsics.checkNotNullParameter((Object)pathCandidate, (String)"pathCandidate");
        OS os = pathResolver.os();
        Priority standardPriority = this.calculatePriorityCommon(pathResolver, pathCandidate);
        Priority osPriority = switch (WhenMappings.$EnumSwitchMapping$0[os.ordinal()]) {
            case 1 -> this.calculatePriorityWindows(pathCandidate);
            case 2 -> this.calculatePriorityMacos(pathCandidate);
            case 3 -> this.calculatePriorityLinux(pathCandidate);
            case 4 -> this.calculatePriorityLinux(pathCandidate);
            case 5 -> Priority.Companion.getZERO();
            default -> throw new NoWhenBranchMatchedException();
        };
        return standardPriority.plus(osPriority);
    }

    private final Priority calculatePriorityCommon(PathResolver pathResolver, PathCandidate pathCandidate) {
        boolean bl;
        Priority calculatedPriority;
        String extension;
        List pseudoPath;
        block31: {
            boolean $i$f$any;
            Object $this$any$iv;
            block33: {
                block32: {
                    boolean bl2;
                    block30: {
                        boolean bl3;
                        block29: {
                            boolean bl4;
                            block28: {
                                boolean bl5;
                                block27: {
                                    int element$iv;
                                    int n;
                                    String line = pathCandidate.getPath();
                                    pseudoPath = pathResolver.fileSeparator().split(line);
                                    if (pseudoPath.isEmpty()) {
                                        return Priority.Companion.getNEGATIVE();
                                    }
                                    String fileName = (String)CollectionsKt.last((List)pseudoPath);
                                    extension = null;
                                    extension = StringsKt.substringAfterLast((String)fileName, (char)'.', (String)"");
                                    if (StringsKt.isBlank((CharSequence)extension)) {
                                        CharSequence $this$count$iv = fileName;
                                        boolean $i$f$count = false;
                                        int count$iv = 0;
                                        for (n = 0; n < $this$count$iv.length(); ++n) {
                                            int it = element$iv = (int)$this$count$iv.charAt(n);
                                            boolean bl6 = false;
                                            if (!(it == 46)) continue;
                                            ++count$iv;
                                        }
                                        if (count$iv > 1) {
                                            extension = StringsKt.substringAfterLast$default((String)StringsKt.substringBeforeLast$default((String)fileName, (char)'.', null, (int)2, null), (char)'.', null, (int)2, null);
                                        }
                                    }
                                    calculatedPriority = Priority.Companion.getZERO();
                                    $this$any$iv = BUILD_SYSTEM_FILES;
                                    $i$f$any = false;
                                    element$iv = ((String[])$this$any$iv).length;
                                    for (n = 0; n < element$iv; ++n) {
                                        String element$iv2;
                                        String buildSystemFile = element$iv2 = $this$any$iv[n];
                                        boolean bl7 = false;
                                        if (!StringsKt.equals((String)buildSystemFile, (String)fileName, (boolean)true)) continue;
                                        bl5 = true;
                                        break block27;
                                    }
                                    bl5 = false;
                                }
                                if (bl5) {
                                    calculatedPriority = calculatedPriority.plus(Priority.Companion.finishPriority(100));
                                }
                                Set set = OCFileTypeHelpers.sourceExtensions();
                                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"sourceExtensions(...)");
                                $this$any$iv = set;
                                $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl4 = false;
                                } else {
                                    Iterator iterator = $this$any$iv.iterator();
                                    while (iterator.hasNext()) {
                                        Object element$iv = iterator.next();
                                        String it = (String)element$iv;
                                        boolean bl8 = false;
                                        if (!(!Intrinsics.areEqual((Object)extension, (Object)"") && StringsKt.equals((String)extension, (String)it, (boolean)true))) continue;
                                        bl4 = true;
                                        break block28;
                                    }
                                    bl4 = false;
                                }
                            }
                            if (bl4) break block32;
                            Set set = OCFileTypeHelpers.headerExtensions();
                            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"headerExtensions(...)");
                            $this$any$iv = set;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl3 = false;
                            } else {
                                Iterator iterator = $this$any$iv.iterator();
                                while (iterator.hasNext()) {
                                    Object element$iv = iterator.next();
                                    String it = (String)element$iv;
                                    boolean bl9 = false;
                                    if (!(!Intrinsics.areEqual((Object)extension, (Object)"") && StringsKt.equals((String)extension, (String)it, (boolean)true))) continue;
                                    bl3 = true;
                                    break block29;
                                }
                                bl3 = false;
                            }
                        }
                        if (bl3) break block32;
                        Set set = OCFileTypeHelpers.moduleExtensions();
                        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"moduleExtensions(...)");
                        $this$any$iv = set;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            Iterator iterator = $this$any$iv.iterator();
                            while (iterator.hasNext()) {
                                Object element$iv = iterator.next();
                                String it = (String)element$iv;
                                boolean bl10 = false;
                                if (!(!Intrinsics.areEqual((Object)extension, (Object)"") && StringsKt.equals((String)extension, (String)it, (boolean)true))) continue;
                                bl2 = true;
                                break block30;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) break block33;
                }
                calculatedPriority = calculatedPriority.plus(Priority.Companion.finishPriority(99));
            }
            if (pathCandidate.getType() != null) {
                calculatedPriority = calculatedPriority.plus(Priority.Companion.finishPriority(35));
            }
            Set set = OCFileTypeHelpers.objExtensions();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"objExtensions(...)");
            $this$any$iv = set;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    String it = (String)element$iv;
                    boolean bl11 = false;
                    if (!(!Intrinsics.areEqual((Object)extension, (Object)"") && StringsKt.equals((String)extension, (String)it, (boolean)true))) continue;
                    bl = true;
                    break block31;
                }
                bl = false;
            }
        }
        if (bl) {
            calculatedPriority = calculatedPriority.plus(Priority.Companion.finishPriority(30));
        }
        if (!StringsKt.isBlank((CharSequence)extension)) {
            calculatedPriority = calculatedPriority.plus(Priority.Companion.finishPriority(30));
        }
        if (StringsKt.startsWith$default((String)((String)CollectionsKt.first((List)pseudoPath)), (String)"..", (boolean)false, (int)2, null)) {
            calculatedPriority = calculatedPriority.plus(Priority.Companion.startPriority(15));
        }
        if (StringsKt.startsWith$default((String)((String)CollectionsKt.first((List)pseudoPath)), (String)".", (boolean)false, (int)2, null)) {
            calculatedPriority = calculatedPriority.plus(Priority.Companion.startPriority(5));
        }
        calculatedPriority = calculatedPriority.plus(Priority.Companion.startPriority(5 * (pseudoPath.size() - 1)));
        return calculatedPriority;
    }

    private final Priority calculatePriorityWindows(PathCandidate pathCandidate) {
        String line = pathCandidate.getPath();
        CharSequence charSequence = line;
        if (WINDOWS_DISK_PREFIX_REGEX.matches(charSequence) || WINDOWS_SERVER_PREFIX_REGEX.matches(charSequence = (CharSequence)line)) {
            return Priority.Companion.startPriority(60);
        }
        return Priority.Companion.getZERO();
    }

    private final Priority calculatePriorityLinux(PathCandidate pathCandidate) {
        boolean bl;
        String line;
        block3: {
            line = pathCandidate.getPath();
            String[] $this$any$iv = LINUX_DEFAULT_PATH_PREFIXES;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)line, (String)it, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            return Priority.Companion.startPriority(70);
        }
        if (StringsKt.startsWith$default((String)line, (String)"/", (boolean)false, (int)2, null)) {
            return Priority.Companion.startPriority(20);
        }
        return Priority.Companion.getZERO();
    }

    private final Priority calculatePriorityMacos(PathCandidate pathCandidate) {
        boolean bl;
        String line;
        block3: {
            line = pathCandidate.getPath();
            String[] $this$any$iv = MACOS_DEFAULT_PATH_PREFIXES;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)line, (String)it, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            return Priority.Companion.startPriority(70);
        }
        if (StringsKt.startsWith$default((String)line, (String)"/", (boolean)false, (int)2, null)) {
            return Priority.Companion.startPriority(20);
        }
        return Priority.Companion.getZERO();
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile findSingleFileByName(String name) {
        Path path = Paths.get(name, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path filePath = path;
        try {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
            boolean caseSensitive = this.localPathResolver.os() != OS.Windows;
            FilenameIndex.processFilesByName((String)PathsKt.getName((Path)filePath), (boolean)caseSensitive, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.project), (Processor)((Processor)processor));
            Collection collection = processor.getResults();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getResults(...)");
            Iterable iterable = CollectionsKt.filterNotNull((Iterable)collection);
            boolean $i$f$filter = false;
            void var8_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path candidatePath;
                VirtualFile virtualFileCandidate = (VirtualFile)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileCandidate.toNioPath(), (String)"toNioPath(...)");
                if (!candidatePath.endsWith(filePath)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List results = (List)destination$iv$iv;
            return (VirtualFile)CollectionsKt.singleOrNull((List)results);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            return null;
        }
    }

    private final List<PathResolver> getPathResolvers() {
        Object[] objectArray = new PathResolver[]{this.testPathResolver, this.localPathResolver, this.environmentPathResolver};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private static final Filter.Result applyFilter$lambda$0(int $entireLength, String $line, CidrPathConsoleFilter this$0) {
        ProgressManager.checkCanceled();
        List<ConsolePathTokenizer.Token> tokens = new ConsolePathTokenizer($entireLength - $line.length(), $line).getTokens();
        List<PathCandidate> pathCandidates = PathCandidate.Companion.retrieveFrom(tokens);
        Iterable $this$forEach$iv = this$0.getPathResolvers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Filter.Result filterResult;
            PathResolver resolver = (PathResolver)element$iv;
            boolean bl = false;
            if (resolver.os() == OS.Other) {
                CidrPathConsoleFilterKt.access$getLOG$p().warn("Unsupported OS: " + resolver.os());
                continue;
            }
            Filter.Result result = filterResult = this$0.applyFilter(resolver, pathCandidates);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static final CharSequence checkCandidate$lambda$0(PathCandidate it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.fullText();
    }

    private static final void detectRecursively$checkSubString(List<Pair<Integer, Integer>> alreadyVisitedCombinations, CidrPathConsoleFilter this$0, PathResolver $pathResolver, List<PathCandidate> $pathCandidates, List<Filter.ResultItem> $results, List<PathCandidateWithPriority> candidates) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = !((Collection)candidates).isEmpty();
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Pair currentCombination = TuplesKt.to((Object)((PathCandidateWithPriority)CollectionsKt.first(candidates)).getPathCandidate().getPosition(), (Object)((PathCandidateWithPriority)CollectionsKt.last(candidates)).getPathCandidate().getPosition());
        if (alreadyVisitedCombinations.contains(currentCombination)) {
            return;
        }
        boolean bl4 = bl = ((PathCandidateWithPriority)CollectionsKt.first(candidates)).getPriority().getStartPriority() > 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl5 = bl = ((PathCandidateWithPriority)CollectionsKt.last(candidates)).getPriority().getFinishPriority() > 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (this$0.checkCandidate($pathResolver, $pathCandidates, ((Number)currentCombination.getFirst()).intValue(), ((Number)currentCombination.getSecond()).intValue(), $results) == null) {
            int nextFinishPosition;
            int nextStartPosition;
            for (nextStartPosition = 1; nextStartPosition < candidates.size() && candidates.get(nextStartPosition).getPriority().getStartPriority() <= 0; ++nextStartPosition) {
            }
            for (nextFinishPosition = candidates.size() - 2; nextFinishPosition >= 0 && candidates.get(nextFinishPosition).getPriority().getFinishPriority() <= 0; --nextFinishPosition) {
            }
            if (nextFinishPosition != -1) {
                CidrPathConsoleFilter.detectRecursively$checkSubString(alreadyVisitedCombinations, this$0, $pathResolver, $pathCandidates, $results, candidates.subList(0, nextFinishPosition + 1));
            }
            if (nextStartPosition != candidates.size()) {
                CidrPathConsoleFilter.detectRecursively$checkSubString(alreadyVisitedCombinations, this$0, $pathResolver, $pathCandidates, $results, candidates.subList(nextStartPosition, candidates.size()));
            }
        }
        alreadyVisitedCombinations.add((Pair<Integer, Integer>)currentCombination);
    }

    @JvmStatic
    public static final boolean enabled() {
        return Companion.enabled();
    }

    @JvmStatic
    public static final boolean enabledForEnvironment() {
        return Companion.enabledForEnvironment();
    }

    @JvmStatic
    public static final boolean enabledForBinaryFiles() {
        return Companion.enabledForBinaryFiles();
    }

    @JvmStatic
    public static final boolean isMonolith() {
        return Companion.isMonolith();
    }

    @JvmStatic
    public static final int priorityLimit() {
        return Companion.priorityLimit();
    }

    @JvmStatic
    @TestOnly
    public static final void setPriority(int priority) {
        Companion.setPriority(priority);
    }

    public static final /* synthetic */ CidrToolEnvironment access$getEnvironment$p(CidrPathConsoleFilter $this) {
        return $this.environment;
    }

    public static final /* synthetic */ Path access$getBaseDir$p(CidrPathConsoleFilter $this) {
        return $this.baseDir;
    }

    static {
        Object[] objectArray = new String[]{"CMakeLists.txt", "Makefile", "meson.build", "build.ninja"};
        BUILD_SYSTEM_FILES = objectArray;
        objectArray = new String[]{"/usr/include", "/usr/local/include", "/opt/local/include", "/opt/include", "/usr/lib", "/usr/local/lib", "/opt/local/lib", "/opt/lib", "/usr/local/lib64", "/home/"};
        LINUX_DEFAULT_PATH_PREFIXES = objectArray;
        objectArray = new String[]{"/usr/include", "/usr/local/include", "/opt/local/include", "/opt/include", "/usr/lib", "/usr/local/lib", "/opt/local/lib", "/Users/"};
        MACOS_DEFAULT_PATH_PREFIXES = objectArray;
        WINDOWS_DISK_PREFIX_REGEX = new Regex("^[A-Za-z]:\\\\");
        WINDOWS_SERVER_PREFIX_REGEX = new Regex("^\\\\\\\\server\\\\share\\\\");
        objectArray = new Character[]{Character.valueOf('.'), Character.valueOf(','), Character.valueOf('?'), Character.valueOf('!'), Character.valueOf('@'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('=')};
        PATH_PUNCTUATION = objectArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u0013H\u0007J\b\u0010\u0015\u001a\u00020\u0013H\u0007J\b\u0010\u0016\u001a\u00020\u0013H\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilter$Companion;", "", "<init>", "()V", "ONE_APPLY_FILTER_TIMEOUT", "", "BUILD_SYSTEM_FILES", "", "", "[Ljava/lang/String;", "LINUX_DEFAULT_PATH_PREFIXES", "MACOS_DEFAULT_PATH_PREFIXES", "WINDOWS_DISK_PREFIX_REGEX", "Lkotlin/text/Regex;", "WINDOWS_SERVER_PREFIX_REGEX", "PATH_PUNCTUATION", "", "[Ljava/lang/Character;", "enabled", "", "enabledForEnvironment", "enabledForBinaryFiles", "isMonolith", "priorityLimit", "", "setPriority", "", "priority", "intellij.cidr.execution"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean enabled() {
            return AdvancedSettings.Companion.getBoolean("cidr.path.console.filter.slow");
        }

        @JvmStatic
        public final boolean enabledForEnvironment() {
            return AdvancedSettings.Companion.getBoolean("cidr.path.console.filter.slow.environment");
        }

        @JvmStatic
        public final boolean enabledForBinaryFiles() {
            return AdvancedSettings.Companion.getBoolean("cidr.path.console.filter.slow.highlight.binary.files");
        }

        @JvmStatic
        public final boolean isMonolith() {
            return AppModeAssertions.isMonolith();
        }

        @JvmStatic
        public final int priorityLimit() {
            return Registry.Companion.intValue("cidr.path.console.filter.slow.priority.limit");
        }

        @JvmStatic
        @TestOnly
        public final void setPriority(int priority) {
            Registry.Companion.get("cidr.path.console.filter.slow.priority.limit").setValue(priority);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilter$PathCandidateWithPriority;", "", "pathCandidate", "Lcom/jetbrains/cidr/execution/console/PathCandidate;", "priority", "Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilter$Priority;", "<init>", "(Lcom/jetbrains/cidr/execution/console/PathCandidate;Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilter$Priority;)V", "getPathCandidate", "()Lcom/jetbrains/cidr/execution/console/PathCandidate;", "getPriority", "()Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilter$Priority;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.cidr.execution"})
    protected static final class PathCandidateWithPriority {
        @NotNull
        private final PathCandidate pathCandidate;
        @NotNull
        private final Priority priority;

        public PathCandidateWithPriority(@NotNull PathCandidate pathCandidate, @NotNull Priority priority) {
            Intrinsics.checkNotNullParameter((Object)pathCandidate, (String)"pathCandidate");
            Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
            this.pathCandidate = pathCandidate;
            this.priority = priority;
        }

        @NotNull
        public final PathCandidate getPathCandidate() {
            return this.pathCandidate;
        }

        @NotNull
        public final Priority getPriority() {
            return this.priority;
        }

        @NotNull
        public final PathCandidate component1() {
            return this.pathCandidate;
        }

        @NotNull
        public final Priority component2() {
            return this.priority;
        }

        @NotNull
        public final PathCandidateWithPriority copy(@NotNull PathCandidate pathCandidate, @NotNull Priority priority) {
            Intrinsics.checkNotNullParameter((Object)pathCandidate, (String)"pathCandidate");
            Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
            return new PathCandidateWithPriority(pathCandidate, priority);
        }

        public static /* synthetic */ PathCandidateWithPriority copy$default(PathCandidateWithPriority pathCandidateWithPriority, PathCandidate pathCandidate, Priority priority, int n, Object object) {
            if ((n & 1) != 0) {
                pathCandidate = pathCandidateWithPriority.pathCandidate;
            }
            if ((n & 2) != 0) {
                priority = pathCandidateWithPriority.priority;
            }
            return pathCandidateWithPriority.copy(pathCandidate, priority);
        }

        @NotNull
        public String toString() {
            return "PathCandidateWithPriority(pathCandidate=" + this.pathCandidate + ", priority=" + this.priority + ")";
        }

        public int hashCode() {
            int result = this.pathCandidate.hashCode();
            result = result * 31 + this.priority.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PathCandidateWithPriority)) {
                return false;
            }
            PathCandidateWithPriority pathCandidateWithPriority = (PathCandidateWithPriority)other;
            if (!Intrinsics.areEqual((Object)this.pathCandidate, (Object)pathCandidateWithPriority.pathCandidate)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.priority, (Object)pathCandidateWithPriority.priority);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b$\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH&J\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilter$PathResolver;", "", "<init>", "()V", "os", "Lcom/intellij/util/system/OS;", "hostMachine", "Lcom/jetbrains/cidr/system/HostMachine;", "toLocalPath", "", "path", "fileSeparator", "Lcom/jetbrains/cidr/lang/toolchains/CidrFileSeparators;", "fileSeparatorChars", "", "", "fileSeparatorSelectionSubRegex", "parentDirsPrefix", "Lkotlin/text/Regex;", "getParentDirsPrefix", "()Lkotlin/text/Regex;", "intellij.cidr.execution"})
    protected static abstract class PathResolver {
        @NotNull
        private final List<Character> fileSeparatorChars = this.fileSeparator().chars();
        @NotNull
        private final String fileSeparatorSelectionSubRegex = "[" + Regex.Companion.escape(CollectionsKt.joinToString$default((Iterable)this.fileSeparatorChars, (CharSequence)"", null, null, (int)0, null, null, (int)62, null)) + "]";
        @NotNull
        private final Regex parentDirsPrefix = new Regex("^(?:[.](?:" + this.fileSeparatorSelectionSubRegex + ")+)?(?:[.]{2}(?:" + this.fileSeparatorSelectionSubRegex + ")+)+");

        @NotNull
        public abstract OS os();

        @Nullable
        public HostMachine hostMachine() {
            return null;
        }

        @NotNull
        public abstract String toLocalPath(@NotNull String var1);

        @NotNull
        public final CidrFileSeparators fileSeparator() {
            return this.os() == OS.Windows ? CidrFileSeparators.WINDOWS_UNIX : CidrFileSeparators.UNIX;
        }

        @NotNull
        public final Regex getParentDirsPrefix() {
            return this.parentDirsPrefix;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0084\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilter$Priority;", "", "startPriority", "", "finishPriority", "<init>", "(II)V", "getStartPriority", "()I", "getFinishPriority", "plus", "other", "prioritySum", "getPrioritySum", "component1", "component2", "copy", "equals", "", "hashCode", "toString", "", "Companion", "intellij.cidr.execution"})
    protected static final class Priority {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int startPriority;
        private final int finishPriority;
        private final int prioritySum;
        @NotNull
        private static final Priority ZERO = new Priority(0, 0);
        @NotNull
        private static final Priority NEGATIVE = new Priority(-1, -1);

        public Priority(int startPriority, int finishPriority) {
            this.startPriority = startPriority;
            this.finishPriority = finishPriority;
            this.prioritySum = this.startPriority + this.finishPriority;
        }

        public final int getStartPriority() {
            return this.startPriority;
        }

        public final int getFinishPriority() {
            return this.finishPriority;
        }

        @NotNull
        public final Priority plus(@NotNull Priority other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return new Priority(this.startPriority + other.startPriority, this.finishPriority + other.finishPriority);
        }

        public final int getPrioritySum() {
            return this.prioritySum;
        }

        public final int component1() {
            return this.startPriority;
        }

        public final int component2() {
            return this.finishPriority;
        }

        @NotNull
        public final Priority copy(int startPriority, int finishPriority) {
            return new Priority(startPriority, finishPriority);
        }

        public static /* synthetic */ Priority copy$default(Priority priority, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = priority.startPriority;
            }
            if ((n3 & 2) != 0) {
                n2 = priority.finishPriority;
            }
            return priority.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Priority(startPriority=" + this.startPriority + ", finishPriority=" + this.finishPriority + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.startPriority);
            result = result * 31 + Integer.hashCode(this.finishPriority);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Priority)) {
                return false;
            }
            Priority priority = (Priority)other;
            if (this.startPriority != priority.startPriority) {
                return false;
            }
            return this.finishPriority == priority.finishPriority;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilter$Priority$Companion;", "", "<init>", "()V", "ZERO", "Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilter$Priority;", "getZERO", "()Lcom/jetbrains/cidr/execution/console/CidrPathConsoleFilter$Priority;", "NEGATIVE", "getNEGATIVE", "startPriority", "priority", "", "finishPriority", "intellij.cidr.execution"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Priority getZERO() {
                return ZERO;
            }

            @NotNull
            public final Priority getNEGATIVE() {
                return NEGATIVE;
            }

            @NotNull
            public final Priority startPriority(int priority) {
                return new Priority(priority, 0);
            }

            @NotNull
            public final Priority finishPriority(int priority) {
                return new Priority(0, priority);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.macOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.FreeBSD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Other.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

