/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunConfigurationBuildConfigurationEditor;
import com.jetbrains.cidr.execution.CidrRunConfigurationEditorUtil;
import com.jetbrains.cidr.ui.ComboBoxModelKt;
import com.jetbrains.cidr.ui.InvalidItem;
import com.jetbrains.cidr.ui.SortedCollectionComboBoxModel;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class CidrRunConfigurationSettingsEditor<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
extends SettingsEditor<CONFIGURATION>
implements PanelWithAnchor {
    protected final Project myProject;
    protected final BCH myConfigHelper;
    private JComponent myAnchor;
    private JBLabel myTargetLabel;
    protected JComboBox myTargetCombo;
    protected CidrRunConfigurationBuildConfigurationEditor myConfigurationEditor;
    protected CommonProgramParametersPanel myCommonProgramParameters;

    public CidrRunConfigurationSettingsEditor(@NotNull Project project, @NotNull BCH configHelper) {
        if (project == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(0);
        }
        if (configHelper == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myConfigHelper = configHelper;
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBag g = new GridBag().setDefaultFill(1).setDefaultAnchor(10).setDefaultWeightX(1, 1.0).setDefaultInsets(0, (Insets)JBUI.insets((int)0, (int)0, (int)4, (int)10)).setDefaultInsets(1, (Insets)JBUI.insetsBottom((int)4));
        this.createEditorInner(panel, g);
        this.setAnchor(this.myCommonProgramParameters.getAnchor());
        JPanel jPanel = panel;
        if (jPanel == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NlsContexts.Label
    @NotNull
    protected String getTargetComboTitle() {
        String string = this.myConfigHelper.getTargetTitle();
        if (string == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected void createEditorInner(JPanel panel, GridBag g) {
        this.setupTargetCombo(panel, g);
        this.setupConfigurationCombo(panel, g);
        this.createAdditionalControls(panel, g);
        this.setupCommonProgramParametersPanel(panel, g);
    }

    protected void setupTargetCombo(@NotNull JPanel panel, @NotNull GridBag g) {
        if (panel == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(4);
        }
        if (g == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(5);
        }
        this.myTargetLabel = new JBLabel(this.getTargetComboTitle() + ":");
        panel.add((Component)this.myTargetLabel, g.nextLine().next());
        ComboBoxComponent container = this.createTargetComboBox();
        JComponent component = container.component;
        panel.add((Component)component, g.next().coverLine());
        this.myTargetCombo = container.comboBox;
        ComboboxSpeedSearch.installOn((JComboBox)this.myTargetCombo);
        this.myTargetLabel.setLabelFor((Component)component);
        this.myTargetCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2 && CidrRunConfigurationSettingsEditor.this.myTargetCombo.getItemCount() > 0) {
                    return;
                }
                CidrBuildTarget target = e.getStateChange() == 1 ? (CidrBuildTarget)ComboBoxModelKt.getItemValue((ItemEvent)e) : null;
                CidrRunConfigurationSettingsEditor.this.onTargetSelected(target);
            }
        });
        this.resetTargets();
        this.myTargetCombo.setRenderer(CidrRunConfigurationEditorUtil.getTargetsRenderer(this.myConfigHelper));
    }

    protected void setupConfigurationCombo(@NotNull JPanel panel, @NotNull GridBag g) {
        if (panel == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(6);
        }
        if (g == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(7);
        }
        this.myConfigurationEditor = CidrRunConfigurationBuildConfigurationEditor.getInstance(this.myConfigHelper, this.myTargetCombo);
        this.myConfigurationEditor.createAdditionalControls(panel, g);
    }

    protected void setupCommonProgramParametersPanel(@NotNull JPanel panel, @NotNull GridBag g) {
        if (panel == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(8);
        }
        if (g == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(9);
        }
        this.myCommonProgramParameters = this.createProgramParametersPanel();
        panel.add((Component)this.myCommonProgramParameters, g.nextLine().weighty(1.0).insets(8, -1, 8, -1).coverLine());
    }

    @NotNull
    protected CommonProgramParametersPanel createProgramParametersPanel() {
        return new CommonProgramParametersPanel();
    }

    protected void resetTargets() {
        ComboBoxModel oldModel = this.myTargetCombo.getModel();
        Object oldSelected = oldModel.getSelectedItem();
        SortedCollectionComboBoxModel model = new SortedCollectionComboBoxModel(ComparisonsKt.compareBy((Function1[])new Function1[]{it -> {
            if (it == null) {
                return Integer.valueOf(0);
            }
            if (it instanceof CidrBuildTarget) {
                return Integer.valueOf(4);
            }
            return Integer.valueOf(10);
        }}));
        model.addAll(this.getTargets());
        this.myTargetCombo.setModel(model);
        this.myTargetCombo.setSelectedItem(null);
        if (oldSelected != null) {
            BuildTargetData oldTargetData = CidrRunConfigurationSettingsEditor.itemToTargetData(oldSelected);
            Object toSelect = model.contains(oldSelected) ? oldSelected : ReadAction.compute(() -> this.myConfigHelper.findTarget(oldTargetData));
            CidrRunConfigurationEditorUtil.setSelectedItem(this.myTargetCombo, toSelect, oldTargetData);
        }
    }

    @Nullable
    private static BuildTargetData itemToTargetData(@Nullable Object item) {
        if (item instanceof BuildTargetData) {
            return (BuildTargetData)item;
        }
        if (item instanceof CidrBuildTarget) {
            return new BuildTargetData((CidrBuildTarget)item);
        }
        if (item instanceof InvalidItem) {
            return (BuildTargetData)((InvalidItem)item).getValue();
        }
        return null;
    }

    @NotNull
    protected @Unmodifiable List<TARGET> getTargets() {
        List list = this.myConfigHelper.getTargets();
        if (list == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(10);
        }
        return list;
    }

    protected void createAdditionalControls(JPanel panel, GridBag g) {
    }

    protected void onTargetSelected(@Nullable TARGET target) {
    }

    protected void resetEditorFrom(@NotNull CONFIGURATION runConfiguration) {
        if (runConfiguration == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(11);
        }
        this.resetBuildAndConfigurationFrom(runConfiguration);
        this.myCommonProgramParameters.reset(runConfiguration);
    }

    protected void resetBuildAndConfigurationFrom(@NotNull CONFIGURATION runConfiguration) {
        BuildTargetAndConfigurationData buildData;
        if (runConfiguration == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(12);
        }
        BuildTargetData buildTargetData = (buildData = runConfiguration.getTargetAndConfigurationData()) == null ? null : buildData.target;
        ReadAction.run(() -> {
            CidrBuildTarget buildTarget = this.myConfigHelper.findTarget(buildTargetData);
            CidrBuildConfiguration buildConfig = this.myConfigHelper.findConfiguration(buildTarget, buildData == null ? null : buildData.configurationName);
            CidrRunConfigurationEditorUtil.setSelectedItem(this.myTargetCombo, buildTarget, buildTargetData);
            this.myConfigurationEditor.selectConfiguration(buildConfig, buildData == null ? null : buildData.configurationName);
        });
    }

    protected void applyEditorTo(@NotNull CONFIGURATION runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(13);
        }
        this.applyBuildAndConfigurationTo(runConfiguration);
        this.myCommonProgramParameters.applyTo(runConfiguration);
    }

    @Nullable
    public BuildTargetData getSelectedBuildTargetData() {
        CidrBuildTarget selectedBuildTarget = (CidrBuildTarget)ComboBoxModelKt.getSelectedItemValue((JComboBox)this.myTargetCombo);
        return selectedBuildTarget != null ? new BuildTargetData(selectedBuildTarget) : (BuildTargetData)ComboBoxModelKt.getSelectedInvalidItemValue((JComboBox)this.myTargetCombo);
    }

    protected void applyBuildAndConfigurationTo(@NotNull CONFIGURATION runConfiguration) {
        if (runConfiguration == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(14);
        }
        BuildTargetData selectedBuildTargetData = this.getSelectedBuildTargetData();
        String selectedConfigurationName = this.myConfigurationEditor.getSelectedConfiguration();
        runConfiguration.setTargetAndConfigurationData(new BuildTargetAndConfigurationData(selectedBuildTargetData, selectedConfigurationName));
        this.syncBuildAndExecute(runConfiguration, selectedBuildTargetData);
    }

    protected void syncBuildAndExecute(@NotNull CONFIGURATION configuration, @Nullable BuildTargetData buildTargetData) {
        if (configuration == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(15);
        }
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myCommonProgramParameters.setAnchor(anchor);
        this.myTargetLabel.setAnchor(anchor);
    }

    @NotNull
    protected ComboBoxComponent createTargetComboBox() {
        return new ComboBoxComponent((JComboBox)((Object)CidrRunConfigurationEditorUtil.createCombo()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configHelper";
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrRunConfigurationSettingsEditor";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrRunConfigurationSettingsEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetComboTitle";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupTargetCombo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationCombo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setupCommonProgramParametersPanel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resetBuildAndConfigurationFrom";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyBuildAndConfigurationTo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "syncBuildAndExecute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 10 -> new IllegalStateException(string);
        };
    }

    protected static class ComboBoxComponent {
        @NotNull
        public final JComboBox comboBox;
        @NotNull
        public final JComponent component;

        public ComboBoxComponent(JComboBox comboBox) {
            this(comboBox, comboBox);
        }

        public ComboBoxComponent(@NotNull JComponent component, @NotNull JComboBox comboBox) {
            if (component == null) {
                ComboBoxComponent.$$$reportNull$$$0(0);
            }
            if (comboBox == null) {
                ComboBoxComponent.$$$reportNull$$$0(1);
            }
            this.comboBox = comboBox;
            this.component = component;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "comboBox";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/CidrRunConfigurationSettingsEditor$ComboBoxComponent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

