/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.TerminalExecutionConsole;
import com.jetbrains.cidr.execution.CidrPathWithOffsetConsoleFilter;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrConsoleBuilder
extends TextConsoleBuilderImpl {
    @NotNull
    private final Project myProject;
    private final boolean myEmulateTerminal;

    public CidrConsoleBuilder(@NotNull Project project, @Nullable CidrToolEnvironment environment, @Nullable Path baseDir) {
        if (project == null) {
            CidrConsoleBuilder.$$$reportNull$$$0(0);
        }
        this(project, environment, baseDir, false);
    }

    public CidrConsoleBuilder(@NotNull Project project, @Nullable CidrToolEnvironment environment, @Nullable Path baseDir, boolean emulateTerminal) {
        if (project == null) {
            CidrConsoleBuilder.$$$reportNull$$$0(1);
        }
        super(project);
        this.myProject = project;
        this.myEmulateTerminal = emulateTerminal;
        this.addFilter(new CidrPathWithOffsetConsoleFilter(project, environment, baseDir));
    }

    @NotNull
    protected ConsoleView createConsole() {
        if (this.myEmulateTerminal) {
            return new TerminalExecutionConsole(this.myProject, null);
        }
        ConsoleView consoleView = super.createConsole();
        if (consoleView == null) {
            CidrConsoleBuilder.$$$reportNull$$$0(2);
        }
        return consoleView;
    }

    @NotNull
    public ConsoleView createConsole(@NotNull ConfigurationType type, @NotNull SMTRunnerConsoleProperties consoleProperties) {
        if (type == null) {
            CidrConsoleBuilder.$$$reportNull$$$0(3);
        }
        if (consoleProperties == null) {
            CidrConsoleBuilder.$$$reportNull$$$0(4);
        }
        SMTRunnerConsoleView console = (SMTRunnerConsoleView)SMTestRunnerConnectionUtil.createConsole((String)type.getId(), (TestConsoleProperties)consoleProperties);
        Disposer.register((Disposable)this.getProject(), (Disposable)console);
        Objects.requireNonNull(console.getResultsViewer().getTreeView()).getSelectionModel().setSelectionMode(4);
        SMTRunnerConsoleView sMTRunnerConsoleView = console;
        if (sMTRunnerConsoleView == null) {
            CidrConsoleBuilder.$$$reportNull$$$0(5);
        }
        return sMTRunnerConsoleView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrConsoleBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrConsoleBuilder";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

