/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.jetbrains.cidr.execution.CidrProgramParameters;
import java.nio.charset.Charset;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CidrCommandLineConfigurator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final CidrProgramParameters myAppParameters;

    public CidrCommandLineConfigurator(@NotNull Project project, @NotNull CidrProgramParameters appParameters) {
        if (project == null) {
            CidrCommandLineConfigurator.$$$reportNull$$$0(0);
        }
        if (appParameters == null) {
            CidrCommandLineConfigurator.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myAppParameters = appParameters;
    }

    public void configureCommandLine(@NotNull GeneralCommandLine cl) throws ExecutionException {
        if (cl == null) {
            CidrCommandLineConfigurator.$$$reportNull$$$0(2);
        }
        Charset charset = EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset();
        cl.setCharset(charset);
        cl.setWorkDirectory(CidrProgramParameters.pathToFile(this.myAppParameters.getWorkingDirectory()));
        cl.getParametersList().addAll(this.myAppParameters.getProgramParametersList().getList());
        Map env = cl.getEnvironment();
        env.putAll(this.myAppParameters.getEnv());
        if (SystemInfo.isMac) {
            env.putIfAbsent("NSUnbufferedIO", "YES");
        }
        cl.withParentEnvironmentType(this.myAppParameters.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        cl.withInput(CidrProgramParameters.pathToFile(this.myAppParameters.getRedirectInputPath()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appParameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/CidrCommandLineConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "configureCommandLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

