# -*- coding: utf-8 -*-

# This file is part of the Calibre-Web (https://github.com/janeczku/calibre-web)
#   Copyright (C) 2019 OzzieIsaacs, pwr
# Licensed under GLPv3. See the project's LICENSE file for details.

# pylint: disable=too-many-lines,bad-continuation

# This file is autogenerated, do NOT add, change, or delete ANY string
# If you need help or assistance for adding a new language, please contact the project team  

# map iso639 language codes to language names, translated

LANGUAGE_NAMES = {
    "ar": {
        "abk": "Abkhazian",
        "ace": "Achinese",
        "ach": "Acoli",
        "ada": "Adangme",
        "ady": "Adyghe",
        "aar": "Afar",
        "afh": "Afrihili",
        "afr": "الأفريكانس",
        "ain": "Ainu (Japan)",
        "aka": "Akan",
        "akk": "Akkadian",
        "sqi": "Albanian",
        "ale": "Aleut",
        "amh": "Amharic",
        "anp": "Angika",
        "ara": "العربية",
        "arg": "Aragonese",
        "arp": "Arapaho",
        "arw": "Arawak",
        "hye": "الأرمينية",
        "asm": "Assamese",
        "ast": "Asturian",
        "ava": "Avaric",
        "ave": "Avestan",
        "awa": "Awadhi",
        "aym": "Aymara",
        "aze": "الأذربيجانية",
        "ban": "البالية",
        "bal": "Baluchi",
        "bam": "Bambara",
        "bas": "Basa (Cameroon)",
        "bak": "Bashkir",
        "eus": "الباسك",
        "bej": "Beja",
        "bel": "بلاروسي",
        "bem": "Bemba (Zambia)",
        "ben": "البنغالية",
        "bit": "Berinomo",
        "bho": "Bhojpuri",
        "bik": "Bikol",
        "byn": "Bilin",
        "bin": "Bini",
        "bis": "Bislama",
        "zbl": "Blissymbols",
        "bos": "Bosnian",
        "bra": "Braj",
        "bre": "البريتون",
        "bug": "البجينيز",
        "bul": "البلغارية",
        "bua": "Buriat",
        "mya": "البورمية",
        "cad": "Caddo",
        "cat": "الكاتالانية",
        "ceb": "Cebuano",
        "chg": "Chagatai",
        "cha": "Chamorro",
        "che": "Chechen",
        "chr": "الشيروكى",
        "chy": "Cheyenne",
        "chb": "Chibcha",
        "zho": "الصينية",
        "chn": "Chinook jargon",
        "chp": "Chipewyan",
        "cho": "Choctaw",
        "cht": "Cholón",
        "chk": "Chuukese",
        "chv": "Chuvash",
        "cop": "القبطية",
        "cor": "Cornish",
        "cos": "Corsican",
        "cre": "Cree",
        "mus": "Creek",
        "hrv": "الكرواتية",
        "ces": "التشيكية",
        "dak": "Dakota",
        "dan": "الدنماركية",
        "dar": "Dargwa",
        "del": "Delaware",
        "div": "Dhivehi",
        "din": "Dinka",
        "doi": "Dogri (macrolanguage)",
        "dgr": "Dogrib",
        "dua": "Duala",
        "nld": "الهولندية",
        "dse": "Dutch Sign Language",
        "dyu": "Dyula",
        "dzo": "الزونخاية",
        "efi": "Efik",
        "egy": "Egyptian (Ancient)",
        "eka": "Ekajuk",
        "elx": "Elamite",
        "eng": "الإنجليزية",
        "enu": "Enu",
        "myv": "Erzya",
        "epo": "الإسبرانتو",
        "est": "الإستونية",
        "ewe": "Ewe",
        "ewo": "Ewondo",
        "fan": "Fang (Equatorial Guinea)",
        "fat": "Fanti",
        "fao": "Faroese",
        "fij": "Fijian",
        "fil": "Filipino",
        "fin": "الفنلندية",
        "fon": "Fon",
        "fra": "الفرنسية",
        "fur": "Friulian",
        "ful": "Fulah",
        "gaa": "Ga",
        "glg": "Galician",
        "lug": "Ganda",
        "gay": "Gayo",
        "gba": "Gbaya (Central African Republic)",
        "hmj": "Ge",
        "gez": "Geez",
        "kat": "Georgian",
        "deu": "الألمانية",
        "gil": "Gilbertese",
        "gon": "Gondi",
        "gor": "Gorontalo",
        "got": "القوطية",
        "grb": "Grebo",
        "grn": "Guarani",
        "guj": "الغوجاراتية",
        "gwi": "Gwichʼin",
        "hai": "Haida",
        "hau": "Hausa",
        "haw": "Hawaiian",
        "heb": "العبرية",
        "her": "Herero",
        "hil": "Hiligaynon",
        "hin": "الهندية",
        "hmo": "Hiri Motu",
        "hit": "Hittite",
        "hmn": "Hmong",
        "hun": "الهنغارية (المجرية)",
        "hup": "Hupa",
        "iba": "Iban",
        "isl": "الآيسلندية",
        "ido": "Ido",
        "ibo": "Igbo",
        "ilo": "Iloko",
        "ind": "الإندونيسية",
        "inh": "Ingush",
        "ina": "Interlingua (International Auxiliary Language Association)",
        "ile": "Interlingue",
        "iku": "Inuktitut",
        "ipk": "Inupiaq",
        "gle": "الأيرلندية",
        "ita": "الإيطالية",
        "jpn": "اليابانية",
        "jav": "الجاوية",
        "jrb": "Judeo-Arabic",
        "jpr": "Judeo-Persian",
        "kbd": "Kabardian",
        "kab": "Kabyle",
        "kac": "Kachin",
        "kal": "Kalaallisut",
        "xal": "Kalmyk",
        "kam": "Kamba (Kenya)",
        "kan": "الكانادا",
        "kau": "Kanuri",
        "kaa": "Kara-Kalpak",
        "krc": "Karachay-Balkar",
        "krl": "Karelian",
        "kas": "Kashmiri",
        "csb": "Kashubian",
        "kaw": "Kawi",
        "kaz": "Kazakh",
        "kha": "Khasi",
        "kho": "Khotanese",
        "kik": "Kikuyu",
        "kmb": "Kimbundu",
        "kin": "Kinyarwanda",
        "kir": "Kirghiz",
        "tlh": "Klingon",
        "kom": "Komi",
        "kon": "Kongo",
        "kok": "Konkani (macrolanguage)",
        "kor": "الكورية",
        "kos": "Kosraean",
        "kpe": "Kpelle",
        "kua": "Kuanyama",
        "kum": "Kumyk",
        "kur": "الكردية",
        "kru": "Kurukh",
        "kut": "Kutenai",
        "lad": "Ladino",
        "lah": "Lahnda",
        "lam": "Lamba",
        "lao": "اللاو",
        "lat": "Latin",
        "lav": "اللاتفية",
        "lez": "Lezghian",
        "lim": "Limburgan",
        "lin": "Lingala",
        "lit": "الليتوانية",
        "jbo": "Lojban",
        "loz": "Lozi",
        "lub": "Luba-Katanga",
        "lua": "Luba-Lulua",
        "lui": "Luiseno",
        "smj": "Lule Sami",
        "lun": "Lunda",
        "luo": "Luo (Kenya and Tanzania)",
        "lus": "Lushai",
        "ltz": "Luxembourgish",
        "mkd": "المقدونية",
        "mad": "Madurese",
        "mag": "Magahi",
        "mai": "Maithili",
        "mak": "Makasar",
        "mlg": "Malagasy",
        "msa": "Malay (macrolanguage)",
        "mal": "الماليالام",
        "mlt": "المالطية",
        "mnc": "Manchu",
        "mdr": "Mandar",
        "man": "Mandingo",
        "mni": "Manipuri",
        "glv": "Manx",
        "mri": "الموري",
        "arn": "Mapudungun",
        "mar": "Marathi",
        "chm": "Mari (Russia)",
        "mah": "Marshallese",
        "mwr": "Marwari",
        "mas": "Masai",
        "men": "Mende (Sierra Leone)",
        "mic": "Mi'kmaq",
        "min": "Minangkabau",
        "mwl": "Mirandese",
        "moh": "Mohawk",
        "mdf": "Moksha",
        "lol": "Mongo",
        "mon": "المغولية",
        "mos": "Mossi",
        "mul": "Multiple languages",
        "nqo": "N'Ko",
        "nau": "Nauru",
        "nav": "Navajo",
        "ndo": "Ndonga",
        "nap": "Neapolitan",
        "nia": "Nias",
        "niu": "Niuean",
        "zxx": "No linguistic content",
        "nog": "Nogai",
        "nor": "النرويجية",
        "nob": "Norwegian Bokmål",
        "nno": "Norwegian Nynorsk",
        "nym": "Nyamwezi",
        "nya": "Nyanja",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Occitan (post 1500)",
        "oji": "Ojibwa",
        "orm": "Oromo",
        "osa": "Osage",
        "oss": "Ossetian",
        "pal": "Pahlavi",
        "pau": "Palauan",
        "pli": "Pali",
        "pam": "Pampanga",
        "pag": "Pangasinan",
        "pan": "Panjabi",
        "pap": "Papiamento",
        "fas": "الفارسي",
        "phn": "الفينيقية",
        "pon": "Pohnpeian",
        "pol": "البولندية",
        "por": "البرتغالية",
        "pus": "Pashto",
        "que": "Quechua",
        "raj": "Rajasthani",
        "rap": "Rapanui",
        "ron": "الرومانية",
        "roh": "Romansh",
        "rom": "Romany",
        "run": "Rundi",
        "rus": "الروسية",
        "smo": "Samoan",
        "sad": "Sandawe",
        "sag": "Sango",
        "san": "Sanskrit",
        "sat": "Santali",
        "srd": "Sardinian",
        "sas": "Sasak",
        "sco": "Scots",
        "sel": "Selkup",
        "srp": "الصربية",
        "srr": "Serer",
        "shn": "Shan",
        "sna": "Shona",
        "scn": "Sicilian",
        "sid": "Sidamo",
        "bla": "Siksika",
        "snd": "Sindhi",
        "sin": "السينهالا",
        "den": "Slave (Athapascan)",
        "slk": "السلوفاكية",
        "slv": "السلوفينية",
        "sog": "Sogdian",
        "som": "Somali",
        "snk": "Soninke",
        "spa": "الأسبانية",
        "srn": "Sranan Tongo",
        "suk": "Sukuma",
        "sux": "Sumerian",
        "sun": "السوندية",
        "sus": "Susu",
        "swa": "Swahili (macrolanguage)",
        "ssw": "Swati",
        "swe": "السويدية",
        "syr": "السريانية",
        "tgl": "التاغالوغية",
        "tah": "Tahitian",
        "tgk": "Tajik",
        "tmh": "Tamashek",
        "tam": "التاميلية",
        "tat": "Tatar",
        "tel": "التيلوغو",
        "ter": "Tereno",
        "tet": "Tetum",
        "tha": "التايلاندية",
        "bod": "التبتية",
        "tig": "Tigre",
        "tir": "Tigrinya",
        "tem": "Timne",
        "tiv": "Tiv",
        "tli": "Tlingit",
        "tpi": "Tok Pisin",
        "tkl": "Tokelau",
        "tog": "Tonga (Nyasa)",
        "ton": "Tonga (Tonga Islands)",
        "tsi": "Tsimshian",
        "tso": "Tsonga",
        "tsn": "Tswana",
        "tum": "Tumbuka",
        "tur": "التركية",
        "tuk": "Turkmen",
        "tvl": "Tuvalu",
        "tyv": "Tuvinian",
        "twi": "Twi",
        "udm": "Udmurt",
        "uga": "الأجاريتيكية",
        "uig": "الاغورية",
        "ukr": "Ukrainian",
        "umb": "Umbundu",
        "mis": "Uncoded languages",
        "und": "Undetermined",
        "urd": "الاردية",
        "uzb": "Uzbek",
        "vai": "الفاي",
        "ven": "Venda",
        "vie": "الفييتنامية",
        "vol": "Volapük",
        "vot": "Votic",
        "wln": "الوالون",
        "war": "Waray (Philippines)",
        "was": "Washo",
        "cym": "الويلزية",
        "wal": "Wolaytta",
        "wol": "Wolof",
        "xho": "الهاوسا",
        "sah": "Yakut",
        "yao": "Yao",
        "yap": "Yapese",
        "yid": "Yiddish",
        "yor": "Yoruba",
        "zap": "Zapotec",
        "zza": "Zaza",
        "zen": "Zenaga",
        "zha": "Zhuang",
        "zul": "الزولو",
        "zun": "Zuni"
    },
    "cs": {
        "aar": "afarština",
        "abk": "abchazajština",
        "ace": "atěžština",
        "ach": "ačoli (luoština)",
        "ada": "adangmeština",
        "ady": "adyghe",
        "afh": "afrihilijština",
        "afr": "afrikánština",
        "ain": "ainu (Japonsko)",
        "aka": "akanština",
        "akk": "akkadština",
        "ale": "aleutština",
        "alt": "altajština; jižní",
        "amh": "Amharština",
        "ang": "Angličtina; stará (asi 450-1100)",
        "anp": "angika",
        "ara": "arabština",
        "arc": "aramejština; oficiální (700-300 př. n. l.)",
        "arg": "aragonská španělština",
        "arn": "mapudungun",
        "arp": "arapaho",
        "arw": "arawacké jazyky",
        "asm": "ásámština",
        "ast": "asturština",
        "ava": "avarština",
        "ave": "avestština",
        "awa": "avadhština (avadhí)",
        "aym": "aymarština",
        "aze": "azerbajdžánština",
        "bak": "Baskirština",
        "bal": "balúčština",
        "bam": "bambarština",
        "ban": "balijština",
        "bas": "basa (Kamerun)",
        "bej": "bedža",
        "bel": "běloruština",
        "bem": "bemba (Zambie)",
        "ben": "bengálština",
        "bho": "bhódžpurština",
        "bik": "bikolština",
        "bin": "bini",
        "bis": "bislamština",
        "bit": "berinomo",
        "bla": "siksika",
        "bod": "tibetština",
        "bos": "bosenština",
        "bra": "bradžština",
        "bre": "bretonština",
        "bua": "burjatština",
        "bug": "bugiština",
        "bul": "bulharština",
        "byn": "bilin",
        "cad": "caddo",
        "car": "carib; Galibi",
        "cat": "katalánština",
        "ceb": "cebuánština",
        "ces": "Čeština",
        "cha": "čamoro",
        "chb": "čibča",
        "che": "čečenština",
        "chg": "Chagatai",
        "chk": "čukčtina",
        "chm": "Mari (Russia)",
        "chn": "činuk pidžin",
        "cho": "choctawština",
        "chp": "čipeva",
        "chr": "čerokézština",
        "cht": "Cholón",
        "chu": "Slavonic; Old",
        "chv": "čuvaština",
        "chy": "čejenština",
        "cop": "koptština",
        "cor": "kornština",
        "cos": "korsičtina",
        "cre": "krí",
        "crh": "Turkish; Crimean",
        "csb": "kašubština",
        "cym": "velština",
        "dak": "dakotština",
        "dan": "dánština",
        "dar": "dargwa",
        "del": "delawarština",
        "den": "atabaské jazyky",
        "deu": "Němčina",
        "dgr": "dogrib",
        "din": "dinkština",
        "div": "Dhivehi",
        "doi": "Dogri (macrolanguage)",
        "dsb": "Sorbian; Lower",
        "dse": "holandský znakový jazyk",
        "dua": "dualština",
        "dum": "Dutch; Middle (ca. 1050-1350)",
        "dyu": "djula",
        "dzo": "Bhútánština",
        "efi": "efik",
        "egy": "egyptština (starověká)",
        "eka": "ekajuk",
        "ell": "řečtina; moderní (1453-)",
        "elx": "elamština",
        "eng": "Angličtina",
        "enm": "Angličtina; středověká (1100-1500)",
        "enu": "Enu",
        "epo": "esperanto",
        "est": "estonština",
        "eus": "baskičtina",
        "ewe": "eweština",
        "ewo": "ewondo",
        "fan": "Fang (Equatorial Guinea)",
        "fao": "faerština",
        "fas": "perština",
        "fat": "fantiština",
        "fij": "Fidži",
        "fil": "Filipino",
        "fin": "finština",
        "fon": "fonština",
        "fra": "francouzština",
        "frm": "French; Middle (ca. 1400-1600)",
        "fro": "French; Old (842-ca. 1400)",
        "frr": "Frisian; Northern",
        "frs": "Frisian; Eastern",
        "fry": "Frisian; Western",
        "ful": "fulahština",
        "fur": "furlanština",
        "gaa": "ga",
        "gay": "gayo",
        "gba": "Gbaya (Central African Republic)",
        "gez": "etiopština",
        "gil": "kiribatština",
        "gla": "Gaelic; Scottish",
        "gle": "irština",
        "glg": "Galician",
        "glv": "manština",
        "gmh": "German; Middle High (ca. 1050-1500)",
        "goh": "German; Old High (ca. 750-1050)",
        "gon": "góndština",
        "gor": "gorontalo",
        "got": "gótština",
        "grb": "grebo",
        "grc": "řečtina; starověká (do 1453)",
        "grn": "Guaranština",
        "gsw": "German; Swiss",
        "guj": "Gudžarátština",
        "gwi": "Gwichʼin",
        "hai": "haida",
        "hat": "Creole; Haitian",
        "hau": "Hausa",
        "haw": "havajština",
        "heb": "hebrejština",
        "her": "herero",
        "hil": "hiligayonština",
        "hin": "hindština",
        "hit": "chetitština",
        "hmj": "Ge",
        "hmn": "hmongština",
        "hmo": "hiri motu",
        "hrv": "chorvatština",
        "hsb": "Sorbian; Upper",
        "hun": "maďarština",
        "hup": "hupa",
        "hye": "arménština",
        "iba": "iban",
        "ibo": "igbo",
        "ido": "ido",
        "iii": "Yi; Sichuan",
        "iku": "Inuktitutština",
        "ile": "Interlingue",
        "ilo": "ilokánština",
        "ina": "Interlingua (Mezinárodní pomocná jazyková asociace)",
        "ind": "indonézština",
        "inh": "inguština",
        "ipk": "Inupiakština",
        "isl": "islandština",
        "ita": "italština",
        "jav": "jávština",
        "jbo": "lojban",
        "jpn": "japonština",
        "jpr": "judeo-perština",
        "jrb": "judeo-arabština",
        "kaa": "karakalpačtina",
        "kab": "kabulí",
        "kac": "kačjinština",
        "kal": "Kalaallisut",
        "kam": "Kamba (Kenya)",
        "kan": "Kannadština",
        "kas": "kašmírština",
        "kat": "Gruzínština",
        "kau": "kanuri",
        "kaw": "kawi",
        "kaz": "Kazachština",
        "kbd": "kabardština",
        "kha": "Khasi",
        "khm": "Khmer; Central",
        "kho": "chotánština",
        "kik": "Kikuyu",
        "kin": "Kinyarwandština",
        "kir": "Kirgizština",
        "kmb": "kimbundština",
        "kok": "Konkani (macrolanguage)",
        "kom": "komijština",
        "kon": "Kongo",
        "kor": "korejština",
        "kos": "kosrajština",
        "kpe": "kpelle",
        "krc": "karachay-balkarština",
        "krl": "karelština",
        "kru": "kurukh",
        "kua": "Kuanyama",
        "kum": "kumyčtina",
        "kur": "kurdština",
        "kut": "kutenai",
        "lad": "ladino",
        "lah": "lahnda",
        "lam": "lambština",
        "lao": "Laoština",
        "lat": "latina",
        "lav": "Latvian",
        "lez": "lezgiština",
        "lim": "Limburgan",
        "lin": "Ngalština",
        "lit": "litevština",
        "lol": "mongština",
        "loz": "lozština",
        "ltz": "Luxembourgish",
        "lua": "luba-luluaština",
        "lub": "lubu-katanžština",
        "lug": "Ganda",
        "lui": "luiseňo",
        "lun": "lundština",
        "luo": "luoština (Keňa a Tanzanie)",
        "lus": "lušáí",
        "mad": "madurština",
        "mag": "magahština",
        "mah": "Marshallese",
        "mai": "maithilština",
        "mak": "makasarština",
        "mal": "Malabarština",
        "man": "mandingština",
        "mar": "maráthština",
        "mas": "masajština",
        "mdf": "moksha",
        "mdr": "mandarínština",
        "men": "Mende (Sierra Leone)",
        "mga": "irština; středověká (900-1200)",
        "mic": "Mi'kmaq",
        "min": "minangkabau",
        "mis": "Uncoded languages",
        "mkd": "makedonština",
        "mlg": "Malgaština",
        "mlt": "maltézština",
        "mnc": "manchu",
        "mni": "manipurština",
        "moh": "mohawk",
        "mon": "mongolština",
        "mos": "mosi",
        "mri": "maorština",
        "msa": "Malay (macrolanguage)",
        "mul": "násobné jazyky",
        "mus": "krík",
        "mwl": "mirandština",
        "mwr": "márvárština",
        "mya": "Barmština",
        "myv": "erzya",
        "nap": "neapolština",
        "nau": "naurština",
        "nav": "navažština",
        "nbl": "Ndebele; South",
        "nde": "Ndebele; North",
        "ndo": "ndondština",
        "nds": "German; Low",
        "nep": "nepálština",
        "new": "Bhasa; Nepal",
        "nia": "nias",
        "niu": "niue",
        "nld": "holandština",
        "nno": "Norwegian Nynorsk",
        "nob": "Norwegian Bokmål",
        "nog": "nogai",
        "non": "norština; stará",
        "nor": "norština",
        "nqo": "N'Ko",
        "nso": "Sotho; Northern",
        "nwc": "Newari; Old",
        "nya": "Nyanja",
        "nym": "ňamwežština",
        "nyn": "nyankolština",
        "nyo": "Nyoro",
        "nzi": "nzima",
        "oci": "Occitan (post 1500)",
        "oji": "Ojibwa",
        "ori": "orija",
        "orm": "Oromo (Afan)",
        "osa": "osagština",
        "oss": "Ossetian",
        "ota": "turečtina; osmanská (1500-1928)",
        "pag": "pangsinan",
        "pal": "pahlaví",
        "pam": "pampangau",
        "pan": "Panjabi",
        "pap": "papiamento",
        "pau": "palauština",
        "peo": "Persian; Old (ca. 600-400 B.C.)",
        "phn": "Slovinština",
        "pli": "páli",
        "pol": "Polština",
        "pon": "pohnpeiština",
        "por": "portugalština",
        "pro": "provensálština; stará (do 1500)",
        "pus": "pašto",
        "que": "kečuánština",
        "raj": "rádžasthánština",
        "rap": "rapanuiština",
        "rar": "Maori; Cook Islands",
        "roh": "Romansh",
        "rom": "římština",
        "ron": "rumunština",
        "run": "Kirundi",
        "rup": "Romanian; Macedo-",
        "rus": "Ruština",
        "sad": "sandawština",
        "sag": "sangoština",
        "sah": "jakutština",
        "sam": "Aramaic; Samaritan",
        "san": "sanskrt",
        "sas": "sačtina",
        "sat": "santálí",
        "scn": "sicilština",
        "sco": "skotština",
        "sel": "selkupština",
        "sga": "irština; stará (do 900)",
        "shn": "šanština",
        "sid": "sidamo",
        "sin": "Sinhálština",
        "slk": "Slovenština",
        "slv": "slovinština",
        "sma": "Sami; Southern",
        "sme": "Sami; Northern",
        "smj": "lule sami",
        "smn": "Sami; Inari",
        "smo": "Samoyština",
        "sms": "Sami; Skolt",
        "sna": "šonština",
        "snd": "sindhština",
        "snk": "sonikština",
        "sog": "sogdijština",
        "som": "somálština",
        "sot": "sotština; jižní",
        "spa": "španělština",
        "sqi": "albánština",
        "srd": "sardinština",
        "srn": "Sranan Tongo",
        "srp": "srbština",
        "srr": "Serer",
        "ssw": "Siswatština",
        "suk": "sukuma",
        "sun": "Sundanština",
        "sus": "susu",
        "sux": "sumerština",
        "swa": "svahilština (makrojazyk)",
        "swe": "švédština",
        "syc": "Syriac; Classical",
        "syr": "syrština",
        "tah": "tahitština",
        "tam": "Tamilština",
        "tat": "tatarština",
        "tel": "Telugu",
        "tem": "temne",
        "ter": "tereno",
        "tet": "tetumština",
        "tgk": "Tádžičtina",
        "tgl": "Tagalog",
        "tha": "thajština",
        "tig": "tigrejština",
        "tir": "Tigrinijština",
        "tiv": "tivština",
        "tkl": "tokelauština",
        "tlh": "Klingon",
        "tli": "tlingit",
        "tmh": "Tamashek",
        "tog": "tongština (nyasa)",
        "ton": "Tonga",
        "tpi": "tok pisin",
        "tsi": "tsimshijské jazyky",
        "tsn": "Setswanština",
        "tso": "Tsonga",
        "tuk": "turkmenistánština",
        "tum": "tumbukština",
        "tur": "turečtina",
        "tvl": "tuvalština",
        "twi": "ťwiština",
        "tyv": "tuvština",
        "udm": "udmurtština",
        "uga": "ugaritština",
        "uig": "Uighurština",
        "ukr": "ukrajinština",
        "umb": "umbundu",
        "und": "neurčitý",
        "urd": "urdština",
        "uzb": "uzbekistánština",
        "vai": "vai",
        "ven": "vendština",
        "vie": "vietnamština",
        "vol": "volapük",
        "vot": "votiatština",
        "wal": "Wolaytta",
        "war": "Waray (Philippines)",
        "was": "washo",
        "wln": "valonština",
        "wol": "volofština",
        "xal": "Kalmyk",
        "xho": "xhoština",
        "yao": "jaoština",
        "yap": "japština",
        "yid": "Jidiš",
        "yor": "jorubština",
        "zap": "Zapotec",
        "zbl": "Blissymbols",
        "zen": "zenaga",
        "zha": "Zhuang",
        "zho": "čínština",
        "zul": "Zulu",
        "zun": "zunijština",
        "zxx": "bez lingvistického obsahu",
        "zza": "zaza"
    },
    "de": {
        "aar": "Danakil-Sprache",
        "abk": "Abchasisch",
        "ace": "Aceh-Sprache",
        "ach": "Acholi-Sprache",
        "ada": "Adangme-Sprache",
        "ady": "Adygisch",
        "afh": "Afrihili",
        "afr": "Afrikaans",
        "ain": "Ainu-Sprache (Japan)",
        "aka": "Akan-Sprache",
        "akk": "Akkadisch",
        "ale": "Aleutisch",
        "alt": "Altaisch; Süd",
        "amh": "Amharisch",
        "ang": "Englisch; Alt (ca. 450-1100)",
        "anp": "Anga-Sprache",
        "ara": "Arabisch",
        "arc": "Aramäisch",
        "arg": "Aragonesisch",
        "arn": "Mapudungun",
        "arp": "Arapaho",
        "arw": "Arawakisch",
        "asm": "Assamesisch",
        "ast": "Asturisch",
        "ava": "Awarisch",
        "ave": "Avestisch",
        "awa": "Awadhi",
        "aym": "Aymara",
        "aze": "Aserbaidschanisch",
        "bak": "Baschkirisch",
        "bal": "Belutschisch",
        "bam": "Bambara",
        "ban": "Balinesisch",
        "bas": "Basa (Kamerun)",
        "bej": "Bedja (Bedauye)",
        "bel": "Weißrussisch",
        "bem": "Bemba (Sambia)",
        "ben": "Bengalisch",
        "bho": "Bhojpuri",
        "bik": "Bikol",
        "bin": "Bini",
        "bis": "Bislama",
        "bit": "Berinomo",
        "bla": "Blackfoot",
        "bod": "Tibetisch",
        "bos": "Bosnisch",
        "bra": "Braj-Bhakha",
        "bre": "Bretonisch",
        "bua": "Burjatisch",
        "bug": "Buginesisch",
        "bul": "Bulgarisch",
        "byn": "Bilin",
        "cad": "Caddo",
        "car": "Karibisch; Galíbi",
        "cat": "Katalanisch",
        "ceb": "Cebuano",
        "ces": "Tschechisch",
        "cha": "Chamorro",
        "chb": "Chibcha",
        "che": "Tschetschenisch",
        "chg": "Tschagataisch",
        "chk": "Trukesisch",
        "chm": "Mari (Russland)",
        "chn": "Chinook",
        "cho": "Choctaw",
        "chp": "Chipewyan",
        "chr": "Cherokee",
        "cht": "Cholón",
        "chu": "Altkirchenslawisch",
        "chv": "Tschuwaschisch",
        "chy": "Cheyenne",
        "cop": "Koptisch",
        "cor": "Kornisch",
        "cos": "Korsisch",
        "cre": "Cree",
        "crh": "Türkisch; Krimtatarisch",
        "csb": "Kaschubisch",
        "cym": "Walisisch",
        "dak": "Dakota",
        "dan": "Dänisch",
        "dar": "Darginisch",
        "del": "Delaware",
        "den": "Slave (Athapaskisch)",
        "deu": "Deutsch",
        "dgr": "Dogrib",
        "din": "Dinka",
        "div": "Dhivehi",
        "doi": "Dogri (Makrosprache)",
        "dsb": "Sorbisch; Nieder",
        "dse": "Niederländische Zeichensprache",
        "dua": "Duala",
        "dum": "Niederländisch; Mittel (ca. 1050-1350)",
        "dyu": "Dyula",
        "dzo": "Dzongkha",
        "efi": "Efik",
        "egy": "Ägyptisch (Historisch)",
        "eka": "Ekajuk",
        "ell": "Neugriechisch (ab 1453)",
        "elx": "Elamisch",
        "eng": "Englisch",
        "enm": "Mittelenglisch",
        "enu": "Enu",
        "epo": "Esperanto",
        "est": "Estnisch",
        "eus": "Baskisch",
        "ewe": "Ewe-Sprache",
        "ewo": "Ewondo",
        "fan": "Fang (Äquatorial-Guinea)",
        "fao": "Färöisch",
        "fas": "Persisch",
        "fat": "Fanti",
        "fij": "Fidschianisch",
        "fil": "Filipino",
        "fin": "Finnisch",
        "fon": "Fon",
        "fra": "Französisch",
        "frm": "Französisch; Mittel (ca. 1400 - 1600)",
        "fro": "Französisch; Alt (842 - ca. 1400)",
        "frr": "Friesisch; Nord",
        "frs": "Friesisch; Ost",
        "fry": "Friesisch; West",
        "ful": "Ful",
        "fur": "Friaulisch",
        "gaa": "Ga",
        "gay": "Gayo",
        "gba": "Gbaya (Zentralafrikanische Republik)",
        "gez": "Altäthiopisch",
        "gil": "Gilbertesisch",
        "gla": "Gälisch; Schottisch",
        "gle": "Irisch",
        "glg": "Galicisch",
        "glv": "Manx",
        "gmh": "Mittelhochdeutsch (ca. 1050-1500)",
        "goh": "Althochdeutsch (ca. 750-1050)",
        "gon": "Gondi",
        "gor": "Gorontalesisch",
        "got": "Gotisch",
        "grb": "Grebo",
        "grc": "Altgriechisch (bis 1453)",
        "grn": "Guaraní",
        "gsw": "Schweizerdeutsch",
        "guj": "Gujarati",
        "gwi": "Kutchin",
        "hai": "Haida",
        "hat": "Kreolisch; Haitisch",
        "hau": "Haussa",
        "haw": "Hawaiianisch",
        "heb": "Hebräisch",
        "her": "Herero",
        "hil": "Hiligaynon",
        "hin": "Hindi",
        "hit": "Hethitisch",
        "hmj": "Ge",
        "hmn": "Miao-Sprachen",
        "hmo": "Hiri-Motu",
        "hrv": "Kroatisch",
        "hsb": "Obersorbisch",
        "hun": "Ungarisch",
        "hup": "Hupa",
        "hye": "Armenisch",
        "iba": "Iban",
        "ibo": "Ibo",
        "ido": "Ido",
        "iii": "Yi; Sichuan",
        "iku": "Inuktitut",
        "ile": "Interlingue",
        "ilo": "Ilokano",
        "ina": "Interlingua (Internationale Hilfssprachen-Vereinigung)",
        "ind": "Indonesisch",
        "inh": "Inguschisch",
        "ipk": "Inupiaq",
        "isl": "Isländisch",
        "ita": "Italienisch",
        "jav": "Javanisch",
        "jbo": "Lojban",
        "jpn": "Japanisch",
        "jpr": "Jüdisch-Persisch",
        "jrb": "Jüdisch-Arabisch",
        "kaa": "Karakalpakisch",
        "kab": "Kabylisch",
        "kac": "Kachinisch",
        "kal": "Kalaallisut (Grönländisch)",
        "kam": "Kamba (Kenia)",
        "kan": "Kannada",
        "kas": "Kaschmirisch",
        "kat": "Georgisch",
        "kau": "Kanuri",
        "kaw": "Kawi; Altjavanisch",
        "kaz": "Kasachisch",
        "kbd": "Kabardisch",
        "kha": "Khasi-Sprache",
        "khm": "Khmer; Zentral",
        "kho": "Sakisch",
        "kik": "Kikuyu",
        "kin": "Rwanda",
        "kir": "Kirgisisch",
        "kmb": "Mbundu; Kimbundu",
        "kok": "Konkani (Makrosprache)",
        "kom": "Komi",
        "kon": "Kongo",
        "kor": "Koreanisch",
        "kos": "Kosraeanisch",
        "kpe": "Kpelle",
        "krc": "Karachay-Balkar",
        "krl": "Karenisch",
        "kru": "Kurukh",
        "kua": "Kwanyama",
        "kum": "Kumükisch",
        "kur": "Kurdisch",
        "kut": "Kutenai",
        "lad": "Judenspanisch",
        "lah": "Lahnda",
        "lam": "Banjari; Lamba",
        "lao": "Laotisch",
        "lat": "Lateinisch",
        "lav": "Lettisch",
        "lez": "Lesgisch",
        "lim": "Limburgisch",
        "lin": "Lingala",
        "lit": "Litauisch",
        "lol": "Mongo",
        "loz": "Rotse",
        "ltz": "Luxemburgisch",
        "lua": "Luba-Lulua",
        "lub": "Luba-Katanga",
        "lug": "Ganda",
        "lui": "Luiseno",
        "lun": "Lunda",
        "luo": "Luo (Kenia und Tansania)",
        "lus": "Lushai",
        "mad": "Maduresisch",
        "mag": "Khotta",
        "mah": "Marshallesisch",
        "mai": "Maithili",
        "mak": "Makassarisch",
        "mal": "Malayalam",
        "man": "Mande; Mandigo; Malinke",
        "mar": "Marathi",
        "mas": "Massai",
        "mdf": "Moksha",
        "mdr": "Mandaresisch",
        "men": "Mende (Sierra Leone)",
        "mga": "Mittelirisch (900-1200)",
        "mic": "Mikmak",
        "min": "Minangkabau",
        "mis": "Nichtklassifizierte Sprachen",
        "mkd": "Makedonisch",
        "mlg": "Madegassisch",
        "mlt": "Maltesisch",
        "mnc": "Manchu; Mandschurisch",
        "mni": "Meithei-Sprache",
        "moh": "Mohawk",
        "mon": "Mongolisch",
        "mos": "Mossi",
        "mri": "Maori",
        "msa": "Malaiisch (Makrosprache)",
        "mul": "Mehrsprachig; Polyglott",
        "mus": "Muskogee",
        "mwl": "Mirandesisch",
        "mwr": "Marwari",
        "mya": "Burmesisch",
        "myv": "Erzya",
        "nap": "Neapolitanisch",
        "nau": "Nauruanisch",
        "nav": "Navajo",
        "nbl": "Ndebele (Süd)",
        "nde": "Ndebele (Nord)",
        "ndo": "Ndonga",
        "nds": "Plattdeutsch",
        "nep": "Nepali",
        "new": "Bhasa; Nepalesisch",
        "nia": "Nias",
        "niu": "Niue",
        "nld": "Niederländisch",
        "nno": "Nynorsk (Norwegen)",
        "nob": "Norwegisch-Bokmål",
        "nog": "Nogai",
        "non": "Altnordisch",
        "nor": "Norwegisch",
        "nqo": "N'Ko",
        "nso": "Sotho; Nord",
        "nwc": "Newari; Alt",
        "nya": "Nyanja",
        "nym": "Nyamwezi",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Okzitanisch (nach 1500)",
        "oji": "Ojibwa",
        "ori": "Orija",
        "orm": "Oromo",
        "osa": "Osage",
        "oss": "Ossetisch",
        "ota": "Ottomanisch (Osmanisch/Türkisch) (1500-1928)",
        "pag": "Pangasinan",
        "pal": "Mittelpersisch",
        "pam": "Pampanggan",
        "pan": "Panjabi",
        "pap": "Papiamento",
        "pau": "Palau",
        "peo": "Persisch; Alt (ca. 600-400 v.Chr.)",
        "phn": "Phönikisch",
        "pli": "Pali",
        "pol": "Polnisch",
        "pon": "Ponapeanisch",
        "por": "Portugiesisch",
        "pro": "Altokzitanisch; Altprovenzalisch (bis 1500)",
        "pus": "Paschtu; Afghanisch",
        "que": "Ketschua",
        "raj": "Rajasthani",
        "rap": "Osterinsel-Sprache; Rapanui",
        "rar": "Maori; Cook-Inseln",
        "roh": "Bündnerromanisch",
        "rom": "Romani; Zigeunersprache",
        "ron": "Rumänisch",
        "run": "Rundi",
        "rup": "Rumänisch; Mezedonisch",
        "rus": "Russisch",
        "sad": "Sandawe",
        "sag": "Sango",
        "sah": "Jakutisch",
        "sam": "Aramäisch; Samaritanisch",
        "san": "Sanskrit",
        "sas": "Sassak",
        "sat": "Santali",
        "scn": "Sizilianisch",
        "sco": "Schottisch",
        "sel": "Selkupisch",
        "sga": "Altirisch (bis 900)",
        "shn": "Schan",
        "sid": "Sidamo",
        "sin": "Singhalesisch",
        "slk": "Slowakisch",
        "slv": "Slowenisch",
        "sma": "Sami; Süd",
        "sme": "Nordsamisch",
        "smj": "Samisch (Lule)",
        "smn": "Samisch; Inari",
        "smo": "Samoanisch",
        "sms": "Samisch; Skolt",
        "sna": "Schona",
        "snd": "Sindhi",
        "snk": "Soninke",
        "sog": "Sogdisch",
        "som": "Somali",
        "sot": "Sotho (Süd)",
        "spa": "Spanisch; Kastilianisch",
        "sqi": "Albanisch",
        "srd": "Sardisch",
        "srn": "Sranan Tongo",
        "srp": "Serbisch",
        "srr": "Serer",
        "ssw": "Swazi",
        "suk": "Sukuma",
        "sun": "Sundanesisch",
        "sus": "Susu",
        "sux": "Sumerisch",
        "swa": "Swahili (Makrosprache)",
        "swe": "Schwedisch",
        "syc": "Syrisch; Klassisch",
        "syr": "Syrisch",
        "tah": "Tahitisch",
        "tam": "Tamilisch",
        "tat": "Tatarisch",
        "tel": "Telugu",
        "tem": "Temne",
        "ter": "Tereno",
        "tet": "Tetum",
        "tgk": "Tadschikisch",
        "tgl": "Tagalog",
        "tha": "Thailändisch",
        "tig": "Tigre",
        "tir": "Tigrinja",
        "tiv": "Tiv",
        "tkl": "Tokelauanisch",
        "tlh": "Klingonisch",
        "tli": "Tlingit",
        "tmh": "Tamaseq",
        "tog": "Tonga (Nyasa)",
        "ton": "Tonga (Tonga-Inseln)",
        "tpi": "Neumelanesisch; Pidgin",
        "tsi": "Tsimshian",
        "tsn": "Tswana",
        "tso": "Tsonga",
        "tuk": "Turkmenisch",
        "tum": "Tumbuka",
        "tur": "Türkisch",
        "tvl": "Elliceanisch",
        "twi": "Twi",
        "tyv": "Tuwinisch",
        "udm": "Udmurt",
        "uga": "Ugaritisch",
        "uig": "Uigurisch",
        "ukr": "Ukrainisch",
        "umb": "Mbundu; Umbundu",
        "und": "Unbestimmbar",
        "urd": "Urdu",
        "uzb": "Usbekisch",
        "vai": "Vai",
        "ven": "Venda",
        "vie": "Vietnamesisch",
        "vol": "Volapük",
        "vot": "Wotisch",
        "wal": "Wolaytta",
        "war": "Waray (Philippinen)",
        "was": "Washo",
        "wln": "Wallonisch",
        "wol": "Wolof",
        "xal": "Kalmükisch",
        "xho": "Xhosa",
        "yao": "Yao",
        "yap": "Yapesisch",
        "yid": "Jiddisch",
        "yor": "Joruba",
        "zap": "Zapotekisch",
        "zbl": "Bliss-Symbole",
        "zen": "Zenaga",
        "zha": "Zhuang",
        "zho": "Chinesisch",
        "zul": "Zulu",
        "zun": "Zuni",
        "zxx": "Kein sprachlicher Inhalt",
        "zza": "Zaza"
    },
    "el": {
        "abk": "Αμπχαζιανά",
        "ace": "Ατσενέζικα",
        "ach": "Ακόλο",
        "ada": "Αντάνγκμε",
        "ady": "Αντύγκε",
        "aar": "Αφάρ",
        "afh": "Αφριχίλι",
        "afr": "Αφρικάανς",
        "ain": "Αϊνού (Ιαπωνία)",
        "aka": "Ακάν",
        "akk": "Akkadian",
        "sqi": "Αλβανικά",
        "ale": "Aleut",
        "amh": "Amharic",
        "anp": "Angika",
        "ara": "Αραβικά",
        "arg": "Αραγωνικά ",
        "arp": "Αραπάχο",
        "arw": "Arawak",
        "hye": "Αρμένικα",
        "asm": "Assamese",
        "ast": "Asturian",
        "ava": "Αβαρικά",
        "ave": "Avestan",
        "awa": "Awadhi",
        "aym": "Aymara",
        "aze": "Αζερμπαϊτζιανά",
        "ban": "Balinese",
        "bal": "Baluchi",
        "bam": "Bambara",
        "bas": "Basa (Cameroon)",
        "bak": "Bashkir",
        "eus": "Βασκικά",
        "bej": "Beja",
        "bel": "Λευκωρωσικά",
        "bem": "Bemba (Zambia)",
        "ben": "Μπενγκάλι",
        "bit": "Berinomo",
        "bho": "Bhojpuri",
        "bik": "Bikol",
        "byn": "Bilin",
        "bin": "Bini",
        "bis": "Bislama",
        "zbl": "Blissymbols",
        "bos": "Βοσνιακά",
        "bra": "Braj",
        "bre": "Βρετονικά",
        "bug": "Buginese",
        "bul": "Βουλγάρικα",
        "bua": "Buriat",
        "mya": "Burmese",
        "cad": "Caddo",
        "cat": "Καταλανικά",
        "ceb": "Cebuano",
        "chg": "Chagatai",
        "cha": "Chamorro",
        "che": "Τσετσενικά",
        "chr": "Cherokee",
        "chy": "Cheyenne",
        "chb": "Chibcha",
        "zho": "Κινέζικα",
        "chn": "Chinook jargon",
        "chp": "Chipewyan",
        "cho": "Choctaw",
        "cht": "Cholón",
        "chk": "Chuukese",
        "chv": "Chuvash",
        "cop": "Κοπτικά",
        "cor": "Cornish",
        "cos": "Κορσικανικά",
        "cre": "Cree",
        "mus": "Creek",
        "hrv": "Κροατικά",
        "ces": "Τσέχικα",
        "dak": "Dakota",
        "dan": "Δανέζικα",
        "dar": "Dargwa",
        "del": "Delaware",
        "div": "Dhivehi",
        "din": "Dinka",
        "doi": "Dogri (macrolanguage)",
        "dgr": "Dogrib",
        "dua": "Duala",
        "nld": "Ολλανδικά",
        "dse": "Ολλανδική νοηματική γλώσσα",
        "dyu": "Dyula",
        "dzo": "Dzongkha",
        "efi": "Efik",
        "egy": "Αρχαία Αιγυπτιακά",
        "eka": "Ekajuk",
        "elx": "Elamite",
        "eng": "Αγγλικά",
        "enu": "Enu",
        "myv": "Erzya",
        "epo": "Εσπεράντο",
        "est": "Εσθονικά",
        "ewe": "Ewe",
        "ewo": "Ewondo",
        "fan": "Fang (Equatorial Guinea)",
        "fat": "Fanti",
        "fao": "Faroese",
        "fij": "Fijian",
        "fil": "Filipino",
        "fin": "Φινλανδικά",
        "fon": "Fon",
        "fra": "Γαλλικά",
        "fur": "Friulian",
        "ful": "Fulah",
        "gaa": "Ga",
        "glg": "Galician",
        "lug": "Ganda",
        "gay": "Gayo",
        "gba": "Gbaya (Central African Republic)",
        "hmj": "Ge",
        "gez": "Geez",
        "kat": "Γεωργιανά",
        "deu": "Γερμανικά",
        "gil": "Gilbertese",
        "gon": "Gondi",
        "gor": "Gorontalo",
        "got": "Γοτθικά",
        "grb": "Grebo",
        "grc": "Ελληνικά; Αρχαία (to 1453)",
        "ell": "Ελληνικά; Μοντέρνα (1453-)",
        "grn": "Guarani",
        "guj": "Gujarati",
        "gwi": "Gwichʼin",
        "hai": "Haida",
        "hau": "Hausa",
        "haw": "Hawaiian",
        "heb": "Εβραϊκά",
        "her": "Herero",
        "hil": "Hiligaynon",
        "hin": "Ινδικά",
        "hmo": "Hiri Motu",
        "hit": "Hittite",
        "hmn": "Hmong",
        "hun": "Ουγγρικά",
        "hup": "Hupa",
        "iba": "Iban",
        "isl": "Ισλανδικά",
        "ido": "Ido",
        "ibo": "Igbo",
        "ilo": "Iloko",
        "ind": "Ινδονησιακά",
        "inh": "Ingush",
        "ina": "Interlingua (International Auxiliary Language Association)",
        "ile": "Interlingue",
        "iku": "Inuktitut",
        "ipk": "Inupiaq",
        "gle": "Ιρλανδέζικα",
        "ita": "Ιταλικά",
        "jpn": "Γιαπωνέζικα",
        "jav": "Javanese",
        "jrb": "Judeo-Arabic",
        "jpr": "Judeo-Persian",
        "kbd": "Kabardian",
        "kab": "Kabyle",
        "kac": "Kachin",
        "kal": "Kalaallisut",
        "xal": "Kalmyk",
        "kam": "Kamba (Kenya)",
        "kan": "Kannada",
        "kau": "Kanuri",
        "kaa": "Kara-Kalpak",
        "krc": "Karachay-Balkar",
        "krl": "Karelian",
        "kas": "Kashmiri",
        "csb": "Kashubian",
        "kaw": "Kawi",
        "kaz": "Kazakh",
        "kha": "Khasi",
        "kho": "Khotanese",
        "kik": "Kikuyu",
        "kmb": "Kimbundu",
        "kin": "Kinyarwanda",
        "kir": "Kirghiz",
        "tlh": "Κλίγκον",
        "kom": "Komi",
        "kon": "Kongo",
        "kok": "Konkani (macrolanguage)",
        "kor": "Κορεάτικα",
        "kos": "Kosraean",
        "kpe": "Kpelle",
        "kua": "Kuanyama",
        "kum": "Kumyk",
        "kur": "Κουρδικά",
        "kru": "Kurukh",
        "kut": "Kutenai",
        "lad": "Ladino",
        "lah": "Lahnda",
        "lam": "Lamba",
        "lao": "Lao",
        "lat": "Λατινικά",
        "lav": "Λετονέζικα",
        "lez": "Lezghian",
        "lim": "Limburgan",
        "lin": "Lingala",
        "lit": "Λιθουανικά",
        "jbo": "Lojban",
        "loz": "Lozi",
        "lub": "Luba-Katanga",
        "lua": "Luba-Lulua",
        "lui": "Luiseno",
        "smj": "Lule Sami",
        "lun": "Lunda",
        "luo": "Luo (Kenya and Tanzania)",
        "lus": "Lushai",
        "ltz": "Luxembourgish",
        "mkd": "Σλαβομακεδονικά",
        "mad": "Madurese",
        "mag": "Magahi",
        "mai": "Maithili",
        "mak": "Makasar",
        "mlg": "Malagasy",
        "msa": "Malay (macrolanguage)",
        "mal": "Malayalam",
        "mlt": "Maltese",
        "mnc": "Manchu",
        "mdr": "Mandar",
        "man": "Mandingo",
        "mni": "Manipuri",
        "glv": "Manx",
        "mri": "Maori",
        "arn": "Mapudungun",
        "mar": "Marathi",
        "chm": "Mari (Russia)",
        "mah": "Marshallese",
        "mwr": "Marwari",
        "mas": "Masai",
        "men": "Mende (Sierra Leone)",
        "mic": "Mi'kmaq",
        "min": "Minangkabau",
        "mwl": "Mirandese",
        "moh": "Mohawk",
        "mdf": "Moksha",
        "lol": "Mongo",
        "mon": "Μογγολικά",
        "mos": "Mossi",
        "mul": "Πολλαπλές γλώσσες",
        "nqo": "N'Ko",
        "nau": "Nauru",
        "nav": "Navajo",
        "ndo": "Ndonga",
        "nap": "Neapolitan",
        "nia": "Nias",
        "niu": "Niuean",
        "zxx": "Χωρίς γλωσσολογικό περιεχόμενο",
        "nog": "Nogai",
        "nor": "Νορβηγικά",
        "nob": "Norwegian Bokmål",
        "nno": "Νορβηγικά Nynorsk",
        "nym": "Nyamwezi",
        "nya": "Nyanja",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Occitan (post 1500)",
        "oji": "Ojibwa",
        "orm": "Oromo",
        "osa": "Osage",
        "oss": "Ossetian",
        "pal": "Pahlavi",
        "pau": "Palauan",
        "pli": "Pali",
        "pam": "Pampanga",
        "pag": "Pangasinan",
        "pan": "Panjabi",
        "pap": "Papiamento",
        "fas": "Περσικά",
        "phn": "Φοινικικά",
        "pon": "Pohnpeian",
        "pol": "Πολωνέζικα",
        "por": "Πορτογαλικά",
        "pus": "Pashto",
        "que": "Quechua",
        "raj": "Rajasthani",
        "rap": "Rapanui",
        "ron": "Ρουμάνικα",
        "roh": "Romansh",
        "rom": "Romany",
        "run": "Rundi",
        "rus": "Ρώσικα",
        "smo": "Samoan",
        "sad": "Sandawe",
        "sag": "Sango",
        "san": "Σανσκριτικά",
        "sat": "Santali",
        "srd": "Sardinian",
        "sas": "Sasak",
        "sco": "Σκωτσέζικα",
        "sel": "Selkup",
        "srp": "Σερβικά",
        "srr": "Serer",
        "shn": "Shan",
        "sna": "Shona",
        "scn": "Sicilian",
        "sid": "Sidamo",
        "bla": "Siksika",
        "snd": "Sindhi",
        "sin": "Sinhala",
        "den": "Slave (Athapascan)",
        "slk": "Σλοβακικά",
        "slv": "Σλοβενικά",
        "sog": "Σογδιανά",
        "som": "Σομαλικά",
        "snk": "Soninke",
        "spa": "Ισπανικά",
        "srn": "Sranan Tongo",
        "suk": "Sukuma",
        "sux": "Sumerian",
        "sun": "Sundanese",
        "sus": "Susu",
        "swa": "Swahili (macrolanguage)",
        "ssw": "Swati",
        "swe": "Σουηδικά",
        "syr": "Συριακά",
        "tgl": "Tagalog",
        "tah": "Tahitian",
        "tgk": "Tajik",
        "tmh": "Tamashek",
        "tam": "Ταμίλ",
        "tat": "Tatar",
        "tel": "Telugu",
        "ter": "Tereno",
        "tet": "Tetum",
        "tha": "Ταϊλανδέζικη",
        "bod": "Θιβετιανά",
        "tig": "Tigre",
        "tir": "Tigrinya",
        "tem": "Timne",
        "tiv": "Tiv",
        "tli": "Tlingit",
        "tpi": "Tok Pisin",
        "tkl": "Τοκελάου",
        "tog": "Tonga (Nyasa)",
        "ton": "Tonga (Tonga Islands)",
        "tsi": "Tsimshian",
        "tso": "Tsonga",
        "tsn": "Tswana",
        "tum": "Tumbuka",
        "tur": "Τουρκικά",
        "tuk": "Τουρκμένικα",
        "tvl": "Tuvalu",
        "tyv": "Tuvinian",
        "twi": "Twi",
        "udm": "Udmurt",
        "uga": "Ugaritic",
        "uig": "Uighur",
        "ukr": "Ουκρανικά",
        "umb": "Umbundu",
        "mis": "Uncoded languages",
        "und": "Απροσδιόριστη",
        "urd": "Urdu",
        "uzb": "Uzbek",
        "vai": "Vai",
        "ven": "Venda",
        "vie": "Βιετναμέζικα",
        "vol": "Volapük",
        "vot": "Votic",
        "wln": "Walloon",
        "war": "Waray (Philippines)",
        "was": "Washo",
        "cym": "Ουαλικά",
        "wal": "Wolaytta",
        "wol": "Wolof",
        "xho": "Xhosa",
        "sah": "Yakut",
        "yao": "Yao",
        "yap": "Yapese",
        "yid": "Yiddish",
        "yor": "Yoruba",
        "zap": "Zapotec",
        "zza": "Zaza",
        "zen": "Zenaga",
        "zha": "Zhuang",
        "zul": "Zulu",
        "zun": "Zuni"
    },
    "es": {
        "aar": "Afar",
        "abk": "Abjasio",
        "ace": "Achenés",
        "ach": "Acholi",
        "ada": "Adangme",
        "ady": "Adigué",
        "afh": "Afrihili",
        "afr": "Afrikáans",
        "ain": "Ainu (Japón)",
        "aka": "Acano",
        "akk": "Acadio",
        "ale": "Aleutiano",
        "alt": "Altai meridional",
        "amh": "Amhárico",
        "ang": "Inglés antiguo (ca. 450-1100)",
        "anp": "Angika",
        "ara": "Árabe",
        "arc": "Arameo oficial (700-300 A. C.)",
        "arg": "Aragonés",
        "arn": "Mapudungun",
        "arp": "Arapajó",
        "arw": "Arahuaco",
        "asm": "Asamés",
        "ast": "Asturiano",
        "ava": "Ávaro",
        "ave": "Avéstico",
        "awa": "Awadhi",
        "aym": "Aimara",
        "aze": "Azerí",
        "bak": "Bashkir",
        "bal": "Baluchi",
        "bam": "Bambara",
        "ban": "Balinés",
        "bas": "Basa (Camerún)",
        "bej": "Beya",
        "bel": "Bielorruso",
        "bem": "Bemba (Zambia)",
        "ben": "Bengalí",
        "bho": "Bopurí",
        "bik": "Bicolano",
        "bin": "Bini",
        "bis": "Bislama",
        "bit": "Berinomo",
        "bla": "Siksiká",
        "bod": "Tibetano",
        "bos": "Bosnio",
        "bra": "Braj",
        "bre": "Bretón",
        "bua": "Buriato",
        "bug": "Buginés",
        "bul": "Búlgaro",
        "byn": "Bilin",
        "cad": "Caddo",
        "car": "Caribe galibí",
        "cat": "Catalán",
        "ceb": "Cebuano",
        "ces": "Checo",
        "cha": "Chamorro",
        "chb": "Muisca",
        "che": "Checheno",
        "chg": "Chagatai",
        "chk": "Chuukés",
        "chm": "Mari (Rusia)",
        "chn": "Jerga chinook",
        "cho": "Choctaw",
        "chp": "Chipewyan",
        "chr": "Cheroqui",
        "cht": "Cholón",
        "chu": "Eslavo antiguo",
        "chv": "Chuvasio",
        "chy": "Cheyenne",
        "cop": "Copto",
        "cor": "Córnico",
        "cos": "Corso",
        "cre": "Cree",
        "crh": "Tártaro de Crimea",
        "csb": "Casubio",
        "cym": "Galés",
        "dak": "Dakota",
        "dan": "Danés",
        "dar": "Dargwa",
        "del": "Delaware",
        "den": "Slave (atabascano)",
        "deu": "Alemán",
        "dgr": "Dogrib",
        "din": "Dinka",
        "div": "Dhivehi",
        "doi": "Dogri (macrolengua)",
        "dsb": "Bajo sorabo",
        "dse": "Lengua de signos neerlandesa",
        "dua": "Duala",
        "dum": "Neerlandés medio (ca. 1050-1350)",
        "dyu": "Diula",
        "dzo": "Dzongkha",
        "efi": "Efik",
        "egy": "Egipcio (antiguo)",
        "eka": "Ekajuk",
        "ell": "Griego moderno (1453-)",
        "elx": "Elamita",
        "eng": "Inglés",
        "enm": "Inglés medio (1100-1500)",
        "enu": "Enu",
        "epo": "Esperanto",
        "est": "Estonio",
        "eus": "Vasco",
        "ewe": "Ewe",
        "ewo": "Ewondo",
        "fan": "Fang (Guinea Ecuatorial)",
        "fao": "Feroés",
        "fas": "Persa",
        "fat": "Fanti",
        "fij": "Fiyiano",
        "fil": "Filipino",
        "fin": "Finés",
        "fon": "Fon",
        "fra": "Francés",
        "frm": "Francés medio (ca. 1400-1600)",
        "fro": "Francés antiguo (842-ca. 1400)",
        "frr": "Frisón septentrional",
        "frs": "Frisón oriental",
        "fry": "Frisón occidental",
        "ful": "Fula",
        "fur": "Friulano",
        "gaa": "Ga",
        "gay": "Gayo",
        "gba": "Gbaya (República Centroafricana)",
        "gez": "Ge'ez",
        "gil": "Gilbertés",
        "gla": "Gaélico escocés",
        "gle": "Irlandés",
        "glg": "Gallego",
        "glv": "Manés",
        "gmh": "Alto alemán medio (ca. 1050-1500)",
        "goh": "Alto alemán antiguo (ca. 750-1050)",
        "gon": "Gondi",
        "gor": "Gorontalo",
        "got": "Gótico",
        "grb": "Grebo",
        "grc": "Griego antiguo (hasta 1453)",
        "grn": "Guaraní",
        "gsw": "Alemán suizo",
        "guj": "Guyaratí",
        "gwi": "Gwichʼin",
        "hai": "Haida",
        "hat": "Criollo haitiano",
        "hau": "Hausa",
        "haw": "Hawaiano",
        "heb": "Hebreo",
        "her": "Herero",
        "hil": "Hiligainón",
        "hin": "Hindi",
        "hit": "Hitita",
        "hmj": "Ge",
        "hmn": "Hmong",
        "hmo": "Hiri motu",
        "hrv": "Croata",
        "hsb": "Alto sorabo",
        "hun": "Húngaro",
        "hup": "Hupa",
        "hye": "Armenio",
        "iba": "Iban",
        "ibo": "Igbo",
        "ido": "Ido",
        "iii": "Yi de Sichuan",
        "iku": "Inuktitut",
        "ile": "Interlingüe",
        "ilo": "Ilocano",
        "ina": "Interlingua",
        "ind": "Indonesio",
        "inh": "Ingusetio",
        "ipk": "Iñupiaq",
        "isl": "Islandés",
        "ita": "Italiano",
        "jav": "Javanés",
        "jbo": "Lojban",
        "jpn": "Japonés",
        "jpr": "Judeo-persa",
        "jrb": "Judeo-árabe",
        "kaa": "Karakalpako",
        "kab": "Cabilio",
        "kac": "Kachin",
        "kal": "Kalaallisut",
        "kam": "Kamba (Kenia)",
        "kan": "Canarés",
        "kas": "Cachemir",
        "kat": "Georgiano",
        "kau": "Kanuri",
        "kaw": "Kawi",
        "kaz": "Kazajo",
        "kbd": "Cabardiano",
        "kha": "Khasi",
        "khm": "Jemer central",
        "kho": "Khotanés",
        "kik": "Kikuyu",
        "kin": "Kinyarwanda",
        "kir": "Kirguís",
        "kmb": "Kimbundu",
        "kok": "Konkaní (macrolengua)",
        "kom": "Komi",
        "kon": "Kikongo",
        "kor": "Coreano",
        "kos": "Kosraeano",
        "kpe": "Kpelle",
        "krc": "Karachayo-bálkaro",
        "krl": "Carelio",
        "kru": "Kurukh",
        "kua": "Kuanyama",
        "kum": "Cumuco",
        "kur": "Curdo",
        "kut": "Kutenai",
        "lad": "Ladino",
        "lah": "Lahnda",
        "lam": "Lamba",
        "lao": "Laosiano",
        "lat": "Latín",
        "lav": "Letón",
        "lez": "Lezguino",
        "lim": "Limburgan",
        "lin": "Lingala",
        "lit": "Lituano",
        "lol": "Mongo",
        "loz": "Lozi",
        "ltz": "Luxemburgués",
        "lua": "Chiluba",
        "lub": "Kiluba",
        "lug": "Luganda",
        "lui": "Luiseño",
        "lun": "Lunda",
        "luo": "Luo (Kenia y Tanzania)",
        "lus": "Mizo",
        "mad": "Madurés",
        "mag": "Magahi",
        "mah": "Marshalés",
        "mai": "Maithili",
        "mak": "Macasar",
        "mal": "Malayalam",
        "man": "Mandingo",
        "mar": "Maratí",
        "mas": "Masai",
        "mdf": "Moksha",
        "mdr": "Mandar",
        "men": "Mende (Sierra Leona)",
        "mga": "Irlandés medio (900-1200)",
        "mic": "Mi'kmaq",
        "min": "Minangkabau",
        "mis": "Idiomas sin codificar",
        "mkd": "Macedonio",
        "mlg": "Malgache",
        "mlt": "Maltés",
        "mnc": "Manchú",
        "mni": "Meitei",
        "moh": "Mohawk",
        "mon": "Mongol",
        "mos": "Mossi",
        "mri": "Maorí",
        "msa": "Malayo (macrolengua)",
        "mul": "Idiomas múltiples",
        "mus": "Creek",
        "mwl": "Mirandés",
        "mwr": "Marwari",
        "mya": "Birmano",
        "myv": "Erzya",
        "nap": "Napolitano",
        "nau": "Nauruano",
        "nav": "Navajo",
        "nbl": "Ndebele meridional",
        "nde": "Ndebele septentrional",
        "ndo": "Ndonga",
        "nds": "Bajo alemán",
        "nep": "Nepalí",
        "new": "Bhasa; Nepalés",
        "nia": "Nias",
        "niu": "Niuano",
        "nld": "Neerlandés",
        "nno": "Noruego nynorsk",
        "nob": "Noruego bokmål",
        "nog": "Nogayo",
        "non": "Noruego antiguo",
        "nor": "Noruego",
        "nqo": "N'ko",
        "nso": "Sepedi",
        "nwc": "Newarí antiguo",
        "nya": "Nyanja",
        "nym": "Nyamwezi",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzema",
        "oci": "Occitano (posterior a 1500)",
        "oji": "Ojibwa",
        "ori": "Oriya",
        "orm": "Oromo",
        "osa": "Osage",
        "oss": "Osetio",
        "ota": "Turco otomano (1500-1928)",
        "pag": "Pangasinense",
        "pal": "Pahlavi",
        "pam": "Pampango",
        "pan": "Panyabí",
        "pap": "Papiamento",
        "pau": "Palauano",
        "peo": "Persa antiguo (ca. 600-400 A. C.)",
        "phn": "Fenicio",
        "pli": "Pali",
        "pol": "Polaco",
        "pon": "Pohnpeiano",
        "por": "Portugués",
        "pro": "Provenzal antiguo (hasta 1500)",
        "pus": "Pastún",
        "que": "Quechua",
        "raj": "Rajastaní",
        "rap": "Rapanui",
        "rar": "Maorí; Islas Cook",
        "roh": "Romanche",
        "rom": "Romaní",
        "ron": "Rumano",
        "run": "Kirundi",
        "rup": "Rumano; Macedo-",
        "rus": "Ruso",
        "sad": "Sandavés",
        "sag": "Sango",
        "sah": "Yakuto",
        "sam": "Arameo samaritano",
        "san": "Sánscrito",
        "sas": "Sasak",
        "sat": "Santalí",
        "scn": "Siciliano",
        "sco": "Escocés (germánico)",
        "sel": "Selkup",
        "sga": "Irlandés antiguo (hasta 900)",
        "shn": "Shan",
        "sid": "Sidamo",
        "sin": "Cingalés",
        "slk": "Eslovaco",
        "slv": "Esloveno",
        "sma": "Sami meridional",
        "sme": "Sami septentrional",
        "smj": "Sami de Lule",
        "smn": "Sami de Inari",
        "smo": "Samoano",
        "sms": "Sami de Skolt",
        "sna": "Shona",
        "snd": "Sindhi",
        "snk": "Soninké",
        "sog": "Sogdiano",
        "som": "Somalí",
        "sot": "Sesotho",
        "spa": "Español",
        "sqi": "Albanés",
        "srd": "Sardo",
        "srn": "Sranan tongo",
        "srp": "Serbio",
        "srr": "Serer",
        "ssw": "Swazi",
        "suk": "Sukuma",
        "sun": "Sundanés",
        "sus": "Susu",
        "sux": "Sumerio",
        "swa": "Suajili (macrolengua)",
        "swe": "Sueco",
        "syc": "Siríaco clásico",
        "syr": "Siríaco",
        "tah": "Tahitiano",
        "tam": "Tamil",
        "tat": "Tártaro",
        "tel": "Telugú",
        "tem": "Temné",
        "ter": "Tereno",
        "tet": "Tetun",
        "tgk": "Tayiko",
        "tgl": "Tagalo",
        "tha": "Tailandés",
        "tig": "Tigré",
        "tir": "Tigriña",
        "tiv": "Tiv",
        "tkl": "Tokelauano",
        "tlh": "Klingon",
        "tli": "Tlingit",
        "tmh": "Targuí",
        "tog": "Tonga (Malaui)",
        "ton": "Tonga (Islas Tonga)",
        "tpi": "Tok pisin",
        "tsi": "Tsimshian",
        "tsn": "Setsuana",
        "tso": "Tsonga",
        "tuk": "Turcomano",
        "tum": "Tumbuka",
        "tur": "Turco",
        "tvl": "Tuvaluano",
        "twi": "Twi",
        "tyv": "Tuvano",
        "udm": "Udmurt",
        "uga": "Ugarítico",
        "uig": "Uiguro",
        "ukr": "Ucraniano",
        "umb": "Umbundu",
        "und": "Indeterminado",
        "urd": "Urdu",
        "uzb": "Uzbeko",
        "vai": "Vai",
        "ven": "Venda",
        "vie": "Vietnamita",
        "vol": "Volapük",
        "vot": "Vótico",
        "wal": "Wolaytta",
        "war": "Waray (Filipinas)",
        "was": "Washo",
        "wln": "Valón",
        "wol": "Wólof",
        "xal": "Calmuco",
        "xho": "Xhosa",
        "yao": "Yao",
        "yap": "Yapés",
        "yid": "Yidis",
        "yor": "Yoruba",
        "zap": "Zapoteco",
        "zbl": "Símbolos de Bliss",
        "zen": "Zenaga",
        "zha": "Chuang",
        "zho": "Chino",
        "zul": "Zulú",
        "zun": "Zuñi",
        "zxx": "Sin contenido lingüístico",
        "zza": "Zaza"
    },
    "fi": {
        "aar": "afar",
        "abk": "abhaasi",
        "ace": "aceh",
        "ach": "atšoli",
        "ada": "adangme",
        "ady": "adyge",
        "afh": "afrihili",
        "afr": "afrikaans",
        "ain": "Ainu (Japan)",
        "aka": "Akan",
        "akk": "akkadi",
        "ale": "aleutti",
        "alt": "Altai; Southern",
        "amh": "amhara",
        "ang": "English; Old (ca. 450-1100)",
        "anp": "angika",
        "ara": "arabia",
        "arc": "Aramaic; Official (700-300 BCE)",
        "arg": "aragonia",
        "arn": "Mapudungun",
        "arp": "arapaho",
        "arw": "arawak",
        "asm": "asami",
        "ast": "asturia",
        "ava": "avaari",
        "ave": "avestan",
        "awa": "awadhi",
        "aym": "Aymara",
        "aze": "azeri",
        "bak": "baškiiri",
        "bal": "belutši",
        "bam": "Bambara",
        "ban": "bali",
        "bas": "Basa (Cameroon)",
        "bej": "beja",
        "bel": "valkovenäjä",
        "bem": "Bemba (Zambia)",
        "ben": "bengali",
        "bho": "bhojpuri",
        "bik": "bikol",
        "bin": "bini",
        "bis": "bislama",
        "bit": "Berinomo",
        "bla": "mustajalka (siksika)",
        "bod": "tiibetti",
        "bos": "bosnia",
        "bra": "bradž",
        "bre": "bretoni",
        "bua": "burjaatti",
        "bug": "bugi",
        "bul": "bulgaria",
        "byn": "Bilin",
        "cad": "caddo",
        "car": "Carib; Galibi",
        "cat": "katalaani",
        "ceb": "cebuano",
        "ces": "tšekki",
        "cha": "chamorro",
        "chb": "chibcha",
        "che": "tšetšeeni",
        "chg": "Chagatai",
        "chk": "chuuk",
        "chm": "mari (Venäjä)",
        "chn": "chinook-jargon",
        "cho": "choctaw",
        "chp": "chipewyan",
        "chr": "cherokee",
        "cht": "Cholón",
        "chu": "Slavonic; Old",
        "chv": "tšuvassi",
        "chy": "cheyenne",
        "cop": "kopti",
        "cor": "korni",
        "cos": "korsika",
        "cre": "cree",
        "crh": "krimintataari",
        "csb": "kašubi",
        "cym": "kymri",
        "dak": "dakota",
        "dan": "tanska",
        "dar": "dargva",
        "del": "delaware",
        "den": "athapaski-slavi",
        "deu": "saksa",
        "dgr": "dogrib",
        "din": "Dinka",
        "div": "Dhivehi",
        "doi": "Dogri (macrolanguage)",
        "dsb": "alasorbi",
        "dse": "Dutch Sign Language",
        "dua": "duala",
        "dum": "Dutch; Middle (ca. 1050-1350)",
        "dyu": "dyula",
        "dzo": "dzongkha",
        "efi": "efik",
        "egy": "muinaisegypti",
        "eka": "ekajuk",
        "ell": "nykykreikka",
        "elx": "elami",
        "eng": "englanti",
        "enm": "keskienglanti",
        "enu": "Enu",
        "epo": "esperanto",
        "est": "viro",
        "eus": "baski",
        "ewe": "ewe",
        "ewo": "ewondo",
        "fan": "Fang (Equatorial Guinea)",
        "fao": "fääri",
        "fas": "persia",
        "fat": "fanti",
        "fij": "fidži",
        "fil": "filipino",
        "fin": "suomi",
        "fon": "fon",
        "fra": "ranska",
        "frm": "French; Middle (ca. 1400-1600)",
        "fro": "French; Old (842-ca. 1400)",
        "frr": "Frisian; Northern",
        "frs": "Frisian; Eastern",
        "fry": "Frisian; Western",
        "ful": "fulani",
        "fur": "friuli",
        "gaa": "gã",
        "gay": "gayo",
        "gba": "Gbaya (Central African Republic)",
        "gez": "ge'ez",
        "gil": "kiribati",
        "gla": "Gaelic; Scottish",
        "gle": "iiri",
        "glg": "galicia",
        "glv": "manksi",
        "gmh": "German; Middle High (ca. 1050-1500)",
        "goh": "German; Old High (ca. 750-1050)",
        "gon": "gondi",
        "gor": "gorontalo",
        "got": "gootti",
        "grb": "grebo",
        "grc": "muinaiskreikka",
        "grn": "guarani",
        "gsw": "German; Swiss",
        "guj": "gujarati",
        "gwi": "Gwichʼin",
        "hai": "haida",
        "hat": "Creole; Haitian",
        "hau": "hausa",
        "haw": "havaiji",
        "heb": "heprea",
        "her": "herero",
        "hil": "hiligaynon",
        "hin": "hindi",
        "hit": "heetti",
        "hmj": "Ge",
        "hmn": "hmong",
        "hmo": "hiri-motu",
        "hrv": "kroatia",
        "hsb": "Sorbian; Upper",
        "hun": "unkari",
        "hup": "hupa",
        "hye": "armenia",
        "iba": "Iban",
        "ibo": "igbo",
        "ido": "ido",
        "iii": "Yi; Sichuan",
        "iku": "inuktitut",
        "ile": "interlingue",
        "ilo": "iloko",
        "ina": "interlingua",
        "ind": "indonesia",
        "inh": "inguuši",
        "ipk": "iñupiaq",
        "isl": "islanti",
        "ita": "italia",
        "jav": "jaava",
        "jbo": "lojban",
        "jpn": "japani",
        "jpr": "juutalaispersia",
        "jrb": "juutalaisarabia",
        "kaa": "karakalpakki",
        "kab": "kabyyli",
        "kac": "kachin",
        "kal": "grönlanti",
        "kam": "Kamba (Kenya)",
        "kan": "kannada",
        "kas": "kashmiri",
        "kat": "georgia",
        "kau": "kanuri",
        "kaw": "kavi",
        "kaz": "kazakki",
        "kbd": "kabardi",
        "kha": "Khasi",
        "khm": "Khmer; Central",
        "kho": "khotani",
        "kik": "kikuyu",
        "kin": "ruanda",
        "kir": "kirgiisi",
        "kmb": "kimbundu",
        "kok": "Konkani (macrolanguage)",
        "kom": "komi",
        "kon": "Kongo",
        "kor": "korea",
        "kos": "kosrae",
        "kpe": "kpelle",
        "krc": "karatšai-balkaari",
        "krl": "karjala",
        "kru": "kurukh",
        "kua": "kuanjama",
        "kum": "kumykki",
        "kur": "kurdi",
        "kut": "kutenai",
        "lad": "ladino",
        "lah": "lahnda",
        "lam": "lamba",
        "lao": "lao",
        "lat": "latina",
        "lav": "latvia",
        "lez": "lezgi",
        "lim": "Limburgan",
        "lin": "lingala",
        "lit": "liettua",
        "lol": "mongo",
        "loz": "lozi",
        "ltz": "Luxemburg",
        "lua": "luba (Lulua)",
        "lub": "luba (Katanga)",
        "lug": "Ganda",
        "lui": "luiseño",
        "lun": "lunda",
        "luo": "luo",
        "lus": "lushai",
        "mad": "madura",
        "mag": "magahi",
        "mah": "Marshallese",
        "mai": "maithili",
        "mak": "Makasar",
        "mal": "malayalam",
        "man": "mandingo",
        "mar": "marathi",
        "mas": "masai",
        "mdf": "mokša",
        "mdr": "mandar",
        "men": "Mende (Sierra Leone)",
        "mga": "keski-iiri",
        "mic": "Mi'kmaq",
        "min": "minangkabau",
        "mis": "Uncoded languages",
        "mkd": "makedonia",
        "mlg": "malagassi",
        "mlt": "malta",
        "mnc": "mantšu",
        "mni": "manipuri",
        "moh": "mohawk",
        "mon": "Mongolian",
        "mos": "mossi",
        "mri": "maori",
        "msa": "Malay (macrolanguage)",
        "mul": "monia kieliä",
        "mus": "muskogi",
        "mwl": "mirandês",
        "mwr": "marwari",
        "mya": "burma",
        "myv": "ersä",
        "nap": "napoli",
        "nau": "nauru",
        "nav": "Navajo",
        "nbl": "ndebele; eteländebele",
        "nde": "ndebele; pohjoisndebele",
        "ndo": "ndonga",
        "nds": "German; Low",
        "nep": "nepali",
        "new": "Bhasa; Nepal",
        "nia": "nias",
        "niu": "niue",
        "nld": "hollanti",
        "nno": "norja (uusnorja)",
        "nob": "Norwegian Bokmål",
        "nog": "nogai",
        "non": "muinaisnorja",
        "nor": "norja",
        "nqo": "N'Ko",
        "nso": "Sotho; Northern",
        "nwc": "Newari; Old",
        "nya": "Nyanja",
        "nym": "nyamwezi",
        "nyn": "nyankole",
        "nyo": "Nyoro",
        "nzi": "nzima",
        "oci": "Occitan (post 1500)",
        "oji": "Ojibwa",
        "ori": "oriya",
        "orm": "oromo",
        "osa": "osage",
        "oss": "Ossetian",
        "ota": "osmaninturkki",
        "pag": "pangasinan",
        "pal": "pahlavi",
        "pam": "pampanga",
        "pan": "Panjabi",
        "pap": "papiamentu",
        "pau": "palau",
        "peo": "Persian; Old (ca. 600-400 B.C.)",
        "phn": "foinikia",
        "pli": "Pali",
        "pol": "puola",
        "pon": "pohnpei",
        "por": "portugali",
        "pro": "muinaisprovensaali",
        "pus": "pašto",
        "que": "Quechua",
        "raj": "rajasthani",
        "rap": "rapanui",
        "rar": "Maori; Cook Islands",
        "roh": "Romansh",
        "rom": "romani",
        "ron": "romania",
        "run": "rundi",
        "rup": "Romanian; Macedo-",
        "rus": "venäjä",
        "sad": "sandawe",
        "sag": "Sango",
        "sah": "jakuutti",
        "sam": "Aramaic; Samaritan",
        "san": "sanskrit",
        "sas": "Sasak",
        "sat": "santali",
        "scn": "sisilia",
        "sco": "skotti",
        "sel": "selkuppi",
        "sga": "muinaisiiri",
        "shn": "shan",
        "sid": "sidamo",
        "sin": "Sinhala",
        "slk": "slovakki",
        "slv": "sloveeni",
        "sma": "eteläsaame",
        "sme": "pohjoissaame",
        "smj": "luulajansaame",
        "smn": "inarinsaame",
        "smo": "samoa",
        "sms": "koltansaami",
        "sna": "shona",
        "snd": "sindhi",
        "snk": "soninke",
        "sog": "sogdi",
        "som": "somali",
        "sot": "eteläsotho",
        "spa": "espanja",
        "sqi": "albania",
        "srd": "sardi",
        "srn": "Sranan Tongo",
        "srp": "serbia",
        "srr": "Serer",
        "ssw": "swazi",
        "suk": "sukuma",
        "sun": "sunda",
        "sus": "susu",
        "sux": "sumeri",
        "swa": "Swahili (macrolanguage)",
        "swe": "ruotsi",
        "syc": "Syriac; Classical",
        "syr": "syyria",
        "tah": "tahiti",
        "tam": "tamili",
        "tat": "tataari",
        "tel": "Telugu",
        "tem": "temne",
        "ter": "tereno",
        "tet": "tetum",
        "tgk": "tadžikki",
        "tgl": "tagalog",
        "tha": "thai",
        "tig": "tigre",
        "tir": "tigrinya",
        "tiv": "tiv",
        "tkl": "tokelau",
        "tlh": "Klingon",
        "tli": "tlinglit",
        "tmh": "Tamashek",
        "tog": "Malawin tonga",
        "ton": "Tongan tonga",
        "tpi": "tok-pisin",
        "tsi": "tsimshian",
        "tsn": "tswana",
        "tso": "tsonga",
        "tuk": "turkmeeni",
        "tum": "tumbuka",
        "tur": "turkki",
        "tvl": "tuvalu",
        "twi": "twi",
        "tyv": "tuva",
        "udm": "udmurtti",
        "uga": "ugarit",
        "uig": "uiguuri",
        "ukr": "ukraina",
        "umb": "umbundu",
        "und": "määrittämätön",
        "urd": "urdu",
        "uzb": "uzbekki",
        "vai": "vai",
        "ven": "venda",
        "vie": "vietnam",
        "vol": "volapük",
        "vot": "vatja",
        "wal": "Wolaytta",
        "war": "Waray (Philippines)",
        "was": "washo",
        "wln": "valloni",
        "wol": "wolof",
        "xal": "Kalmyk",
        "xho": "xhosa",
        "yao": "mien",
        "yap": "yap",
        "yid": "jiddiš",
        "yor": "yoruba",
        "zap": "Zapotec",
        "zbl": "Blissymbols",
        "zen": "zenaga",
        "zha": "Zhuang",
        "zho": "kiina",
        "zul": "zulu",
        "zun": "zuni",
        "zxx": "No linguistic content",
        "zza": "Zaza"
    },
    "fr": {
        "aar": "afar",
        "abk": "abkhaze",
        "ace": "at-chinois",
        "ach": "acoli",
        "ada": "adangme",
        "ady": "adyguéen",
        "afh": "afrihili",
        "afr": "Afrikaans",
        "ain": "aïnou (Japon)",
        "aka": "akan",
        "akk": "akkadien",
        "ale": "aléoute",
        "alt": "altaï méridional",
        "amh": "amharique",
        "ang": "anglo-saxon (environ 450-1100)",
        "anp": "angika",
        "ara": "arabe",
        "arc": "araméen officiel (700-300 A.C.)",
        "arg": "aragonais",
        "arn": "mapudungun",
        "arp": "arapaho",
        "arw": "arawak",
        "asm": "assamais",
        "ast": "asturien",
        "ava": "avar",
        "ave": "avestique",
        "awa": "awadhi",
        "aym": "aymara",
        "aze": "azéri",
        "bak": "bachkir",
        "bal": "baloutchi",
        "bam": "bambara",
        "ban": "balinais",
        "bas": "basa (Cameroun)",
        "bej": "beja",
        "bel": "biélorusse",
        "bem": "bemba (Zambie)",
        "ben": "bengali",
        "bho": "bhojpuri",
        "bik": "bikol",
        "bin": "bini",
        "bis": "bislama",
        "bit": "berinomo",
        "bla": "pied-noir",
        "bod": "tibétain",
        "bos": "bosniaque",
        "bra": "braj",
        "bre": "breton",
        "bua": "bouriate",
        "bug": "buginais",
        "bul": "bulgare",
        "byn": "bilin",
        "cad": "caddo",
        "car": "carib; Galibi",
        "cat": "catalan",
        "ceb": "cébuan",
        "ces": "tchèque",
        "cha": "chamorro",
        "chb": "chibcha",
        "che": "thétchène",
        "chg": "chagatai",
        "chk": "chuukese",
        "chm": "mari (Russie)",
        "chn": "chinook; jargon",
        "cho": "choctaw",
        "chp": "chipewyan",
        "chr": "cherokee",
        "cht": "cholón",
        "chu": "slavon; ancien",
        "chv": "tchouvache",
        "chy": "cheyenne",
        "cop": "copte",
        "cor": "cornish",
        "cos": "corse",
        "cre": "cri",
        "crh": "turc de Crimée",
        "csb": "kachoubien",
        "cym": "gallois",
        "dak": "dakota",
        "dan": "danois",
        "dar": "dargwa",
        "del": "delaware",
        "den": "esclave (athapascan)",
        "deu": "allemand",
        "dgr": "dogrib",
        "din": "dinka",
        "div": "dhivehi",
        "doi": "dogri (macrolangue)",
        "dsb": "bas-sorbien",
        "dse": "langue des signes néerlandaise",
        "dua": "duala",
        "dum": "néerlandais moyen (environ 1050-1350)",
        "dyu": "dioula",
        "dzo": "dzongkha",
        "efi": "efik",
        "egy": "égyptien ancien",
        "eka": "ekajuk",
        "ell": "grec moderne (après 1453)",
        "elx": "élamite",
        "eng": "anglais",
        "enm": "anglais moyen (1100-1500)",
        "enu": "enu",
        "epo": "espéranto",
        "est": "estonien",
        "eus": "basque",
        "ewe": "ewe",
        "ewo": "ewondo",
        "fan": "fang (Guinée Équatoriale)",
        "fao": "féroéen",
        "fas": "persan",
        "fat": "fanti",
        "fij": "fidjien",
        "fil": "filipino",
        "fin": "finnois",
        "fon": "fon-gbe",
        "fra": "Français",
        "frm": "français moyen (environ 1400-1600)",
        "fro": "ancien français (842 à environ 1400)",
        "frr": "frison septentrional",
        "frs": "frison oriental",
        "fry": "frison occidental",
        "ful": "fulah",
        "fur": "frioulan",
        "gaa": "ga",
        "gay": "gayo",
        "gba": "gbaya (République Centrafricaine)",
        "gez": "geez",
        "gil": "gilbertese",
        "gla": "gaélique écossais",
        "gle": "irlandais",
        "glg": "galicien",
        "glv": "manx",
        "gmh": "allemand; moyen haut (environ 1050-1500)",
        "goh": "allemand; vieux haut (environ 750-1050)",
        "gon": "gondi",
        "gor": "gorontalo",
        "got": "gothique",
        "grb": "grebo",
        "grc": "grec ancien (jusqu'à 1453)",
        "grn": "guarani",
        "gsw": "allemand de Suisse",
        "guj": "gujarati",
        "gwi": "gwichʼin",
        "hai": "haida",
        "hat": "créole haïtien",
        "hau": "hausa",
        "haw": "hawaïen",
        "heb": "hébreu",
        "her": "herero",
        "hil": "hiligaynon",
        "hin": "hindi",
        "hit": "hittite",
        "hmj": "ge",
        "hmn": "hmong",
        "hmo": "hiri Motu",
        "hrv": "croate",
        "hsb": "haut-sorbien",
        "hun": "hongrois",
        "hup": "hupa",
        "hye": "arménien",
        "iba": "iban",
        "ibo": "igbo",
        "ido": "ido",
        "iii": "yi de Sichuan",
        "iku": "inuktitut",
        "ile": "interlingue",
        "ilo": "iloko",
        "ina": "interlingua (association pour une langue auxiliaire internationale)",
        "ind": "indonésien",
        "inh": "ingouche",
        "ipk": "inupiaq",
        "isl": "islandais",
        "ita": "italien",
        "jav": "javanais",
        "jbo": "lojban",
        "jpn": "japonais",
        "jpr": "judéo-persan",
        "jrb": "judéo-arabe",
        "kaa": "kara-kalpak",
        "kab": "kabyle",
        "kac": "kachin",
        "kal": "kalaallisut",
        "kam": "kamba (Kenya)",
        "kan": "kannada",
        "kas": "cachemiri",
        "kat": "géorgien",
        "kau": "kanuri",
        "kaw": "kawi",
        "kaz": "kazakh",
        "kbd": "kabardian",
        "kha": "khasi",
        "khm": "khmer central",
        "kho": "khotanais",
        "kik": "kikuyu",
        "kin": "kinyarwanda",
        "kir": "kirghize",
        "kmb": "kimbundu",
        "kok": "konkani (macrolangue)",
        "kom": "komi",
        "kon": "kongo",
        "kor": "coréen",
        "kos": "kosraéen",
        "kpe": "kpelle",
        "krc": "karachay-balkar",
        "krl": "carélien",
        "kru": "kurukh",
        "kua": "kuanyama",
        "kum": "kumyk",
        "kur": "kurde",
        "kut": "kutenai",
        "lad": "ladino",
        "lah": "lahnda",
        "lam": "lamba",
        "lao": "lao",
        "lat": "latin",
        "lav": "letton",
        "lez": "lezghian",
        "lim": "limbourgeois",
        "lin": "lingala",
        "lit": "lituanien",
        "lol": "mongo",
        "loz": "lozi",
        "ltz": "luxembourgeois",
        "lua": "luba-lulua",
        "lub": "luba-katanga",
        "lug": "ganda",
        "lui": "luiseno",
        "lun": "lunda",
        "luo": "luo (Kenya et Tanzanie)",
        "lus": "lushai",
        "mad": "madurais",
        "mag": "magahi",
        "mah": "marshallais",
        "mai": "maithili",
        "mak": "makassar",
        "mal": "malayalam",
        "man": "mandingue",
        "mar": "marathi",
        "mas": "massaï",
        "mdf": "moksha",
        "mdr": "mandar",
        "men": "mende (Sierra Léone)",
        "mga": "irlandais intermédiaire (900-1200)",
        "mic": "micmaque",
        "min": "minangkabau",
        "mis": "Langues non codées",
        "mkd": "macédonien",
        "mlg": "malgache",
        "mlt": "maltais",
        "mnc": "mandchou",
        "mni": "manipuri",
        "moh": "mohawk",
        "mon": "mongol",
        "mos": "mossi",
        "mri": "maori",
        "msa": "malais (macrolangue)",
        "mul": "Langues multiples",
        "mus": "creek",
        "mwl": "mirandais",
        "mwr": "marwari",
        "mya": "birman",
        "myv": "erzya",
        "nap": "napolitain",
        "nau": "nauru",
        "nav": "navajo",
        "nbl": "ndebele méridional",
        "nde": "ndebele septentrional",
        "ndo": "ndonga",
        "nds": "Allemand; Bas",
        "nep": "népalais",
        "new": "bhasa; Népal",
        "nia": "nias",
        "niu": "niuéen",
        "nld": "néerlandais",
        "nno": "norvégien nynorsk",
        "nob": "norvégien bokmål",
        "nog": "nogaï",
        "non": "norse ancien",
        "nor": "norvégien",
        "nqo": "n'Ko",
        "nso": "sotho septentrional",
        "nwc": "newari ancien",
        "nya": "nyanja",
        "nym": "nyamwezi",
        "nyn": "nyankole",
        "nyo": "nyoro",
        "nzi": "nzima",
        "oci": "occitan (après 1500)",
        "oji": "ojibwa",
        "ori": "oriya",
        "orm": "oromo",
        "osa": "osage",
        "oss": "ossétien",
        "ota": "turc ottoman (1500-1928)",
        "pag": "pangasinan",
        "pal": "pahlavi",
        "pam": "pampangan",
        "pan": "pendjabi",
        "pap": "papiamento",
        "pau": "palauéen",
        "peo": "perse ancien (environ 600-400 avant J.-C.)",
        "phn": "phénicien",
        "pli": "pali",
        "pol": "polonais",
        "pon": "pohnpeien",
        "por": "portugais",
        "pro": "provençal ancien (jusqu'à 1500)",
        "pus": "pushto",
        "que": "quechua",
        "raj": "rajasthani",
        "rap": "rapanui",
        "rar": "maori des Îles Cook",
        "roh": "romanche",
        "rom": "romany",
        "ron": "roumain",
        "run": "rundi",
        "rup": "macédo-roumain",
        "rus": "russe",
        "sad": "sandawe",
        "sag": "sango",
        "sah": "iakoute",
        "sam": "aramaïque samaritain",
        "san": "sanskrit",
        "sas": "sasak",
        "sat": "santali",
        "scn": "sicilien",
        "sco": "écossais",
        "sel": "selkup",
        "sga": "irlandais ancien (jusqu'à 900)",
        "shn": "shan",
        "sid": "sidamo",
        "sin": "sinhala",
        "slk": "slovaque",
        "slv": "slovène",
        "sma": "sami méridional",
        "sme": "sami septentrional",
        "smj": "sami de Lule",
        "smn": "sami d'Inari",
        "smo": "samoan",
        "sms": "sami de Skolt",
        "sna": "shona",
        "snd": "sindhi",
        "snk": "soninke",
        "sog": "sogdien",
        "som": "somali",
        "sot": "sotho méridional",
        "spa": "espagnol",
        "sqi": "albanais",
        "srd": "sarde",
        "srn": "sranan Tongo",
        "srp": "serbe",
        "srr": "serer",
        "ssw": "swati",
        "suk": "sukuma",
        "sun": "sundanais",
        "sus": "susu",
        "sux": "sumérien",
        "swa": "swahili (macrolangue)",
        "swe": "suédois",
        "syc": "syriaque classique",
        "syr": "syriaque",
        "tah": "tahitien",
        "tam": "tamoul",
        "tat": "tatar",
        "tel": "télougou",
        "tem": "timne",
        "ter": "tereno",
        "tet": "tetum",
        "tgk": "tadjik",
        "tgl": "tagalog",
        "tha": "thai",
        "tig": "tigre",
        "tir": "tigrigna",
        "tiv": "tiv",
        "tkl": "tokelau",
        "tlh": "klingon",
        "tli": "tlingit",
        "tmh": "tamacheq",
        "tog": "tonga (Nyasa)",
        "ton": "tonga (Îles Tonga)",
        "tpi": "tok Pisin",
        "tsi": "tsimshien",
        "tsn": "tswana",
        "tso": "tsonga",
        "tuk": "turkmène",
        "tum": "tumbuka",
        "tur": "turc",
        "tvl": "tuvalu",
        "twi": "twi",
        "tyv": "tuvinien",
        "udm": "udmurt",
        "uga": "ougaritique",
        "uig": "ouïghour",
        "ukr": "ukrainien",
        "umb": "umbundu",
        "und": "indéterminé",
        "urd": "ourdou",
        "uzb": "ouszbek",
        "vai": "vai",
        "ven": "venda",
        "vie": "vietnamien",
        "vol": "volapük",
        "vot": "votique",
        "wal": "wolaytta",
        "war": "waray (Philippines)",
        "was": "washo",
        "wln": "wallon",
        "wol": "wolof",
        "xal": "kalmouke",
        "xho": "xhosa",
        "yao": "yao",
        "yap": "yapese",
        "yid": "yiddish",
        "yor": "yoruba",
        "zap": "zapotèque",
        "zbl": "blissymbols",
        "zen": "zenaga",
        "zha": "zhuang",
        "zho": "chinois",
        "zul": "zoulou",
        "zun": "zuni",
        "zxx": "pas de contenu linguistique",
        "zza": "zaza"
    },
    "gl": {
        "abk": "Abjaziano",
        "ace": "Achinés",
        "ach": "Acolí",
        "ada": "Adangme",
        "ady": "Adigué",
        "aar": "Afar",
        "afh": "Afrihili",
        "afr": "Africáner",
        "ain": "Ainu (Xapón)",
        "aka": "Akan",
        "akk": "Acadio",
        "sqi": "Albanian",
        "ale": "Aleutiano",
        "amh": "Amhárico",
        "anp": "Angika",
        "ara": "Árabe",
        "arg": "Aragonés",
        "arp": "Arapaho",
        "arw": "Arawak",
        "hye": "Armenian",
        "asm": "Asamés",
        "ast": "Asturiano",
        "ava": "Avárico",
        "ave": "Avéstico",
        "awa": "Awadhi",
        "aym": "Aymara",
        "aze": "Acerbaixano",
        "ban": "Balinés",
        "bal": "Baluchi",
        "bam": "Bambara",
        "bas": "Basa (Camerún)",
        "bak": "Bashkir",
        "eus": "Vasco",
        "bej": "Beja",
        "bel": "Bielorruso",
        "bem": "Bemba (Zambia)",
        "ben": "Bengalí",
        "bit": "Berinomo",
        "bho": "Bhojpuri",
        "bik": "Bikol",
        "byn": "Bilin",
        "bin": "Bini",
        "bis": "Bislama",
        "zbl": "Símbolos Blis",
        "bos": "Bosnio",
        "bra": "Braj",
        "bre": "Bretón",
        "bug": "Buginés",
        "bul": "Búlgaro",
        "bua": "Buriat",
        "mya": "Birmano",
        "cad": "Caddo",
        "cat": "Catalán",
        "ceb": "Cebuano",
        "chg": "Chagatai",
        "cha": "Chamorro",
        "che": "Checheno",
        "chr": "Cherokee",
        "chy": "Cheyenne",
        "chb": "Chibcha",
        "zho": "Chinés",
        "chn": "Chinook; argot",
        "chp": "Chipewyan",
        "cho": "Choctaw",
        "cht": "Cholón",
        "chk": "Chuukese",
        "chv": "Chuvash",
        "cop": "Copto",
        "cor": "Cornish",
        "cos": "Corso",
        "cre": "Cree",
        "mus": "Creek",
        "hrv": "Croata",
        "ces": "Checo",
        "dak": "Dakota",
        "dan": "Danés",
        "dar": "Dargwa",
        "del": "Delaware",
        "div": "Dhivehi",
        "din": "Dinka",
        "doi": "Dogri (macrolingua)",
        "dgr": "Dogrib",
        "dua": "Duala",
        "nld": "Holandés",
        "dse": "Lingua de signos holandés",
        "dyu": "Dyula",
        "dzo": "Dzongkha",
        "efi": "Efik",
        "egy": "Exipcio (antigo)",
        "eka": "Ekajuk",
        "elx": "Elamita",
        "eng": "Inglés",
        "enu": "Enu",
        "myv": "Erzya",
        "epo": "Esperanto",
        "est": "Estonio",
        "ewe": "Ewe",
        "ewo": "Ewondo",
        "fan": "Fang (Guinea ecuatorial)",
        "fat": "Fanti",
        "fao": "Feroés",
        "fij": "Fixino",
        "fil": "Filipino",
        "fin": "Finés",
        "fon": "Fon",
        "fra": "Francés",
        "fur": "Friuliano",
        "ful": "Fulah",
        "gaa": "Ga",
        "glg": "Galego",
        "lug": "Ganda",
        "gay": "Gayo",
        "gba": "Gbaya (República centroafricana)",
        "hmj": "Ge",
        "gez": "Geez",
        "kat": "Xeorxiano",
        "deu": "Alemán",
        "gil": "Gilbertés",
        "gon": "Gondi",
        "gor": "Gorontalo",
        "got": "Gótico",
        "grb": "Grebo",
        "grn": "Guaraní",
        "guj": "Gujarati",
        "gwi": "Gwichʼin",
        "hai": "Haida",
        "hau": "Haussa",
        "haw": "Hawaiano",
        "heb": "Hebreo",
        "her": "Herero",
        "hil": "Hiligaynon",
        "hin": "Hindi",
        "hmo": "Hiri Motu",
        "hit": "Hitita",
        "hmn": "Hmong",
        "hun": "Húngaro",
        "hup": "Hupa",
        "iba": "Iban",
        "isl": "Islandés",
        "ido": "Ido",
        "ibo": "Igbo",
        "ilo": "Iloko",
        "ind": "Indonesio",
        "inh": "Ingush",
        "ina": "Interlingua (lingua internacional auxiliar)",
        "ile": "Interlingue",
        "iku": "Inuktitut",
        "ipk": "Inupiak",
        "gle": "Irlandés",
        "ita": "Italiano",
        "jpn": "Xaponés",
        "jav": "Xavanés",
        "jrb": "Xudeu-Árabe",
        "jpr": "Xudeu-Persa",
        "kbd": "Kabardian",
        "kab": "Kabyle",
        "kac": "Kachin",
        "kal": "Kalaallisut",
        "xal": "Kalmyk",
        "kam": "Kamba (Kenya)",
        "kan": "Kannada",
        "kau": "Kanuri",
        "kaa": "Kara-Kalpak",
        "krc": "Karachay-Balkar",
        "krl": "Karelian",
        "kas": "Kashmiri",
        "csb": "Kashubiano",
        "kaw": "Kawi",
        "kaz": "Kazako",
        "kha": "Khasi",
        "kho": "Khotanese",
        "kik": "Kikuyu",
        "kmb": "Kimbundu",
        "kin": "Kinyarwanda",
        "kir": "Kirghizo",
        "tlh": "Klingon",
        "kom": "Komi",
        "kon": "Kongo",
        "kok": "Konkani (macrolingua)",
        "kor": "Coreano",
        "kos": "Kosraeano",
        "kpe": "Kpelle",
        "kua": "Kuanyama",
        "kum": "Kumyk",
        "kur": "Kurdo",
        "kru": "Kurukh",
        "kut": "Kutenai",
        "lad": "Ladino",
        "lah": "Lahnda",
        "lam": "Lamba",
        "lao": "Laosiano",
        "lat": "Latín",
        "lav": "Letón",
        "lez": "Lezghiano",
        "lim": "Limburgués",
        "lin": "Lingala",
        "lit": "Lituano",
        "jbo": "Lojban",
        "loz": "Lozi",
        "lub": "Luba-Katanga",
        "lua": "Luba-Lulua",
        "lui": "Luiseno",
        "smj": "Sami Lule",
        "lun": "Lunda",
        "luo": "Luo (Kenia e Tanzania)",
        "lus": "Lushai",
        "ltz": "Luxemburgués",
        "mkd": "Macedonio",
        "mad": "Madurese",
        "mag": "Magahi",
        "mai": "Maithili",
        "mak": "Makasar",
        "mlg": "Malgache",
        "msa": "Malayo (macroLingua)",
        "mal": "Malayalamo",
        "mlt": "Maltés",
        "mnc": "Manchu",
        "mdr": "Mandar",
        "man": "Mandingo",
        "mni": "Manipuri",
        "glv": "Manx [Gaélico de Manx]",
        "mri": "Maorí",
        "arn": "Mapudungun",
        "mar": "Marath",
        "chm": "Mari (Rusia)",
        "mah": "Marshalés",
        "mwr": "Marwari",
        "mas": "Masai",
        "men": "Mende (Sierra Leone)",
        "mic": "Mi'kmaq",
        "min": "Minangkabau",
        "mwl": "Mirandés",
        "moh": "Mohawk",
        "mdf": "Moksha",
        "lol": "Mongo",
        "mon": "Mongolian",
        "mos": "Mossi",
        "mul": "Varios idiomas",
        "nqo": "N'Ko",
        "nau": "Naurí",
        "nav": "Navajo",
        "ndo": "Ndonga",
        "nap": "Neapolitano",
        "nia": "Nias",
        "niu": "Niués",
        "zxx": "Sen contido lingüístico",
        "nog": "Nogai",
        "nor": "Noruegués",
        "nob": "Noruego Bokmål",
        "nno": "Noruegués nynorsk",
        "nym": "Nyamwezi",
        "nya": "Nyanja",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Occitano (después de 1500)",
        "oji": "Ojibwa",
        "orm": "Oromo (Afan)",
        "osa": "Osage",
        "oss": "Osetio",
        "pal": "Pahlavi",
        "pau": "Palauan",
        "pli": "Pali",
        "pam": "Pampanga",
        "pag": "Pangasinan",
        "pan": "Punjabí",
        "pap": "Papiamento",
        "fas": "Persa",
        "phn": "Fenicio",
        "pon": "Pohnpeian",
        "pol": "Polaco",
        "por": "Portugués",
        "pus": "Pashtún",
        "que": "Quechúa",
        "raj": "Rajasthani",
        "rap": "Rapanui",
        "ron": "Romanés",
        "roh": "Romanche",
        "rom": "Romaní",
        "run": "Kiroundi",
        "rus": "Ruso",
        "smo": "Samoano",
        "sad": "Sandawe",
        "sag": "Sango",
        "san": "Sánscrito",
        "sat": "Santali",
        "srd": "Sardo",
        "sas": "Sasak",
        "sco": "Escocés",
        "sel": "Selkup",
        "srp": "Serbio",
        "srr": "Serer",
        "shn": "Shan",
        "sna": "Shona",
        "scn": "Siciliano",
        "sid": "Sidamo",
        "bla": "Siksika",
        "snd": "Sindhi",
        "sin": "Cingalés",
        "den": "Eslavo (Athapascan)",
        "slk": "Eslovaco",
        "slv": "Esloveno",
        "sog": "Sogdian",
        "som": "Somalí",
        "snk": "Soninke",
        "spa": "Español",
        "srn": "Sranan Tongo",
        "suk": "Sukuma",
        "sux": "Sumerio",
        "sun": "Sundanés",
        "sus": "Susu",
        "swa": "Swahili (macrolingua)",
        "ssw": "Siswati",
        "swe": "Sueco",
        "syr": "Syriac",
        "tgl": "Tagalo",
        "tah": "Tahitiano",
        "tgk": "Tajiko",
        "tmh": "Tamashek",
        "tam": "Tamil",
        "tat": "Tártaro",
        "tel": "Telougou",
        "ter": "Tereno",
        "tet": "Tetum",
        "tha": "Thai",
        "bod": "Tibetano",
        "tig": "Tigre",
        "tir": "Tigrinya",
        "tem": "Timne",
        "tiv": "Tiv",
        "tli": "Tlingit",
        "tpi": "Tok Pisin",
        "tkl": "Tokelau",
        "tog": "Tonga (Nyasa)",
        "ton": "Tonga (Islas Tonga)",
        "tsi": "Tsimshian",
        "tso": "Tsonga",
        "tsn": "Setchwana",
        "tum": "Tumbuka",
        "tur": "Turco",
        "tuk": "Turkmeno",
        "tvl": "Tuvalu",
        "tyv": "Tuvinian",
        "twi": "Tchi",
        "udm": "Udmurt",
        "uga": "Ugarítico",
        "uig": "Uiguro",
        "ukr": "Ucraíno",
        "umb": "Umbundu",
        "mis": "Idiomas no codificados",
        "und": "Sen determinar",
        "urd": "Urdu",
        "uzb": "Uzbeko",
        "vai": "Vai",
        "ven": "Venda",
        "vie": "Vietnamita",
        "vol": "Volapük",
        "vot": "Votic",
        "wln": "Valón",
        "war": "Waray (Filipinas)",
        "was": "Washo",
        "cym": "Galés",
        "wal": "Wolaytta",
        "wol": "Wolof",
        "xho": "Xhosa",
        "sah": "Yakut",
        "yao": "Yao",
        "yap": "Yapese",
        "yid": "Yiddish",
        "yor": "Yoruba",
        "zap": "Zapoteco",
        "zza": "Zaza",
        "zen": "Zenaga",
        "zha": "Zhuang",
        "zul": "Zulú",
        "zun": "Zuni"
    },
    "hu": {
        "aar": "Afar",
        "abk": "Abház",
        "ace": "Akinéz",
        "ach": "Acoli",
        "ada": "Adangme",
        "ady": "Adyghe",
        "afh": "Afrihili",
        "afr": "Afrikaans",
        "ain": "ainu (Japán)",
        "aka": "akan",
        "akk": "akkád",
        "ale": "aleut",
        "alt": "altáji; déli",
        "amh": "amhara",
        "ang": "angol; óangol (kb. 450-1100)",
        "anp": "angika",
        "ara": "arab",
        "arc": "arámi; hivatalos (i.e. 700- i.e. 300)",
        "arg": "aragóniai",
        "arn": "Mapudungun",
        "arp": "arapaho",
        "arw": "arawak",
        "asm": "asszámi",
        "ast": "Asturian",
        "ava": "avar",
        "ave": "avesztai",
        "awa": "avádi",
        "aym": "ajmara",
        "aze": "azeri",
        "bak": "baskír",
        "bal": "baluchi",
        "bam": "bambara",
        "ban": "balinéz",
        "bas": "Basa (Cameroon)",
        "bej": "beja",
        "bel": "belarusz",
        "bem": "Bemba (Zambia)",
        "ben": "bengáli",
        "bho": "bhodzspuri",
        "bik": "bikol",
        "bin": "bini",
        "bis": "biszlama",
        "bit": "Berinomo",
        "bla": "szikszika",
        "bod": "tibeti",
        "bos": "bosnyák",
        "bra": "bradzs",
        "bre": "breton",
        "bua": "burját",
        "bug": "buginéz",
        "bul": "bolgár",
        "byn": "Bilin",
        "cad": "caddo",
        "car": "Carib; Galibi",
        "cat": "katalán",
        "ceb": "cebuano",
        "ces": "cseh",
        "cha": "csamorro",
        "chb": "csibcsa",
        "che": "csecsen",
        "chg": "chagati",
        "chk": "csukéz",
        "chm": "Mari (Russia)",
        "chn": "chinook zsargon",
        "cho": "csoktó",
        "chp": "csippeva",
        "chr": "cserokí",
        "cht": "Cholón",
        "chu": "szláv; ószláv",
        "chv": "csuvas",
        "chy": "csejen",
        "cop": "kopt",
        "cor": "cornwalli",
        "cos": "korzikai",
        "cre": "cree",
        "crh": "Turkish; Crimean",
        "csb": "kasubi",
        "cym": "velszi",
        "dak": "dakota",
        "dan": "dán",
        "dar": "dargwa",
        "del": "delavár",
        "den": "Szolga (atapaszkán)",
        "deu": "német",
        "dgr": "dogrib",
        "din": "dinka",
        "div": "Dhivehi",
        "doi": "Dogri (macrolanguage)",
        "dsb": "Sorbian; Lower",
        "dse": "Dutch Sign Language",
        "dua": "duala",
        "dum": "Dutch; Middle (ca. 1050-1350)",
        "dyu": "djula",
        "dzo": "dzongka",
        "efi": "efik",
        "egy": "óegyiptomi",
        "eka": "ekajuk",
        "ell": "modern görög (1453-)",
        "elx": "elamita",
        "eng": "angol",
        "enm": "angol; középkori (1100-1500)",
        "enu": "Enu",
        "epo": "eszperantó",
        "est": "észt",
        "eus": "Baszk",
        "ewe": "ewe",
        "ewo": "ewondo",
        "fan": "Fang (Equatorial Guinea)",
        "fao": "Feröeri",
        "fas": "perzsa",
        "fat": "fanti",
        "fij": "fidzsi",
        "fil": "Filipino",
        "fin": "finn",
        "fon": "fon",
        "fra": "francia",
        "frm": "French; Middle (ca. 1400-1600)",
        "fro": "francia; ófrancia (842- kb. 1400)",
        "frr": "Frisian; Northern",
        "frs": "Frisian; Eastern",
        "fry": "Frisian; Western",
        "ful": "fula",
        "fur": "friul",
        "gaa": "ga",
        "gay": "gajo",
        "gba": "Gbaya (Central African Republic)",
        "gez": "gíz",
        "gil": "gilberti",
        "gla": "Gaelic; Scottish",
        "gle": "ír",
        "glg": "galíciai",
        "glv": "manx",
        "gmh": "German; Middle High (ca. 1050-1500)",
        "goh": "német; ónémet (kb. 750-1050)",
        "gon": "gondi",
        "gor": "gorontalo",
        "got": "gót",
        "grb": "grebo",
        "grc": "ógörög (1453-ig)",
        "grn": "guarani",
        "gsw": "German; Swiss",
        "guj": "gudzsarati",
        "gwi": "Gwichʼin",
        "hai": "haida",
        "hat": "Creole; Haitian",
        "hau": "hausza",
        "haw": "hawaii",
        "heb": "héber",
        "her": "herero",
        "hil": "hiligajnon",
        "hin": "hindi",
        "hit": "hettita",
        "hmj": "Ge",
        "hmn": "hmong",
        "hmo": "hiri motu",
        "hrv": "horvát",
        "hsb": "Sorbian; Upper",
        "hun": "Magyar",
        "hup": "hupa",
        "hye": "örmény",
        "iba": "iba",
        "ibo": "igbo",
        "ido": "ido",
        "iii": "Yi; Sichuan",
        "iku": "inuktitut",
        "ile": "interlingva",
        "ilo": "iloko",
        "ina": "interlingva (Nemzetközi Segédnyelv Egyesület)",
        "ind": "indonéz",
        "inh": "ingus",
        "ipk": "inupiak",
        "isl": "izlandi",
        "ita": "olasz",
        "jav": "jávai",
        "jbo": "lodzsban",
        "jpn": "japán",
        "jpr": "judeo-perzsa",
        "jrb": "judeo-arab",
        "kaa": "kara-kalpak",
        "kab": "kabile",
        "kac": "kachin",
        "kal": "Kalaallisut",
        "kam": "Kamba (Kenya)",
        "kan": "kannada",
        "kas": "kasmíri",
        "kat": "grúz",
        "kau": "kanuri",
        "kaw": "kawi",
        "kaz": "kazah",
        "kbd": "kabardi",
        "kha": "kazi",
        "khm": "Khmer; Central",
        "kho": "kotáni",
        "kik": "kikuyu",
        "kin": "kinyarwanda",
        "kir": "kirgiz",
        "kmb": "kimbundu",
        "kok": "Konkani (macrolanguage)",
        "kom": "komi",
        "kon": "kongo",
        "kor": "koreai",
        "kos": "koszrai",
        "kpe": "kpelle",
        "krc": "karacsai-balkar",
        "krl": "kareliai",
        "kru": "kuruk",
        "kua": "kuanyama",
        "kum": "kumyk",
        "kur": "kurd",
        "kut": "kutenai",
        "lad": "ladino",
        "lah": "landa",
        "lam": "lamba",
        "lao": "lao",
        "lat": "latin",
        "lav": "lett",
        "lez": "lezgi",
        "lim": "Limburgan",
        "lin": "lingala",
        "lit": "litván",
        "lol": "mongo",
        "loz": "lozi",
        "ltz": "Luxembourgish",
        "lua": "luba-lulua",
        "lub": "luba-katanga",
        "lug": "ganda",
        "lui": "luisendo",
        "lun": "lunda",
        "luo": "luo (Kenya és Tanzánia)",
        "lus": "lushai",
        "mad": "maduri",
        "mag": "magahi",
        "mah": "Marshallese",
        "mai": "maithili",
        "mak": "makasar",
        "mal": "malajalam",
        "man": "mandingo",
        "mar": "marathi",
        "mas": "maszáj",
        "mdf": "moksa",
        "mdr": "mandar",
        "men": "Mende (Sierra Leone)",
        "mga": "közép-ír (900-1200)",
        "mic": "Mi'kmaq",
        "min": "minangkabau",
        "mis": "Uncoded languages",
        "mkd": "macedón",
        "mlg": "malagasy",
        "mlt": "máltai",
        "mnc": "manchu",
        "mni": "manipuri",
        "moh": "mohawk",
        "mon": "mongol",
        "mos": "mossi",
        "mri": "maori",
        "msa": "Malay (macrolanguage)",
        "mul": "több nyelv",
        "mus": "creek",
        "mwl": "mirandese",
        "mwr": "marwari",
        "mya": "burmai",
        "myv": "erzija",
        "nap": "nápolyi",
        "nau": "nauru",
        "nav": "Navajo",
        "nbl": "ndebele (déli)",
        "nde": "ndebele (északi)",
        "ndo": "ndonga",
        "nds": "German; Low",
        "nep": "nepáli",
        "new": "Bhasa; Nepal",
        "nia": "nias",
        "niu": "niuei",
        "nld": "holland",
        "nno": "norvég (nynorsk)",
        "nob": "Norwegian Bokmål",
        "nog": "nogai",
        "non": "norvég; ónorvég",
        "nor": "norvég",
        "nqo": "N'Ko",
        "nso": "sotho (északi)",
        "nwc": "newari; ónewari",
        "nya": "Nyanja",
        "nym": "nyamwezi",
        "nyn": "nyankole",
        "nyo": "nyoro",
        "nzi": "nzima",
        "oci": "Occitan (post 1500)",
        "oji": "odzsibwa",
        "ori": "orija",
        "orm": "oromo",
        "osa": "oszage",
        "oss": "Ossetian",
        "ota": "török (ottomán) (1500-1928)",
        "pag": "pangasini",
        "pal": "pahlavi",
        "pam": "pampanga",
        "pan": "Panjabi",
        "pap": "papiamento",
        "pau": "palaui",
        "peo": "Persian; Old (ca. 600-400 B.C.)",
        "phn": "főníciai",
        "pli": "pali",
        "pol": "lengyel",
        "pon": "ponpei",
        "por": "portugál",
        "pro": "provanszál; ó (1500-ig)",
        "pus": "pushto",
        "que": "kecsua",
        "raj": "radzsasztani",
        "rap": "rapanui",
        "rar": "Maori; Cook Islands",
        "roh": "Romansh",
        "rom": "roma",
        "ron": "román",
        "run": "rundi",
        "rup": "Romanian; Macedo-",
        "rus": "orosz",
        "sad": "sandawe",
        "sag": "szango",
        "sah": "jakut",
        "sam": "arámi; szamaritánus",
        "san": "szankszrit",
        "sas": "szaszak",
        "sat": "szantáli",
        "scn": "friuli",
        "sco": "skót",
        "sel": "szelkup",
        "sga": "ír; óír (900-ig)",
        "shn": "shan",
        "sid": "szidamo",
        "sin": "Sinhala",
        "slk": "szlovák",
        "slv": "szlovén",
        "sma": "Sami; Southern",
        "sme": "Sami; Northern",
        "smj": "lule szami",
        "smn": "Sami; Inari",
        "smo": "szamoai",
        "sms": "Sami; Skolt",
        "sna": "shona",
        "snd": "szindi",
        "snk": "soninke",
        "sog": "sogdi",
        "som": "szomáli",
        "sot": "sotho; déli",
        "spa": "spanyol",
        "sqi": "albán",
        "srd": "szardíniai",
        "srn": "Sranan Tongo",
        "srp": "szerb",
        "srr": "serer",
        "ssw": "swati",
        "suk": "sukuma",
        "sun": "szundanéz",
        "sus": "susu",
        "sux": "sumér",
        "swa": "Swahili (macrolanguage)",
        "swe": "svéd",
        "syc": "Syriac; Classical",
        "syr": "szír",
        "tah": "tahiti",
        "tam": "tamil",
        "tat": "tatár",
        "tel": "telugu",
        "tem": "timne",
        "ter": "tereno",
        "tet": "tetum",
        "tgk": "tadzsik",
        "tgl": "tagalog",
        "tha": "thai",
        "tig": "tigre",
        "tir": "tigrinya",
        "tiv": "tiv",
        "tkl": "tokelau",
        "tlh": "Klingon",
        "tli": "tlingit",
        "tmh": "tamasek",
        "tog": "tonga (nyasza)",
        "ton": "tonga (Tonga-szigetek)",
        "tpi": "tok pisin",
        "tsi": "cimsi",
        "tsn": "tswana",
        "tso": "tsonga",
        "tuk": "türkmén",
        "tum": "tumbuka",
        "tur": "török",
        "tvl": "tuvalu",
        "twi": "twi",
        "tyv": "tuvini",
        "udm": "udmurt",
        "uga": "uragi",
        "uig": "ujgur",
        "ukr": "ukrán",
        "umb": "umbundu",
        "und": "ismeretlen",
        "urd": "urdu",
        "uzb": "üzbég",
        "vai": "vai",
        "ven": "venda",
        "vie": "vietnami",
        "vol": "volapük",
        "vot": "vót",
        "wal": "Wolaytta",
        "war": "Waray (Philippines)",
        "was": "washo",
        "wln": "vallon",
        "wol": "wolof",
        "xal": "Kalmyk",
        "xho": "xhosa",
        "yao": "yao",
        "yap": "jap",
        "yid": "jiddis",
        "yor": "joruba",
        "zap": "Zapoték",
        "zbl": "Blissymbols",
        "zen": "zenaga",
        "zha": "zsuang",
        "zho": "kínai",
        "zul": "Zulu",
        "zun": "zuni",
        "zxx": "No linguistic content",
        "zza": "Zaza"
    },
    "id": {
        "abk": "Abkhazian",
        "ace": "Achinese",
        "ach": "Acoli",
        "ada": "Adangme",
        "ady": "Adyghe",
        "aar": "Afar",
        "afh": "Afrihili",
        "afr": "Afrika",
        "ain": "Ainu (Japan)",
        "aka": "Akan",
        "akk": "Akkadian",
        "sqi": "Albanian",
        "ale": "Aleut",
        "amh": "Amharic",
        "anp": "Angika",
        "ara": "Arab",
        "arg": "Aragonese",
        "arp": "Arapaho",
        "arw": "Arawak",
        "hye": "Armenia",
        "asm": "Assam",
        "ast": "Asturian",
        "ava": "Avaric",
        "ave": "Avestan",
        "awa": "Awadhi",
        "aym": "Aymara",
        "aze": "Azerbaijani",
        "ban": "Balinese",
        "bal": "Baluchi",
        "bam": "Bambara",
        "bas": "Basa (Cameroon)",
        "bak": "Bashkir",
        "eus": "Basque",
        "bej": "Beja",
        "bel": "Belarusian",
        "bem": "Bemba (Zambia)",
        "ben": "Bengal",
        "bit": "Berinomo",
        "bho": "Bhojpuri",
        "bik": "Bikol",
        "byn": "Bilin",
        "bin": "Bini",
        "bis": "Bislama",
        "zbl": "Blissymbols",
        "bos": "Bosnian",
        "bra": "Braj",
        "bre": "Breton",
        "bug": "Bugis",
        "bul": "Bulgaria",
        "bua": "Buriat",
        "mya": "Burma",
        "cad": "Caddo",
        "cat": "Catalan",
        "ceb": "Cebuano",
        "chg": "Chagatai",
        "cha": "Chamorro",
        "che": "Chechen",
        "chr": "Cherokee",
        "chy": "Cheyenne",
        "chb": "Chibcha",
        "zho": "Cina",
        "chn": "Chinook jargon",
        "chp": "Chipewyan",
        "cho": "Choctaw",
        "cht": "Cholón",
        "chk": "Chuukese",
        "chv": "Chuvash",
        "cop": "Koptik",
        "cor": "Cornish",
        "cos": "Corsican",
        "cre": "Cree",
        "mus": "Creek",
        "hrv": "Kroasia",
        "ces": "Ceko",
        "dak": "Dakota",
        "dan": "Denmark",
        "dar": "Dargwa",
        "del": "Delaware",
        "div": "Dhivehi",
        "din": "Dinka",
        "doi": "Dogri (macrolanguage)",
        "dgr": "Dogrib",
        "dua": "Duala",
        "nld": "Belanda",
        "dse": "Dutch Sign Language",
        "dyu": "Dyula",
        "dzo": "Dzongkha",
        "efi": "Efik",
        "egy": "Mesir Kuno",
        "eka": "Ekajuk",
        "elx": "Elamite",
        "eng": "Inggris",
        "enu": "Enu",
        "myv": "Erzya",
        "epo": "Esperanto",
        "est": "Estonia",
        "ewe": "Ewe",
        "ewo": "Ewondo",
        "fan": "Fang (Equatorial Guinea)",
        "fat": "Fanti",
        "fao": "Faro",
        "fij": "Fiji",
        "fil": "Filipino",
        "fin": "Finlandia",
        "fon": "Fon",
        "fra": "Prancis",
        "fur": "Friulian",
        "ful": "Fulah",
        "gaa": "Ga",
        "glg": "Galician",
        "lug": "Ganda",
        "gay": "Gayo",
        "gba": "Gbaya (Central African Republic)",
        "hmj": "Ge",
        "gez": "Geez",
        "kat": "Georgian",
        "deu": "Jerman",
        "gil": "Gilbertese",
        "gon": "Gondi",
        "gor": "Gorontalo",
        "got": "Gothik",
        "grb": "Grebo",
        "grn": "Guarani",
        "guj": "Gujarati",
        "gwi": "Gwichʼin",
        "hai": "Haida",
        "hau": "Hausa",
        "haw": "Hawaii",
        "heb": "Israel",
        "her": "Herero",
        "hil": "Hiligaynon",
        "hin": "Hindi",
        "hmo": "Hiri Motu",
        "hit": "Hittite",
        "hmn": "Hmong",
        "hun": "Hungaria",
        "hup": "Hupa",
        "iba": "Iban",
        "isl": "Islandia",
        "ido": "Ido",
        "ibo": "Igbo",
        "ilo": "Iloko",
        "ind": "Bahasa Indonesia",
        "inh": "Ingush",
        "ina": "Interlingua (International Auxiliary Language Association)",
        "ile": "Interlingue",
        "iku": "Inuktitut",
        "ipk": "Inupiaq",
        "gle": "Irlandia",
        "ita": "Italia",
        "jpn": "Jepang",
        "jav": "Javanese",
        "jrb": "Judeo-Arabic",
        "jpr": "Judeo-Persian",
        "kbd": "Kabardian",
        "kab": "Kabyle",
        "kac": "Kachin",
        "kal": "Kalaallisut",
        "xal": "Kalmyk",
        "kam": "Kamba (Kenya)",
        "kan": "Kannada",
        "kau": "Kanuri",
        "kaa": "Kara-Kalpak",
        "krc": "Karachay-Balkar",
        "krl": "Karelian",
        "kas": "Kashmir",
        "csb": "Kashubian",
        "kaw": "Kawi",
        "kaz": "Kazakh",
        "kha": "Khasi",
        "kho": "Khotanese",
        "kik": "Kikuyu",
        "kmb": "Kimbundu",
        "kin": "Kinyarwanda",
        "kir": "Kirghiz",
        "tlh": "Klingon",
        "kom": "Komi",
        "kon": "Kongo",
        "kok": "Konkani (macrolanguage)",
        "kor": "Korea",
        "kos": "Kosraean",
        "kpe": "Kpelle",
        "kua": "Kuanyama",
        "kum": "Kumyk",
        "kur": "Kurdish",
        "kru": "Kurukh",
        "kut": "Kutenai",
        "lad": "Ladino",
        "lah": "Lahnda",
        "lam": "Lamba",
        "lao": "Lao",
        "lat": "Latin",
        "lav": "Latvian",
        "lez": "Lezghian",
        "lim": "Limburgan",
        "lin": "Lingala",
        "lit": "Lithuania",
        "jbo": "Lojban",
        "loz": "Lozi",
        "lub": "Luba-Katanga",
        "lua": "Luba-Lulua",
        "lui": "Luiseno",
        "smj": "Lule Sami",
        "lun": "Lunda",
        "luo": "Luo (Kenya and Tanzania)",
        "lus": "Lushai",
        "ltz": "Luxembourgish",
        "mkd": "Masedonian",
        "mad": "Madurese",
        "mag": "Magahi",
        "mai": "Maithili",
        "mak": "Makasar",
        "mlg": "Malagasi",
        "msa": "Malay (macrolanguage)",
        "mal": "Malayalam",
        "mlt": "Maltese",
        "mnc": "Manchu",
        "mdr": "Mandar",
        "man": "Mandingo",
        "mni": "Manipuri",
        "glv": "Manx",
        "mri": "Maori",
        "arn": "Mapudungun",
        "mar": "Marathi",
        "chm": "Mari (Russia)",
        "mah": "Marshallese",
        "mwr": "Marwari",
        "mas": "Masai",
        "men": "Mende (Sierra Leone)",
        "mic": "Mi'kmaq",
        "min": "Minangkabau",
        "mwl": "Mirandese",
        "moh": "Mohawk",
        "mdf": "Moksha",
        "lol": "Mongo",
        "mon": "Mongolian",
        "mos": "Mossi",
        "mul": "Multiple languages",
        "nqo": "N'Ko",
        "nau": "Nauru",
        "nav": "Navajo",
        "ndo": "Ndonga",
        "nap": "Neapolitan",
        "nia": "Nias",
        "niu": "Niuean",
        "zxx": "No linguistic content",
        "nog": "Nogai",
        "nor": "Norwegian",
        "nob": "Norwegian Bokmål",
        "nno": "Norwegian Nynorsk",
        "nym": "Nyamwezi",
        "nya": "Nyanja",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Occitan (post 1500)",
        "oji": "Ojibwa",
        "orm": "Oromo",
        "osa": "Osage",
        "oss": "Ossetian",
        "pal": "Pahlavi",
        "pau": "Palauan",
        "pli": "Pali",
        "pam": "Pampanga",
        "pag": "Pangasinan",
        "pan": "Panjabi",
        "pap": "Papiamento",
        "fas": "Persian",
        "phn": "Phoenician",
        "pon": "Pohnpeian",
        "pol": "Polandia",
        "por": "Portugis",
        "pus": "Pashto",
        "que": "Quechua",
        "raj": "Rajasthani",
        "rap": "Rapanui",
        "ron": "Rumania",
        "roh": "Romansh",
        "rom": "Romany",
        "run": "Rundi",
        "rus": "Rusia",
        "smo": "Samoan",
        "sad": "Sandawe",
        "sag": "Sango",
        "san": "Sanskrit",
        "sat": "Santali",
        "srd": "Sardinian",
        "sas": "Sasak",
        "sco": "Scots",
        "sel": "Selkup",
        "srp": "Serbia",
        "srr": "Serer",
        "shn": "Shan",
        "sna": "Shona",
        "scn": "Sicilian",
        "sid": "Sidamo",
        "bla": "Siksika",
        "snd": "Sindhi",
        "sin": "Sinhala",
        "den": "Slave (Athapascan)",
        "slk": "Slovakia",
        "slv": "Slovenia",
        "sog": "Sogdian",
        "som": "Somali",
        "snk": "Soninke",
        "spa": "Spanyol",
        "srn": "Sranan Tongo",
        "suk": "Sukuma",
        "sux": "Sumerian",
        "sun": "Sundan",
        "sus": "Susu",
        "swa": "Swahili (macrolanguage)",
        "ssw": "Swati",
        "swe": "Swedia",
        "syr": "Syriac",
        "tgl": "Tagalog",
        "tah": "Tahitian",
        "tgk": "Tajik",
        "tmh": "Tamashek",
        "tam": "Tamil",
        "tat": "Tatar",
        "tel": "Telugu",
        "ter": "Tereno",
        "tet": "Tetum",
        "tha": "Thailand",
        "bod": "Tibet",
        "tig": "Tigre",
        "tir": "Tigrinya",
        "tem": "Timne",
        "tiv": "Tiv",
        "tli": "Tlingit",
        "tpi": "Tok Pisin",
        "tkl": "Tokelau",
        "tog": "Tonga (Nyasa)",
        "ton": "Tonga (Tonga Islands)",
        "tsi": "Tsimshian",
        "tso": "Tsonga",
        "tsn": "Tswana",
        "tum": "Tumbuka",
        "tur": "Turki",
        "tuk": "Turkmen",
        "tvl": "Tuvalu",
        "tyv": "Tuvinian",
        "twi": "Twi",
        "udm": "Udmurt",
        "uga": "Ugaritic",
        "uig": "Uighur",
        "ukr": "Ukrainian",
        "umb": "Umbundu",
        "mis": "Uncoded languages",
        "und": "Undetermined",
        "urd": "Urdu",
        "uzb": "Uzbek",
        "vai": "Vai",
        "ven": "Venda",
        "vie": "Vietnamese",
        "vol": "Volapük",
        "vot": "Votic",
        "wln": "Wallon",
        "war": "Waray (Philippines)",
        "was": "Washo",
        "cym": "Welsh",
        "wal": "Wolaytta",
        "wol": "Wolof",
        "xho": "Xhosa",
        "sah": "Yakut",
        "yao": "Yao",
        "yap": "Yapese",
        "yid": "Yiddish",
        "yor": "Yoruba",
        "zap": "Zapotec",
        "zza": "Zaza",
        "zen": "Zenaga",
        "zha": "Zhuang",
        "zul": "Zulu",
        "zun": "Zuni"
    },
    "it": {
        "aar": "Afar",
        "abk": "Abkhazian",
        "ace": "Achinese",
        "ach": "Acoli",
        "ada": "Adangme",
        "ady": "Adyghe",
        "afh": "Afrihili",
        "afr": "Afrikaans",
        "ain": "Ainu (Giappone)",
        "aka": "Akan",
        "akk": "Accadico",
        "ale": "Aleut",
        "alt": "Altai meridionale",
        "amh": "Amarico",
        "ang": "Inglese antico (ca. 450-1100)",
        "anp": "Angika",
        "ara": "Arabo",
        "arc": "Aramaico ufficiale (700-300 p.e.v.)",
        "arg": "Aragonese",
        "arn": "Mapudungun",
        "arp": "Arapaho",
        "arw": "Arawak",
        "asm": "Assamese",
        "ast": "Asturiano",
        "ava": "Avarico",
        "ave": "Avestano",
        "awa": "Awadhi",
        "aym": "Aymara",
        "aze": "Azerbaijano",
        "bak": "Bashkir",
        "bal": "Baluchi",
        "bam": "Bambara",
        "ban": "Balinese",
        "bas": "Basa (Cameru)",
        "bej": "Beja",
        "bel": "Bielorusso",
        "bem": "Bemba (Zambia)",
        "ben": "Bengalese",
        "bho": "Bhojpuri",
        "bik": "bicol",
        "bin": "Bini",
        "bis": "bislama",
        "bit": "Berinomo",
        "bla": "Siksika",
        "bod": "Tibetano",
        "bos": "Bosniaco",
        "bra": "braj",
        "bre": "Bretone",
        "bua": "Buriat",
        "bug": "Buginese",
        "bul": "Bulgaro",
        "byn": "Bilin",
        "cad": "caddo",
        "car": "Carib (Galibi)",
        "cat": "Catalano",
        "ceb": "Cebuano",
        "ces": "Ceco",
        "cha": "Chamorro",
        "chb": "Chibcha",
        "che": "Chechen",
        "chg": "Ciagataico",
        "chk": "Chuukese",
        "chm": "Mari (Russia)",
        "chn": "Chinook jargon",
        "cho": "Choctaw",
        "chp": "Chipewyan",
        "chr": "Cherokee",
        "cht": "Cholón",
        "chu": "Slavo antico",
        "chv": "Chuvash",
        "chy": "Cheyenne",
        "cop": "Copto",
        "cor": "Cornish",
        "cos": "Corso",
        "cre": "Cree",
        "crh": "Turco; Crimeo",
        "csb": "kashubian",
        "cym": "Gallese",
        "dak": "Dakota",
        "dan": "Danese",
        "dar": "Dargwa",
        "del": "delaware",
        "den": "Slave (Athapascan)",
        "deu": "Tedesco",
        "dgr": "Dogrib",
        "din": "Dinca",
        "div": "Dhivehi",
        "doi": "Dogri (macrolingua)",
        "dsb": "Lusaziano inferiore",
        "dse": "Olandense (linguaggio dei segni)",
        "dua": "Duala",
        "dum": "Olandese medio (ca. 1050-1350)",
        "dyu": "Diula",
        "dzo": "Dzongkha",
        "efi": "Efik",
        "egy": "Egiziano antico",
        "eka": "Ekajuk",
        "ell": "Greco moderno (1453-)",
        "elx": "Elamitico",
        "eng": "Inglese",
        "enm": "Inglese medio (1100-1500)",
        "enu": "Enu",
        "epo": "Esperanto",
        "est": "Estone",
        "eus": "Basco",
        "ewe": "Ewe",
        "ewo": "Ewondo",
        "fan": "Fang (Guinea equatoriale)",
        "fao": "Faroese",
        "fas": "Persiano",
        "fat": "Fanti",
        "fij": "Figiano",
        "fil": "Filippino",
        "fin": "Finlandese",
        "fon": "Fon",
        "fra": "Francese",
        "frm": "Francese medio (ca. 1400-1600)",
        "fro": "Francese antico (842-ca. 1400)",
        "frr": "Frisone settentrionale",
        "frs": "Frisone orientale",
        "fry": "Frisone occidentale",
        "ful": "Fulah",
        "fur": "Friulano",
        "gaa": "ga",
        "gay": "gayo",
        "gba": "Gbaya (Repubblica centro africana)",
        "gez": "Geez",
        "gil": "Gilbertese",
        "gla": "Gaelico (Scozzese)",
        "gle": "Gaelico",
        "glg": "Galiziano",
        "glv": "Manx",
        "gmh": "Tedesco medio alto (ca. 1050-1500)",
        "goh": "Tedesco antico alto (ca. 750-1050)",
        "gon": "Gondi",
        "gor": "Gorontalo",
        "got": "Gotico",
        "grb": "Grebo",
        "grc": "Greco antico (fino al 1453)",
        "grn": "Guarani",
        "gsw": "Tedesco (Svizzera)",
        "guj": "Gujarati",
        "gwi": "Gwichʼin",
        "hai": "Haida",
        "hat": "Creolo (Haitiano)",
        "hau": "Hausa",
        "haw": "hawaiano",
        "heb": "Ebraico",
        "her": "Herero",
        "hil": "Hiligayna",
        "hin": "Hindi",
        "hit": "hittite",
        "hmj": "Ge",
        "hmn": "Hmong",
        "hmo": "Hiri motu",
        "hrv": "Croato",
        "hsb": "Lusaziano superiore",
        "hun": "Ungherese",
        "hup": "Hupa",
        "hye": "armeno",
        "iba": "Iban",
        "ibo": "Igbo",
        "ido": "Ido",
        "iii": "Yi; Sichuan",
        "iku": "inuktitut",
        "ile": "Interlingua",
        "ilo": "Ilocano",
        "ina": "Interlingua (International Auxiliary Language Association)",
        "ind": "Indonesiano",
        "inh": "Ingush",
        "ipk": "Inupiaq",
        "isl": "Islandese",
        "ita": "Italiano",
        "jav": "Javanese",
        "jbo": "lojban",
        "jpn": "Giapponese",
        "jpr": "Giudeo-persiano",
        "jrb": "Giudeo-arabo",
        "kaa": "Kara-Kalpak",
        "kab": "Kabyle",
        "kac": "Kachin",
        "kal": "Kalaallisut",
        "kam": "Kamba (Kenya)",
        "kan": "kannada",
        "kas": "kashmiri",
        "kat": "Georgiano",
        "kau": "Kanuri",
        "kaw": "Kawi",
        "kaz": "Kazako",
        "kbd": "Kabardia",
        "kha": "Khasi",
        "khm": "Khmer centrale",
        "kho": "Khotanese",
        "kik": "Kikuyu",
        "kin": "Kinyarwanda",
        "kir": "Kirghiso",
        "kmb": "Kimbundu",
        "kok": "Konkani (macrolinguaggio)",
        "kom": "Komi",
        "kon": "Kongo",
        "kor": "Coreano",
        "kos": "Kosraean",
        "kpe": "Kpelle",
        "krc": "karachay-Balkar",
        "krl": "Karelian",
        "kru": "Kurukh",
        "kua": "Kuanyama",
        "kum": "kumyk",
        "kur": "Curdo",
        "kut": "kutenai",
        "lad": "Ladino",
        "lah": "lahnda",
        "lam": "Lamba",
        "lao": "Lao",
        "lat": "Latino",
        "lav": "Lettone",
        "lez": "Lezghian",
        "lim": "Limburgan",
        "lin": "Lingala",
        "lit": "Lituano",
        "lol": "Mongo",
        "loz": "lozi",
        "ltz": "Lussemburghese",
        "lua": "Luba-lulua",
        "lub": "Luba-katanga",
        "lug": "Ganda",
        "lui": "Luiseno",
        "lun": "Lunda",
        "luo": "Luo (Kenya e Tanzania)",
        "lus": "Lushai",
        "mad": "Madurese",
        "mag": "Magahi",
        "mah": "Marshallese",
        "mai": "Maithili",
        "mak": "Makasar",
        "mal": "Malayalam",
        "man": "Mandingo",
        "mar": "Marathi",
        "mas": "Masai",
        "mdf": "Moksha",
        "mdr": "Mandar",
        "men": "Mende (Sierra Leone)",
        "mga": "Irlandese medio (900-1200)",
        "mic": "Mi'kmaq",
        "min": "Minangkabau",
        "mis": "Lingue non codificate",
        "mkd": "Macedone",
        "mlg": "malagasy",
        "mlt": "Maltese",
        "mnc": "Manchu",
        "mni": "Manipuri",
        "moh": "mohawk",
        "mon": "Mongolo",
        "mos": "Mossi",
        "mri": "Maori",
        "msa": "Malay (macrolingua)",
        "mul": "Lingue multiple",
        "mus": "Creek",
        "mwl": "Mirandese",
        "mwr": "Marwari",
        "mya": "Burmese",
        "myv": "Erzya",
        "nap": "Napoletano",
        "nau": "Nauru",
        "nav": "Navajo",
        "nbl": "Ndebele del Sud",
        "nde": "Ndebele del Nord",
        "ndo": "Ndonga",
        "nds": "Tedesco; Volgare",
        "nep": "Nepali",
        "new": "Bhasa; Nepal",
        "nia": "Nias",
        "niu": "Niuean",
        "nld": "Olandese",
        "nno": "Norvegese nynorsk",
        "nob": "Norvegese bokmål",
        "nog": "Nogai",
        "non": "Norse antico",
        "nor": "Norvegese",
        "nqo": "N'Ko",
        "nso": "Sotho settentrionale",
        "nwc": "Newari antico",
        "nya": "Nyanja",
        "nym": "Nyamwezi",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Occitan (post 1500)",
        "oji": "Ojibwa",
        "ori": "Oriya",
        "orm": "Oromo",
        "osa": "Osage",
        "oss": "Ossetian",
        "ota": "Turco ottomano (1500-1928)",
        "pag": "Pangasinan",
        "pal": "Pahlavi",
        "pam": "pampanga",
        "pan": "Panjabi",
        "pap": "Papiamento",
        "pau": "Palauan",
        "peo": "Persiano antico (ca. 600-400 A.C.)",
        "phn": "Fenicio",
        "pli": "Pali",
        "pol": "Polacco",
        "pon": "Pohnpeian",
        "por": "Portoghese",
        "pro": "Provençal antico (fino al 1500)",
        "pus": "Pushto",
        "que": "Quechua",
        "raj": "rajasthani",
        "rap": "Rapanui",
        "rar": "Maori (Isole Cook)",
        "roh": "Romansh",
        "rom": "Romany",
        "ron": "Rumeno",
        "run": "Rundi",
        "rup": "Rumeno macedone",
        "rus": "Russo",
        "sad": "Sandawe",
        "sag": "Sango",
        "sah": "Yakut",
        "sam": "Aramaico samaritano",
        "san": "Sanscrito",
        "sas": "Sasak",
        "sat": "Santali",
        "scn": "Siciliano",
        "sco": "Scots",
        "sel": "Selkup",
        "sga": "Irlandese antico (fino al ’900)",
        "shn": "Shan",
        "sid": "Sidamo",
        "sin": "Sinhala",
        "slk": "Slovacco",
        "slv": "Sloveno",
        "sma": "Sami meridionale",
        "sme": "Sami settentrionale",
        "smj": "sami lule",
        "smn": "Sami; Inari",
        "smo": "Samoano",
        "sms": "Sami; Skolt",
        "sna": "Shona",
        "snd": "Sindhi",
        "snk": "Soninke",
        "sog": "Sogdian",
        "som": "Somali",
        "sot": "Sotho meridionale",
        "spa": "Spagnolo",
        "sqi": "Albanese",
        "srd": "Sardo",
        "srn": "Sranan Tongo",
        "srp": "Serbo",
        "srr": "Serer",
        "ssw": "Swati",
        "suk": "sukuma",
        "sun": "Sundanese",
        "sus": "Susu",
        "sux": "Sumero",
        "swa": "Swahili (macro-lingua)",
        "swe": "Svedese",
        "syc": "Siriaco classico",
        "syr": "Siriaco",
        "tah": "Tahitian",
        "tam": "Tamil",
        "tat": "Tatarico",
        "tel": "Telugu",
        "tem": "Temne",
        "ter": "Tereno",
        "tet": "Tetum",
        "tgk": "Tajik",
        "tgl": "Tagalog",
        "tha": "Thailandese",
        "tig": "Tigre",
        "tir": "Tigrinya",
        "tiv": "Tiv",
        "tkl": "Tokelau",
        "tlh": "Klingon",
        "tli": "Tlingit",
        "tmh": "Tamashek",
        "tog": "Tonga (Nyasa)",
        "ton": "Tonga (Isole Tonga)",
        "tpi": "Tok pisin",
        "tsi": "Tsimshian",
        "tsn": "Tswana",
        "tso": "Tsonga",
        "tuk": "Turkmeno",
        "tum": "Tumbuka",
        "tur": "Turco",
        "tvl": "Tuvalu",
        "twi": "Twi",
        "tyv": "Tuvinian",
        "udm": "Udmurt",
        "uga": "Ugaritico",
        "uig": "Uighuro",
        "ukr": "Ucraino",
        "umb": "Umbundu",
        "und": "Non determinato",
        "urd": "Urdu",
        "uzb": "Usbeco",
        "vai": "Vai",
        "ven": "venda",
        "vie": "Vietnamita",
        "vol": "Volapük",
        "vot": "Votic",
        "wal": "Wolaytta",
        "war": "Waray (Filippine)",
        "was": "Washo",
        "wln": "Walloon",
        "wol": "Wolof",
        "xal": "Kalmyk",
        "xho": "Xhosa",
        "yao": "Yao",
        "yap": "Yapese",
        "yid": "Yiddish",
        "yor": "Yoruba",
        "zap": "Zapoteco",
        "zbl": "Blissymbols",
        "zen": "Zenaga",
        "zha": "Zhuang",
        "zho": "Cinese",
        "zul": "Zulu",
        "zun": "Zuni",
        "zxx": "Nessun contenuto linguistico",
        "zza": "Zaza"
    },
    "ja": {
        "aar": "アファル語",
        "abk": "アブハジア語",
        "ace": "アチェー語",
        "ach": "アチョリ語",
        "ada": "アダングメ語",
        "ady": "Adyghe",
        "afh": "アフリヒリ",
        "afr": "アフリカーンス語",
        "ain": "Ainu (Japan)",
        "aka": "アカン語",
        "akk": "アッカド語",
        "ale": "アレウト語",
        "alt": "Altai; Southern",
        "amh": "アムハラ語",
        "ang": "English; Old (ca. 450-1100)",
        "anp": "アンギカ語",
        "ara": "アラビア語",
        "arc": "Aramaic; Official (700-300 BCE)",
        "arg": "アラゴン語",
        "arn": "Mapudungun",
        "arp": "アラパホー語",
        "arw": "アラワク語",
        "asm": "アッサム語",
        "ast": "Asturian",
        "ava": "アヴァル語",
        "ave": "アヴェスタ語",
        "awa": "アワディ語",
        "aym": "アイマラ語",
        "aze": "アゼルバイジャン語",
        "bak": "バシキール語",
        "bal": "バルーチー語",
        "bam": "バンバラ語",
        "ban": "バリ語",
        "bas": "Basa (Cameroon)",
        "bej": "ベジャ語",
        "bel": "白ロシア語",
        "bem": "Bemba (Zambia)",
        "ben": "ベンガル語",
        "bho": "ボージプリー語",
        "bik": "ビコル語",
        "bin": "ビニ語",
        "bis": "ビスラマ語",
        "bit": "Berinomo",
        "bla": "ブラックフット語",
        "bod": "チベット語",
        "bos": "ボスニア語",
        "bra": "ブラジ語",
        "bre": "ブルトン語",
        "bua": "ブリヤート語",
        "bug": "ブギ語",
        "bul": "ブルガリア語",
        "byn": "Bilin",
        "cad": "カドー語",
        "car": "Carib; Galibi",
        "cat": "カタロニア語",
        "ceb": "セブアノ語",
        "ces": "チェコ語",
        "cha": "チャモロ語",
        "chb": "チブチャ語",
        "che": "チェチェン語",
        "chg": "チャガタイ語",
        "chk": "チューク語",
        "chm": "Mari (Russia)",
        "chn": "チヌーク混成語",
        "cho": "チョクトー語",
        "chp": "チペワイアン語",
        "chr": "チェロキー語",
        "cht": "Cholón",
        "chu": "Slavonic; Old",
        "chv": "チュヴァシュ語",
        "chy": "シャイアン語",
        "cop": "コプト語",
        "cor": "コーンウォール語",
        "cos": "コルシカ語",
        "cre": "クリー語",
        "crh": "Turkish; Crimean",
        "csb": "カシュビアン語",
        "cym": "ウェールズ語",
        "dak": "ダコタ語",
        "dan": "デンマーク語",
        "dar": "ダルガン語",
        "del": "デラウェア語",
        "den": "スレーブ語 (アサパスカン語)",
        "deu": "ドイツ語",
        "dgr": "ドクリブ語",
        "din": "ディンカ語",
        "div": "Dhivehi",
        "doi": "Dogri (macrolanguage)",
        "dsb": "Sorbian; Lower",
        "dse": "Dutch Sign Language",
        "dua": "ドゥアラ語",
        "dum": "Dutch; Middle (ca. 1050-1350)",
        "dyu": "デュラ語",
        "dzo": "ゾンカ語",
        "efi": "エフィク語",
        "egy": "エジプト語 (古代)",
        "eka": "エカジュク語",
        "ell": "ギリシア語; 現代 (1453-)",
        "elx": "エラム語",
        "eng": "英語",
        "enm": "英語; 中世 (1100-1500)",
        "enu": "Enu",
        "epo": "エスペラント",
        "est": "エストニア語",
        "eus": "バスク語",
        "ewe": "エウェ語",
        "ewo": "エウォンド語",
        "fan": "Fang (Equatorial Guinea)",
        "fao": "フェロー語",
        "fas": "ペルシア語",
        "fat": "ファンティー語",
        "fij": "フィジー語",
        "fil": "Filipino",
        "fin": "フィン語",
        "fon": "フォン語",
        "fra": "フランス語",
        "frm": "French; Middle (ca. 1400-1600)",
        "fro": "French; Old (842-ca. 1400)",
        "frr": "Frisian; Northern",
        "frs": "Frisian; Eastern",
        "fry": "Frisian; Western",
        "ful": "フラ語",
        "fur": "フリウリ語",
        "gaa": "ガ語",
        "gay": "ガヨ語",
        "gba": "Gbaya (Central African Republic)",
        "gez": "ゲーズ語",
        "gil": "キリバス語",
        "gla": "Gaelic; Scottish",
        "gle": "アイルランド語",
        "glg": "Galician",
        "glv": "マン島語",
        "gmh": "German; Middle High (ca. 1050-1500)",
        "goh": "German; Old High (ca. 750-1050)",
        "gon": "ゴーンディー語",
        "gor": "ゴロンタロ語",
        "got": "ゴート語",
        "grb": "グレボ語",
        "grc": "ギリシア語; 古代 (-1453)",
        "grn": "グアラニー語",
        "gsw": "German; Swiss",
        "guj": "グジャラーティー語",
        "gwi": "Gwichʼin",
        "hai": "ハイダ語",
        "hat": "Creole; Haitian",
        "hau": "ハウサ語",
        "haw": "ハワイ語",
        "heb": "ヘブライ語",
        "her": "ヘレロ語",
        "hil": "ヒリジャノン語",
        "hin": "ヒンディー語",
        "hit": "ヒッタイト語",
        "hmj": "Ge",
        "hmn": "フモング語",
        "hmo": "ヒリモトゥ語",
        "hrv": "クロアチア語",
        "hsb": "Sorbian; Upper",
        "hun": "ハンガリー語",
        "hup": "アタパスカ語",
        "hye": "アルメニア語",
        "iba": "イバン語",
        "ibo": "イボ語",
        "ido": "イド語",
        "iii": "Yi; Sichuan",
        "iku": "イヌクチタット語",
        "ile": "インターリング",
        "ilo": "イロカノ語",
        "ina": "インターリングア語 (国際補助語協会)",
        "ind": "インドネシア語",
        "inh": "イングーシ語",
        "ipk": "イヌピアク語",
        "isl": "アイスランド語",
        "ita": "イタリア語",
        "jav": "ジャワ語",
        "jbo": "ロジバン語",
        "jpn": "日本語",
        "jpr": "ユダヤ・ペルシア語",
        "jrb": "ユダヤ・アラビア語",
        "kaa": "カラ・カルパク語",
        "kab": "カビル語",
        "kac": "カチン語",
        "kal": "Kalaallisut",
        "kam": "Kamba (Kenya)",
        "kan": "カンナダ語",
        "kas": "カシミーリー語",
        "kat": "グルジア語",
        "kau": "カヌリ語",
        "kaw": "カウィ語",
        "kaz": "カザーフ語",
        "kbd": "カバルダ語",
        "kha": "カシ語",
        "khm": "Khmer; Central",
        "kho": "ホータン語",
        "kik": "キクユ語",
        "kin": "キンヤルワンダ語",
        "kir": "キルギス語",
        "kmb": "キンブンドゥ語",
        "kok": "Konkani (macrolanguage)",
        "kom": "コミ語",
        "kon": "コンゴ語",
        "kor": "朝鮮語",
        "kos": "コスラエ語",
        "kpe": "クペレ語",
        "krc": "カラチャイ・バルカル語",
        "krl": "カレリア語",
        "kru": "クルク語",
        "kua": "クアニャマ語",
        "kum": "クミック語",
        "kur": "クルド語",
        "kut": "クテナイ語",
        "lad": "ラジノ語",
        "lah": "ラフンダー語",
        "lam": "ランバ語",
        "lao": "ラオ語",
        "lat": "ラテン語",
        "lav": "ラトヴィア語",
        "lez": "レズギ語",
        "lim": "Limburgan",
        "lin": "リンガラ語",
        "lit": "リトアニア語",
        "lol": "モンゴ語",
        "loz": "ロジ語",
        "ltz": "Luxembourgish",
        "lua": "ルバ・ルルア語",
        "lub": "ルバ語",
        "lug": "ガンダ語",
        "lui": "ルイセニョ語",
        "lun": "ランダ語",
        "luo": "ルオ語 (ケニアとタンザニア)",
        "lus": "ルシャイ語",
        "mad": "マドゥラ語",
        "mag": "マガヒ語",
        "mah": "Marshallese",
        "mai": "マイチリ語",
        "mak": "マカッサル語",
        "mal": "マラヤーラム語",
        "man": "マンディンゴ語",
        "mar": "マラーティー語",
        "mas": "マサイ語",
        "mdf": "モクシャ語",
        "mdr": "マンダル語",
        "men": "Mende (Sierra Leone)",
        "mga": "アイルランド語; 中世 (900-1200)",
        "mic": "Mi'kmaq",
        "min": "ミナンカバウ語",
        "mis": "Uncoded languages",
        "mkd": "マケドニア語",
        "mlg": "マラガシ語",
        "mlt": "マルタ語",
        "mnc": "満州語",
        "mni": "マニプル語",
        "moh": "モーホーク語",
        "mon": "蒙古語",
        "mos": "モッシー語",
        "mri": "マオリ語",
        "msa": "Malay (macrolanguage)",
        "mul": "多言語",
        "mus": "クリーク語",
        "mwl": "ミランド語",
        "mwr": "マルワリ語",
        "mya": "ビルマ語",
        "myv": "エルジャ語",
        "nap": "ナポリ語",
        "nau": "ナウル語",
        "nav": "Navajo",
        "nbl": "ヌデベレ語; 南",
        "nde": "マタベレ語; 北",
        "ndo": "ンドンガ語",
        "nds": "German; Low",
        "nep": "ネパール語",
        "new": "Bhasa; Nepal",
        "nia": "ニアス語",
        "niu": "ニウーエイ語",
        "nld": "オランダ語",
        "nno": "ニーノシュク・ノルウェー語",
        "nob": "Norwegian Bokmål",
        "nog": "ノガイ語",
        "non": "スカンジナビア語; 古期",
        "nor": "ノルウェー語",
        "nqo": "ンコ文字",
        "nso": "Sotho; Northern",
        "nwc": "Newari; Old",
        "nya": "Nyanja",
        "nym": "ムエジ語",
        "nyn": "ニャンコール語",
        "nyo": "ニョロ語",
        "nzi": "ンゼマ語",
        "oci": "Occitan (post 1500)",
        "oji": "オジブワ語",
        "ori": "オリヤー語",
        "orm": "オロモ語",
        "osa": "オーセージ語",
        "oss": "Ossetian",
        "ota": "トルコ語; オスマン (1500-1928)",
        "pag": "パンガシナーン語",
        "pal": "パーラヴィー語",
        "pam": "パンパンガ語",
        "pan": "Panjabi",
        "pap": "パピアメント",
        "pau": "パラオ語",
        "peo": "Persian; Old (ca. 600-400 B.C.)",
        "phn": "フェニキア語",
        "pli": "パーリ語",
        "pol": "ポーランド語",
        "pon": "ポナペ語",
        "por": "ポルトガル語",
        "pro": "プロヴァンス語; 古期 (-1500)",
        "pus": "プシュトゥー語",
        "que": "キチュワ語",
        "raj": "ラージャスターニー語",
        "rap": "ラパヌーイ語",
        "rar": "Maori; Cook Islands",
        "roh": "Romansh",
        "rom": "ロマニ語",
        "ron": "ルーマニア語",
        "run": "ルンディ語",
        "rup": "Romanian; Macedo-",
        "rus": "ロシア語",
        "sad": "サンダウェ語",
        "sag": "サンゴ語",
        "sah": "ヤクート語",
        "sam": "Aramaic; Samaritan",
        "san": "梵語",
        "sas": "ササク語",
        "sat": "サンターリー語",
        "scn": "シチリア語",
        "sco": "スコットランド語",
        "sel": "セリクプ語",
        "sga": "アイルランド語; 古 (-900)",
        "shn": "シャン語",
        "sid": "シダモ語",
        "sin": "シンハラ文字",
        "slk": "スロヴァキア語",
        "slv": "スロヴェニア語",
        "sma": "Sami; Southern",
        "sme": "Sami; Northern",
        "smj": "ルレ・サーミ語",
        "smn": "Sami; Inari",
        "smo": "サモア語",
        "sms": "Sami; Skolt",
        "sna": "ショナ語",
        "snd": "シンディー語",
        "snk": "ソニンケ語",
        "sog": "ソグド語",
        "som": "ソマリ語",
        "sot": "ソト語; 南",
        "spa": "スペイン語",
        "sqi": "アルバニア語",
        "srd": "サルデーニャ語",
        "srn": "Sranan Tongo",
        "srp": "セルビア語",
        "srr": "セレール語",
        "ssw": "シスワティ語",
        "suk": "スクマ語",
        "sun": "スンダ語",
        "sus": "スス語",
        "sux": "シュメール語",
        "swa": "Swahili (macrolanguage)",
        "swe": "スウェーデン語",
        "syc": "Syriac; Classical",
        "syr": "シリア語",
        "tah": "タヒチ語",
        "tam": "タミル語",
        "tat": "タタール語",
        "tel": "テルグ語",
        "tem": "テムネ語",
        "ter": "テレーノ語",
        "tet": "テトゥン語",
        "tgk": "タジク語",
        "tgl": "タガログ語",
        "tha": "タイ語",
        "tig": "ティグレ語",
        "tir": "ティグリニア語",
        "tiv": "ティブ語",
        "tkl": "トケラウ語",
        "tlh": "Klingon",
        "tli": "トリンギット語",
        "tmh": "タマシェク語",
        "tog": "トンガ語 (ニアサ)",
        "ton": "トンガ語 (トンガ諸島)",
        "tpi": "トック・ピジン",
        "tsi": "チムシュ語",
        "tsn": "ツワナ語",
        "tso": "ツォンガ語",
        "tuk": "トゥルクメン語",
        "tum": "タンブカ語",
        "tur": "トルコ語",
        "tvl": "ツバル語",
        "twi": "トウィ語",
        "tyv": "ツバニア語",
        "udm": "ウドムルト語",
        "uga": "ウガリット語",
        "uig": "ウイグル語",
        "ukr": "ウクライナ語",
        "umb": "アンブンドゥ語",
        "und": "言語名不明",
        "urd": "ウルドゥー語",
        "uzb": "ウズベク語",
        "vai": "ヴァイ語",
        "ven": "ベンダ語",
        "vie": "ベトナム語",
        "vol": "ボラピューク語",
        "vot": "ヴォート語",
        "wal": "Wolaytta",
        "war": "Waray (Philippines)",
        "was": "ワショ語",
        "wln": "ワロン語",
        "wol": "ウォロフ語",
        "xal": "Kalmyk",
        "xho": "ホサ語",
        "yao": "ヤオ語",
        "yap": "ヤップ語",
        "yid": "イディッシュ語",
        "yor": "ヨルバ語",
        "zap": "ザポテック語",
        "zbl": "Blissymbols",
        "zen": "ゼナガ語",
        "zha": "Zhuang",
        "zho": "中国語",
        "zul": "ズールー語",
        "zun": "ズニ語",
        "zxx": "No linguistic content",
        "zza": "Zaza"
    },
    "km": {
        "aar": "Afar",
        "abk": "Abkhazian",
        "ace": "Achinese",
        "ach": "Acoli",
        "ada": "Adangme",
        "ady": "Adyghe",
        "afh": "Afrihili",
        "afr": "Afrikaans",
        "ain": "Ainu (Japan)",
        "aka": "Akan",
        "akk": "Akkadian",
        "ale": "Aleut",
        "alt": "Altai; Southern",
        "amh": "Amharic",
        "ang": "English; Old (ca. 450-1100)",
        "anp": "Angika",
        "ara": "Arabic",
        "arc": "Aramaic; Official (700-300 BCE)",
        "arg": "Aragonese",
        "arn": "Mapudungun",
        "arp": "Arapaho",
        "arw": "Arawak",
        "asm": "Assamese",
        "ast": "Asturian",
        "ava": "Avaric",
        "ave": "Avestan",
        "awa": "Awadhi",
        "aym": "Aymara",
        "aze": "Azerbaijani",
        "bak": "Bashkir",
        "bal": "Baluchi",
        "bam": "Bambara",
        "ban": "Balinese",
        "bas": "Basa (Cameroon)",
        "bej": "Beja",
        "bel": "Belarusian",
        "bem": "Bemba (Zambia)",
        "ben": "Bengali",
        "bho": "Bhojpuri",
        "bik": "Bikol",
        "bin": "Bini",
        "bis": "Bislama",
        "bit": "Berinomo",
        "bla": "Siksika",
        "bod": "Tibetan",
        "bos": "Bosnian",
        "bra": "Braj",
        "bre": "Breton",
        "bua": "Buriat",
        "bug": "Buginese",
        "bul": "Bulgarian",
        "byn": "Bilin",
        "cad": "Caddo",
        "car": "Carib; Galibi",
        "cat": "Catalan",
        "ceb": "Cebuano",
        "ces": "Czech",
        "cha": "Chamorro",
        "chb": "Chibcha",
        "che": "Chechen",
        "chg": "Chagatai",
        "chk": "Chuukese",
        "chm": "Mari (Russia)",
        "chn": "Chinook jargon",
        "cho": "Choctaw",
        "chp": "Chipewyan",
        "chr": "Cherokee",
        "cht": "Cholón",
        "chu": "Slavonic; Old",
        "chv": "Chuvash",
        "chy": "Cheyenne",
        "cop": "Coptic",
        "cor": "Cornish",
        "cos": "Corsican",
        "cre": "Cree",
        "crh": "Turkish; Crimean",
        "csb": "Kashubian",
        "cym": "Welsh",
        "dak": "Dakota",
        "dan": "Danish",
        "dar": "Dargwa",
        "del": "Delaware",
        "den": "Slave (Athapascan)",
        "deu": "German",
        "dgr": "Dogrib",
        "din": "Dinka",
        "div": "Dhivehi",
        "doi": "Dogri (macrolanguage)",
        "dsb": "Sorbian; Lower",
        "dse": "Dutch Sign Language",
        "dua": "Duala",
        "dum": "Dutch; Middle (ca. 1050-1350)",
        "dyu": "Dyula",
        "dzo": "Dzongkha",
        "efi": "Efik",
        "egy": "Egyptian (Ancient)",
        "eka": "Ekajuk",
        "ell": "Greek; Modern (1453-)",
        "elx": "Elamite",
        "eng": "English",
        "enm": "English; Middle (1100-1500)",
        "enu": "Enu",
        "epo": "Esperanto",
        "est": "Estonian",
        "eus": "Basque",
        "ewe": "Ewe",
        "ewo": "Ewondo",
        "fan": "Fang (Equatorial Guinea)",
        "fao": "Faroese",
        "fas": "Persian",
        "fat": "Fanti",
        "fij": "Fijian",
        "fil": "Filipino",
        "fin": "Finnish",
        "fon": "Fon",
        "fra": "French",
        "frm": "French; Middle (ca. 1400-1600)",
        "fro": "French; Old (842-ca. 1400)",
        "frr": "Frisian; Northern",
        "frs": "Frisian; Eastern",
        "fry": "Frisian; Western",
        "ful": "Fulah",
        "fur": "Friulian",
        "gaa": "Ga",
        "gay": "Gayo",
        "gba": "Gbaya (Central African Republic)",
        "gez": "Geez",
        "gil": "Gilbertese",
        "gla": "Gaelic; Scottish",
        "gle": "Irish",
        "glg": "Galician",
        "glv": "Manx",
        "gmh": "German; Middle High (ca. 1050-1500)",
        "goh": "German; Old High (ca. 750-1050)",
        "gon": "Gondi",
        "gor": "Gorontalo",
        "got": "Gothic",
        "grb": "Grebo",
        "grc": "Greek; Ancient (to 1453)",
        "grn": "Guarani",
        "gsw": "German; Swiss",
        "guj": "Gujarati",
        "gwi": "Gwichʼin",
        "hai": "Haida",
        "hat": "Creole; Haitian",
        "hau": "Hausa",
        "haw": "Hawaiian",
        "heb": "Hebrew",
        "her": "Herero",
        "hil": "Hiligaynon",
        "hin": "Hindi",
        "hit": "Hittite",
        "hmj": "Ge",
        "hmn": "Hmong",
        "hmo": "Hiri Motu",
        "hrv": "Croatian",
        "hsb": "Sorbian; Upper",
        "hun": "Hungarian",
        "hup": "Hupa",
        "hye": "Armenian",
        "iba": "Iban",
        "ibo": "Igbo",
        "ido": "Ido",
        "iii": "Yi; Sichuan",
        "iku": "Inuktitut",
        "ile": "Interlingue",
        "ilo": "Iloko",
        "ina": "Interlingua (International Auxiliary Language Association)",
        "ind": "Indonesian",
        "inh": "Ingush",
        "ipk": "Inupiaq",
        "isl": "Icelandic",
        "ita": "Italian",
        "jav": "Javanese",
        "jbo": "Lojban",
        "jpn": "Japanese",
        "jpr": "Judeo-Persian",
        "jrb": "Judeo-Arabic",
        "kaa": "Kara-Kalpak",
        "kab": "Kabyle",
        "kac": "Kachin",
        "kal": "Kalaallisut",
        "kam": "Kamba (Kenya)",
        "kan": "Kannada",
        "kas": "Kashmiri",
        "kat": "Georgian",
        "kau": "Kanuri",
        "kaw": "Kawi",
        "kaz": "Kazakh",
        "kbd": "Kabardian",
        "kha": "Khasi",
        "khm": "Khmer; Central",
        "kho": "Khotanese",
        "kik": "Kikuyu",
        "kin": "Kinyarwanda",
        "kir": "Kirghiz",
        "kmb": "Kimbundu",
        "kok": "Konkani (macrolanguage)",
        "kom": "Komi",
        "kon": "Kongo",
        "kor": "Korean",
        "kos": "Kosraean",
        "kpe": "Kpelle",
        "krc": "Karachay-Balkar",
        "krl": "Karelian",
        "kru": "Kurukh",
        "kua": "Kuanyama",
        "kum": "Kumyk",
        "kur": "Kurdish",
        "kut": "Kutenai",
        "lad": "Ladino",
        "lah": "Lahnda",
        "lam": "Lamba",
        "lao": "Lao",
        "lat": "Latin",
        "lav": "Latvian",
        "lez": "Lezghian",
        "lim": "Limburgan",
        "lin": "Lingala",
        "lit": "Lithuanian",
        "lol": "Mongo",
        "loz": "Lozi",
        "ltz": "Luxembourgish",
        "lua": "Luba-Lulua",
        "lub": "Luba-Katanga",
        "lug": "Ganda",
        "lui": "Luiseno",
        "lun": "Lunda",
        "luo": "Luo (Kenya and Tanzania)",
        "lus": "Lushai",
        "mad": "Madurese",
        "mag": "Magahi",
        "mah": "Marshallese",
        "mai": "Maithili",
        "mak": "Makasar",
        "mal": "Malayalam",
        "man": "Mandingo",
        "mar": "Marathi",
        "mas": "Masai",
        "mdf": "Moksha",
        "mdr": "Mandar",
        "men": "Mende (Sierra Leone)",
        "mga": "Irish; Middle (900-1200)",
        "mic": "Mi'kmaq",
        "min": "Minangkabau",
        "mis": "Uncoded languages",
        "mkd": "Macedonian",
        "mlg": "Malagasy",
        "mlt": "Maltese",
        "mnc": "Manchu",
        "mni": "Manipuri",
        "moh": "Mohawk",
        "mon": "Mongolian",
        "mos": "Mossi",
        "mri": "Maori",
        "msa": "Malay (macrolanguage)",
        "mul": "Multiple languages",
        "mus": "Creek",
        "mwl": "Mirandese",
        "mwr": "Marwari",
        "mya": "Burmese",
        "myv": "Erzya",
        "nap": "Neapolitan",
        "nau": "Nauru",
        "nav": "Navajo",
        "nbl": "Ndebele; South",
        "nde": "Ndebele; North",
        "ndo": "Ndonga",
        "nds": "German; Low",
        "nep": "Nepali",
        "new": "Bhasa; Nepal",
        "nia": "Nias",
        "niu": "Niuean",
        "nld": "Dutch",
        "nno": "Norwegian Nynorsk",
        "nob": "Norwegian Bokmål",
        "nog": "Nogai",
        "non": "Norse; Old",
        "nor": "Norwegian",
        "nqo": "N'Ko",
        "nso": "Sotho; Northern",
        "nwc": "Newari; Old",
        "nya": "Nyanja",
        "nym": "Nyamwezi",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Occitan (post 1500)",
        "oji": "Ojibwa",
        "ori": "Oriya",
        "orm": "Oromo",
        "osa": "Osage",
        "oss": "Ossetian",
        "ota": "Turkish; Ottoman (1500-1928)",
        "pag": "Pangasinan",
        "pal": "Pahlavi",
        "pam": "Pampanga",
        "pan": "Panjabi",
        "pap": "Papiamento",
        "pau": "Palauan",
        "peo": "Persian; Old (ca. 600-400 B.C.)",
        "phn": "Phoenician",
        "pli": "Pali",
        "pol": "Polish",
        "pon": "Pohnpeian",
        "por": "Portuguese",
        "pro": "Provençal; Old (to 1500)",
        "pus": "Pashto",
        "que": "Quechua",
        "raj": "Rajasthani",
        "rap": "Rapanui",
        "rar": "Maori; Cook Islands",
        "roh": "Romansh",
        "rom": "Romany",
        "ron": "Romanian",
        "run": "Rundi",
        "rup": "Romanian; Macedo-",
        "rus": "Russian",
        "sad": "Sandawe",
        "sag": "Sango",
        "sah": "Yakut",
        "sam": "Aramaic; Samaritan",
        "san": "Sanskrit",
        "sas": "Sasak",
        "sat": "Santali",
        "scn": "Sicilian",
        "sco": "Scots",
        "sel": "Selkup",
        "sga": "Irish; Old (to 900)",
        "shn": "Shan",
        "sid": "Sidamo",
        "sin": "Sinhala",
        "slk": "Slovak",
        "slv": "Slovenian",
        "sma": "Sami; Southern",
        "sme": "Sami; Northern",
        "smj": "Lule Sami",
        "smn": "Sami; Inari",
        "smo": "Samoan",
        "sms": "Sami; Skolt",
        "sna": "Shona",
        "snd": "Sindhi",
        "snk": "Soninke",
        "sog": "Sogdian",
        "som": "Somali",
        "sot": "Sotho; Southern",
        "spa": "Spanish",
        "sqi": "Albanian",
        "srd": "Sardinian",
        "srn": "Sranan Tongo",
        "srp": "Serbian",
        "srr": "Serer",
        "ssw": "Swati",
        "suk": "Sukuma",
        "sun": "Sundanese",
        "sus": "Susu",
        "sux": "Sumerian",
        "swa": "Swahili (macrolanguage)",
        "swe": "Swedish",
        "syc": "Syriac; Classical",
        "syr": "Syriac",
        "tah": "Tahitian",
        "tam": "Tamil",
        "tat": "Tatar",
        "tel": "Telugu",
        "tem": "Timne",
        "ter": "Tereno",
        "tet": "Tetum",
        "tgk": "Tajik",
        "tgl": "Tagalog",
        "tha": "Thai",
        "tig": "Tigre",
        "tir": "Tigrinya",
        "tiv": "Tiv",
        "tkl": "Tokelau",
        "tlh": "Klingon",
        "tli": "Tlingit",
        "tmh": "Tamashek",
        "tog": "Tonga (Nyasa)",
        "ton": "Tonga (Tonga Islands)",
        "tpi": "Tok Pisin",
        "tsi": "Tsimshian",
        "tsn": "Tswana",
        "tso": "Tsonga",
        "tuk": "Turkmen",
        "tum": "Tumbuka",
        "tur": "Turkish",
        "tvl": "Tuvalu",
        "twi": "Twi",
        "tyv": "Tuvinian",
        "udm": "Udmurt",
        "uga": "Ugaritic",
        "uig": "Uighur",
        "ukr": "Ukrainian",
        "umb": "Umbundu",
        "und": "Undetermined",
        "urd": "Urdu",
        "uzb": "Uzbek",
        "vai": "Vai",
        "ven": "Venda",
        "vie": "Vietnamese",
        "vol": "Volapük",
        "vot": "Votic",
        "wal": "Wolaytta",
        "war": "Waray (Philippines)",
        "was": "Washo",
        "wln": "Walloon",
        "wol": "Wolof",
        "xal": "Kalmyk",
        "xho": "Xhosa",
        "yao": "Yao",
        "yap": "Yapese",
        "yid": "Yiddish",
        "yor": "Yoruba",
        "zap": "Zapotec",
        "zbl": "Blissymbols",
        "zen": "Zenaga",
        "zha": "Zhuang",
        "zho": "Chinese",
        "zul": "Zulu",
        "zun": "Zuni",
        "zxx": "No linguistic content",
        "zza": "Zaza"
    },
    "ko": {
        "abk": "압하스어",
        "ace": "아체어",
        "ach": "아촐리어",
        "ada": "Adangme",
        "ady": "Adyghe",
        "aar": "아파르어",
        "afh": "Afrihili",
        "afr": "아프리칸스어",
        "ain": "Ainu (Japan)",
        "aka": "Akan",
        "akk": "Akkadian",
        "sqi": "Albanian",
        "ale": "Aleut",
        "amh": "Amharic",
        "anp": "Angika",
        "ara": "아라비아어",
        "arg": "Aragonese",
        "arp": "Arapaho",
        "arw": "Arawak",
        "hye": "아르메니아어",
        "asm": "Assamese",
        "ast": "Asturian",
        "ava": "Avaric",
        "ave": "아베스타어",
        "awa": "Awadhi",
        "aym": "Aymara",
        "aze": "Azerbaijani",
        "ban": "발리 문자",
        "bal": "Baluchi",
        "bam": "Bambara",
        "bas": "Basa (Cameroon)",
        "bak": "Bashkir",
        "eus": "바스크어",
        "bej": "Beja",
        "bel": "벨로루시어",
        "bem": "Bemba (Zambia)",
        "ben": "벵골 문자",
        "bit": "Berinomo",
        "bho": "Bhojpuri",
        "bik": "Bikol",
        "byn": "Bilin",
        "bin": "Bini",
        "bis": "Bislama",
        "zbl": "Blissymbols",
        "bos": "Bosnian",
        "bra": "Braj",
        "bre": "Breton",
        "bug": "부기 문자",
        "bul": "불가리아어",
        "bua": "Buriat",
        "mya": "Burmese",
        "cad": "Caddo",
        "cat": "카탈로니아어",
        "ceb": "Cebuano",
        "chg": "Chagatai",
        "cha": "Chamorro",
        "che": "Chechen",
        "chr": "체로키 문자",
        "chy": "Cheyenne",
        "chb": "Chibcha",
        "zho": "중국어",
        "chn": "Chinook jargon",
        "chp": "Chipewyan",
        "cho": "Choctaw",
        "cht": "Cholón",
        "chk": "Chuukese",
        "chv": "Chuvash",
        "cop": "콥트어",
        "cor": "Cornish",
        "cos": "Corsican",
        "cre": "Cree",
        "mus": "Creek",
        "hrv": "크로아티아어",
        "ces": "체크어",
        "dak": "Dakota",
        "dan": "덴마크어",
        "dar": "Dargwa",
        "del": "Delaware",
        "div": "Dhivehi",
        "din": "Dinka",
        "doi": "Dogri (macrolanguage)",
        "dgr": "Dogrib",
        "dua": "Duala",
        "nld": "네덜란드어",
        "dse": "Dutch Sign Language",
        "dyu": "Dyula",
        "dzo": "Dzongkha",
        "efi": "Efik",
        "egy": "Egyptian (Ancient)",
        "eka": "Ekajuk",
        "elx": "Elamite",
        "eng": "영어",
        "enu": "Enu",
        "myv": "Erzya",
        "epo": "에스페란토어",
        "est": "에스토니아어",
        "ewe": "Ewe",
        "ewo": "Ewondo",
        "fan": "Fang (Equatorial Guinea)",
        "fat": "Fanti",
        "fao": "페로스어",
        "fij": "Fijian",
        "fil": "Filipino",
        "fin": "핀란드어",
        "fon": "Fon",
        "fra": "프랑스어",
        "fur": "Friulian",
        "ful": "Fulah",
        "gaa": "Ga",
        "glg": "Galician",
        "lug": "Ganda",
        "gay": "Gayo",
        "gba": "Gbaya (Central African Republic)",
        "hmj": "Ge",
        "gez": "Geez",
        "kat": "그루지야어",
        "deu": "독일어",
        "gil": "Gilbertese",
        "gon": "Gondi",
        "gor": "Gorontalo",
        "got": "고트어",
        "grb": "Grebo",
        "grn": "Guarani",
        "guj": "구자라트 문자",
        "gwi": "Gwichʼin",
        "hai": "Haida",
        "hau": "Hausa",
        "haw": "Hawaiian",
        "heb": "헤브루어",
        "her": "Herero",
        "hil": "Hiligaynon",
        "hin": "Hindi",
        "hmo": "Hiri Motu",
        "hit": "Hittite",
        "hmn": "Hmong",
        "hun": "헝가리어",
        "hup": "Hupa",
        "iba": "Iban",
        "isl": "아이슬란드어",
        "ido": "Ido",
        "ibo": "Igbo",
        "ilo": "Iloko",
        "ind": "인도네시아어",
        "inh": "Ingush",
        "ina": "Interlingua (International Auxiliary Language Association)",
        "ile": "Interlingue",
        "iku": "Inuktitut",
        "ipk": "Inupiaq",
        "gle": "아일랜드어",
        "ita": "이탈리아어",
        "jpn": "일본어",
        "jav": "Javanese",
        "jrb": "Judeo-Arabic",
        "jpr": "Judeo-Persian",
        "kbd": "Kabardian",
        "kab": "Kabyle",
        "kac": "Kachin",
        "kal": "Kalaallisut",
        "xal": "Kalmyk",
        "kam": "Kamba (Kenya)",
        "kan": " 칸나다 문자",
        "kau": "Kanuri",
        "kaa": "Kara-Kalpak",
        "krc": "Karachay-Balkar",
        "krl": "Karelian",
        "kas": "Kashmiri",
        "csb": "Kashubian",
        "kaw": "Kawi",
        "kaz": "Kazakh",
        "kha": "Khasi",
        "kho": "Khotanese",
        "kik": "Kikuyu",
        "kmb": "Kimbundu",
        "kin": "Kinyarwanda",
        "kir": "Kirghiz",
        "tlh": "Klingon",
        "kom": "Komi",
        "kon": "Kongo",
        "kok": "Konkani (macrolanguage)",
        "kor": "한국어",
        "kos": "Kosraean",
        "kpe": "Kpelle",
        "kua": "Kuanyama",
        "kum": "Kumyk",
        "kur": "Kurdish",
        "kru": "Kurukh",
        "kut": "Kutenai",
        "lad": "Ladino",
        "lah": "Lahnda",
        "lam": "Lamba",
        "lao": "라오 문자",
        "lat": "Latin",
        "lav": "라트비아어",
        "lez": "Lezghian",
        "lim": "Limburgan",
        "lin": "Lingala",
        "lit": "리투아니아어",
        "jbo": "Lojban",
        "loz": "Lozi",
        "lub": "Luba-Katanga",
        "lua": "Luba-Lulua",
        "lui": "Luiseno",
        "smj": "Lule Sami",
        "lun": "Lunda",
        "luo": "Luo (Kenya and Tanzania)",
        "lus": "Lushai",
        "ltz": "Luxembourgish",
        "mkd": "마케도니아어",
        "mad": "Madurese",
        "mag": "Magahi",
        "mai": "Maithili",
        "mak": "Makasar",
        "mlg": "Malagasy",
        "msa": "Malay (macrolanguage)",
        "mal": "말라얄람 문자",
        "mlt": "Maltese",
        "mnc": "Manchu",
        "mdr": "Mandar",
        "man": "Mandingo",
        "mni": "Manipuri",
        "glv": "Manx",
        "mri": "Maori",
        "arn": "Mapudungun",
        "mar": "Marathi",
        "chm": "Mari (Russia)",
        "mah": "Marshallese",
        "mwr": "Marwari",
        "mas": "Masai",
        "men": "Mende (Sierra Leone)",
        "mic": "Mi'kmaq",
        "min": "Minangkabau",
        "mwl": "Mirandese",
        "moh": "Mohawk",
        "mdf": "Moksha",
        "lol": "Mongo",
        "mon": "몽골 문자",
        "mos": "Mossi",
        "mul": "Multiple languages",
        "nqo": "응코 문자",
        "nau": "나우루어",
        "nav": "나바호어",
        "ndo": "Ndonga",
        "nap": "Neapolitan",
        "nia": "Nias",
        "niu": "Niuean",
        "zxx": "No linguistic content",
        "nog": "Nogai",
        "nor": "노르웨이어",
        "nob": "Norwegian Bokmål",
        "nno": "Norwegian Nynorsk",
        "nym": "Nyamwezi",
        "nya": "Nyanja",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Occitan (post 1500)",
        "oji": "Ojibwa",
        "orm": "Oromo",
        "osa": "Osage",
        "oss": "Ossetian",
        "pal": "Pahlavi",
        "pau": "Palauan",
        "pli": "Pali",
        "pam": "Pampanga",
        "pag": "Pangasinan",
        "pan": "Panjabi",
        "pap": "Papiamento",
        "fas": "Persian",
        "phn": " 페니키아 문자",
        "pon": "Pohnpeian",
        "pol": "폴란드어",
        "por": "포르투갈어",
        "pus": "Pashto",
        "que": "Quechua",
        "raj": "Rajasthani",
        "rap": "Rapanui",
        "ron": "루마니아어",
        "roh": "Romansh",
        "rom": "Romany",
        "run": "Rundi",
        "rus": "러시아어",
        "smo": "Samoan",
        "sad": "Sandawe",
        "sag": "Sango",
        "san": "Sanskrit",
        "sat": "Santali",
        "srd": "Sardinian",
        "sas": "Sasak",
        "sco": "Scots",
        "sel": "Selkup",
        "srp": "세르비아어",
        "srr": "Serer",
        "shn": "Shan",
        "sna": "Shona",
        "scn": "Sicilian",
        "sid": "Sidamo",
        "bla": "Siksika",
        "snd": "Sindhi",
        "sin": "싱할라 문자",
        "den": "Slave (Athapascan)",
        "slk": "슬로바키아어",
        "slv": "슬로베니아어",
        "sog": "Sogdian",
        "som": "Somali",
        "snk": "Soninke",
        "spa": "스페인어",
        "srn": "Sranan Tongo",
        "suk": "Sukuma",
        "sux": "Sumerian",
        "sun": "Sundanese",
        "sus": "Susu",
        "swa": "Swahili (macrolanguage)",
        "ssw": "Swati",
        "swe": "스웨덴어",
        "syr": "시리아 문자",
        "tgl": "타갈로그 문자",
        "tah": "Tahitian",
        "tgk": "Tajik",
        "tmh": "Tamashek",
        "tam": "타밀 문자",
        "tat": "Tatar",
        "tel": "텔루구 문자",
        "ter": "Tereno",
        "tet": "Tetum",
        "tha": "태국어",
        "bod": "티베트 문자",
        "tig": "Tigre",
        "tir": "Tigrinya",
        "tem": "Timne",
        "tiv": "Tiv",
        "tli": "Tlingit",
        "tpi": "Tok Pisin",
        "tkl": "Tokelau",
        "tog": "Tonga (Nyasa)",
        "ton": "Tonga (Tonga Islands)",
        "tsi": "Tsimshian",
        "tso": "Tsonga",
        "tsn": "Tswana",
        "tum": "Tumbuka",
        "tur": "터키어",
        "tuk": "Turkmen",
        "tvl": "Tuvalu",
        "tyv": "Tuvinian",
        "twi": "Twi",
        "udm": "Udmurt",
        "uga": "우가리트 문자",
        "uig": "Uighur",
        "ukr": "Ukrainian",
        "umb": "Umbundu",
        "mis": "Uncoded languages",
        "und": "Undetermined",
        "urd": "Urdu",
        "uzb": "Uzbek",
        "vai": "Vai",
        "ven": "Venda",
        "vie": "베트남어",
        "vol": "Volapük",
        "vot": "Votic",
        "wln": "Walloon",
        "war": "Waray (Philippines)",
        "was": "Washo",
        "cym": "Welsh",
        "wal": "Wolaytta",
        "wol": "Wolof",
        "xho": "Xhosa",
        "sah": "Yakut",
        "yao": "Yao",
        "yap": "Yapese",
        "yid": "Yiddish",
        "yor": "Yoruba",
        "zap": "Zapotec",
        "zza": "Zaza",
        "zen": "Zenaga",
        "zha": "Zhuang",
        "zul": "Zulu",
        "zun": "Zuni"
    },
    "nl": {
        "aar": "Afar; Hamitisch",
        "abk": "Abchazisch",
        "ace": "Achinees",
        "ach": "Acholi",
        "ada": "Adangme",
        "ady": "Adyghe",
        "afh": "Afrihili",
        "afr": "Afrikaans",
        "ain": "Ainu (Japan)",
        "aka": "Akaans",
        "akk": "Akkadiaans",
        "ale": "Aleut",
        "alt": "Altajs; zuidelijk",
        "amh": "Amhaars; Amharisch",
        "ang": "Engels; oud (ca. 450-1100)",
        "anp": "Angika",
        "ara": "Arabisch",
        "arc": "Aramees; officieel (700-300 B.C.)",
        "arg": "Aragonees",
        "arn": "Mapudungun",
        "arp": "Arapaho",
        "arw": "Arawak",
        "asm": "Assamees; Assami",
        "ast": "Asturisch",
        "ava": "Avaars; Awari",
        "ave": "Avestisch",
        "awa": "Awadhi",
        "aym": "Aymara",
        "aze": "Azerbeidzjaans",
        "bak": "Basjkiers; Basjkirisch",
        "bal": "Balutsji; Baluchi",
        "bam": "Bambara",
        "ban": "Balinees",
        "bas": "Basa (Kameroen)",
        "bej": "Beja",
        "bel": "Wit-Russisch; Belarussisch",
        "bem": "Bemba (Zambia)",
        "ben": "Bengaals",
        "bho": "Bhojpuri",
        "bik": "Bikol",
        "bin": "Bini; Edo",
        "bis": "Bislama",
        "bit": "Berinomo",
        "bla": "Siksika",
        "bod": "Tibetaans",
        "bos": "Bosnisch",
        "bra": "Braj",
        "bre": "Bretons; Bretoens",
        "bua": "Boeriaats",
        "bug": "Buginees",
        "bul": "Bulgaars",
        "byn": "Bilin",
        "cad": "Caddo",
        "car": "Caribische talen",
        "cat": "Catalaans",
        "ceb": "Cebuano",
        "ces": "Tsjechisch",
        "cha": "Chamorro",
        "chb": "Tsjibtsja",
        "che": "Tsjetsjeens",
        "chg": "Chagatai",
        "chk": "Chukees",
        "chm": "Mari (Rusland)",
        "chn": "Chinook-jargon",
        "cho": "Choctaw",
        "chp": "Chipewyaans",
        "chr": "Cherokee",
        "cht": "Cholón",
        "chu": "Slavisch; oud (kerk)",
        "chv": "Tsjoevasjisch",
        "chy": "Cheyenne",
        "cop": "Koptisch",
        "cor": "Cornisch",
        "cos": "Corsicaans",
        "cre": "Cree",
        "crh": "Turks; Crimean",
        "csb": "Kasjoebiaans",
        "cym": "Welsh",
        "dak": "Dakota",
        "dan": "Deens",
        "dar": "Dargwa",
        "del": "Delaware",
        "den": "Slavisch (Athapascaans)",
        "deu": "Duits",
        "dgr": "Dogrib",
        "din": "Dinka",
        "div": "Divehi",
        "doi": "Dogri",
        "dsb": "Sorbisch; lager",
        "dse": "Nederlandse gebarentaal",
        "dua": "Duala",
        "dum": "Nederlands; middel (ca. 1050-1350)",
        "dyu": "Dyula",
        "dzo": "Dzongkha",
        "efi": "Efikisch",
        "egy": "Egyptisch (antiek)",
        "eka": "Ekajuk",
        "ell": "Grieks; Modern (1453-)",
        "elx": "Elamitisch",
        "eng": "Engels",
        "enm": "Engels; middel (1100-1500)",
        "enu": "Enu",
        "epo": "Esperanto",
        "est": "Estlands",
        "eus": "Baskisch",
        "ewe": "Ewe",
        "ewo": "Ewondo",
        "fan": "Fang",
        "fao": "Faeröers",
        "fas": "Perzisch",
        "fat": "Fanti",
        "fij": "Fijisch",
        "fil": "Filipijns",
        "fin": "Fins",
        "fon": "Fon",
        "fra": "Frans",
        "frm": "Frans; middel (ca. 1400-1600)",
        "fro": "Frans; oud (842-ca. 1400)",
        "frr": "Fries; noordelijk (Duitsland)",
        "frs": "Fries; oostelijk (Duitsland)",
        "fry": "Fries",
        "ful": "Fulah",
        "fur": "Friulisch",
        "gaa": "Ga",
        "gay": "Gayo",
        "gba": "Gbaya (Centraal Afrikaanse Republiek)",
        "gez": "Ge'ez",
        "gil": "Gilbertees",
        "gla": "Keltisch; schots",
        "gle": "Iers",
        "glg": "Galiciaans",
        "glv": "Manx",
        "gmh": "Duits; middel hoog (ca. 1050-1500)",
        "goh": "Duits; oud hoog (ca. 750-1050)",
        "gon": "Gondi",
        "gor": "Gorontalo",
        "got": "Gothisch",
        "grb": "Grebo",
        "grc": "Grieks; antiek (tot 1453)",
        "grn": "Guarani",
        "gsw": "Duits; Zwitserland",
        "guj": "Gujarati",
        "gwi": "Gwichʼin",
        "hai": "Haida",
        "hat": "Creools; Haïtiaans",
        "hau": "Hausa",
        "haw": "Hawaiiaans",
        "heb": "Hebreeuws",
        "her": "Herero",
        "hil": "Hiligainoons",
        "hin": "Hindi",
        "hit": "Hittitisch",
        "hmj": "Ge",
        "hmn": "Hmong",
        "hmo": "Hiri Motu",
        "hrv": "Kroatisch",
        "hsb": "Servisch; hoger",
        "hun": "Hongaars",
        "hup": "Hupa",
        "hye": "Armeens",
        "iba": "Ibaans",
        "ibo": "Igbo",
        "ido": "Ido",
        "iii": "Yi; Sichuan - Nuosu",
        "iku": "Inuktitut",
        "ile": "Interlingue",
        "ilo": "Iloko",
        "ina": "Interlingua (International Auxiliary Language Association)",
        "ind": "Indonesisch",
        "inh": "Ingoesjetisch",
        "ipk": "Inupiak",
        "isl": "IJslands",
        "ita": "Italiaans",
        "jav": "Javaans",
        "jbo": "Lojbaans",
        "jpn": "Japans",
        "jpr": "Joods-Perzisch",
        "jrb": "Joods-Arabisch",
        "kaa": "Kara-Kalpak",
        "kab": "Kabyle",
        "kac": "Katsjin",
        "kal": "Groenlands",
        "kam": "Kamba (Kenya)",
        "kan": "Kannada; Kanara; Kanarees",
        "kas": "Kashmiri",
        "kat": "Georgisch",
        "kau": "Kanuri",
        "kaw": "Kawi",
        "kaz": "Kazachs",
        "kbd": "Kabardisch; Tsjerkessisch",
        "kha": "Khasi",
        "khm": "Khmer, Cambodjaans",
        "kho": "Khotanees",
        "kik": "Kikuyu",
        "kin": "Kinyarwanda",
        "kir": "Kirgizisch",
        "kmb": "Kimbundu",
        "kok": "Konkani",
        "kom": "Komi",
        "kon": "Kikongo",
        "kor": "Koreaans",
        "kos": "Kosraeaans",
        "kpe": "Kpelle",
        "krc": "Karatsjay-Balkar",
        "krl": "Karelisch",
        "kru": "Kurukh",
        "kua": "Kuanyama",
        "kum": "Kumyk",
        "kur": "Koerdisch",
        "kut": "Kutenaïsch",
        "lad": "Ladino",
        "lah": "Lahnda",
        "lam": "Lamba",
        "lao": "Laotiaans",
        "lat": "Latijn",
        "lav": "Lets",
        "lez": "Lezghiaans",
        "lim": "Limburgs",
        "lin": "Lingala",
        "lit": "Litouws",
        "lol": "Mongo",
        "loz": "Lozi",
        "ltz": "Luxemburgs",
        "lua": "Luba-Lulua",
        "lub": "Luba-Katanga",
        "lug": "Luganda",
        "lui": "Luiseno",
        "lun": "Lunda",
        "luo": "Luo (Kenia en Tanzania)",
        "lus": "Lushai",
        "mad": "Madurees",
        "mag": "Magahisch",
        "mah": "Marshallees",
        "mai": "Maithili",
        "mak": "Makasar",
        "mal": "Malayalam",
        "man": "Mandingo",
        "mar": "Marathi",
        "mas": "Masai",
        "mdf": "Moksja",
        "mdr": "Mandars",
        "men": "Mende",
        "mga": "Iers; middel (900-1200)",
        "mic": "Mi'kmaq; Micmac",
        "min": "Minangkabau",
        "mis": "Niet-gecodeerde talen",
        "mkd": "Macedonisch",
        "mlg": "Malagassisch",
        "mlt": "Maltees",
        "mnc": "Manchu",
        "mni": "Manipuri",
        "moh": "Mohawk",
        "mon": "Mongools",
        "mos": "Mossisch",
        "mri": "Maori",
        "msa": "Maleis",
        "mul": "Meerdere talen",
        "mus": "Creek",
        "mwl": "Mirandees",
        "mwr": "Marwari",
        "mya": "Burmees",
        "myv": "Erzya",
        "nap": "Napolitaans",
        "nau": "Nauruaans",
        "nav": "Navajo",
        "nbl": "Ndebele; zuid",
        "nde": "Ndebele; noord",
        "ndo": "Ndonga",
        "nds": "Duits; Laag",
        "nep": "Nepalees",
        "new": "Newari; Nepal",
        "nia": "Nias",
        "niu": "Niueaans",
        "nld": "Nederlands",
        "nno": "Noors; Nynorsk",
        "nob": "Noors; Bokmål",
        "nog": "Nogai",
        "non": "Noors; oud",
        "nor": "Noors",
        "nqo": "N'Ko",
        "nso": "Pedi; Sepedi; Noord-Sothotisch",
        "nwc": "Newari; Klassiek Nepal",
        "nya": "Nyanja",
        "nym": "Nyamwezi",
        "nyn": "Nyankools",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Occitaans (na 1500)",
        "oji": "Ojibwa",
        "ori": "Oriya",
        "orm": "Oromo",
        "osa": "Osaags",
        "oss": "Ossetisch",
        "ota": "Turks; ottomaans (1500-1928)",
        "pag": "Pangasinaans",
        "pal": "Pehlevi",
        "pam": "Pampanga",
        "pan": "Punjabi",
        "pap": "Papiamento",
        "pau": "Palauaans",
        "peo": "Perzisch; oud (ca. 600-400 B.C.)",
        "phn": "Foenisisch",
        "pli": "Pali",
        "pol": "Pools",
        "pon": "Pohnpeiaans",
        "por": "Portugees",
        "pro": "Provençaals; oud (tot 1500)",
        "pus": "Poesjto",
        "que": "Quechua",
        "raj": "Rajasthani",
        "rap": "Rapanui",
        "rar": "Rarotongan; Cookeilanden Maori",
        "roh": "Reto-Romaans",
        "rom": "Romani",
        "ron": "Roemeens",
        "run": "Rundi",
        "rup": "Roemeens; Macedo-",
        "rus": "Russisch",
        "sad": "Sandawe",
        "sag": "Sangho",
        "sah": "Jakoets",
        "sam": "Aramees; Samaritaans",
        "san": "Sanskriet",
        "sas": "Sasaaks",
        "sat": "Santali",
        "scn": "Siciliaans",
        "sco": "Schots",
        "sel": "Sulkoeps",
        "sga": "Iers; oud (tot 900)",
        "shn": "Sjaans",
        "sid": "Sidamo",
        "sin": "Sinhala",
        "slk": "Slowaaks",
        "slv": "Sloveens",
        "sma": "Samisch; zuid, Laps; zuid",
        "sme": "Samisch; noord, Laps; noord",
        "smj": "Lule Sami",
        "smn": "Sami; Inari, Laps; Inari",
        "smo": "Samoaans",
        "sms": "Sami; Skolt, Laps; Skolt",
        "sna": "Shona",
        "snd": "Sindhi",
        "snk": "Soninke",
        "sog": "Sogdiaans",
        "som": "Somalisch",
        "sot": "Sothaans; zuidelijk",
        "spa": "Spaans",
        "sqi": "Albanees",
        "srd": "Sardinisch",
        "srn": "Sranan Tongo",
        "srp": "Servisch",
        "srr": "Serer",
        "ssw": "Swati",
        "suk": "Sukuma",
        "sun": "Soendanees; Sundanees",
        "sus": "Susu",
        "sux": "Sumerisch",
        "swa": "Swahili",
        "swe": "Zweeds",
        "syc": "Syriac; Klassiek",
        "syr": "Syrisch",
        "tah": "Tahitisch",
        "tam": "Tamil",
        "tat": "Tataars",
        "tel": "Telugu",
        "tem": "Timne",
        "ter": "Tereno",
        "tet": "Tetum",
        "tgk": "Tadzjieks",
        "tgl": "Tagalog",
        "tha": "Thai",
        "tig": "Tigre",
        "tir": "Tigrinya",
        "tiv": "Tiv",
        "tkl": "Tokelau",
        "tlh": "Klingon; tlhIngan-Hol",
        "tli": "Tlingit",
        "tmh": "Tamasjek",
        "tog": "Tonga (Nyasa)",
        "ton": "Tonga (Tonga-eilanden)",
        "tpi": "Tok Pisin",
        "tsi": "Tsimsjiaans",
        "tsn": "Tswana",
        "tso": "Tsonga",
        "tuk": "Turkmeens",
        "tum": "Tumbuka",
        "tur": "Turks",
        "tvl": "Tuvalu",
        "twi": "Twi",
        "tyv": "Tuviniaans",
        "udm": "Udmurts",
        "uga": "Ugaritisch",
        "uig": "Oeigoers; Oejgoers",
        "ukr": "Oekraïens",
        "umb": "Umbundu",
        "und": "Onbepaald",
        "urd": "Urdu",
        "uzb": "Oezbeeks",
        "vai": "Vai",
        "ven": "Venda",
        "vie": "Vietnamees",
        "vol": "Volapük",
        "vot": "Votisch",
        "wal": "Walamo",
        "war": "Waray (Filipijns)",
        "was": "Wasjo",
        "wln": "Waals",
        "wol": "Wolof",
        "xal": "Kalmyk",
        "xho": "Xhosa",
        "yao": "Yao",
        "yap": "Yapees",
        "yid": "Jiddisch",
        "yor": "Yoruba",
        "zap": "Zapotec",
        "zbl": "Blissymbolen",
        "zen": "Zenaga",
        "zha": "Zhuang, Tsjoeang",
        "zho": "Chinees",
        "zul": "Zoeloe",
        "zun": "Zuni",
        "zxx": "Geen linguïstische inhoud",
        "zza": "Zaza"
    },
    "no": {
        "abk": "Abkhazian",
        "ace": "Achinese",
        "ach": "Acoli",
        "ada": "Adangme",
        "ady": "Adyghe",
        "aar": "Afar",
        "afh": "Afrihili",
        "afr": "Afrikansk",
        "ain": "Ainu (Japan)",
        "aka": "Akan",
        "akk": "Akkadian",
        "sqi": "Albansk",
        "ale": "Aleut",
        "amh": "Amharic",
        "anp": "Angika",
        "ara": "Arabisk",
        "arg": "Aragonsk",
        "arp": "Arapaho",
        "arw": "Arawak",
        "hye": "Armensk",
        "asm": "assamisk",
        "ast": "Asturian",
        "ava": "Avaric",
        "ave": "Avestisk",
        "awa": "Awadhi",
        "aym": "Aymara",
        "aze": "Aserbadjansk",
        "ban": "Balinese",
        "bal": "Baluchi",
        "bam": "Bambara",
        "bas": "Basa (Cameroon)",
        "bak": "Basjkirsk",
        "eus": "Baskisk",
        "bej": "Beja",
        "bel": "Hviterussisk",
        "bem": "Bemba (Zambia)",
        "ben": "Bengali",
        "bit": "Berinomo",
        "bho": "Bhojpuri",
        "bik": "Bikol",
        "byn": "Bilin",
        "bin": "Bini",
        "bis": "Bislama",
        "zbl": "Blissymbols",
        "bos": "Bosnian",
        "bra": "Braj",
        "bre": "Breton",
        "bug": "Buginese",
        "bul": "Bulgarsk",
        "bua": "Buriat",
        "mya": "burmesisk",
        "cad": "Caddo",
        "cat": "Katalan",
        "ceb": "Cebuano",
        "chg": "Chagatai",
        "cha": "chamorro",
        "che": "Chechen",
        "chr": "cherokee",
        "chy": "Cheyenne",
        "chb": "Chibcha",
        "zho": "Kinesisk",
        "chn": "Chinook jargon",
        "chp": "Chipewyan",
        "cho": "Choctaw",
        "cht": "Cholón",
        "chk": "Chuukese",
        "chv": "tsjuvansk",
        "cop": "Koptisk",
        "cor": "Cornish",
        "cos": "Corsican",
        "cre": "Cree",
        "mus": "Creek",
        "hrv": "Kroatsisk",
        "ces": "Tjekkisk",
        "dak": "Dakota",
        "dan": "Dansk",
        "dar": "Dargwa",
        "del": "Delaware",
        "div": "Dhivehi",
        "din": "Dinka",
        "doi": "Dogri (macrolanguage)",
        "dgr": "Dogrib",
        "dua": "Duala",
        "nld": "Nederlandsk",
        "dse": "Dutch Sign Language",
        "dyu": "Dyula",
        "dzo": "dzongkha",
        "efi": "Efik",
        "egy": "Egyptian (Ancient)",
        "eka": "Ekajuk",
        "elx": "Elamite",
        "eng": "Engelsk",
        "enu": "Enu",
        "myv": "Erzya",
        "epo": "Esperanto",
        "est": "Estonsk",
        "ewe": "ewe",
        "ewo": "Ewondo",
        "fan": "Fang (Equatorial Guinea)",
        "fat": "Fanti",
        "fao": "færøysk",
        "fij": "fijiansk",
        "fil": "Filipino",
        "fin": "Finsk",
        "fon": "Fon",
        "fra": "Fransk",
        "fur": "Friulian",
        "ful": "fulani",
        "gaa": "Ga",
        "glg": "Galician",
        "lug": "Ganda",
        "gay": "Gayo",
        "gba": "Gbaya (Central African Republic)",
        "hmj": "Ge",
        "gez": "Geez",
        "kat": "Georgisk",
        "deu": "Tysk",
        "gil": "Gilbertese",
        "gon": "Gondi",
        "gor": "Gorontalo",
        "got": "Gotisk",
        "grb": "Grebo",
        "grn": "Guarani",
        "guj": "gujarati",
        "gwi": "Gwichʼin",
        "hai": "Haida",
        "hau": "Hausa",
        "haw": "hawaiisk",
        "heb": "Hebraisk",
        "her": "Herero",
        "hil": "Hiligaynon",
        "hin": "hindi",
        "hmo": "Hiri Motu",
        "hit": "Hittite",
        "hmn": "Hmong",
        "hun": "Ungarsk",
        "hup": "Hupa",
        "iba": "Iban",
        "isl": "Islandsk",
        "ido": "ido",
        "ibo": "ibo",
        "ilo": "Iloko",
        "ind": "Indonesisk",
        "inh": "Ingush",
        "ina": "Interlingua (International Auxiliary Language Association)",
        "ile": "interlingue",
        "iku": "inuktitut",
        "ipk": "unupiak",
        "gle": "Irsk",
        "ita": "Italiensk",
        "jpn": "Japansk",
        "jav": "Javanesisk",
        "jrb": "Judeo-Arabic",
        "jpr": "Judeo-Persian",
        "kbd": "Kabardian",
        "kab": "Kabyle",
        "kac": "Kachin",
        "kal": "Grønlandsk",
        "xal": "Kalmyk",
        "kam": "Kamba (Kenya)",
        "kan": "kannada",
        "kau": "Kanuri",
        "kaa": "Kara-Kalpak",
        "krc": "Karachay-Balkar",
        "krl": "Karelisk",
        "kas": "kasjmiri",
        "csb": "Kashubian",
        "kaw": "Kawi",
        "kaz": "kasakhisk",
        "kha": "Khasi",
        "kho": "Khotanese",
        "kik": "kikuyu",
        "kmb": "Kimbundu",
        "kin": "kinjarwanda",
        "kir": "kirgisisk",
        "tlh": "Klingon",
        "kom": "komi",
        "kon": "Kongo",
        "kok": "Konkani (macrolanguage)",
        "kor": "Koreansk",
        "kos": "Kosraean",
        "kpe": "Kpelle",
        "kua": "kuanyama",
        "kum": "Kumyk",
        "kur": "Kurdisk",
        "kru": "Kurukh",
        "kut": "Kutenai",
        "lad": "Ladino",
        "lah": "Lahnda",
        "lam": "Lamba",
        "lao": "laotisk",
        "lat": "Latin",
        "lav": "Latvisk",
        "lez": "Lezghian",
        "lim": "Limburgan",
        "lin": "lingala",
        "lit": "Lituaisk",
        "jbo": "Lojban",
        "loz": "Lozi",
        "lub": "luba-katanga",
        "lua": "Luba-Lulua",
        "lui": "Luiseno",
        "smj": "Lulesamisk",
        "lun": "Lunda",
        "luo": "Luo (Kenya and Tanzania)",
        "lus": "Lushai",
        "ltz": "Luxemburgisk",
        "mkd": "Makedonsk",
        "mad": "Madurese",
        "mag": "Magahi",
        "mai": "Maithili",
        "mak": "Makasar",
        "mlg": "madagassisk",
        "msa": "Malay (macrolanguage)",
        "mal": "malayalam",
        "mlt": "Maltisk",
        "mnc": "Manchu",
        "mdr": "Mandar",
        "man": "Mandingo",
        "mni": "Manipuri",
        "glv": "manx",
        "mri": "Maori",
        "arn": "Mapudungun",
        "mar": "Marathi",
        "chm": "Mari (Russland)",
        "mah": "Marshallese",
        "mwr": "Marwari",
        "mas": "Masai",
        "men": "Mende (Sierra Leone)",
        "mic": "Mi'kmaq",
        "min": "Minangkabau",
        "mwl": "Mirandese",
        "moh": "Mohawk",
        "mdf": "Moksha",
        "lol": "Mongo",
        "mon": "Mongolsk",
        "mos": "Mossi",
        "mul": "Flere språk",
        "nqo": "N'Ko",
        "nau": "nauru",
        "nav": "Navajo",
        "ndo": "Ndonga",
        "nap": "Napolitansk",
        "nia": "Nias",
        "niu": "Niuean",
        "zxx": "Inget språklig innhold",
        "nog": "Nogai",
        "nor": "Norsk",
        "nob": "Norsk bokmål",
        "nno": "Norsk nynorsk",
        "nym": "Nyamwezi",
        "nya": "Nyanja",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Occitan (post 1500)",
        "oji": "Ojibwa",
        "orm": "oromo",
        "osa": "Osage",
        "oss": "Ossetian",
        "pal": "Pahlavi",
        "pau": "Palauan",
        "pli": "Pali",
        "pam": "Pampanga",
        "pag": "Pangasinan",
        "pan": "Panjabi",
        "pap": "Papiamento",
        "fas": "Persisk",
        "phn": "Phoenician",
        "pon": "Pohnpeian",
        "pol": "Polsk",
        "por": "Portugisisk",
        "pus": "Pashto",
        "que": "Quechua",
        "raj": "Rajasthani",
        "rap": "Rapanui",
        "ron": "Rumensk",
        "roh": "Retoromansk",
        "rom": "Romany",
        "run": "rundi",
        "rus": "Russisk",
        "smo": "samoansk",
        "sad": "Sandawe",
        "sag": "Sango",
        "san": "sanskrit",
        "sat": "Santali",
        "srd": "Sardinsk",
        "sas": "Sasak",
        "sco": "Scots",
        "sel": "Selkup",
        "srp": "Serbisk",
        "srr": "Serer",
        "shn": "Shan",
        "sna": "Shona",
        "scn": "Siciliansk",
        "sid": "sidamo",
        "bla": "Siksika",
        "snd": "sindhi",
        "sin": "Sinhala",
        "den": "Slave (Athapascan)",
        "slk": "Slovakisk",
        "slv": "Slovensk",
        "sog": "Sogdian",
        "som": "somalisk",
        "snk": "Soninke",
        "spa": "Spansk",
        "srn": "Sranan Tongo",
        "suk": "Sukuma",
        "sux": "Sumerian",
        "sun": "sundanesisk",
        "sus": "Susu",
        "swa": "Swahili (macrolanguage)",
        "ssw": "swati",
        "swe": "Svensk",
        "syr": "Syriac",
        "tgl": "tagalog",
        "tah": "Tahitian",
        "tgk": "Tajik",
        "tmh": "Tamashek",
        "tam": "Tamilsk",
        "tat": "tatarisk",
        "tel": "Telugu",
        "ter": "Tereno",
        "tet": "Tetum",
        "tha": "Thai",
        "bod": "tibetansk",
        "tig": "Tigre",
        "tir": "Tigrinya",
        "tem": "Timne",
        "tiv": "Tiv",
        "tli": "Tlingit",
        "tpi": "Tok Pisin",
        "tkl": "Tokelau",
        "tog": "Tonga (Nyasa)",
        "ton": "tonga (Tonga-øyene)",
        "tsi": "Tsimshian",
        "tso": "tsonga",
        "tsn": "tswana",
        "tum": "Tumbuka",
        "tur": "Tyrkisk",
        "tuk": "turkmensk",
        "tvl": "Tuvalu",
        "tyv": "Tuvinian",
        "twi": "twi",
        "udm": "Udmurt",
        "uga": "Ugaritic",
        "uig": "uigurisk",
        "ukr": "Ukrainsk",
        "umb": "Umbundu",
        "mis": "Uncoded languages",
        "und": "Undetermined",
        "urd": "urdu",
        "uzb": "usbekisk",
        "vai": "Vai",
        "ven": "venda",
        "vie": "Vietnamesisk",
        "vol": "Volapük",
        "vot": "Votic",
        "wln": "Walloon",
        "war": "Waray (Philippines)",
        "was": "Washo",
        "cym": "Walisisk",
        "wal": "Wolaytta",
        "wol": "wolof",
        "xho": "Xhosa",
        "sah": "Yakut",
        "yao": "Yao",
        "yap": "Yapese",
        "yid": "jiddisk",
        "yor": "joruba",
        "zap": "Zapotec",
        "zza": "Zaza",
        "zen": "Zenaga",
        "zha": "Zhuang",
        "zul": "Zulu",
        "zun": "Zuni"
    },
    "pl": {
        "aar": "afarski",
        "abk": "abchaski",
        "ace": "aczineski",
        "ach": "aczoli",
        "ada": "adangme",
        "ady": "adygejski",
        "afh": "afrihili",
        "afr": "afrykanerski",
        "ain": "ajnoski (Japonia)",
        "aka": "akan",
        "akk": "akadyjski",
        "ale": "aleucki",
        "alt": "ałtajski południowy",
        "amh": "amharski",
        "ang": "Staroangielski (ok. 450-1100)",
        "anp": "angika",
        "ara": "arabski",
        "arc": "aramejski oficjalny (700-300 p.n.e.)",
        "arg": "aragoński",
        "arn": "araukański",
        "arp": "arapaho",
        "arw": "arawak",
        "asm": "asamski",
        "ast": "asturyjski",
        "ava": "awarski",
        "ave": "awestyjski",
        "awa": "awadhi",
        "aym": "ajmara",
        "aze": "azerski",
        "bak": "baszkirski",
        "bal": "baluczi",
        "bam": "bambara",
        "ban": "balijski",
        "bas": "basa (Kamerun)",
        "bej": "bedża",
        "bel": "białoruski",
        "bem": "bemba (Zambia)",
        "ben": "bengalski",
        "bho": "bhodźpuri",
        "bik": "bikol",
        "bin": "edo",
        "bis": "bislama",
        "bit": "Berinomo",
        "bla": "siksika",
        "bod": "tybetański",
        "bos": "bośniacki",
        "bra": "bradź",
        "bre": "bretoński",
        "bua": "buriacki",
        "bug": "bugijski",
        "bul": "bułgarski",
        "byn": "blin",
        "cad": "kaddo",
        "car": "karaibski galibi",
        "cat": "kataloński",
        "ceb": "cebuański",
        "ces": "czeski",
        "cha": "czamorro",
        "chb": "czibcza",
        "che": "czeczeński",
        "chg": "czagatajski",
        "chk": "chuuk",
        "chm": "maryjski (Rosja)",
        "chn": "żargon chinoocki",
        "cho": "czoktaw",
        "chp": "chipewyan",
        "chr": "czerokeski",
        "cht": "Cholón",
        "chu": "starosłowiański",
        "chv": "czuwaski",
        "chy": "czejeński",
        "cop": "koptyjski",
        "cor": "kornijski",
        "cos": "korsykański",
        "cre": "kri",
        "crh": "krymskotatarski",
        "csb": "kaszubski",
        "cym": "walijski",
        "dak": "dakota",
        "dan": "duński",
        "dar": "dargwijski",
        "del": "delaware",
        "den": "slavey (atapaskański)",
        "deu": "niemiecki",
        "dgr": "dogrib",
        "din": "dinka",
        "div": "malediwski; divehi",
        "doi": "dogri (makrojęzyk)",
        "dsb": "dolnołużycki",
        "dse": "holenderski język migowy",
        "dua": "duala",
        "dum": "holenderski średniowieczny (ok. 1050-1350)",
        "dyu": "diula",
        "dzo": "dzongka",
        "efi": "efik",
        "egy": "egipski (starożytny)",
        "eka": "ekajuk",
        "ell": "grecki współczesny (1453-)",
        "elx": "elamicki",
        "eng": "Angielski",
        "enm": "angielski średniowieczny (1100-1500)",
        "enu": "Enu",
        "epo": "esperanto",
        "est": "estoński",
        "eus": "baskijski",
        "ewe": "ewe",
        "ewo": "ewondo",
        "fan": "fang (Gwinea Równikowa)",
        "fao": "farerski",
        "fas": "perski",
        "fat": "fanti",
        "fij": "fidżyjski",
        "fil": "pilipino",
        "fin": "fiński",
        "fon": "fon",
        "fra": "francuski",
        "frm": "francuski średniowieczny (ok. 1400-1600)",
        "fro": "starofrancuski (842-ok. 1400)",
        "frr": "północnofryzyjski",
        "frs": "wschodniofryzyjski",
        "fry": "zachodniofryzyjski",
        "ful": "fulani",
        "fur": "friulski",
        "gaa": "ga",
        "gay": "gayo",
        "gba": "gbaya (Republika Środkowoafrykańska)",
        "gez": "gyyz",
        "gil": "gilbertański",
        "gla": "szkocki gaelicki",
        "gle": "irlandzki",
        "glg": "galicyjski",
        "glv": "manx",
        "gmh": "średnio-wysoko-niemiecki (ok. 1050-1500)",
        "goh": "staro-wysoko-niemiecki (ok. 750-1050)",
        "gon": "gondi",
        "gor": "gorontalo",
        "got": "gocki",
        "grb": "grebo",
        "grc": "grecki starożytny (do 1453)",
        "grn": "guarani",
        "gsw": "niemiecki szwajcarski",
        "guj": "gudźarati",
        "gwi": "gwichʼin",
        "hai": "haida",
        "hat": "kreolski haitański",
        "hau": "hausa",
        "haw": "hawajski",
        "heb": "hebrajski",
        "her": "herero",
        "hil": "hiligajnon",
        "hin": "hindi",
        "hit": "hetycki",
        "hmj": "Ge",
        "hmn": "hmong",
        "hmo": "hiri motu",
        "hrv": "chorwacki",
        "hsb": "górnołużycki",
        "hun": "węgierski",
        "hup": "hupa",
        "hye": "ormiański",
        "iba": "ibanag",
        "ibo": "ibo",
        "ido": "ido",
        "iii": "syczuański",
        "iku": "inuktitut",
        "ile": "interlingue",
        "ilo": "ilokano",
        "ina": "interlingua (Międzynarodowe Stowarzyszenie Języka Pomocniczego)",
        "ind": "indonezyjski",
        "inh": "inguski",
        "ipk": "inupiaq",
        "isl": "islandzki",
        "ita": "włoski",
        "jav": "jawajski",
        "jbo": "lojban",
        "jpn": "japoński",
        "jpr": "judeo-perski",
        "jrb": "judeoarabski",
        "kaa": "karakałpacki",
        "kab": "kabylski",
        "kac": "kaczin",
        "kal": "kalaallisut",
        "kam": "kamba (Kenia)",
        "kan": "kannada",
        "kas": "kaszmirski",
        "kat": "gruziński",
        "kau": "kanuri",
        "kaw": "kawi",
        "kaz": "kazaski",
        "kbd": "kabardyjski",
        "kha": "khasi",
        "khm": "środkowokhmerski",
        "kho": "chotański",
        "kik": "kikiju",
        "kin": "ruanda",
        "kir": "kirgiski",
        "kmb": "kimbundu",
        "kok": "konkani (makrojęzyk)",
        "kom": "komi",
        "kon": "kongo",
        "kor": "koreański",
        "kos": "kosrae",
        "kpe": "kpelle",
        "krc": "karaczajsko-bałkarski",
        "krl": "karelski",
        "kru": "kurukh",
        "kua": "kwanyama",
        "kum": "kumycki",
        "kur": "kurdyjski",
        "kut": "kutenai",
        "lad": "ladino",
        "lah": "lahnda",
        "lam": "lamba",
        "lao": "laotański",
        "lat": "łaciński",
        "lav": "łotewski",
        "lez": "lezgiński",
        "lim": "limburgijski",
        "lin": "lingala",
        "lit": "litewski",
        "lol": "mongo",
        "loz": "lozi",
        "ltz": "luksemburski",
        "lua": "luba-lulua",
        "lub": "luba-katanga",
        "lug": "luganda",
        "lui": "luiseno",
        "lun": "lunda",
        "luo": "luo (Kenia i Tanzania)",
        "lus": "lushai",
        "mad": "madurajski",
        "mag": "magahi",
        "mah": "marshalski",
        "mai": "maithili",
        "mak": "makasar",
        "mal": "malajalam",
        "man": "mandingo",
        "mar": "marathi",
        "mas": "masajski",
        "mdf": "moksza",
        "mdr": "mandar",
        "men": "mende (Sierra Leone)",
        "mga": "irlandzki średniowieczny (900-1200)",
        "mic": "micmac",
        "min": "minangkabau",
        "mis": "języki niezakodowane",
        "mkd": "macedoński",
        "mlg": "malgaski",
        "mlt": "maltański",
        "mnc": "mandżurski",
        "mni": "manipuri",
        "moh": "mohawk",
        "mon": "mongolski",
        "mos": "mossi",
        "mri": "maoryski",
        "msa": "malajski (makrojęzyk)",
        "mul": "wiele języków",
        "mus": "krik",
        "mwl": "mirandyjski",
        "mwr": "marwari",
        "mya": "birmański",
        "myv": "erzja",
        "nap": "neapolitański",
        "nau": "nauruański",
        "nav": "navaho",
        "nbl": "ndebele południowy",
        "nde": "ndebele północny",
        "ndo": "ndonga",
        "nds": "German; Low",
        "nep": "nepalski",
        "new": "newarski",
        "nia": "nias",
        "niu": "niue",
        "nld": "holenderski",
        "nno": "norweski Nynorsk",
        "nob": "norweski Bokmål",
        "nog": "nogajski",
        "non": "staronordyjski",
        "nor": "norweski",
        "nqo": "n’ko",
        "nso": "sotho północny",
        "nwc": "newarski klasyczny",
        "nya": "njandża",
        "nym": "nyamwezi",
        "nyn": "nyankole",
        "nyo": "nyoro",
        "nzi": "nzema",
        "oci": "okcytański (po 1500)",
        "oji": "odżibwe",
        "ori": "orija",
        "orm": "oromo",
        "osa": "osage",
        "oss": "osetyjski",
        "ota": "turecki otomański (1500-1928)",
        "pag": "pangasino",
        "pal": "pahlawi",
        "pam": "pampango",
        "pan": "pendżabski",
        "pap": "papiamento",
        "pau": "palau",
        "peo": "staroperski (ok. 600-400 p.n.e)",
        "phn": "fenicki",
        "pli": "pali",
        "pol": "Polski",
        "pon": "pohnpei",
        "por": "portugalski",
        "pro": "prowansalski średniowieczny (do 1500)",
        "pus": "paszto",
        "que": "keczua",
        "raj": "radźasthani",
        "rap": "rapanui",
        "rar": "maoryski Wysp Cooka",
        "roh": "retoromański",
        "rom": "romski",
        "ron": "rumuński",
        "run": "rundi",
        "rup": "arumuński",
        "rus": "rosyjski",
        "sad": "sandawe",
        "sag": "sango",
        "sah": "jakucki",
        "sam": "samarytański aramejski",
        "san": "sanskryt",
        "sas": "sasak",
        "sat": "santali",
        "scn": "sycylijski",
        "sco": "scots",
        "sel": "selkupski",
        "sga": "staroirlandzki (do 900)",
        "shn": "szan",
        "sid": "sidamo",
        "sin": "syngaleski",
        "slk": "słowacki",
        "slv": "słoweński",
        "sma": "południowolapoński",
        "sme": "północnolapoński",
        "smj": "lapoński lule",
        "smn": "lapoński inari",
        "smo": "samoański",
        "sms": "lapoński skolt",
        "sna": "shona",
        "snd": "sindhi",
        "snk": "soninke",
        "sog": "sogdiański",
        "som": "somalijski",
        "sot": "sotho południowy",
        "spa": "hiszpański",
        "sqi": "albański",
        "srd": "sardyński",
        "srn": "sranan tongo",
        "srp": "serbski",
        "srr": "serer",
        "ssw": "suazi",
        "suk": "sukuma",
        "sun": "sundajski",
        "sus": "susu",
        "sux": "sumeryjski",
        "swa": "suahili (makrojęzyk)",
        "swe": "szwedzki",
        "syc": "syryjski klasyczny",
        "syr": "syryjski",
        "tah": "tahitański",
        "tam": "tamilski",
        "tat": "tatarski",
        "tel": "telugu",
        "tem": "temne",
        "ter": "tereno",
        "tet": "tetum",
        "tgk": "tadżycki",
        "tgl": "tagalski",
        "tha": "tajski",
        "tig": "tigre",
        "tir": "tigrinia",
        "tiv": "tiw",
        "tkl": "tokelau",
        "tlh": "klingoński",
        "tli": "tlingit",
        "tmh": "tuareski",
        "tog": "tongański (Nyasa)",
        "ton": "tongański (Wyspy Tonga)",
        "tpi": "tok pisin",
        "tsi": "tsimszian",
        "tsn": "tswana",
        "tso": "tsonga",
        "tuk": "turkmeński",
        "tum": "tumbuka",
        "tur": "turecki",
        "tvl": "tuvalu",
        "twi": "twi",
        "tyv": "tuwiński",
        "udm": "udmurcki",
        "uga": "ugarycki",
        "uig": "ujgurski",
        "ukr": "ukraiński",
        "umb": "umbundu",
        "und": "nieokreślony",
        "urd": "urdu",
        "uzb": "uzbecki",
        "vai": "wai",
        "ven": "venda",
        "vie": "wietnamski",
        "vol": "wolapik",
        "vot": "wotycki",
        "wal": "walamo",
        "war": "warajski (Filipiny)",
        "was": "washo",
        "wln": "waloński",
        "wol": "wolof",
        "xal": "kałmucki",
        "xho": "xhosa",
        "yao": "yao",
        "yap": "japski",
        "yid": "jidysz",
        "yor": "joruba",
        "zap": "zapotecki",
        "zbl": "bliss",
        "zen": "zenaga",
        "zha": "zhuang",
        "zho": "chiński",
        "zul": "zuluski",
        "zun": "zuni",
        "zxx": "brak kontekstu językowego",
        "zza": "zazaki"
    },
    "pt": {
        "abk": "Abcázio",
        "ace": "Achém",
        "ach": "Acoli",
        "ada": "Adangme",
        "ady": "Adyghe",
        "aar": "Afar",
        "afh": "Afrihili",
        "afr": "Africânder",
        "ain": "Ainu (Japão)",
        "aka": "Akan",
        "akk": "Acadiano",
        "sqi": "Albanês",
        "ale": "Aleúte",
        "amh": "Amárico",
        "anp": "Angika",
        "ara": "Arabic",
        "arg": "Aragonese",
        "arp": "Arapaho",
        "arw": "Arawak",
        "hye": "Armênio",
        "asm": "Assamese",
        "ast": "Asturian",
        "ava": "Avaric",
        "ave": "Avestan",
        "awa": "Awadhi",
        "aym": "Aymara",
        "aze": "Azerbaijano",
        "ban": "Balinês",
        "bal": "Balúchi",
        "bam": "Bambara",
        "bas": "Basa (Cameroon)",
        "bak": "Bashkir",
        "eus": "Basque",
        "bej": "Beja",
        "bel": "Belarusian",
        "bem": "Bemba (Zambia)",
        "ben": "Bengali",
        "bit": "Berinomo",
        "bho": "Bhojpuri",
        "bik": "Bikol",
        "byn": "Bilin",
        "bin": "Bini",
        "bis": "Bislama",
        "zbl": "Blissymbols",
        "bos": "Bosnian",
        "bra": "Braj",
        "bre": "Bretão",
        "bug": "Buginese",
        "bul": "Búlgaro",
        "bua": "Buriat",
        "mya": "Birmanês",
        "cad": "Caddo",
        "cat": "Catalão",
        "ceb": "Cebuano",
        "chg": "Chagatai",
        "cha": "Chamorro",
        "che": "Chechen",
        "chr": "Cheroqui",
        "chy": "Cheyenne",
        "chb": "Chibcha",
        "zho": "Chinês",
        "chn": "Chinook jargon",
        "chp": "Chipewyan",
        "cho": "Choctaw",
        "cht": "Cholón",
        "chk": "Chuukese",
        "chv": "Chuvash",
        "cop": "Coptic",
        "cor": "Cornish",
        "cos": "Corsican",
        "cre": "Cree",
        "mus": "Creek",
        "hrv": "Croata",
        "ces": "Czech",
        "dak": "Dacota",
        "dan": "Danish",
        "dar": "Dargwa",
        "del": "Delaware",
        "div": "Dhivehi",
        "din": "Dinka",
        "doi": "Dogri (macrolanguage)",
        "dgr": "Dogrib",
        "dua": "Duala",
        "nld": "Holandês",
        "dse": "Língua gestual holandesa",
        "dyu": "Dyula",
        "dzo": "Dzongkha",
        "efi": "Efik",
        "egy": "Egyptian (Ancient)",
        "eka": "Ekajuk",
        "elx": "Elamite",
        "eng": "Inglês",
        "enu": "Enu",
        "myv": "Erzya",
        "epo": "Esperanto",
        "est": "Estónio",
        "ewe": "Ewe",
        "ewo": "Ewondo",
        "fan": "Fang (Equatorial Guinea)",
        "fat": "Fanti",
        "fao": "Faroese",
        "fij": "Fijian",
        "fil": "Filipino",
        "fin": "Finlandês",
        "fon": "Fon",
        "fra": "Francês",
        "fur": "Friuliano",
        "ful": "Fulah",
        "gaa": "Ga",
        "glg": "Galician",
        "lug": "Ganda",
        "gay": "Gayo",
        "gba": "Gbaya (Central African Republic)",
        "hmj": "Ge",
        "gez": "Geez",
        "kat": "Georgiano",
        "deu": "Alemão",
        "gil": "Gilbertês",
        "gon": "Gondi",
        "gor": "Gorontalo",
        "got": "Gótico",
        "grb": "Grebo",
        "grn": "Guarani",
        "guj": "Guzerate",
        "gwi": "Gwichʼin",
        "hai": "Haida",
        "hau": "Hauçá",
        "haw": "Havaiano",
        "heb": "Hebraico",
        "her": "Herero",
        "hil": "Hiligaynon",
        "hin": "Hindi",
        "hmo": "Hiri Motu",
        "hit": "Hitita",
        "hmn": "Hmong",
        "hun": "Húngaro",
        "hup": "Hupa",
        "iba": "Iban",
        "isl": "Islandês",
        "ido": "Ido",
        "ibo": "Igbo",
        "ilo": "Ilocano",
        "ind": "Indonésio",
        "inh": "Ingush",
        "ina": "Interlingua (International Auxiliary Language Association)",
        "ile": "Interlingue",
        "iku": "Inuktitut",
        "ipk": "Inupiaq",
        "gle": "Irlandês",
        "ita": "Italiano",
        "jpn": "Japanese",
        "jav": "Javanês",
        "jrb": "Judeo-Arabic",
        "jpr": "Judeo-Persian",
        "kbd": "Kabardian",
        "kab": "Kabyle",
        "kac": "Kachin",
        "kal": "Kalaallisut",
        "xal": "Kalmyk",
        "kam": "Kamba (Quênia)",
        "kan": "Canarês",
        "kau": "Kanuri",
        "kaa": "Kara-Kalpak",
        "krc": "Karachay-Balkar",
        "krl": "Karelian",
        "kas": "Kashmiri",
        "csb": "Kashubian",
        "kaw": "Kawi",
        "kaz": "Cazaque",
        "kha": "Khasi",
        "kho": "Khotanese",
        "kik": "Quicuio",
        "kmb": "Quimbundo",
        "kin": "Kinyarwanda",
        "kir": "Quirguiz",
        "tlh": "Klingon",
        "kom": "Komi",
        "kon": "Quicongo",
        "kok": "Konkani (macrolanguage)",
        "kor": "Coreano",
        "kos": "Kosraean",
        "kpe": "Kpelle",
        "kua": "Kuanyama",
        "kum": "Kumyk",
        "kur": "Kurdish",
        "kru": "Kurukh",
        "kut": "Kutenai",
        "lad": "Ladino",
        "lah": "Lahnda",
        "lam": "Lamba",
        "lao": "Laosiano",
        "lat": "Latin",
        "lav": "Letão",
        "lez": "Lezghian",
        "lim": "Limburgan",
        "lin": "Lingala",
        "lit": "Lituano",
        "jbo": "Lojban",
        "loz": "Lozi",
        "lub": "Luba-Catanga",
        "lua": "Luba-Lulua",
        "lui": "Luiseno",
        "smj": "Lule Sami",
        "lun": "Lunda",
        "luo": "Luo (Kenya and Tanzania)",
        "lus": "Lushai",
        "ltz": "Luxembourgish",
        "mkd": "Macedónio",
        "mad": "Madurese",
        "mag": "Magahi",
        "mai": "Maithili",
        "mak": "Makasar",
        "mlg": "Malgaxe",
        "msa": "Malay (macrolanguage)",
        "mal": "Malayalam",
        "mlt": "Maltese",
        "mnc": "Manchu",
        "mdr": "Mandar",
        "man": "Mandinga",
        "mni": "Manipuri",
        "glv": "Manx",
        "mri": "Maori",
        "arn": "Mapudungun",
        "mar": "Marata",
        "chm": "Mari (Russia)",
        "mah": "Marshallese",
        "mwr": "Marwari",
        "mas": "Masai",
        "men": "Mende (Sierra Leone)",
        "mic": "Mi'kmaq",
        "min": "Minangkabau",
        "mwl": "Mirandês",
        "moh": "Mohawk",
        "mdf": "Mocsa",
        "lol": "Mongo",
        "mon": "Mongolian",
        "mos": "Mossi",
        "mul": "Múltiplos idiomas",
        "nqo": "N'Ko",
        "nau": "Nauruano",
        "nav": "Navajo",
        "ndo": "Ndonga",
        "nap": "Neapolitan",
        "nia": "Nias",
        "niu": "Niueano",
        "zxx": "Sem conteúdo linguistico",
        "nog": "Nogai",
        "nor": "Norueguês",
        "nob": "Norueguês, Dano",
        "nno": "Norueguês, Novo",
        "nym": "Nyamwezi",
        "nya": "Nyanja",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Occitan (post 1500)",
        "oji": "Ojibwa",
        "orm": "Oromo",
        "osa": "Osage",
        "oss": "Ossetian",
        "pal": "Pálavi",
        "pau": "Palauano",
        "pli": "Pali",
        "pam": "Pampanga",
        "pag": "Pangasinense",
        "pan": "Panjabi",
        "pap": "Papiamento",
        "fas": "Persian",
        "phn": "Fenício",
        "pon": "Pohnpeian",
        "pol": "Polaco",
        "por": "Português",
        "pus": "Pushto",
        "que": "Quíchua",
        "raj": "Rajastani",
        "rap": "Rapanui",
        "ron": "Romeno",
        "roh": "Romansh",
        "rom": "Romany",
        "run": "Rundi",
        "rus": "Russo",
        "smo": "Samoan",
        "sad": "Sandawe",
        "sag": "Sango",
        "san": "Sanskrit",
        "sat": "Santali",
        "srd": "Sardinian",
        "sas": "Sasak",
        "sco": "Scots",
        "sel": "Selkup",
        "srp": "Sérvio",
        "srr": "Serere",
        "shn": "Shan",
        "sna": "Shona",
        "scn": "Sicilian",
        "sid": "Sidamo",
        "bla": "Siksika",
        "snd": "Sindi",
        "sin": "Cingalês",
        "den": "Slave (Athapascan)",
        "slk": "Eslovaco",
        "slv": "Esloveno",
        "sog": "Sogdian",
        "som": "Somali",
        "snk": "Soninke",
        "spa": "Espanhol",
        "srn": "Sranan Tongo",
        "suk": "Sukuma",
        "sux": "Sumerian",
        "sun": "Sudanês",
        "sus": "Sosso",
        "swa": "Swahili (macrolanguage)",
        "ssw": "Swati",
        "swe": "Sueco",
        "syr": "Siríaco",
        "tgl": "Tagaloge",
        "tah": "Tahitian",
        "tgk": "Tajik",
        "tmh": "Tamaxeque",
        "tam": "Tamil",
        "tat": "Tatar",
        "tel": "Telugu",
        "ter": "Tereno",
        "tet": "Tétum",
        "tha": "Tailandês",
        "bod": "Tibetano",
        "tig": "Tigre",
        "tir": "Tigrinya",
        "tem": "Timne",
        "tiv": "Tiv",
        "tli": "Tlingit",
        "tpi": "Tok Pisin",
        "tkl": "Toquelauano",
        "tog": "Toganês (Nyasa)",
        "ton": "Tonga (ilhas tonga)",
        "tsi": "Tsimshian",
        "tso": "Tsonga",
        "tsn": "Tswana",
        "tum": "Tumbuka",
        "tur": "Turco",
        "tuk": "Turcomano",
        "tvl": "Tuvaluano",
        "tyv": "Tuvinian",
        "twi": "Twi",
        "udm": "Udmurt",
        "uga": "Ugarítico",
        "uig": "Uighur",
        "ukr": "Ucraniano",
        "umb": "Umbundu",
        "mis": "Idiomas sem código",
        "und": "Não identificável",
        "urd": "Urdu",
        "uzb": "Usbeque",
        "vai": "Vai",
        "ven": "Venda",
        "vie": "Vietnamita",
        "vol": "Volapük",
        "vot": "Votic",
        "wln": "Walloon",
        "war": "Waray (Philippines)",
        "was": "Washo",
        "cym": "Galês",
        "wal": "Wolaytta",
        "wol": "Uolofe",
        "xho": "Xosa",
        "sah": "Iacuto",
        "yao": "Iao",
        "yap": "Yapese",
        "yid": "Ídiche",
        "yor": "Iorubá",
        "zap": "Zapoteca",
        "zza": "Zaza",
        "zen": "Zenaga",
        "zha": "Zhuang",
        "zul": "Zulu",
        "zun": "Zuni"
    },
    "pt_BR": {
        "abk": "Abcázio",
        "ace": "Achém",
        "ach": "Acoli",
        "ada": "Adangme",
        "ady": "Adyghe",
        "aar": "Afar",
        "afh": "Afrihili",
        "afr": "Africânder",
        "ain": "Ainu (Japão)",
        "aka": "Akan",
        "akk": "Acadiano",
        "sqi": "Albanês",
        "ale": "Aleúte",
        "amh": "Amárico",
        "anp": "Angika",
        "ara": "Arabic",
        "arg": "Aragonese",
        "arp": "Arapaho",
        "arw": "Arawak",
        "hye": "Armênio",
        "asm": "Assamese",
        "ast": "Asturian",
        "ava": "Avaric",
        "ave": "Avestan",
        "awa": "Awadhi",
        "aym": "Aymara",
        "aze": "Azerbaijano",
        "ban": "Balinês",
        "bal": "Balúchi",
        "bam": "Bambara",
        "bas": "Basa (Cameroon)",
        "bak": "Bashkir",
        "eus": "Basque",
        "bej": "Beja",
        "bel": "Belarusian",
        "bem": "Bemba (Zambia)",
        "ben": "Bengali",
        "bit": "Berinomo",
        "bho": "Bhojpuri",
        "bik": "Bikol",
        "byn": "Bilin",
        "bin": "Bini",
        "bis": "Bislama",
        "zbl": "Blissymbols",
        "bos": "Bosnian",
        "bra": "Braj",
        "bre": "Bretão",
        "bug": "Buginese",
        "bul": "Búlgaro",
        "bua": "Buriat",
        "mya": "Birmanês",
        "cad": "Caddo",
        "cat": "Catalão",
        "ceb": "Cebuano",
        "chg": "Chagatai",
        "cha": "Chamorro",
        "che": "Chechen",
        "chr": "Cheroqui",
        "chy": "Cheyenne",
        "chb": "Chibcha",
        "zho": "Chinês",
        "chn": "Chinook jargon",
        "chp": "Chipewyan",
        "cho": "Choctaw",
        "cht": "Cholón",
        "chk": "Chuukese",
        "chv": "Chuvash",
        "cop": "Coptic",
        "cor": "Cornish",
        "cos": "Corsican",
        "cre": "Cree",
        "mus": "Creek",
        "hrv": "Croata",
        "ces": "Czech",
        "dak": "Dacota",
        "dan": "Danish",
        "dar": "Dargwa",
        "del": "Delaware",
        "div": "Dhivehi",
        "din": "Dinka",
        "doi": "Dogri (macrolanguage)",
        "dgr": "Dogrib",
        "dua": "Duala",
        "nld": "Holandês",
        "dse": "Língua gestual holandesa",
        "dyu": "Dyula",
        "dzo": "Dzongkha",
        "efi": "Efik",
        "egy": "Egyptian (Ancient)",
        "eka": "Ekajuk",
        "elx": "Elamite",
        "eng": "Inglês",
        "enu": "Enu",
        "myv": "Erzya",
        "epo": "Esperanto",
        "est": "Estónio",
        "ewe": "Ewe",
        "ewo": "Ewondo",
        "fan": "Fang (Equatorial Guinea)",
        "fat": "Fanti",
        "fao": "Faroese",
        "fij": "Fijian",
        "fil": "Filipino",
        "fin": "Finlandês",
        "fon": "Fon",
        "fra": "Francês",
        "fur": "Friuliano",
        "ful": "Fulah",
        "gaa": "Ga",
        "glg": "Galician",
        "lug": "Ganda",
        "gay": "Gayo",
        "gba": "Gbaya (Central African Republic)",
        "hmj": "Ge",
        "gez": "Geez",
        "kat": "Georgiano",
        "deu": "Alemão",
        "gil": "Gilbertês",
        "gon": "Gondi",
        "gor": "Gorontalo",
        "got": "Gótico",
        "grb": "Grebo",
        "grn": "Guarani",
        "guj": "Guzerate",
        "gwi": "Gwichʼin",
        "hai": "Haida",
        "hau": "Hauçá",
        "haw": "Havaiano",
        "heb": "Hebraico",
        "her": "Herero",
        "hil": "Hiligaynon",
        "hin": "Hindi",
        "hmo": "Hiri Motu",
        "hit": "Hitita",
        "hmn": "Hmong",
        "hun": "Húngaro",
        "hup": "Hupa",
        "iba": "Iban",
        "isl": "Islandês",
        "ido": "Ido",
        "ibo": "Igbo",
        "ilo": "Ilocano",
        "ind": "Indonésio",
        "inh": "Ingush",
        "ina": "Interlingua (International Auxiliary Language Association)",
        "ile": "Interlingue",
        "iku": "Inuktitut",
        "ipk": "Inupiaq",
        "gle": "Irlandês",
        "ita": "Italiano",
        "jpn": "Japanese",
        "jav": "Javanês",
        "jrb": "Judeo-Arabic",
        "jpr": "Judeo-Persian",
        "kbd": "Kabardian",
        "kab": "Kabyle",
        "kac": "Kachin",
        "kal": "Kalaallisut",
        "xal": "Kalmyk",
        "kam": "Kamba (Quênia)",
        "kan": "Canarês",
        "kau": "Kanuri",
        "kaa": "Kara-Kalpak",
        "krc": "Karachay-Balkar",
        "krl": "Karelian",
        "kas": "Kashmiri",
        "csb": "Kashubian",
        "kaw": "Kawi",
        "kaz": "Cazaque",
        "kha": "Khasi",
        "kho": "Khotanese",
        "kik": "Quicuio",
        "kmb": "Quimbundo",
        "kin": "Kinyarwanda",
        "kir": "Quirguiz",
        "tlh": "Klingon",
        "kom": "Komi",
        "kon": "Quicongo",
        "kok": "Konkani (macrolanguage)",
        "kor": "Coreano",
        "kos": "Kosraean",
        "kpe": "Kpelle",
        "kua": "Kuanyama",
        "kum": "Kumyk",
        "kur": "Kurdish",
        "kru": "Kurukh",
        "kut": "Kutenai",
        "lad": "Ladino",
        "lah": "Lahnda",
        "lam": "Lamba",
        "lao": "Laosiano",
        "lat": "Latin",
        "lav": "Letão",
        "lez": "Lezghian",
        "lim": "Limburgan",
        "lin": "Lingala",
        "lit": "Lituano",
        "jbo": "Lojban",
        "loz": "Lozi",
        "lub": "Luba-Catanga",
        "lua": "Luba-Lulua",
        "lui": "Luiseno",
        "smj": "Lule Sami",
        "lun": "Lunda",
        "luo": "Luo (Kenya and Tanzania)",
        "lus": "Lushai",
        "ltz": "Luxembourgish",
        "mkd": "Macedónio",
        "mad": "Madurese",
        "mag": "Magahi",
        "mai": "Maithili",
        "mak": "Makasar",
        "mlg": "Malgaxe",
        "msa": "Malay (macrolanguage)",
        "mal": "Malayalam",
        "mlt": "Maltese",
        "mnc": "Manchu",
        "mdr": "Mandar",
        "man": "Mandinga",
        "mni": "Manipuri",
        "glv": "Manx",
        "mri": "Maori",
        "arn": "Mapudungun",
        "mar": "Marata",
        "chm": "Mari (Russia)",
        "mah": "Marshallese",
        "mwr": "Marwari",
        "mas": "Masai",
        "men": "Mende (Sierra Leone)",
        "mic": "Mi'kmaq",
        "min": "Minangkabau",
        "mwl": "Mirandês",
        "moh": "Mohawk",
        "mdf": "Mocsa",
        "lol": "Mongo",
        "mon": "Mongolian",
        "mos": "Mossi",
        "mul": "Múltiplos idiomas",
        "nqo": "N'Ko",
        "nau": "Nauruano",
        "nav": "Navajo",
        "ndo": "Ndonga",
        "nap": "Neapolitan",
        "nia": "Nias",
        "niu": "Niueano",
        "zxx": "Sem conteúdo linguistico",
        "nog": "Nogai",
        "nor": "Norueguês",
        "nob": "Norueguês, Dano",
        "nno": "Norueguês, Novo",
        "nym": "Nyamwezi",
        "nya": "Nyanja",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Occitan (post 1500)",
        "oji": "Ojibwa",
        "orm": "Oromo",
        "osa": "Osage",
        "oss": "Ossetian",
        "pal": "Pálavi",
        "pau": "Palauano",
        "pli": "Pali",
        "pam": "Pampanga",
        "pag": "Pangasinense",
        "pan": "Panjabi",
        "pap": "Papiamento",
        "fas": "Persian",
        "phn": "Fenício",
        "pon": "Pohnpeian",
        "pol": "Polaco",
        "por": "Português",
        "pus": "Pushto",
        "que": "Quíchua",
        "raj": "Rajastani",
        "rap": "Rapanui",
        "ron": "Romeno",
        "roh": "Romansh",
        "rom": "Romany",
        "run": "Rundi",
        "rus": "Russo",
        "smo": "Samoan",
        "sad": "Sandawe",
        "sag": "Sango",
        "san": "Sanskrit",
        "sat": "Santali",
        "srd": "Sardinian",
        "sas": "Sasak",
        "sco": "Scots",
        "sel": "Selkup",
        "srp": "Sérvio",
        "srr": "Serere",
        "shn": "Shan",
        "sna": "Shona",
        "scn": "Sicilian",
        "sid": "Sidamo",
        "bla": "Siksika",
        "snd": "Sindi",
        "sin": "Cingalês",
        "den": "Slave (Athapascan)",
        "slk": "Eslovaco",
        "slv": "Esloveno",
        "sog": "Sogdian",
        "som": "Somali",
        "snk": "Soninke",
        "spa": "Espanhol",
        "srn": "Sranan Tongo",
        "suk": "Sukuma",
        "sux": "Sumerian",
        "sun": "Sudanês",
        "sus": "Sosso",
        "swa": "Swahili (macrolanguage)",
        "ssw": "Swati",
        "swe": "Sueco",
        "syr": "Siríaco",
        "tgl": "Tagaloge",
        "tah": "Tahitian",
        "tgk": "Tajik",
        "tmh": "Tamaxeque",
        "tam": "Tamil",
        "tat": "Tatar",
        "tel": "Telugu",
        "ter": "Tereno",
        "tet": "Tétum",
        "tha": "Tailandês",
        "bod": "Tibetano",
        "tig": "Tigre",
        "tir": "Tigrinya",
        "tem": "Timne",
        "tiv": "Tiv",
        "tli": "Tlingit",
        "tpi": "Tok Pisin",
        "tkl": "Toquelauano",
        "tog": "Toganês (Nyasa)",
        "ton": "Tonga (ilhas tonga)",
        "tsi": "Tsimshian",
        "tso": "Tsonga",
        "tsn": "Tswana",
        "tum": "Tumbuka",
        "tur": "Turco",
        "tuk": "Turcomano",
        "tvl": "Tuvaluano",
        "tyv": "Tuvinian",
        "twi": "Twi",
        "udm": "Udmurt",
        "uga": "Ugarítico",
        "uig": "Uighur",
        "ukr": "Ucraniano",
        "umb": "Umbundu",
        "mis": "Idiomas sem código",
        "und": "Não identificável",
        "urd": "Urdu",
        "uzb": "Usbeque",
        "vai": "Vai",
        "ven": "Venda",
        "vie": "Vietnamita",
        "vol": "Volapük",
        "vot": "Votic",
        "wln": "Walloon",
        "war": "Waray (Philippines)",
        "was": "Washo",
        "cym": "Galês",
        "wal": "Wolaytta",
        "wol": "Uolofe",
        "xho": "Xosa",
        "sah": "Iacuto",
        "yao": "Iao",
        "yap": "Yapese",
        "yid": "Ídiche",
        "yor": "Iorubá",
        "zap": "Zapoteca",
        "zza": "Zaza",
        "zen": "Zenaga",
        "zha": "Zhuang",
        "zul": "Zulu",
        "zun": "Zuni"
    },
    "ru": {
        "aar": "Афар",
        "abk": "Абхазский",
        "ace": "Ачехский",
        "ach": "Ачоли",
        "ada": "Адангме",
        "ady": "Адыгейский",
        "afh": "Африхили",
        "afr": "Африкаанс",
        "ain": "Ainu (Japan)",
        "aka": "Акан",
        "akk": "Аккадский",
        "ale": "Алеутский",
        "alt": "Altai; Southern",
        "amh": "Амхарский (Амаринья)",
        "ang": "English; Old (ca. 450-1100)",
        "anp": "Анжика",
        "ara": "Арабский",
        "arc": "Арамейский; Официальный",
        "arg": "Арагонский",
        "arn": "Mapudungun",
        "arp": "Арапахо",
        "arw": "Аравакский",
        "asm": "Ассамский",
        "ast": "Астурийский",
        "ava": "Аварский",
        "ave": "Авестийский",
        "awa": "Авадхи",
        "aym": "Аймара",
        "aze": "Азербайджанский",
        "bak": "Башкирский",
        "bal": "Baluchi",
        "bam": "Бамбара",
        "ban": "Балийский",
        "bas": "Баса (Камерун)",
        "bej": "Беджа",
        "bel": "Белорусский",
        "bem": "Бемба (Замбия)",
        "ben": "Бенгальский",
        "bho": "Бходжпури",
        "bik": "Бикольский",
        "bin": "Бини",
        "bis": "Бислама",
        "bit": "Berinomo",
        "bla": "Сиксика",
        "bod": "Тибетский",
        "bos": "Боснийский",
        "bra": "Браун",
        "bre": "Бретонский",
        "bua": "Бурятский",
        "bug": "Бугийский",
        "bul": "Болгарский",
        "byn": "Bilin",
        "cad": "Каддо",
        "car": "Carib; Galibi",
        "cat": "Каталанский",
        "ceb": "Себуано",
        "ces": "Чешский",
        "cha": "Чаморро",
        "chb": "Чибча",
        "che": "Чеченский",
        "chg": "Чагатайский",
        "chk": "Трукский",
        "chm": "Марийский (Россия)",
        "chn": "Чинук жаргон",
        "cho": "Чоктав",
        "chp": "Чипевианский",
        "chr": "Чероки",
        "cht": "Cholón",
        "chu": "Slavonic; Old",
        "chv": "Чувашский",
        "chy": "Чейенн",
        "cop": "Коптский",
        "cor": "Корнский",
        "cos": "Корсиканский",
        "cre": "Кри",
        "crh": "Turkish; Crimean",
        "csb": "Кашубианский",
        "cym": "Уэльский (Валлийский)",
        "dak": "Дакота",
        "dan": "Датский",
        "dar": "Даргва",
        "del": "Делаварский",
        "den": "Атапачские языки",
        "deu": "Немецкий",
        "dgr": "Догриб",
        "din": "Динка",
        "div": "Dhivehi",
        "doi": "Dogri (macrolanguage)",
        "dsb": "Sorbian; Lower",
        "dse": "Dutch Sign Language",
        "dua": "Дуала",
        "dum": "Dutch; Middle (ca. 1050-1350)",
        "dyu": "Диула (Дьюла)",
        "dzo": "Дзонг-кэ",
        "efi": "Эфик",
        "egy": "Древнеегипетский",
        "eka": "Экаджук",
        "ell": "Новогреческий (с 1453)",
        "elx": "Эламский",
        "eng": "Английский",
        "enm": "Среднеанглийский (1100-1500)",
        "enu": "Enu",
        "epo": "Эсперанто",
        "est": "Эстонский",
        "eus": "Баскский",
        "ewe": "Эве",
        "ewo": "Эвондо",
        "fan": "Fang (Equatorial Guinea)",
        "fao": "Фарерский",
        "fas": "Персидский",
        "fat": "Фанти",
        "fij": "Фиджийский",
        "fil": "Filipino",
        "fin": "Финский",
        "fon": "Фон",
        "fra": "Французский",
        "frm": "French; Middle (ca. 1400-1600)",
        "fro": "French; Old (842-ca. 1400)",
        "frr": "Frisian; Northern",
        "frs": "Frisian; Eastern",
        "fry": "Frisian; Western",
        "ful": "Фулах",
        "fur": "Фриулианский",
        "gaa": "Га",
        "gay": "Гайо",
        "gba": "Gbaya (Central African Republic)",
        "gez": "Геэз",
        "gil": "Гильбертский",
        "gla": "Gaelic; Scottish",
        "gle": "Ирландский",
        "glg": "Galician",
        "glv": "Мэнкский",
        "gmh": "German; Middle High (ca. 1050-1500)",
        "goh": "German; Old High (ca. 750-1050)",
        "gon": "Гонди",
        "gor": "Горонтало",
        "got": "Готский",
        "grb": "Гребо",
        "grc": "Древнегреческий (по 1453)",
        "grn": "Гуарани",
        "gsw": "German; Swiss",
        "guj": "Гуджарати",
        "gwi": "Gwichʼin",
        "hai": "Хайда",
        "hat": "Creole; Haitian",
        "hau": "Хауса",
        "haw": "Гавайский",
        "heb": "Иврит",
        "her": "Гереро",
        "hil": "Хилигайнон",
        "hin": "Хинди",
        "hit": "Хиттит",
        "hmj": "Ge",
        "hmn": "Хмонг",
        "hmo": "Хири Моту",
        "hrv": "Хорватский",
        "hsb": "Sorbian; Upper",
        "hun": "Венгерский",
        "hup": "Хупа",
        "hye": "Армянский",
        "iba": "Ибанский",
        "ibo": "Игбо",
        "ido": "Идо",
        "iii": "Yi; Sichuan",
        "iku": "Инуктитут",
        "ile": "Интерлингве",
        "ilo": "Илоко",
        "ina": "Интерлингва (Ассоциация международного вспомогательного языка)",
        "ind": "Индонезийский",
        "inh": "Ингушский",
        "ipk": "Инулиак",
        "isl": "Исландский",
        "ita": "Итальянский",
        "jav": "Яванский",
        "jbo": "Лоджбан",
        "jpn": "Японский",
        "jpr": "Еврейско-персидский",
        "jrb": "Еврейско-арабский",
        "kaa": "Каракалпакский",
        "kab": "Кабильский",
        "kac": "Качинский",
        "kal": "Kalaallisut",
        "kam": "Kamba (Kenya)",
        "kan": "Каннада",
        "kas": "Кашмири",
        "kat": "Грузинский",
        "kau": "Канури",
        "kaw": "Кави",
        "kaz": "Казахский",
        "kbd": "Кабардинский",
        "kha": "Кхаси",
        "khm": "Khmer; Central",
        "kho": "Хотанский",
        "kik": "Кикуйю",
        "kin": "Киньяруанда",
        "kir": "Киргизский",
        "kmb": "Кимбунду",
        "kok": "Konkani (macrolanguage)",
        "kom": "Коми",
        "kon": "Конго",
        "kor": "Корейский",
        "kos": "Косраинский",
        "kpe": "Кпелле",
        "krc": "Карачаево-балкарский",
        "krl": "Карельский",
        "kru": "Курух",
        "kua": "Киньяма",
        "kum": "Кумыкский",
        "kur": "Курдский",
        "kut": "Кутенаи",
        "lad": "Ладино",
        "lah": "Лахнда",
        "lam": "Ламба",
        "lao": "Лаосский",
        "lat": "Латинский",
        "lav": "Латвийский",
        "lez": "Лезгинский",
        "lim": "Limburgan",
        "lin": "Лингала",
        "lit": "Литовский",
        "lol": "Монго",
        "loz": "Лози",
        "ltz": "Luxembourgish",
        "lua": "Луба-Лулуа",
        "lub": "Луба-Катанга",
        "lug": "Ганда",
        "lui": "Луисеньо",
        "lun": "Лунда",
        "luo": "Луо (Кения и Танзания)",
        "lus": "Лушай",
        "mad": "Мадурский",
        "mag": "Магахи",
        "mah": "Marshallese",
        "mai": "Майтхили",
        "mak": "Макассарский",
        "mal": "Малаялам",
        "man": "Мандинго",
        "mar": "Маратхи",
        "mas": "Масаи",
        "mdf": "Мокшанский",
        "mdr": "Мандарский",
        "men": "Mende (Sierra Leone)",
        "mga": "Среднеирландский (900-1200)",
        "mic": "Mi'kmaq",
        "min": "Минангкабау",
        "mis": "Uncoded languages",
        "mkd": "Македонский",
        "mlg": "Малагаси",
        "mlt": "Мальтийский",
        "mnc": "Манчу",
        "mni": "Манипури",
        "moh": "Мохаук",
        "mon": "Монгольский",
        "mos": "Моей",
        "mri": "Маори",
        "msa": "Malay (macrolanguage)",
        "mul": "Разных семей языки",
        "mus": "Крик",
        "mwl": "Мирандские",
        "mwr": "Марвари",
        "mya": "Бирманский",
        "myv": "Эрзянский",
        "nap": "Неаполитанский",
        "nau": "Науру",
        "nav": "Navajo",
        "nbl": "Ндебеле южный",
        "nde": "Ндебеле северный",
        "ndo": "Ндунга",
        "nds": "German; Low",
        "nep": "Непальский",
        "new": "Bhasa; Nepal",
        "nia": "Ниас",
        "niu": "Ниуэ",
        "nld": "Нидерландский",
        "nno": "Норвежский Нюнорск",
        "nob": "Norwegian Bokmål",
        "nog": "Ногайский",
        "non": "Старонорвежский",
        "nor": "Норвежский",
        "nqo": "Н'ко",
        "nso": "Sotho; Northern",
        "nwc": "Newari; Old",
        "nya": "Nyanja",
        "nym": "Ньямвези",
        "nyn": "Ньянколе",
        "nyo": "Ньоро",
        "nzi": "Нзима",
        "oci": "Occitan (post 1500)",
        "oji": "Оджибва",
        "ori": "Ория",
        "orm": "Оромо",
        "osa": "Оседжи",
        "oss": "Ossetian",
        "ota": "Турецкий; Отомангский (1500-1928)",
        "pag": "Пангасинан",
        "pal": "Пехлевийский",
        "pam": "Пампанга",
        "pan": "Panjabi",
        "pap": "Папьяменто",
        "pau": "Палау",
        "peo": "Persian; Old (ca. 600-400 B.C.)",
        "phn": "Финикийский",
        "pli": "Пали",
        "pol": "Польский",
        "pon": "Фонпейский",
        "por": "Португальский",
        "pro": "Старопровансальский (по 1500)",
        "pus": "Пушту",
        "que": "Кечуа",
        "raj": "Раджастхани",
        "rap": "Рапаню",
        "rar": "Maori; Cook Islands",
        "roh": "Romansh",
        "rom": "Цыганский",
        "ron": "Румынский",
        "run": "Рунди",
        "rup": "Romanian; Macedo-",
        "rus": "Русский",
        "sad": "Сандаве",
        "sag": "Санго",
        "sah": "Якутский",
        "sam": "Aramaic; Samaritan",
        "san": "Санскрит",
        "sas": "Сасакский",
        "sat": "Сантали",
        "scn": "Сицилийский",
        "sco": "Шотландский",
        "sel": "Селкапский",
        "sga": "Староирландский (по 900)",
        "shn": "Шанский",
        "sid": "Сидама",
        "sin": "Сингальский",
        "slk": "Словацкий",
        "slv": "Словенский",
        "sma": "Sami; Southern",
        "sme": "Sami; Northern",
        "smj": "Люле-саамский",
        "smn": "Sami; Inari",
        "smo": "Самоанский",
        "sms": "Sami; Skolt",
        "sna": "Шона",
        "snd": "Синдхи",
        "snk": "Сонинк",
        "sog": "Согдийский",
        "som": "Сомали",
        "sot": "Сото Южный",
        "spa": "Испанский",
        "sqi": "Албанский",
        "srd": "Сардинский",
        "srn": "Sranan Tongo",
        "srp": "Сербский",
        "srr": "Серер",
        "ssw": "Свати",
        "suk": "Сукума",
        "sun": "Сунданский",
        "sus": "Сусу",
        "sux": "Шумерский",
        "swa": "Swahili (macrolanguage)",
        "swe": "Шведский",
        "syc": "Syriac; Classical",
        "syr": "Сирийский",
        "tah": "Таитянский",
        "tam": "Тамильский",
        "tat": "Татарский",
        "tel": "Телугу",
        "tem": "Темне",
        "ter": "Терено",
        "tet": "Тетумский",
        "tgk": "Таджикский",
        "tgl": "Тагалог",
        "tha": "Таи",
        "tig": "Тигре",
        "tir": "Тигринья",
        "tiv": "Тив",
        "tkl": "Токелау",
        "tlh": "Klingon",
        "tli": "Тлингит",
        "tmh": "Тамашек",
        "tog": "Тонга (Ньяса)",
        "ton": "Тонга (острова Тонга)",
        "tpi": "Ток Писин",
        "tsi": "Цимшиан",
        "tsn": "Тсвана",
        "tso": "Тсонга",
        "tuk": "Туркменский",
        "tum": "Тумбука",
        "tur": "Турецкий",
        "tvl": "Тувалу",
        "twi": "Тви",
        "tyv": "Тувинский",
        "udm": "Удмуртский",
        "uga": "Угаритский",
        "uig": "Уйгурский",
        "ukr": "Украинский",
        "umb": "Умбунду",
        "und": "Неидентифицированный",
        "urd": "Урду",
        "uzb": "Узбекский",
        "vai": "Ваи",
        "ven": "Венда",
        "vie": "Вьетнамский",
        "vol": "Волапюк",
        "vot": "Вотик",
        "wal": "Wolaytta",
        "war": "Waray (Philippines)",
        "was": "Вашо",
        "wln": "Валлун",
        "wol": "Волоф",
        "xal": "Kalmyk",
        "xho": "Коса",
        "yao": "Яо",
        "yap": "Яапийский",
        "yid": "Идиш",
        "yor": "Йоруба",
        "zap": "Сапотекский",
        "zbl": "Blissymbols",
        "zen": "Зенагский",
        "zha": "Чжуанский",
        "zho": "Китайский",
        "zul": "Зулусский",
        "zun": "Зуньи",
        "zxx": "Нет языкового содержимого",
        "zza": "Зазаки"
    },
    "sk": {
        "abk": "Abkhazian",
        "ace": "Achinese",
        "ach": "Acoli",
        "ada": "Adangme",
        "ady": "Adyghe",
        "aar": "Afar",
        "afh": "Afrihili",
        "afr": "Afrikánsky",
        "ain": "Ainu (Japan)",
        "aka": "Akan",
        "akk": "Akkadian",
        "sqi": "Albanian",
        "ale": "Aleut",
        "amh": "Amharic",
        "anp": "Angika",
        "ara": "Arabská",
        "arg": "Aragonese",
        "arp": "Arapaho",
        "arw": "Arawak",
        "hye": "Arménčina",
        "asm": "Assamese",
        "ast": "Asturian",
        "ava": "Avaric",
        "ave": "Avestan",
        "awa": "Awadhi",
        "aym": "Aymara",
        "aze": "Ázerbajdžánsky",
        "ban": "Balinese",
        "bal": "Baluchi",
        "bam": "Bambara",
        "bas": "Basa (Cameroon)",
        "bak": "Bashkir",
        "eus": "Baskitský",
        "bej": "Beja",
        "bel": "Belarusian",
        "bem": "Bemba (Zambia)",
        "ben": "Bengali",
        "bit": "Berinomo",
        "bho": "Bhojpuri",
        "bik": "Bikol",
        "byn": "Bilin",
        "bin": "Bini",
        "bis": "Bislama",
        "zbl": "Blissymbols",
        "bos": "Bosnian",
        "bra": "Braj",
        "bre": "Bretónsky",
        "bug": "Buginese",
        "bul": "Bulharský",
        "bua": "Buriat",
        "mya": "Burmese",
        "cad": "Caddo",
        "cat": "Katalánsky",
        "ceb": "Cebuano",
        "chg": "Chagatai",
        "cha": "Chamorro",
        "che": "Chechen",
        "chr": "Cherokee",
        "chy": "Cheyenne",
        "chb": "Chibcha",
        "zho": "Čínsky",
        "chn": "Chinook jargon",
        "chp": "Chipewyan",
        "cho": "Choctaw",
        "cht": "Cholón",
        "chk": "Chuukese",
        "chv": "Chuvash",
        "cop": "Coptic",
        "cor": "Cornish",
        "cos": "Corsican",
        "cre": "Cree",
        "mus": "Creek",
        "hrv": "Chorvátsky",
        "ces": "Český",
        "dak": "Dakota",
        "dan": "Dánsky",
        "dar": "Dargwa",
        "del": "Delaware",
        "div": "Dhivehi",
        "din": "Dinka",
        "doi": "Dogri (macrolanguage)",
        "dgr": "Dogrib",
        "dua": "Duala",
        "nld": "Holandský",
        "dse": "Dutch Sign Language",
        "dyu": "Dyula",
        "dzo": "Dzongkha",
        "efi": "Efik",
        "egy": "Egyptian (Ancient)",
        "eka": "Ekajuk",
        "elx": "Elamite",
        "eng": "Angličtina",
        "enu": "Enu",
        "myv": "Erzya",
        "epo": "Esperanto",
        "est": "Estónsky",
        "ewe": "Ewe",
        "ewo": "Ewondo",
        "fan": "Fang (Equatorial Guinea)",
        "fat": "Fanti",
        "fao": "Faroese",
        "fij": "Fijian",
        "fil": "Filipino",
        "fin": "Fínsky",
        "fon": "Fon",
        "fra": "Francúzsky",
        "fur": "Friulian",
        "ful": "Fulah",
        "gaa": "Ga",
        "glg": "Galician",
        "lug": "Ganda",
        "gay": "Gayo",
        "gba": "Gbaya (Central African Republic)",
        "hmj": "Ge",
        "gez": "Geez",
        "kat": "Georgian",
        "deu": "Nemecký",
        "gil": "Gilbertese",
        "gon": "Gondi",
        "gor": "Gorontalo",
        "got": "Gothic",
        "grb": "Grebo",
        "grn": "Guarani",
        "guj": "Gujarati",
        "gwi": "Gwichʼin",
        "hai": "Haida",
        "hau": "Hausa",
        "haw": "Hawaiian",
        "heb": "Hebrejský",
        "her": "Herero",
        "hil": "Hiligaynon",
        "hin": "Hindi",
        "hmo": "Hiri Motu",
        "hit": "Hittite",
        "hmn": "Hmong",
        "hun": "Maďarský",
        "hup": "Hupa",
        "iba": "Iban",
        "isl": "Islandský",
        "ido": "Ido",
        "ibo": "Igbo",
        "ilo": "Iloko",
        "ind": "Indonézsky",
        "inh": "Ingush",
        "ina": "Interlingua (International Auxiliary Language Association)",
        "ile": "Interlingue",
        "iku": "Inuktitut",
        "ipk": "Inupiaq",
        "gle": "Írsky",
        "ita": "Taliansky",
        "jpn": "Japonský",
        "jav": "Javanese",
        "jrb": "Judeo-Arabic",
        "jpr": "Judeo-Persian",
        "kbd": "Kabardian",
        "kab": "Kabyle",
        "kac": "Kachin",
        "kal": "Kalaallisut",
        "xal": "Kalmyk",
        "kam": "Kamba (Kenya)",
        "kan": "Kannada",
        "kau": "Kanuri",
        "kaa": "Kara-Kalpak",
        "krc": "Karachay-Balkar",
        "krl": "Karelian",
        "kas": "Kashmiri",
        "csb": "Kashubian",
        "kaw": "Kawi",
        "kaz": "Kazakh",
        "kha": "Khasi",
        "kho": "Khotanese",
        "kik": "Kikuyu",
        "kmb": "Kimbundu",
        "kin": "Kinyarwanda",
        "kir": "Kirghiz",
        "tlh": "Klingon",
        "kom": "Komi",
        "kon": "Kongo",
        "kok": "Konkani (macrolanguage)",
        "kor": "Kórejský",
        "kos": "Kosraean",
        "kpe": "Kpelle",
        "kua": "Kuanyama",
        "kum": "Kumyk",
        "kur": "Kurdský",
        "kru": "Kurukh",
        "kut": "Kutenai",
        "lad": "Ladino",
        "lah": "Lahnda",
        "lam": "Lamba",
        "lao": "Lao",
        "lat": "Latin",
        "lav": "Latvian",
        "lez": "Lezghian",
        "lim": "Limburgan",
        "lin": "Lingala",
        "lit": "Lotyšský",
        "jbo": "Lojban",
        "loz": "Lozi",
        "lub": "Luba-Katanga",
        "lua": "Luba-Lulua",
        "lui": "Luiseno",
        "smj": "Lule Sami",
        "lun": "Lunda",
        "luo": "Luo (Kenya and Tanzania)",
        "lus": "Lushai",
        "ltz": "Luxembourgish",
        "mkd": "Macedónsky",
        "mad": "Madurese",
        "mag": "Magahi",
        "mai": "Maithili",
        "mak": "Makasar",
        "mlg": "Malagasy",
        "msa": "Malay (macrolanguage)",
        "mal": "Malayalam",
        "mlt": "Maltézsky",
        "mnc": "Manchu",
        "mdr": "Mandar",
        "man": "Mandingo",
        "mni": "Manipuri",
        "glv": "Manx",
        "mri": "Maori",
        "arn": "Mapudungun",
        "mar": "Marathi",
        "chm": "Mari (Russia)",
        "mah": "Marshallese",
        "mwr": "Marwari",
        "mas": "Masai",
        "men": "Mende (Sierra Leone)",
        "mic": "Mi'kmaq",
        "min": "Minangkabau",
        "mwl": "Mirandese",
        "moh": "Mohawk",
        "mdf": "Moksha",
        "lol": "Mongo",
        "mon": "Mongolian",
        "mos": "Mossi",
        "mul": "Multiple languages",
        "nqo": "N'Ko",
        "nau": "Nauru",
        "nav": "Navajo",
        "ndo": "Ndonga",
        "nap": "Neapolitan",
        "nia": "Nias",
        "niu": "Niuean",
        "zxx": "No linguistic content",
        "nog": "Nogai",
        "nor": "Norwegian",
        "nob": "Norwegian Bokmål",
        "nno": "Norwegian Nynorsk",
        "nym": "Nyamwezi",
        "nya": "Nyanja",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Occitan (post 1500)",
        "oji": "Ojibwa",
        "orm": "Oromo",
        "osa": "Osage",
        "oss": "Ossetian",
        "pal": "Pahlavi",
        "pau": "Palauan",
        "pli": "Pali",
        "pam": "Pampanga",
        "pag": "Pangasinan",
        "pan": "Panjabi",
        "pap": "Papiamento",
        "fas": "Persian",
        "phn": "Phoenician",
        "pon": "Pohnpeian",
        "pol": "Poľský",
        "por": "Portugalský",
        "pus": "Pashto",
        "que": "Quechua",
        "raj": "Rajasthani",
        "rap": "Rapanui",
        "ron": "Rumunský",
        "roh": "Romansh",
        "rom": "Romany",
        "run": "Rundi",
        "rus": "Ruský",
        "smo": "Samoan",
        "sad": "Sandawe",
        "sag": "Sango",
        "san": "Sanskrit",
        "sat": "Santali",
        "srd": "Sardinian",
        "sas": "Sasak",
        "sco": "Scots",
        "sel": "Selkup",
        "srp": "Srbský",
        "srr": "Serer",
        "shn": "Shan",
        "sna": "Shona",
        "scn": "Sicilian",
        "sid": "Sidamo",
        "bla": "Siksika",
        "snd": "Sindhi",
        "sin": "Sinhala",
        "den": "Slave (Athapascan)",
        "slk": "Slovenský",
        "slv": "Slovinský",
        "sog": "Sogdian",
        "som": "Somali",
        "snk": "Soninke",
        "spa": "Španielsky",
        "srn": "Sranan Tongo",
        "suk": "Sukuma",
        "sux": "Sumerian",
        "sun": "Sundanese",
        "sus": "Susu",
        "swa": "Swahili (macrolanguage)",
        "ssw": "Swati",
        "swe": "Švédsky",
        "syr": "Syriac",
        "tgl": "Tagalog",
        "tah": "Tahitian",
        "tgk": "Tajik",
        "tmh": "Tamashek",
        "tam": "Tamilský",
        "tat": "Tatar",
        "tel": "Telugu",
        "ter": "Tereno",
        "tet": "Tetum",
        "tha": "Thajský",
        "bod": "Tibetan",
        "tig": "Tigre",
        "tir": "Tigrinya",
        "tem": "Timne",
        "tiv": "Tiv",
        "tli": "Tlingit",
        "tpi": "Tok Pisin",
        "tkl": "Tokelau",
        "tog": "Tonga (Nyasa)",
        "ton": "Tonga (Tonga Islands)",
        "tsi": "Tsimshian",
        "tso": "Tsonga",
        "tsn": "Tswana",
        "tum": "Tumbuka",
        "tur": "Turecký",
        "tuk": "Turkmen",
        "tvl": "Tuvalu",
        "tyv": "Tuvinian",
        "twi": "Twi",
        "udm": "Udmurt",
        "uga": "Ugaritic",
        "uig": "Uighur",
        "ukr": "Ukrainian",
        "umb": "Umbundu",
        "mis": "Uncoded languages",
        "und": "Undetermined",
        "urd": "Urdu",
        "uzb": "Uzbek",
        "vai": "Vai",
        "ven": "Venda",
        "vie": "Vietnamský",
        "vol": "Volapük",
        "vot": "Votic",
        "wln": "Vallónsky",
        "war": "Waray (Philippines)",
        "was": "Washo",
        "cym": "Welšský",
        "wal": "Wolaytta",
        "wol": "Wolof",
        "xho": "Xhosa",
        "sah": "Yakut",
        "yao": "Yao",
        "yap": "Yapese",
        "yid": "Yiddish",
        "yor": "Yoruba",
        "zap": "Zapotec",
        "zza": "Zaza",
        "zen": "Zenaga",
        "zha": "Zhuang",
        "zul": "Zulu",
        "zun": "Zuni"
    },
    "sl": {
        "abk": "abhazijski",
        "ace": "achinese",
        "ach": "Acoli",
        "ada": "Adangme",
        "ady": "Adyghe",
        "aar": "afarski",
        "afh": "Afrihili",
        "afr": "afrikanski",
        "ain": "Ainu (Japan)",
        "aka": "Akan",
        "akk": "akadski",
        "sqi": "albanščina",
        "ale": "aleutski",
        "amh": "amharski",
        "anp": "Angika",
        "ara": "arabski",
        "arg": "aragonski",
        "arp": "Arapaho",
        "arw": "araukanski",
        "hye": "armenščina",
        "asm": "asamski",
        "ast": "Asturian",
        "ava": "avarski",
        "ave": "avestijski jeziki",
        "awa": "Awadhi",
        "aym": "Aymara",
        "aze": "azerbajdžanski",
        "ban": "balijščina",
        "bal": "belučijski",
        "bam": "bambarski",
        "bas": "Basa (Cameroon)",
        "bak": "baškirski",
        "eus": "baskovščina",
        "bej": "Beja",
        "bel": "beloruščina",
        "bem": "Bemba (Zambia)",
        "ben": "bengalščina",
        "bit": "Berinomo",
        "bho": "Bhojpuri",
        "bik": "bikolščina",
        "byn": "Bilin",
        "bin": "Bini",
        "bis": "bislama",
        "zbl": "Blissymbols",
        "bos": "bošnjaščina",
        "bra": "Braj",
        "bre": "bretonščina",
        "bug": "buginščina",
        "bul": "bolgarščina",
        "bua": "burjatščina",
        "mya": "burmanščina",
        "cad": "kadajščina?",
        "cat": "katalonščina",
        "ceb": "cebuanščina",
        "chg": "Chagatai",
        "cha": "čamorščina",
        "che": "čečenščina",
        "chr": "čerokeščina",
        "chy": "čejenščina",
        "chb": "čibčevščina",
        "zho": "kitajščina",
        "chn": "Chinook jargon",
        "chp": "čipevščina",
        "cho": "Choctaw",
        "cht": "Cholón",
        "chk": "Chuukese",
        "chv": "čuvaščina",
        "cop": "koptščina",
        "cor": "kornijščina",
        "cos": "korzijščina",
        "cre": "krijščina",
        "mus": "Creek",
        "hrv": "hrvaščina",
        "ces": "češčina",
        "dak": "Dakota",
        "dan": "danski",
        "dar": "Dargwa",
        "del": "Delaware",
        "div": "Dhivehi",
        "din": "Dinka",
        "doi": "Dogri (macrolanguage)",
        "dgr": "Dogrib",
        "dua": "Duala",
        "nld": "nizozemščina",
        "dse": "Dutch Sign Language",
        "dyu": "Dyula",
        "dzo": "dzongkha",
        "efi": "Efik",
        "egy": "egipčanski",
        "eka": "Ekajuk",
        "elx": "elamščina",
        "eng": "angleščina",
        "enu": "Enu",
        "myv": "Erzya",
        "epo": "esperanto",
        "est": "estonščina",
        "ewe": "evenščina",
        "ewo": "Ewondo",
        "fan": "Fang (Equatorial Guinea)",
        "fat": "Fanti",
        "fao": "ferščina",
        "fij": "fidžijščina",
        "fil": "Filipino",
        "fin": "finščina",
        "fon": "Fon",
        "fra": "francoščina",
        "fur": "furlanščina",
        "ful": "fulščina",
        "gaa": "Ga",
        "glg": "Galician",
        "lug": "Ganda",
        "gay": "gajščina?",
        "gba": "Gbaya (Central African Republic)",
        "hmj": "Ge",
        "gez": "etiopščina?",
        "kat": "gruzinščina",
        "deu": "nemški",
        "gil": "gilbertščina",
        "gon": "Gondi",
        "gor": "Gorontalo",
        "got": "gotščina",
        "grb": "Grebo",
        "grn": "gvaranijščina",
        "guj": "gudžaratščina",
        "gwi": "Gwichʼin",
        "hai": "haidščina",
        "hau": "havščina",
        "haw": "havajščina",
        "heb": "hebrejščina",
        "her": "Herero",
        "hil": "hilingajnonščina",
        "hin": "hindijščina",
        "hmo": "hiri motu",
        "hit": "hetitščina",
        "hmn": "hmonščina; miaojščina",
        "hun": "madžarščina",
        "hup": "hupščina",
        "iba": "ibanščina",
        "isl": "islandščina",
        "ido": "Ido",
        "ibo": "Igbo",
        "ilo": "Iloko",
        "ind": "indonezijščina",
        "inh": "inguščina",
        "ina": "interlingva",
        "ile": "Interlingue",
        "iku": "inuktituščina",
        "ipk": "Inupiaq",
        "gle": "irščina",
        "ita": "italijanščina",
        "jpn": "japonščina",
        "jav": "javanščina",
        "jrb": "Judeo-Arabic",
        "jpr": "Judeo-Persian",
        "kbd": "kabardinščina",
        "kab": "Kabyle",
        "kac": "Kachin",
        "kal": "Kalaallisut",
        "xal": "Kalmyk",
        "kam": "Kamba (Kenya)",
        "kan": "kanareščina",
        "kau": "Kanuri",
        "kaa": "Kara-Kalpak",
        "krc": "Karachay-Balkar",
        "krl": "Karelian",
        "kas": "kašmirščina",
        "csb": "Kashubian",
        "kaw": "kavi",
        "kaz": "kazaščina",
        "kha": "Khasi",
        "kho": "Khotanese",
        "kik": "kikujščina",
        "kmb": "Kimbundu",
        "kin": "Kinyarwanda",
        "kir": "kirgiščina",
        "tlh": "Klingon",
        "kom": "komijščina",
        "kon": "Kongo",
        "kok": "Konkani (macrolanguage)",
        "kor": "korejščina",
        "kos": "Kosraean",
        "kpe": "Kpelle",
        "kua": "Kuanyama",
        "kum": "kumiščina",
        "kur": "kurdščina",
        "kru": "Kurukh",
        "kut": "kutenajščina",
        "lad": "ladinščina",
        "lah": "Lahnda",
        "lam": "Lamba",
        "lao": "laoščina",
        "lat": "latinščina",
        "lav": "latvijščina",
        "lez": "lezginščina",
        "lim": "Limburgan",
        "lin": "lingala",
        "lit": "litvanščina",
        "jbo": "Lojban",
        "loz": "Lozi",
        "lub": "Luba-Katanga",
        "lua": "lubalulujščina",
        "lui": "Luiseno",
        "smj": "Lule Sami",
        "lun": "Lunda",
        "luo": "Luo (Kenya and Tanzania)",
        "lus": "Lushai",
        "ltz": "Luxembourgish",
        "mkd": "makedonščina",
        "mad": "madurščina",
        "mag": "Magahi",
        "mai": "Maithili",
        "mak": "makasarščina",
        "mlg": "malgaščina",
        "msa": "Malay (macrolanguage)",
        "mal": "malajalščina",
        "mlt": "malteščina",
        "mnc": "Manchu",
        "mdr": "Mandar",
        "man": "Mandingo",
        "mni": "manipurščina",
        "glv": "manska gelščina",
        "mri": "maorščina",
        "arn": "Mapudungun",
        "mar": "maratščina",
        "chm": "Mari (Russia)",
        "mah": "Marshallese",
        "mwr": "Marwari",
        "mas": "masajščina",
        "men": "Mende (Sierra Leone)",
        "mic": "Mi'kmaq",
        "min": "Minangkabau",
        "mwl": "Mirandese",
        "moh": "mohoščina",
        "mdf": "Moksha",
        "lol": "Mongo",
        "mon": "mongolščina",
        "mos": "mosanščina",
        "mul": "Več jezikov",
        "nqo": "N'Ko",
        "nau": "Nauru",
        "nav": "navaščina",
        "ndo": "Ndonga",
        "nap": "napolitanščina",
        "nia": "niaščina",
        "niu": "niuejščina",
        "zxx": "No linguistic content",
        "nog": "Nogai",
        "nor": "norveščina",
        "nob": "Norwegian Bokmål",
        "nno": "norveščina; nynorsk",
        "nym": "Nyamwezi",
        "nya": "Nyanja",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Occitan (post 1500)",
        "oji": "Ojibwa",
        "orm": "Oromo",
        "osa": "Osage",
        "oss": "Ossetian",
        "pal": "Pahlavi",
        "pau": "palavanščina",
        "pli": "Pali",
        "pam": "Pampanga",
        "pag": "pangasinanščina",
        "pan": "Panjabi",
        "pap": "papiamentu",
        "fas": "perzijščina",
        "phn": "feničanščina",
        "pon": "Pohnpeian",
        "pol": "poljščina",
        "por": "portugalđščina",
        "pus": "paštu",
        "que": "Quechua",
        "raj": "radžastanščina",
        "rap": "rapanujščina",
        "ron": "romunščina",
        "roh": "Romansh",
        "rom": "romščina",
        "run": "rundščina",
        "rus": "ruščina",
        "smo": "samoanščina",
        "sad": "Sandawe",
        "sag": "Sango",
        "san": "sanskrt",
        "sat": "santalščina",
        "srd": "sardinščina",
        "sas": "Sasak",
        "sco": "škotščina",
        "sel": "selkupščina",
        "srp": "srbščina",
        "srr": "Serer",
        "shn": "šanščina",
        "sna": "šonščina",
        "scn": "sicilijanščina",
        "sid": "Sidamo",
        "bla": "Siksika",
        "snd": "sindščina",
        "sin": "Sinhala",
        "den": "Slave (Athapascan)",
        "slk": "slovaščina",
        "slv": "slovenščina",
        "sog": "Sogdian",
        "som": "Somali",
        "snk": "Soninke",
        "spa": "španščina",
        "srn": "Sranan Tongo",
        "suk": "Sukuma",
        "sux": "sumerščina",
        "sun": "sundščina",
        "sus": "susuamijščina?",
        "swa": "Swahili (macrolanguage)",
        "ssw": "svazijščina?",
        "swe": "švedščina",
        "syr": "sirščina",
        "tgl": "tagaloščina",
        "tah": "tahitijščina",
        "tgk": "tadžiščina",
        "tmh": "Tamashek",
        "tam": "tamilščina",
        "tat": "tatarščina",
        "tel": "Telugu",
        "ter": "Tereno",
        "tet": "Tetum",
        "tha": "tajščina",
        "bod": "tibetanščina",
        "tig": "Tigre",
        "tir": "Tigrinya",
        "tem": "Timne",
        "tiv": "Tiv",
        "tli": "Tlingit",
        "tpi": "tok pisin",
        "tkl": "Tokelau",
        "tog": "Tonga (Nyasa)",
        "ton": "tonganščina",
        "tsi": "tsimšijščina",
        "tso": "Tsonga",
        "tsn": "Tswana",
        "tum": "Tumbuka",
        "tur": "turščina",
        "tuk": "turkmenščina",
        "tvl": "tuvalujščina",
        "tyv": "Tuvinian",
        "twi": "Twi",
        "udm": "Udmurt",
        "uga": "ugaritščina",
        "uig": "ujgurščina",
        "ukr": "ukrajinščina",
        "umb": "Umbundu",
        "mis": "Uncoded languages",
        "und": "nedoločen",
        "urd": "urdujščina",
        "uzb": "uzbeščina",
        "vai": "vajščina",
        "ven": "Venda",
        "vie": "vietnamščina",
        "vol": "Volapük",
        "vot": "votjaščina",
        "wln": "valonščina",
        "war": "Waray (Philippines)",
        "was": "Washo",
        "cym": "valižanščina",
        "wal": "Wolaytta",
        "wol": "Wolof",
        "xho": "koščina",
        "sah": "jakutščina",
        "yao": "jaojščina",
        "yap": "Yapese",
        "yid": "jidiš",
        "yor": "jorubščina",
        "zap": "Zapotec",
        "zza": "Zaza",
        "zen": "Zenaga",
        "zha": "Zhuang",
        "zul": "zulujščina",
        "zun": "Zuni"
    },
    "sv": {
        "aar": "Afar",
        "abk": "Abchaziska",
        "ace": "Acehnesiska (Indonesien)",
        "ach": "Acoli (Uganda)",
        "ada": "Adangme",
        "ady": "Adygeiska",
        "afh": "Afrihili (konstgjort språk)",
        "afr": "Afrikaans",
        "ain": "Ainu (Japan)",
        "aka": "Akan (Ghana, Elfenbenskusten)",
        "akk": "Akkadiska",
        "ale": "Aleutiska",
        "alt": "Altaiska; södra",
        "amh": "Amhariska (Etiopien)",
        "ang": "Engelska; gammal (ca. 450-1100)",
        "anp": "Angika",
        "ara": "Arabiska",
        "arc": "Arameiska; officiell (700-300 f.Kr.)",
        "arg": "Aragonska",
        "arn": "Mapudungun",
        "arp": "Arapaho",
        "arw": "Arawakiska",
        "asm": "Assamesiska",
        "ast": "Asturiska",
        "ava": "Avariska",
        "ave": "Avestiska",
        "awa": "Awadhi",
        "aym": "Aymara (Bolivien)",
        "aze": "Azerbajdzjanska",
        "bak": "Basjkiriska",
        "bal": "Baluchi",
        "bam": "Bambara (Västafrika)",
        "ban": "Balinesiska",
        "bas": "Basa (Kamerun)",
        "bej": "Beyja",
        "bel": "Vitryska",
        "bem": "Bemba (Zambia)",
        "ben": "Bengaliska",
        "bho": "Bhojpuri",
        "bik": "Bikol",
        "bin": "Edo (bini)",
        "bis": "Bislama",
        "bit": "Berinomo",
        "bla": "Siksika (svartfotindianernas språk)",
        "bod": "Tibetanska",
        "bos": "Bosniska",
        "bra": "Braj",
        "bre": "Bretonska",
        "bua": "Burjatiska",
        "bug": "Buginesiska",
        "bul": "Bulgariska",
        "byn": "Bilin",
        "cad": "Caddo",
        "car": "Carib; Galibi",
        "cat": "Katalanska (Katalonien)",
        "ceb": "Cebuanska",
        "ces": "Tjeckiska",
        "cha": "Chamorro",
        "chb": "Chibcha",
        "che": "Tjetjenska",
        "chg": "Chagatai",
        "chk": "Chuukese",
        "chm": "Mari (Ryssland)",
        "chn": "Chinook",
        "cho": "Choctaw",
        "chp": "Chopi",
        "chr": "Cherokesiska",
        "cht": "Cholón",
        "chu": "Slavonic; antik",
        "chv": "Tjuvasjiska",
        "chy": "Cheyenne",
        "cop": "Koptiska",
        "cor": "Korniska",
        "cos": "Korsikanska",
        "cre": "Cree",
        "crh": "Turkiska Krim",
        "csb": "Kasjubianska",
        "cym": "Kymriska",
        "dak": "Dakota",
        "dan": "Danska",
        "dar": "Dargwa",
        "del": "Delaware",
        "den": "Slave",
        "deu": "Tyska",
        "dgr": "Dogrib",
        "din": "Dinka",
        "div": "Divehi",
        "doi": "Dogri (macrolanguage)",
        "dsb": "Sorbian; nedre",
        "dse": "Nederländskt teckenspråk",
        "dua": "Duala",
        "dum": "Hollänska; medeltida (ca. 1050-1350)",
        "dyu": "Dyula",
        "dzo": "Bhutanesiska (Dzongkha)",
        "efi": "Efik",
        "egy": "Egyptiska; gammal",
        "eka": "Ekajuk",
        "ell": "Grekiska; modern (1453-)",
        "elx": "Elamitiska",
        "eng": "Engelska",
        "enm": "Medelengelska (1100-1500)",
        "enu": "Enu",
        "epo": "Esperanto",
        "est": "Estniska",
        "eus": "Baskiska",
        "ewe": "Ewe",
        "ewo": "Ewondo",
        "fan": "Fang (Ekvatorialguinea)",
        "fao": "Färöiska",
        "fas": "Persiska",
        "fat": "Fanti",
        "fij": "Fijianska",
        "fil": "Filipino",
        "fin": "Finska",
        "fon": "Fon",
        "fra": "Franska",
        "frm": "Franska; medel (ca. 1400-1600)",
        "fro": "Franska; gammal (842-ca. 1400)",
        "frr": "Frisian; norra",
        "frs": "Frisian; östra",
        "fry": "Frisian; västra",
        "ful": "Fulani",
        "fur": "Friuliska",
        "gaa": "Ga",
        "gay": "Gayo",
        "gba": "Gbaya (Centralafrikanska republiken)",
        "gez": "Geez; fornetiopiska",
        "gil": "Gilbertesiska",
        "gla": "Gaeliska; skotska",
        "gle": "Iriska",
        "glg": "Galiciska",
        "glv": "Manx",
        "gmh": "Tyska; medelhög (ca. 1050-1500)",
        "goh": "Tyska; gammal hög (ca. 750-1050)",
        "gon": "Gondi",
        "gor": "Gorontalo",
        "got": "Gotiska",
        "grb": "Grebo",
        "grc": "Grekiska; antik (-1453)",
        "grn": "Guarani",
        "gsw": "Tyska; Schweizisk",
        "guj": "Gujarati (Indien)",
        "gwi": "Gwichʼin",
        "hai": "Haida",
        "hat": "Kreolspråk; haitisk kreol",
        "hau": "Haussa",
        "haw": "Hawaiiska",
        "heb": "Hebreiska",
        "her": "Herero",
        "hil": "Hiligaynon",
        "hin": "Hindi",
        "hit": "Hettitiska språk",
        "hmj": "Ge",
        "hmn": "Hmong",
        "hmo": "Hiri Motu",
        "hrv": "Kroatiska",
        "hsb": "Sorbiska; övre",
        "hun": "Ungerska",
        "hup": "Hupa",
        "hye": "Armeniska",
        "iba": "Iban",
        "ibo": "Ibo (Igbo)",
        "ido": "Ido",
        "iii": "Yi; Sichuan",
        "iku": "Inuktitut",
        "ile": "Interlingue",
        "ilo": "Iloko",
        "ina": "Interlingua (International Auxiliary Language Association)",
        "ind": "Indonesiska",
        "inh": "Ingusj",
        "ipk": "Inupiaq",
        "isl": "Isländska",
        "ita": "Italienska",
        "jav": "Javanesiska",
        "jbo": "Lojban",
        "jpn": "Japanska",
        "jpr": "Judepersiska",
        "jrb": "Judearabiska",
        "kaa": "Karakalpakiska",
        "kab": "Kabyliska",
        "kac": "Kachin",
        "kal": "Grönländska (Kalaallisut)",
        "kam": "Kamba (Kenya)",
        "kan": "Kannada (Indien)",
        "kas": "Kashmiri",
        "kat": "Georgiska",
        "kau": "Kanuri",
        "kaw": "Kiwi; fornjavanska",
        "kaz": "Kazakiska (Kazakstan)",
        "kbd": "Kabardinska (östtjerkessiska)",
        "kha": "Khasi",
        "khm": "Khmer (Kambodja)",
        "kho": "Sakiska (khotanesiska)",
        "kik": "Kikuyu (Kenya)",
        "kin": "Kinyarwanda (Rwanda)",
        "kir": "Kirgisiska",
        "kmb": "Mbundu (kimbundu)",
        "kok": "Konkani (macrolanguage)",
        "kom": "Komi",
        "kon": "Kongo",
        "kor": "Koreanska",
        "kos": "Kusaie",
        "kpe": "Kpelle",
        "krc": "Karatjaj-balkar",
        "krl": "Karelska",
        "kru": "Kurukh",
        "kua": "Ovambo (kuanyama)",
        "kum": "Kumyk",
        "kur": "Kurdiska",
        "kut": "Kutenai",
        "lad": "Spanjolska (ladino)",
        "lah": "Lahnda",
        "lam": "Lamba",
        "lao": "Laotiska (Laos)",
        "lat": "Latin",
        "lav": "Lettiska",
        "lez": "Lezginska",
        "lim": "Limburgan",
        "lin": "Lingala (Kongo-Kinshasa, Kongo-Brazzaville)",
        "lit": "Litauiska",
        "lol": "Lolo (mongo)",
        "loz": "Lozi",
        "ltz": "Luxembourgish",
        "lua": "Luba-Lulua",
        "lub": "Luba-Katanga",
        "lug": "Luganda/Ganda (Uganda)",
        "lui": "Luiseno",
        "lun": "Lunda",
        "luo": "Luo (Kenya och Tanzania)",
        "lus": "Mizo (lushai)",
        "mad": "Madurese",
        "mag": "Magahi",
        "mah": "Marshallese",
        "mai": "Maithili",
        "mak": "Makasar",
        "mal": "Malayalam (Indien)",
        "man": "Mande",
        "mar": "Marathi (Indien)",
        "mas": "Massajiska",
        "mdf": "Moksha",
        "mdr": "Mandar",
        "men": "Mende (Sierra Leone)",
        "mga": "irländsk; medel (900-1200)",
        "mic": "Mi'kmaq",
        "min": "Minangkabau",
        "mis": "Okodade språk",
        "mkd": "Makedonska",
        "mlg": "Madagaskiska",
        "mlt": "Maltesiska (Malta)",
        "mnc": "Manchu",
        "mni": "Manipuri",
        "moh": "Mohawk",
        "mon": "Mongoliska",
        "mos": "Mossi",
        "mri": "Maoriska",
        "msa": "Malajiska (makrospråk)",
        "mul": "Flera språk",
        "mus": "Muskogee",
        "mwl": "Mirandese",
        "mwr": "Marwari",
        "mya": "Burmanska",
        "myv": "Erzya",
        "nap": "Neapolitansk italienska",
        "nau": "Nauruanska",
        "nav": "Navajo",
        "nbl": "Ndebele; syd",
        "nde": "Ndebele; norra",
        "ndo": "Ndonga",
        "nds": "Tyska; låg",
        "nep": "Nepalesiska",
        "new": "Bhasa; Nepal",
        "nia": "Nias",
        "niu": "Niuean",
        "nld": "Nederländska",
        "nno": "Nynorsk",
        "nob": "Norskt bokmål",
        "nog": "Nogaiska",
        "non": "Nordiska; gammal",
        "nor": "Norska",
        "nqo": "N'Ko",
        "nso": "Nordsotho",
        "nwc": "Newari; gammal",
        "nya": "Nyanja",
        "nym": "Nyamwezi",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Occitan (post 1500)",
        "oji": "Odjibwa (chippewa)",
        "ori": "Oriya",
        "orm": "Oromo ( Etiopien, Kenya)",
        "osa": "Osage",
        "oss": "Ossetian",
        "ota": "Ottomanska (1500-1928)",
        "pag": "Pangasinan",
        "pal": "Pahlavi (medelpersiska)",
        "pam": "Pampanga (Filippinerna)",
        "pan": "Punjabi (Indien)",
        "pap": "Papiamento",
        "pau": "Palauan",
        "peo": "Persiska; antik (ca. 600-400 f.Kr.)",
        "phn": "Feniciska",
        "pli": "Pali",
        "pol": "Polska",
        "pon": "Ponape",
        "por": "Portugisiska",
        "pro": "Provensalska; gammal (-1500)",
        "pus": "Pashto",
        "que": "Quechua",
        "raj": "Rajasthani",
        "rap": "Rapanui",
        "rar": "Maoriska; Cooköarna",
        "roh": "Romansh",
        "rom": "Romani",
        "ron": "Rumänska",
        "run": "Rundi",
        "rup": "Rumänska; Macedo-",
        "rus": "Ryska",
        "sad": "Sandawe",
        "sag": "Sango",
        "sah": "Jakutiska",
        "sam": "Arameiska; samariska",
        "san": "Sanskrit",
        "sas": "Sasak",
        "sat": "Santali",
        "scn": "Sicilianska",
        "sco": "Lågskotska",
        "sel": "Selkup",
        "sga": "Iriska; gammal (-900)",
        "shn": "Shan",
        "sid": "Sidami",
        "sin": "Sinhala",
        "slk": "Slovakiska",
        "slv": "Slovenska",
        "sma": "Samiska,; södra",
        "sme": "Samiska; norra",
        "smj": "Samiska; Luleå",
        "smn": "Samiska; Inari",
        "smo": "Samoanska",
        "sms": "Samiska; Skolt",
        "sna": "Shona (Zimbabwe)",
        "snd": "Sindhi",
        "snk": "Soninke",
        "sog": "Sogdiska",
        "som": "Somaliska",
        "sot": "Sotho; södra",
        "spa": "Spanska",
        "sqi": "Albanska",
        "srd": "Sardiska",
        "srn": "Sranan Tongo",
        "srp": "Serbiska",
        "srr": "Serer",
        "ssw": "Swazi",
        "suk": "Sukuma",
        "sun": "Sundanesiska",
        "sus": "Susu",
        "sux": "Sumeriska",
        "swa": "Swahili",
        "swe": "Svenska",
        "syc": "Syriac; klassisk",
        "syr": "Syriska",
        "tah": "Tahitiska",
        "tam": "Tamil (Indien, Sri Lanka, Singapore)",
        "tat": "Tatariska ( Ryssland, Ukraina, Turkiet, Kina, Finland, Centralasien)",
        "tel": "Telugu (Indien)",
        "tem": "Temne",
        "ter": "Tereno",
        "tet": "Tetum",
        "tgk": "Tadzjikiska (Tadzjikistan)",
        "tgl": "Tagalog (Filippinerna)",
        "tha": "Thailändska",
        "tig": "Tigre (Eritrea)",
        "tir": "Tigrinja (Etiopien, Eritrea)",
        "tiv": "Tivi",
        "tkl": "Tokelau",
        "tlh": "Klingon",
        "tli": "Tlingit",
        "tmh": "Tamashek",
        "tog": "Tonga (Nyasa)",
        "ton": "Tonga (Tongaöarna)",
        "tpi": "Tok Pisin",
        "tsi": "Tsimshian",
        "tsn": "Setswana/Tswand (Botswana, Sydafrika, Zimbabwe, Namibia)",
        "tso": "Tsonga",
        "tuk": "Turkmeniska",
        "tum": "Tumbuka",
        "tur": "Turkiska",
        "tvl": "Tuvaluan",
        "twi": "Twi",
        "tyv": "Tuvinska",
        "udm": "Udmurt",
        "uga": "Ugaritiska",
        "uig": "UighurUiguriska (Kina, Kazakstan, Pakistan, Kirgizistan, Tadzjikistan, Indien)",
        "ukr": "Ukrainska",
        "umb": "Umbundu",
        "und": "Odefinierat",
        "urd": "Urdu (Pakistan, Indien)",
        "uzb": "Uzbekiska",
        "vai": "Vai",
        "ven": "Venda",
        "vie": "Vietnamesiska",
        "vol": "Volapük",
        "vot": "Votiska",
        "wal": "Wolaytta",
        "war": "Waray (Filippinerna)",
        "was": "Washo",
        "wln": "Vallonska",
        "wol": "Wolof (Senegal, Gambia, Mauretanien)",
        "xal": "Kalmyk",
        "xho": "Xhosa (Sydafrika)",
        "yao": "Yao",
        "yap": "Yap",
        "yid": "Jiddisch",
        "yor": "Yoruba",
        "zap": "Zapotek",
        "zbl": "Blissymbols",
        "zen": "Zenaga",
        "zha": "Zhuang",
        "zho": "Kinesiska",
        "zul": "Zulu (Sydafrika, Malawi, Moçambique, Swaziland)",
        "zun": "Zuni",
        "zxx": "No linguistic content",
        "zza": "Zaza"
    },
    "tr": {
        "abk": "Abhazca",
        "ace": "Achinese",
        "ach": "Acoli",
        "ada": "Adangme",
        "ady": "Adyghe",
        "aar": "Afar",
        "afh": "Afrihili",
        "afr": "Afrikanca",
        "ain": "Ainu (Japonca)",
        "aka": "Akanca (Afrika dili)",
        "akk": "Akatça",
        "sqi": "Albanian",
        "ale": "Alaskaca",
        "amh": "Etiyopyaca",
        "anp": "Angika",
        "ara": "Arapça",
        "arg": "Aragonca (İspanya)",
        "arp": "Arapaho (Kuzey Amerika yerlileri)",
        "arw": "Arawak (Surinam)",
        "hye": "Ermenice",
        "asm": "Assamese (Hindistan)",
        "ast": "Asturyasca",
        "ava": "Avarca",
        "ave": "Avestan (Eski İran)",
        "awa": "Awadhi (Hindistan)",
        "aym": "Aymara (Güney Amerika)",
        "aze": "Azerice",
        "ban": "Balice (Bali adaları)",
        "bal": "Belucice (İran)",
        "bam": "Bambara (Mali)",
        "bas": "Basa (Kamerun)",
        "bak": "Başkırca",
        "eus": "Baskça",
        "bej": "Beja (Eritre; Sudan)",
        "bel": "Beyaz Rusça",
        "bem": "Bemba (Zambia)",
        "ben": "Bengalce",
        "bit": "Berinomo",
        "bho": "Bhojpuri (Hindistan)",
        "bik": "Bikol (Filipinler)",
        "byn": "Bilin",
        "bin": "Bini (Afrika)",
        "bis": "Bislama (Vanuatu; Kuzey Pasifik)",
        "zbl": "Blis Sembolleri",
        "bos": "Boşnakça",
        "bra": "Braj (Hindistan)",
        "bre": "Bretonca",
        "bug": "Buginese (Endonezya)",
        "bul": "Bulgarca",
        "bua": "Buriat (Moğolistan)",
        "mya": "Burmaca",
        "cad": "Caddo (Kuzey Amerika yerlileri)",
        "cat": "Katalanca",
        "ceb": "Cebuano (Filipinler)",
        "chg": "Çağatayca",
        "cha": "Chamorro (Guam adaları)",
        "che": "Çeçence",
        "chr": "Cherokee (Kuzey Amerika yerlileri)",
        "chy": "Cheyenne (kuzey Amerika yerlileri)",
        "chb": "Chibcha (Kolombiya)",
        "zho": "Çince",
        "chn": "Chinook lehçesi (Kuzey Batı Amerika kıyıları)",
        "chp": "Chipewyan (Kuzey Amerika yerlileri)",
        "cho": "Choctaw (Kuzey Amerika yerlileri)",
        "cht": "Cholón",
        "chk": "Chuukese",
        "chv": "Çuvaş (Türkçe)",
        "cop": "Kıptice (Eski Mısır)",
        "cor": "Cornish (Kelt)",
        "cos": "Korsikaca",
        "cre": "Cree (Kuzey Amerika yerlileri)",
        "mus": "Creek",
        "hrv": "Hırvatça",
        "ces": "Çekçe",
        "dak": "Dakota (Kuzey Amerika yerlileri)",
        "dan": "Danimarkaca; Danca",
        "dar": "Dargwa (Dağıstan)",
        "del": "Delaware (Kuzey Amerika yerlileri)",
        "div": "Dhivehi",
        "din": "Dinka (Sudan)",
        "doi": "Dogri (makro dili)",
        "dgr": "Dogrib (Kanada)",
        "dua": "Duala (Afrika)",
        "nld": "Flâmanca (Hollanda dili)",
        "dse": "Hollandalı İşaret Dili",
        "dyu": "Dyula (Burkina Faso; Mali)",
        "dzo": "Dzongkha (Butan)",
        "efi": "Efik (Afrika)",
        "egy": "Mısırca (Eski)",
        "eka": "Ekajuk (Afrika)",
        "elx": "Elamca",
        "eng": "İngilizce",
        "enu": "Enu",
        "myv": "Erzya dili",
        "epo": "Esperanto",
        "est": "Estonca",
        "ewe": "Ewe (Afrika)",
        "ewo": "Ewondo (Afrika)",
        "fan": "Fang (Ekvatoryal Guinea)",
        "fat": "Fanti (Afrika)",
        "fao": "Faroece",
        "fij": "Fiji dili",
        "fil": "Filipince",
        "fin": "Fince",
        "fon": "Fon (Benin)",
        "fra": "Fransızca",
        "fur": "Friulian (İtalya)",
        "ful": "Fulah (Afrika)",
        "gaa": "Ganaca",
        "glg": "Galce",
        "lug": "Ganda Dili",
        "gay": "Gayo (Sumatra)",
        "gba": "Gbaya (Orta Afrika Cumhuriyeti)",
        "hmj": "Ge",
        "gez": "Geez (Etiyopya)",
        "kat": "Gürcüce",
        "deu": "Almanca",
        "gil": "Kiribati dili",
        "gon": "Gondi (Hindistan)",
        "gor": "Gorontalo (Endonezya)",
        "got": "Gotik",
        "grb": "Grebo (Liberya)",
        "grn": "Guarani (Paraguay)",
        "guj": "Gucaratça",
        "gwi": "Gwichʼin",
        "hai": "Haida (Kuzey Amerika yerlileri)",
        "hau": "Hausa Dili",
        "haw": "Havai Dili",
        "heb": "İbranice",
        "her": "Herero Dili",
        "hil": "Hiligaynon",
        "hin": "Hintçe",
        "hmo": "Hiri Motu",
        "hit": "Hititçe",
        "hmn": "Hmong",
        "hun": "Macarca",
        "hup": "Hupa",
        "iba": "Iban",
        "isl": "İzlandaca",
        "ido": "Ido Dili",
        "ibo": "Igbo Dili",
        "ilo": "Iloko",
        "ind": "Endonezyaca",
        "inh": "İnguşca",
        "ina": "Interlingua (Uluslararası Yardımcı Dil Kurumu)",
        "ile": "Interlingue",
        "iku": "Inuktitut",
        "ipk": "Inupiak Dili",
        "gle": "İrlandaca",
        "ita": "İtalyanca",
        "jpn": "Japonca",
        "jav": "Cava Dili",
        "jrb": "Yahudi-Arapçası",
        "jpr": "Yahudi-Farsça",
        "kbd": "Kabardian",
        "kab": "Kabyle",
        "kac": "Kachin",
        "kal": "Kalaallisut",
        "xal": "Kalmyk",
        "kam": "Kamba (Kenya)",
        "kan": "Kannada",
        "kau": "Kanuri Dili",
        "kaa": "Kara-Kalpak",
        "krc": "Karachay-Balkar",
        "krl": "Karelian",
        "kas": "Keşmirce",
        "csb": "Kashubian (Lehçe diyalekti)",
        "kaw": "Kawi",
        "kaz": "Kazakça",
        "kha": "Khasi",
        "kho": "Khotanese",
        "kik": "Kikuyu Dili",
        "kmb": "Kimbundu",
        "kin": "Kinyarwanda",
        "kir": "Kırgızca",
        "tlh": "Klingon",
        "kom": "Komi Dili",
        "kon": "Kongo Dili",
        "kok": "Konkani (makro dil)",
        "kor": "Korece",
        "kos": "Kosraean",
        "kpe": "Kpelle",
        "kua": "Kuanyama Dili",
        "kum": "Kumyk",
        "kur": "Kürtçe",
        "kru": "Kurukh",
        "kut": "Kutenai",
        "lad": "Ladino",
        "lah": "Lahnda",
        "lam": "Lamba",
        "lao": "Laos Dili",
        "lat": "Latince",
        "lav": "Letonca",
        "lez": "Lezghian",
        "lim": "Liburg Dili",
        "lin": "Lingala Dili",
        "lit": "Litvanyaca",
        "jbo": "Lojban dili",
        "loz": "Lozi",
        "lub": "Luba Katanga Dili",
        "lua": "Luba-Lulua",
        "lui": "Luiseno",
        "smj": "Lule Sami",
        "lun": "Lunda",
        "luo": "Luo (Kenya ve Tanzanya)",
        "lus": "Lushai",
        "ltz": "Lüksemburg Dili",
        "mkd": "Makedonca",
        "mad": "Madurese",
        "mag": "Magahi",
        "mai": "Maithili dili",
        "mak": "Makasar",
        "mlg": "Madagaskar Dili",
        "msa": "Malay (makro dili)",
        "mal": "Malayalam",
        "mlt": "Maltaca",
        "mnc": "Manchu",
        "mdr": "Mandar",
        "man": "Mandingo",
        "mni": "Manipuri dili",
        "glv": "Manx (Galler)",
        "mri": "Maori Dili",
        "arn": "Mapudungun",
        "mar": "Marathi",
        "chm": "Mari (Rusya)",
        "mah": "Marshall Dili",
        "mwr": "Marwari",
        "mas": "Masai",
        "men": "Mende (Sierra Leone)",
        "mic": "Mi'kmak",
        "min": "Minangkabau",
        "mwl": "Mirandese",
        "moh": "Mohawk",
        "mdf": "Moşka",
        "lol": "Mongo",
        "mon": "Moğol Dili",
        "mos": "Mossi",
        "mul": "Çoklu diller",
        "nqo": "N'Ko",
        "nau": "Nauru",
        "nav": "Navajo Dili",
        "ndo": "Ndonga Dili",
        "nap": "Neapolitan",
        "nia": "Nias",
        "niu": "Niuean",
        "zxx": "Hiçbir dil içeriği yok",
        "nog": "Nogai",
        "nor": "Norveçce",
        "nob": "Norveççe Bokmal",
        "nno": "Norveççe Nynorsk",
        "nym": "Nyamwezi",
        "nya": "Nyanja",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Oksitanca (1500 sonrası)",
        "oji": "Ojibwa Dili",
        "orm": "Oromo Dili",
        "osa": "Osage",
        "oss": "Osetya Dili",
        "pal": "Pehlevi",
        "pau": "Palauan",
        "pli": "Pali Dili",
        "pam": "Pampanga",
        "pag": "Pangasinan",
        "pan": "Pencabi Dili",
        "pap": "Papiamento",
        "fas": "Farsça",
        "phn": "Fenikçe",
        "pon": "Pohnpeian",
        "pol": "Polonyaca",
        "por": "Portekizce",
        "pus": "Pushto",
        "que": "Quechua",
        "raj": "Rajasthani",
        "rap": "Rapanui",
        "ron": "Rumence",
        "roh": "Romanca",
        "rom": "Çingene Dili",
        "run": "Kirundi",
        "rus": "Rusça",
        "smo": "Samoa Dili",
        "sad": "Sandawe",
        "sag": "Sangho",
        "san": "Sanskritçe",
        "sat": "Santali dili",
        "srd": "Sardinya",
        "sas": "Sasak",
        "sco": "İskoç lehçesi",
        "sel": "Selkup",
        "srp": "Sırpça",
        "srr": "Serer",
        "shn": "Shan",
        "sna": "Shona",
        "scn": "Sicilyalı",
        "sid": "Sidamo",
        "bla": "Siksika (Kuzey Amerika yerlileri)",
        "snd": "Sindhi",
        "sin": "Sinhala Dili",
        "den": "Slave (Athapascan; Kuzey Amerika yerlileri)",
        "slk": "Slovakça",
        "slv": "Slovence",
        "sog": "Sogdian",
        "som": "Somali Dili",
        "snk": "Soninke",
        "spa": "İspanyolca",
        "srn": "Sranan Tongo",
        "suk": "Sukuma",
        "sux": "Sümerce",
        "sun": "Sudan Dili",
        "sus": "Susu",
        "swa": "Swahili (makro dil)",
        "ssw": "Siswati",
        "swe": "İsveçce",
        "syr": "Süryanice",
        "tgl": "Tagalog",
        "tah": "Tahitice",
        "tgk": "Tacikçe",
        "tmh": "Tamashek",
        "tam": "Tamilce",
        "tat": "Tatarca",
        "tel": "Telugu",
        "ter": "Tereno",
        "tet": "Tetum",
        "tha": "Taylandça",
        "bod": "Tibetçe",
        "tig": "Tigre",
        "tir": "Tigrinya Dili",
        "tem": "Timne",
        "tiv": "Tiv",
        "tli": "Tlingit",
        "tpi": "Tok Pisin",
        "tkl": "Tokelau",
        "tog": "Tonga (Nyasa)",
        "ton": "Tonga",
        "tsi": "Tsimshian",
        "tso": "Tsonga",
        "tsn": "Setswana",
        "tum": "Tumbuka",
        "tur": "Türkçe",
        "tuk": "Türkmence",
        "tvl": "Tuvalu",
        "tyv": "Tuvinian",
        "twi": "Twi",
        "udm": "Udmurt",
        "uga": "Ugarit Çivi Yazısı",
        "uig": "Uygurca",
        "ukr": "Ukraynaca",
        "umb": "Umbundu",
        "mis": "Şifresiz diller",
        "und": "Belirlenemeyen",
        "urd": "Urduca",
        "uzb": "Özbekçe",
        "vai": "Vai",
        "ven": "Venda Dili",
        "vie": "Vietnamca",
        "vol": "Volapük",
        "vot": "Votic",
        "wln": "Valonca",
        "war": "Waray (Filipinler)",
        "was": "Vasho",
        "cym": "Gal Dili",
        "wal": "Wolaytta",
        "wol": "Wolof",
        "xho": "Xhosa",
        "sah": "Yakut",
        "yao": "Yao",
        "yap": "Yapese",
        "yid": "Yidiş",
        "yor": "Yoruba",
        "zap": "Zapotec",
        "zza": "Zaza",
        "zen": "Zenaga",
        "zha": "Zuang Dili",
        "zul": "Zulu",
        "zun": "Zuni"
    },
    "uk": {
        "aar": "афар",
        "abk": "абхазька",
        "ace": "ачеська",
        "ach": "ачолі",
        "ada": "адангме",
        "ady": "адигейська",
        "afh": "афрингілі",
        "afr": "африкаанс",
        "ain": "айнська (Японія)",
        "aka": "акан",
        "akk": "аккадська",
        "ale": "алеутська",
        "alt": "алтайська (південна)",
        "amh": "амхарська",
        "ang": "давньоанглійська (бл. 450-1100)",
        "anp": "ангіка",
        "ara": "арабська",
        "arc": "арамейська (офіційна; 700-300 до нашої ери)",
        "arg": "арагонська",
        "arn": "арауканська",
        "arp": "арапахо",
        "arw": "аравакська",
        "asm": "ассамська",
        "ast": "астурійська",
        "ava": "аварська",
        "ave": "авестанська",
        "awa": "авадхі",
        "aym": "аймарська",
        "aze": "азербайджанська",
        "bak": "башкирська",
        "bal": "белуджійська",
        "bam": "бамбара",
        "ban": "балійська",
        "bas": "баса (Камерун)",
        "bej": "бежа",
        "bel": "білоруська",
        "bem": "бемба (Замбія)",
        "ben": "бенгальська",
        "bho": "бходжпурі",
        "bik": "бікольська",
        "bin": "біні",
        "bis": "біслама",
        "bit": "беріномо",
        "bla": "сісіка",
        "bod": "тибетська",
        "bos": "боснійська",
        "bra": "брай",
        "bre": "бретонська",
        "bua": "бурятська",
        "bug": "бугійська",
        "bul": "болгарська",
        "byn": "білін",
        "cad": "каддо",
        "car": "карибська (галібі)",
        "cat": "каталонська",
        "ceb": "себуано",
        "ces": "чеська",
        "cha": "чаморо",
        "chb": "чибча",
        "che": "чеченська",
        "chg": "чагатайська",
        "chk": "чуукська",
        "chm": "марійська (Росія)",
        "chn": "чинук; жаргон",
        "cho": "чоктау",
        "chp": "чипев’ян",
        "chr": "черокі",
        "cht": "чолон",
        "chu": "давньослов’янська",
        "chv": "чуваська",
        "chy": "шаєнн",
        "cop": "коптська",
        "cor": "корнійська",
        "cos": "корсиканська",
        "cre": "крі",
        "crh": "турецька (кримська)",
        "csb": "кашубська",
        "cym": "валійська",
        "dak": "дакота",
        "dan": "данська",
        "dar": "даргва",
        "del": "делаварська",
        "den": "слейві (атабаська)",
        "deu": "німецька",
        "dgr": "догріб",
        "din": "дінка",
        "div": "мальдивська",
        "doi": "догрі (макромова)",
        "dsb": "нижньолужицька",
        "dse": "голландська мова жестів",
        "dua": "дуала",
        "dum": "середньовічна голландська (бл. 1050-1350)",
        "dyu": "діула",
        "dzo": "дзонг-ке",
        "efi": "ефік",
        "egy": "давньоєгипетська",
        "eka": "екаджук",
        "ell": "грецька (з 1453)",
        "elx": "еламська",
        "eng": "англійська",
        "enm": "середньоанглійська (1100-1500)",
        "enu": "ену",
        "epo": "есперанто",
        "est": "естонська",
        "eus": "баскська",
        "ewe": "еве",
        "ewo": "евондо",
        "fan": "фанг (Екваторіальна Гвінея)",
        "fao": "фарерська",
        "fas": "перська",
        "fat": "фанті",
        "fij": "фіджійська",
        "fil": "філіппінська",
        "fin": "фінська",
        "fon": "фон",
        "fra": "французька",
        "frm": "середньофранцузька (бл. 1400-1600)",
        "fro": "давньофранцузька (842-бл. 1400)",
        "frr": "фризька (північна)",
        "frs": "фризька (східна)",
        "fry": "фризька (західна)",
        "ful": "фулах",
        "fur": "фріульська",
        "gaa": "га",
        "gay": "гайо",
        "gba": "гбая (Центральноафриканська Республіка)",
        "gez": "гііз",
        "gil": "гільбертська",
        "gla": "гаельська (Шотландія)",
        "gle": "ірландська",
        "glg": "галісійська",
        "glv": "манкс",
        "gmh": "середньоверхньонімецька (бл. 1050-1500)",
        "goh": "давньосередньонімецька (бл. 750-1050)",
        "gon": "гонді",
        "gor": "горонтало",
        "got": "готська",
        "grb": "гребо",
        "grc": "давньогрецька (до 1453)",
        "grn": "гуарані",
        "gsw": "німецька (Швейцарія)",
        "guj": "гуджараті",
        "gwi": "гвічин",
        "hai": "хайда",
        "hat": "креольська (гаїтянська)",
        "hau": "хауса",
        "haw": "гавайська",
        "heb": "іврит",
        "her": "гереро",
        "hil": "хілігайнон",
        "hin": "хінді",
        "hit": "хетська",
        "hmj": "ге",
        "hmn": "хмонг",
        "hmo": "хірімоту",
        "hrv": "хорватська",
        "hsb": "верхньолужицька",
        "hun": "угорська",
        "hup": "хупа",
        "hye": "вірменська",
        "iba": "ібанська",
        "ibo": "ігбо",
        "ido": "ідо",
        "iii": "ї (Сичуань)",
        "iku": "інуктітут",
        "ile": "окциденталь",
        "ilo": "ілоко",
        "ina": "інтерлінгва (Асоціація міжнародної допоміжної мови)",
        "ind": "індонезійська",
        "inh": "інгушська",
        "ipk": "інупіак",
        "isl": "ісландська",
        "ita": "італійська",
        "jav": "яванська",
        "jbo": "ложбан",
        "jpn": "японська",
        "jpr": "єврейсько-перська",
        "jrb": "єврейсько-арабська",
        "kaa": "каракалпацька",
        "kab": "кабильська",
        "kac": "качин",
        "kal": "калаалісут",
        "kam": "камба (Кенія)",
        "kan": "каннада",
        "kas": "кашмірська",
        "kat": "грузинська",
        "kau": "канурі",
        "kaw": "каві",
        "kaz": "казахська",
        "kbd": "кабардінська",
        "kha": "кхасі",
        "khm": "кхмерська (центральна)",
        "kho": "хотаносакська",
        "kik": "кікуйю",
        "kin": "кіньяруанда",
        "kir": "киргизька",
        "kmb": "кімбунду",
        "kok": "конкані (макромова)",
        "kom": "комі",
        "kon": "конго",
        "kor": "корейська",
        "kos": "косрейська",
        "kpe": "кпелле",
        "krc": "карачаєво-балкарська",
        "krl": "карельська",
        "kru": "курух",
        "kua": "куаньяма",
        "kum": "кумикська",
        "kur": "курдська",
        "kut": "кутенай",
        "lad": "ладіно",
        "lah": "лахнда",
        "lam": "ламба",
        "lao": "лаоська",
        "lat": "латинська",
        "lav": "латиська",
        "lez": "лезгінська",
        "lim": "лімбурганська",
        "lin": "лінгала",
        "lit": "литовська",
        "lol": "монго",
        "loz": "лозі",
        "ltz": "люксембурзька",
        "lua": "луба-лулуа",
        "lub": "луба-катанга",
        "lug": "ганда",
        "lui": "луйсеньо",
        "lun": "лунда",
        "luo": "луо (Кенія і Танзанія)",
        "lus": "лушай",
        "mad": "мадурська",
        "mag": "магахі",
        "mah": "маршальська",
        "mai": "майтхілі",
        "mak": "макасарська",
        "mal": "малаялам",
        "man": "мандінго",
        "mar": "мараті",
        "mas": "масаї",
        "mdf": "мокшанська",
        "mdr": "мандарська",
        "men": "менде (Сьєрра-Леоне)",
        "mga": "середньоірландська (900-1200)",
        "mic": "мікмак",
        "min": "мінангкабау",
        "mis": "мови без коду",
        "mkd": "македонська",
        "mlg": "малагасійська",
        "mlt": "мальтійська",
        "mnc": "манчжурська",
        "mni": "маніпурська",
        "moh": "мохаук",
        "mon": "монгольська",
        "mos": "мосі",
        "mri": "маорійська",
        "msa": "малайська (макромова)",
        "mul": "мови; що належать до декількох родин",
        "mus": "крікська",
        "mwl": "мірандська",
        "mwr": "марварі",
        "mya": "бірманська",
        "myv": "ерзянська",
        "nap": "неаполітанська",
        "nau": "науру",
        "nav": "навахо",
        "nbl": "південна ндебеле",
        "nde": "північна ндебеле",
        "ndo": "ндонга",
        "nds": "нижньонімецька",
        "nep": "непальська",
        "new": "бхаса (Непал)",
        "nia": "ніасійська",
        "niu": "ніуе",
        "nld": "голландська",
        "nno": "норвезька нюноршк",
        "nob": "норвезька букмол",
        "nog": "ногайська",
        "non": "давньонорвезька",
        "nor": "норвезька",
        "nqo": "н’ко",
        "nso": "сото; північне",
        "nwc": "неварі (давня)",
        "nya": "ньянджа",
        "nym": "ньямвезі",
        "nyn": "ньянколе",
        "nyo": "ньоро",
        "nzi": "нзіма",
        "oci": "оксітанська (після 1500)",
        "oji": "оджибва",
        "ori": "орія",
        "orm": "оромо",
        "osa": "оседжі",
        "oss": "осетинська",
        "ota": "оттоманська турецька (1500-1928)",
        "pag": "пангасінан",
        "pal": "пехлевійська",
        "pam": "пампанга",
        "pan": "пенджабі",
        "pap": "папьяменто",
        "pau": "палау",
        "peo": "давньоперська (бл. 600-400 до н.е.)",
        "phn": "фінікійська",
        "pli": "палі",
        "pol": "польська",
        "pon": "понапе",
        "por": "португальська",
        "pro": "провансальська (давня; до 1500 року)",
        "pus": "пуштунська",
        "que": "кечуа",
        "raj": "раджастхані",
        "rap": "рапануї",
        "rar": "маорійська (острови Кука)",
        "roh": "ретророманська",
        "rom": "ромська",
        "ron": "румунська",
        "run": "рунді",
        "rup": "македоно-румунська",
        "rus": "російська",
        "sad": "сандаве",
        "sag": "санго",
        "sah": "якутська",
        "sam": "арамейська (самаритянська)",
        "san": "санскрит",
        "sas": "сасакська",
        "sat": "санталі",
        "scn": "сицилійська",
        "sco": "шотландська",
        "sel": "селькупська",
        "sga": "давньоірландська (до 900)",
        "shn": "шан",
        "sid": "сидама",
        "sin": "сингалійська",
        "slk": "словацька",
        "slv": "словенська",
        "sma": "саамська (південна)",
        "sme": "саамська (північна)",
        "smj": "лулесаамська",
        "smn": "саамська (інарі)",
        "smo": "самоанська",
        "sms": "саамська (сколт)",
        "sna": "шона",
        "snd": "синдхі",
        "snk": "сонікійська",
        "sog": "согдійська",
        "som": "сомалійська",
        "sot": "сото; південна",
        "spa": "іспанська",
        "sqi": "албанська",
        "srd": "сардинська",
        "srn": "сранан-тонго",
        "srp": "сербська",
        "srr": "серер",
        "ssw": "свазі",
        "suk": "сукума",
        "sun": "сунданська",
        "sus": "сусу",
        "sux": "шумерська",
        "swa": "суахілі (макромова)",
        "swe": "шведська",
        "syc": "сирійська (класична)",
        "syr": "сирійська",
        "tah": "таїтянська",
        "tam": "тамільська",
        "tat": "татарська",
        "tel": "телугу",
        "tem": "тімне",
        "ter": "терено",
        "tet": "тетум",
        "tgk": "таджицька",
        "tgl": "тагалог",
        "tha": "таїландська",
        "tig": "тігре",
        "tir": "тигринійська",
        "tiv": "тиві",
        "tkl": "токелау",
        "tlh": "клінгонська",
        "tli": "тлінгіт",
        "tmh": "тамашек",
        "tog": "тонга (ньяса)",
        "ton": "тонга (острови Тонга)",
        "tpi": "ток-пісін",
        "tsi": "цимшіан",
        "tsn": "тсвана",
        "tso": "цонга",
        "tuk": "туркменська",
        "tum": "тумбука",
        "tur": "турецька",
        "tvl": "тувалу",
        "twi": "тві",
        "tyv": "тувінська",
        "udm": "удмурдська",
        "uga": "угаритська",
        "uig": "уйгурська",
        "ukr": "українська",
        "umb": "умбунду",
        "und": "невизначена",
        "urd": "урду",
        "uzb": "узбецька",
        "vai": "вай",
        "ven": "венда",
        "vie": "в'єтнамська",
        "vol": "волапюк",
        "vot": "водська",
        "wal": "волайтта",
        "war": "варай (Філіппіни)",
        "was": "вашо",
        "wln": "валлонська",
        "wol": "волоф",
        "xal": "калмицька",
        "xho": "хоза",
        "yao": "яо",
        "yap": "япська",
        "yid": "ідиш",
        "yor": "йоруба",
        "zap": "сапотецька",
        "zbl": "бліссимволіка",
        "zen": "зеназька",
        "zha": "чжуань",
        "zho": "китайська",
        "zul": "зулуська",
        "zun": "зуні",
        "zxx": "немає мовних даних",
        "zza": "заза"
    },
    "vi": {
        "abk": "Abkhazian",
        "ace": "Tiếng A-chinh",
        "ach": "Tiếng A-co-li",
        "ada": "Tiếng A-đang-me",
        "ady": "Adyghe",
        "aar": "Afar",
        "afh": "Tiếng A-phi-li",
        "afr": "Tiếng Hà Lan-Nam Phi",
        "ain": "Ainu (Japan)",
        "aka": "Akan",
        "akk": "Tiếng A-ca-đi",
        "sqi": "Tiếng An-ba-ni",
        "ale": "Tiếng A-le-uth",
        "amh": "Tiếng Am-ha-ri",
        "anp": "Tiếng An-gi-ca",
        "ara": "Tiếng A-rập",
        "arg": "Tiếng A-ra-got",
        "arp": "Tiếng A-ra-bô",
        "arw": "Tiếng A-ra-ouac",
        "hye": "Tiếng Ác-mê-ni",
        "asm": "Tiếng A-xam",
        "ast": "Asturian",
        "ava": "Tiếng A-va-ri",
        "ave": "Tiếng A-ve-x-tan",
        "awa": "Tiếng A-oua-đi",
        "aym": "Aymara",
        "aze": "Tiếng Agiecbaigiăng",
        "ban": "Tiếng Ba-li",
        "bal": "Tiếng Ba-lu-khi",
        "bam": "Bambara",
        "bas": "Basa (Cameroon)",
        "bak": "Tiếng Ba-s-kic",
        "eus": "Tiếng Baxcơ",
        "bej": "Tiếng Be-gia",
        "bel": "Tiếng Be-la-ruxợ",
        "bem": "Bemba (Zambia)",
        "ben": "Tiếng Băng Gan",
        "bit": "Berinomo",
        "bho": "Tiếng Bo-giơ-pu-ri",
        "bik": "Tiếng Bi-cot",
        "byn": "Bilin",
        "bin": "Tiếng Bi-ni",
        "bis": "Tiếng Bix-la-ma",
        "zbl": "Blissymbols",
        "bos": "Tiếng Bô-xni-a",
        "bra": "Tiếng Boua-giơ",
        "bre": "Tiếng Boue-ton (Pháp)",
        "bug": "Tiếng Bu-gin",
        "bul": "Tiếng Bảo Gai Lơi",
        "bua": "Tiếng Bu-ri-at",
        "mya": "Tiếng Miến Điện",
        "cad": "Tiếng Ca-đô",
        "cat": "Tiếng Catalăng",
        "ceb": "Tiếng Xe-bu-a-nô",
        "chg": "Chagatai",
        "cha": "Tiếng Cha-mo-ro",
        "che": "Tiếng Che-chẹnh",
        "chr": "Tiếng Che-rô-ki",
        "chy": "Tiếng Chê-iênh",
        "chb": "Tiếng Chic-cha",
        "zho": "Tiếng Trung Hoa",
        "chn": "Biệt ngữ Chi-nukh",
        "chp": "Tiếng Chi-pu-i-a",
        "cho": "Tiếng Choc-toa",
        "cht": "Cholón",
        "chk": "Tiếng Chu-ki",
        "chv": "Tiếng Chu-vaxơ",
        "cop": "Ngôn ngữ phổ biến trong Giáo hội Ai Cập",
        "cor": "Tiếng Khonh-uoă",
        "cos": "Tiếng Kho-si-ca",
        "cre": "Tiếng Kh-ri",
        "mus": "Tiếng C-ric",
        "hrv": "Tiếng Crô-át",
        "ces": "Tiếng Séc",
        "dak": "Tiếng Đa-cô-ta",
        "dan": "Tiếng Đan Mạch",
        "dar": "Tiếng Đac-oua",
        "del": "Tiếng Đe-la-oue",
        "div": "Dhivehi",
        "din": "Dinka",
        "doi": "Dogri (macrolanguage)",
        "dgr": "Tiếng Đoc-ric",
        "dua": "Tiếng Đu-a-la",
        "nld": "Tiếng Hòa Lan",
        "dse": "Dutch Sign Language",
        "dyu": "Tiếng Đi-u-la",
        "dzo": "Tiếng Đxong-kha",
        "efi": "Tiếng E-phic",
        "egy": "Tiếng Ai Cập (cổ)",
        "eka": "Tiếng E-ca-giuc",
        "elx": "Tiếng E-la-mi",
        "eng": "Tiếng Anh",
        "enu": "Enu",
        "myv": "Tiếng Ơ-dia",
        "epo": "Tiếng Etpêrantô",
        "est": "Tiếng Phổ Cổ",
        "ewe": "Tiếng E-oue",
        "ewo": "Tiếng E-ouon-đô",
        "fan": "Fang (Equatorial Guinea)",
        "fat": "Tiếng Phan-ti",
        "fao": "Tiếng Pha-rô",
        "fij": "Tiếng Phi-gi",
        "fil": "Filipino",
        "fin": "Tiếng Phần Lan",
        "fon": "Tiếng Phonh",
        "fra": "Tiếng Pháp",
        "fur": "Tiếng Ph-riu-li",
        "ful": "Tiếng Phu-la",
        "gaa": "Tiếng Ga",
        "glg": "Galician",
        "lug": "Ganda",
        "gay": "Tiếng Gay-ô",
        "gba": "Gbaya (Central African Republic)",
        "hmj": "Ge",
        "gez": "Tiếng Gi-d",
        "kat": "Tiếng Gi-oa-gi-a",
        "deu": "Tiếng Đức",
        "gil": "Tiếng Gil-bơt",
        "gon": "Tiếng Gon-đi",
        "gor": "Tiếng Go-ron-ta-lô",
        "got": "Tiếng Gô-tích",
        "grb": "Tiếng Goue-bô",
        "grn": "Tiếng Gua-ra-ni",
        "guj": "Tiếng Gu-gia-ra-ti",
        "gwi": "Gwichʼin",
        "hai": "Tiếng Hai-đa",
        "hau": "Tiếng Hau-xa",
        "haw": "Tiếng Ha-uoai-i",
        "heb": "Tiếng Do Thái",
        "her": "Tiếng He-re-rô",
        "hil": "Tiếng Hi-li-gay-non",
        "hin": "Tiếng Hin-đi",
        "hmo": "Tiếng Mo-tu",
        "hit": "Tiếng Hic-tic",
        "hmn": "Tiếng Miêu",
        "hun": "Tiếng Hung Gia Lợi",
        "hup": "Tiếng Hu-pa",
        "iba": "Iban",
        "isl": "Tiếng Băng đảo",
        "ido": "Tiếng I-đô",
        "ibo": "Tiếng Ic-bô",
        "ilo": "Tiếng I-lô-cô",
        "ind": "Tiếng Nam Dương",
        "inh": "Tiếng In-gut",
        "ina": "Ngôn ngữ lẫn nhau In-tơ-lin-gua (Liên Hiệp Ngôn Ngữ Bổ Trợ Quốc Tế)",
        "ile": "Ngôn ngữ lẫn nhau In-tơ-ling",
        "iku": "Tiếng I-nuc-ti-tuc",
        "ipk": "Tiếng In-u-bơ-lac",
        "gle": "Tiếng Ái Nhĩ Lan",
        "ita": "Tiếng Ý",
        "jpn": "Tiếng Nhật",
        "jav": "Tiếng Gia-va",
        "jrb": "Do thái - A-rập",
        "jpr": "Do thái - Ba tư",
        "kbd": "Tiếng Ca-bat",
        "kab": "Tiếng Ca-bai",
        "kac": "Tiếng Ca-chin",
        "kal": "Kalaallisut",
        "xal": "Kalmyk",
        "kam": "Kamba (Kenya)",
        "kan": "Tiếng Kan-na-đa",
        "kau": "Tiếng Ca-nu-ri",
        "kaa": "Tiếng Ca-ra-Cac-pac",
        "krc": "Tiếng Ca-ra-chay-Boa-ca",
        "krl": "Tiếng Ca-re-ni",
        "kas": "Tiếng Ca-s-mi-ri",
        "csb": "Tiếng Ca-su-bi",
        "kaw": "Tiếng Ca-oui",
        "kaz": "Tiếng Ca-dakh",
        "kha": "Khasi",
        "kho": "Tiếng Kho-tan",
        "kik": "Tiếng Khi-ku-iu",
        "kmb": "Tiếng Kim-bun-đu",
        "kin": "Tiếng Kin-ia-ouanh-đa",
        "kir": "Tiếng Kit-ki-dơ",
        "tlh": "Klingon",
        "kom": "Tiếng Cô-mi",
        "kon": "Kongo",
        "kok": "Konkani (macrolanguage)",
        "kor": "Tiếng Hàn Quốc",
        "kos": "Tiếng Co-x-rai",
        "kpe": "Tiếng C-pe-le",
        "kua": "Tiếng Cu-an-i-am-a",
        "kum": "Tiếng Cu-mic",
        "kur": "Tiếng người Kurd",
        "kru": "Tiếng Cu-ruc",
        "kut": "Tiếng Cu-ten-ai",
        "lad": "Tiếng La-đi-nô",
        "lah": "Tiếng Lan-đa",
        "lam": "Tiếng Lam-ba",
        "lao": "Tiếng Lào",
        "lat": "Tiếng La-tinh",
        "lav": "Tiếng Lát-vi-a",
        "lez": "Tiếng Le-d-khi-an",
        "lim": "Limburgan",
        "lin": "Tiếng Lin-ga-la",
        "lit": "Tiếng Li-tu-a-ni",
        "jbo": "Tiếng Loc-ba",
        "loz": "Tiếng Lo-di",
        "lub": "Tiếng Lu-ba-Ca-tan-ga",
        "lua": "Tiếng Lu-ba-Lu-lu-a",
        "lui": "Tiếng Lui-xen-ô",
        "smj": "Tiếng Sa-mi Lu-le",
        "lun": "Tiếng Lun-đa",
        "luo": "Tiếng Luo (Ken-i-a và Than-dê-ni-a)",
        "lus": "Tiếng Lu-sai",
        "ltz": "Luxembourgish",
        "mkd": "Tiếng Maxêđôni",
        "mad": "Tiếng Ma-đu-ri",
        "mag": "Tiếng Mu-ga-hi",
        "mai": "Tiếng Mai-ti-li",
        "mak": "Makasar",
        "mlg": "Tiếng Ma-la-ga-si",
        "msa": "Malay (macrolanguage)",
        "mal": "Tiếng Ma-lay-am",
        "mlt": "Tiếng Mantơ",
        "mnc": "Tiếng Man-chu (Trung Hoa)",
        "mdr": "Tiếng Man-đa",
        "man": "Tiếng Man-đin-gô",
        "mni": "Tiếng Ma-ni-pu-ri",
        "glv": "Tiếng Man-khơx",
        "mri": "Tiếng Maori",
        "arn": "Mapudungun",
        "mar": "Tiếng Ma-ra-ti",
        "chm": "Mari (Russia)",
        "mah": "Marshallese",
        "mwr": "Tiếng Ma-oua-ri",
        "mas": "Tiếng Ma-sai",
        "men": "Mende (Sierra Leone)",
        "mic": "Mi'kmaq",
        "min": "Tiếng Mi-nang-ca-bau",
        "mwl": "Tiếng Mi-ran-đi",
        "moh": "Tiếng Mô-hoakh",
        "mdf": "Tiếng Moc-sa",
        "lol": "Tiếng Mon-gô",
        "mon": "Tiếng Mông Cổ",
        "mos": "Tiếng Mo-xi",
        "mul": "Đa ngôn ngữ",
        "nqo": "N'Ko",
        "nau": "Tiếng Nau-ru",
        "nav": "Navajo",
        "ndo": "Tiếng N-đon-ga",
        "nap": "Tiếng Na-po-li (Ý)",
        "nia": "Tiếng Ni-at",
        "niu": "Tiếng Niu-i",
        "zxx": "Không có nội dung kiểu ngôn ngữ",
        "nog": "Tiếng No-gai",
        "nor": "Tiếng Na-uy",
        "nob": "Norwegian Bokmål",
        "nno": "Tiếng Na-uy (Nynorsk)",
        "nym": "Tiếng Nai-am-oue-di",
        "nya": "Nyanja",
        "nyn": "Tiếng Nai-an-co-le",
        "nyo": "Nyoro",
        "nzi": "Tiếng N-di-ma",
        "oci": "Occitan (post 1500)",
        "oji": "Ojibwa",
        "orm": "Tiếng O-ro-mô",
        "osa": "Tiếng O-sa-ge",
        "oss": "Ossetian",
        "pal": "Tiếng Pa-la-vi",
        "pau": "Tiếng Pa-lau-a",
        "pli": "Pali",
        "pam": "Tiếng Pam-pan-ga",
        "pag": "Tiếng Pan-ga-sin",
        "pan": "Panjabi",
        "pap": "Tiếng Pa-pi-a-men-tô",
        "fas": "Tiếng Ba Tư",
        "phn": "Tiếng Phê-ni-xi",
        "pon": "Tiếng Pon-pê-i-a",
        "pol": "Tiếng Ba Lan",
        "por": "Tiếng Bồ Đào Nha",
        "pus": "Tiếng Pu-s-tô",
        "que": "Quechua",
        "raj": "Tiếng Ra-gia-x-tni",
        "rap": "Tiếng Ra-pa-nui",
        "ron": "Tiếng Lỗ Má Ni",
        "roh": "Romansh",
        "rom": "Tiếng Gipxi",
        "run": "Tiếng Run-đi",
        "rus": "Tiếng Nga",
        "smo": "Tiếng Xa-mô-a",
        "sad": "Tiếng San-đa-ouê",
        "sag": "Sango",
        "san": "Tiếng Phạn",
        "sat": "Tiếng San-ta-li",
        "srd": "Tiếng Xa-đi-ni-a (Ý)",
        "sas": "Sasak",
        "sco": "Tiếng Ê-cốt",
        "sel": "Tiếng Xe-cuc",
        "srp": "Tiếng Xéc bi",
        "srr": "Serer",
        "shn": "Tiếng San",
        "sna": "Tiếng Sô-na",
        "scn": "Tiếng Xi-xi-li",
        "sid": "Tiếng Xi-đa-mô",
        "bla": "Tiếng Xich-xich-a",
        "snd": "Tiếng Sin-đi",
        "sin": "Sinhala",
        "den": "Tiếng A-ta-pax-ca",
        "slk": "Tiếng Xlô-vác",
        "slv": "Tiếng Xlô-ven",
        "sog": "Tiếng Xoc-đi-a",
        "som": "Tiếng Xô-ma-li",
        "snk": "Tiếng Xo-nin-khe",
        "spa": "Tiếng Tây Ban Nha",
        "srn": "Sranan Tongo",
        "suk": "Tiếng Xu-ku-ma",
        "sux": "Tiếng Xu-me",
        "sun": "Tiếng Xunh-đan",
        "sus": "Tiếng xu-xu",
        "swa": "Swahili (macrolanguage)",
        "ssw": "Tiếng Xôa-thi",
        "swe": "Tiếng Thuỵ Điển",
        "syr": "Tiếng Xi-ri",
        "tgl": "Tiếng Ta-ga-lọc",
        "tah": "Tiếng Ta-hi-ti",
        "tgk": "Tiếng Ta-gic",
        "tmh": "Tamashek",
        "tam": "Tiếng Ta-mil",
        "tat": "Tiếng Tác-ta",
        "tel": "Telugu",
        "ter": "Tiếng Te-re-no",
        "tet": "Tiếng Te-tum",
        "tha": "Tiếng Thái Lan",
        "bod": "Tiếng Tây Tạng",
        "tig": "Tiếng Thi-gơ-rơ",
        "tir": "Tiếng Thi-gơ-rin-ya",
        "tem": "Tiếng Tim-ne",
        "tiv": "Tiếng Ti-ph",
        "tli": "Tiếng Tợ-lin-git",
        "tpi": "Tiếng Tok Pi-sin",
        "tkl": "Tiếng To-ke-lau",
        "tog": "Tiếng Ton-ga (Nai-a-sa)",
        "ton": "Tiếng Ton-ga (Quần đảo Ton-ga)",
        "tsi": "Tiếng T-xim-si-an",
        "tso": "Tiếng Xông-ga",
        "tsn": "Tiếng T-xoua-na",
        "tum": "Tiếng Tum-bu-ka",
        "tur": "Tiếng Thổ Nhĩ Kỳ",
        "tuk": "Tiếng Tuơkh-men",
        "tvl": "Tiếng Tu-va-lu",
        "tyv": "Tiếng Tu-vi-ni",
        "twi": "Tiếng Toui",
        "udm": "Tiếng Ud-mợt",
        "uga": "Tiếng U-ga-ri",
        "uig": "Tiếng Ui-guơ",
        "ukr": "Tiếng Ukraina",
        "umb": "Tiếng Um-bun-đu",
        "mis": "Uncoded languages",
        "und": "Chưa quyết định",
        "urd": "Tiếng Uơ-đu",
        "uzb": "Tiếng U-dơ-bếch",
        "vai": "Tiếng Vai",
        "ven": "Tiếng Ven-đa",
        "vie": "Tiếng Việt",
        "vol": "Tiếng Vo-la-puk",
        "vot": "Tiếng Vo-tic",
        "wln": "Tiếng Oua-lon",
        "war": "Waray (Philippines)",
        "was": "Tiếng Oua-sô",
        "cym": "Tiếng Oue-l-s",
        "wal": "Wolaytta",
        "wol": "Tiếng Ou-o-loc",
        "xho": "Tiếng X-hô-da",
        "sah": "Tiếng Ia-cut",
        "yao": "Tiếng Yao",
        "yap": "Tiếng Yat",
        "yid": "Tiếng Y-đit",
        "yor": "Tiếng Yo-ru-ba",
        "zap": "Zapotec",
        "zza": "Zaza",
        "zen": "Tiếng De-na-ga",
        "zha": "Zhuang",
        "zul": "Tiếng Du-lu",
        "zun": "Tiếng Du-ni"
    },
    "zh_Hans_CN": {
        "aar": "阿法尔语",
        "abk": "阿布哈兹语",
        "ace": "亚齐语",
        "ach": "阿乔利语",
        "ada": "阿当梅语",
        "ady": "阿迪格语",
        "afh": "阿弗里希利语",
        "afr": "南非荷兰语",
        "ain": "阿伊努语（日本）",
        "aka": "阿坎语",
        "akk": "阿卡德语",
        "ale": "阿留申语",
        "alt": "阿尔泰语（南）",
        "amh": "阿姆哈拉语",
        "ang": "英语（上古，约 450-1100）",
        "anp": "安吉卡语",
        "ara": "阿拉伯语",
        "arc": "阿拉米语（官方，公元前 700-300）",
        "arg": "阿拉贡语",
        "arn": "阿劳坎语",
        "arp": "阿拉帕霍语",
        "arw": "阿拉瓦克语",
        "asm": "阿萨姆语",
        "ast": "阿斯图里亚斯语",
        "ava": "阿瓦尔语",
        "ave": "阿维斯陀语",
        "awa": "阿瓦德语",
        "aym": "艾马拉语",
        "aze": "阿塞拜疆语",
        "bak": "巴什基尔语",
        "bal": "俾路支语",
        "bam": "班巴拉语",
        "ban": "巴厘语",
        "bas": "巴萨语（喀麦隆）",
        "bej": "贝扎语",
        "bel": "白俄罗斯语",
        "bem": "本巴语（赞比亚）",
        "ben": "孟加拉语",
        "bho": "博杰普尔语",
        "bik": "比科尔语",
        "bin": "比尼语",
        "bis": "比斯拉马语",
        "bit": "Berinomo",
        "bla": "西克西卡语",
        "bod": "藏语",
        "bos": "波斯尼亚语",
        "bra": "布拉吉语",
        "bre": "布列塔尼语",
        "bua": "布里亚特语",
        "bug": "布吉语",
        "bul": "保加利亚语",
        "byn": "比林语",
        "cad": "卡多语",
        "car": "加勒比语",
        "cat": "加泰罗尼亚语",
        "ceb": "宿务语",
        "ces": "捷克语",
        "cha": "查莫罗语",
        "chb": "奇布查语",
        "che": "车臣语",
        "chg": "察合台语",
        "chk": "丘克语",
        "chm": "马里语（俄罗斯）",
        "chn": "奇努克混合语",
        "cho": "乔克托语",
        "chp": "奇佩维安语",
        "chr": "切罗基语",
        "cht": "Cholón",
        "chu": "斯拉夫语（古教会）",
        "chv": "楚瓦什语",
        "chy": "夏延语",
        "cop": "科普特语",
        "cor": "康沃尔语",
        "cos": "科西嘉语",
        "cre": "克里语",
        "crh": "鞑靼语（克里米亚）",
        "csb": "卡舒比语",
        "cym": "威尔士语",
        "dak": "达科他语",
        "dan": "丹麦语",
        "dar": "达尔格瓦语",
        "del": "特拉华语",
        "den": "史拉维语（阿沙巴斯甘）",
        "deu": "德语",
        "dgr": "多格里布语",
        "din": "丁卡语",
        "div": "迪维希语",
        "doi": "多格拉语",
        "dsb": "索布语（下）",
        "dse": "荷兰手语",
        "dua": "杜亚拉语",
        "dum": "荷兰语（中古，约 1050-1350）",
        "dyu": "迪尤拉语",
        "dzo": "宗喀语",
        "efi": "埃菲克语",
        "egy": "埃及语（古）",
        "eka": "埃克丘克语",
        "ell": "希腊语（现代，1453-）",
        "elx": "埃兰语",
        "eng": "英语",
        "enm": "英语（中古，1100-1500）",
        "enu": "Enu",
        "epo": "世界语",
        "est": "爱沙尼亚语",
        "eus": "巴斯克语",
        "ewe": "埃维语",
        "ewo": "埃翁多语",
        "fan": "芳语（赤道几内亚）",
        "fao": "法罗语",
        "fas": "波斯语",
        "fat": "芳蒂语",
        "fij": "斐济语",
        "fil": "菲律宾语",
        "fin": "芬兰语",
        "fon": "丰语",
        "fra": "法语",
        "frm": "法语（中古，约 1400-1600）",
        "fro": "法语（上古，842-约 1400）",
        "frr": "弗里西语（北）",
        "frs": "弗里西亚语（东）",
        "fry": "弗里西亚语（西）",
        "ful": "富拉语",
        "fur": "弗留利语",
        "gaa": "加语",
        "gay": "卡约语",
        "gba": "巴亚语（中非共和国）",
        "gez": "吉兹语",
        "gil": "吉尔伯特语",
        "gla": "盖尔语（苏格兰）",
        "gle": "爱尔兰语",
        "glg": "加利西亚语",
        "glv": "马恩岛语",
        "gmh": "德语（中古高地，约 1050-1500）",
        "goh": "德语（上古高地，约 750-1050）",
        "gon": "贡德语",
        "gor": "哥伦打洛语",
        "got": "哥特语",
        "grb": "格列博语",
        "grc": "希腊语（古典，直到 1453）",
        "grn": "瓜拉尼语",
        "gsw": "德语（瑞士）",
        "guj": "古吉拉特语",
        "gwi": "库臣语",
        "hai": "海达语",
        "hat": "克里奥尔语（海地）",
        "hau": "豪萨语",
        "haw": "夏威夷语",
        "heb": "希伯来语",
        "her": "赫雷罗语",
        "hil": "希利盖农语",
        "hin": "印地语",
        "hit": "赫梯语",
        "hmj": "亻革家语、重安江苗语",
        "hmn": "苗语",
        "hmo": "希里莫图语",
        "hrv": "克罗地亚语",
        "hsb": "索布语（上）",
        "hun": "匈牙利语",
        "hup": "胡帕语",
        "hye": "亚美尼亚语",
        "iba": "伊班语",
        "ibo": "伊博语",
        "ido": "伊多语",
        "iii": "彝语（四川）",
        "iku": "伊努伊特语",
        "ile": "国际语（西方）",
        "ilo": "伊洛卡诺语",
        "ina": "国际语",
        "ind": "印尼语",
        "inh": "印古什语",
        "ipk": "依努庇克语",
        "isl": "冰岛语",
        "ita": "意大利语",
        "jav": "爪哇语",
        "jbo": "逻辑语",
        "jpn": "日语",
        "jpr": "犹太-波斯语",
        "jrb": "犹太-阿拉伯语",
        "kaa": "卡拉卡尔帕克语",
        "kab": "卡布列语",
        "kac": "景颇语",
        "kal": "格陵兰语",
        "kam": "坎巴语（肯尼亚）",
        "kan": "卡纳达语",
        "kas": "克什米尔语",
        "kat": "格鲁吉亚语",
        "kau": "卡努里语",
        "kaw": "卡威语",
        "kaz": "哈萨克语",
        "kbd": "卡巴尔达语",
        "kha": "卡西语",
        "khm": "高棉语",
        "kho": "和田语",
        "kik": "基库尤语",
        "kin": "基尼阿万达语",
        "kir": "吉尔吉斯语",
        "kmb": "金本杜语",
        "kok": "孔卡尼语",
        "kom": "科米语",
        "kon": "刚果语",
        "kor": "朝鲜语",
        "kos": "科斯拉伊语",
        "kpe": "克佩勒语",
        "krc": "卡拉恰伊-巴尔卡尔语",
        "krl": "卡累利阿语",
        "kru": "库卢克语",
        "kua": "宽亚玛语",
        "kum": "库梅克语",
        "kur": "库尔德语",
        "kut": "库特内语",
        "lad": "拉迪诺语",
        "lah": "拉亨达语",
        "lam": "兰巴语",
        "lao": "老挝语",
        "lat": "拉丁语",
        "lav": "拉脱维亚语",
        "lez": "列兹金语",
        "lim": "林堡语",
        "lin": "林加拉语",
        "lit": "立陶宛语",
        "lol": "芒戈语",
        "loz": "洛齐语",
        "ltz": "卢森堡语",
        "lua": "卢巴-卢拉语",
        "lub": "卢巴-加丹加语",
        "lug": "干达语",
        "lui": "卢伊塞诺语",
        "lun": "隆达语",
        "luo": "卢奥语（肯尼亚和坦桑尼亚）",
        "lus": "卢萨语",
        "mad": "马都拉语",
        "mag": "摩揭陀语",
        "mah": "马绍尔语",
        "mai": "米德勒语",
        "mak": "望加锡语",
        "mal": "马拉雅拉姆语",
        "man": "曼丁哥语",
        "mar": "马拉地语",
        "mas": "马萨伊语",
        "mdf": "莫克沙语",
        "mdr": "曼达语",
        "men": "门德语（塞拉利昂）",
        "mga": "爱尔兰语（中古，900-1200）",
        "mic": "米克马克语",
        "min": "米南卡保语",
        "mis": "未被编码的语言",
        "mkd": "马其顿语",
        "mlg": "马达加斯加语",
        "mlt": "马耳他语",
        "mnc": "满语",
        "mni": "曼尼普尔语",
        "moh": "莫霍克语",
        "mon": "蒙古语",
        "mos": "莫西语",
        "mri": "毛利语",
        "msa": "马来语族",
        "mul": "多种语言",
        "mus": "克里克语",
        "mwl": "米兰德斯语",
        "mwr": "马尔瓦利语",
        "mya": "缅甸语",
        "myv": "厄尔兹亚语",
        "nap": "拿坡里语",
        "nau": "瑙鲁语",
        "nav": "纳瓦霍语",
        "nbl": "恩德贝勒语（南）",
        "nde": "恩德贝勒语（北）",
        "ndo": "恩敦加语",
        "nds": "撒克逊语（低地）",
        "nep": "尼泊尔语",
        "new": "尼瓦尔语",
        "nia": "尼亚斯语",
        "niu": "纽埃语",
        "nld": "荷兰语",
        "nno": "新挪威语",
        "nob": "挪威布克莫尔语",
        "nog": "诺盖语",
        "non": "诺尔斯语（古）",
        "nor": "挪威语",
        "nqo": "西非书面语言字母",
        "nso": "索托语（北）",
        "nwc": "尼瓦尔语（古典）",
        "nya": "尼扬贾语",
        "nym": "尼扬韦齐语",
        "nyn": "尼扬科勒语",
        "nyo": "尼奥罗语",
        "nzi": "恩济马语",
        "oci": "奥克西唐语（1500 后）",
        "oji": "奥吉布瓦语",
        "ori": "奥利亚语",
        "orm": "奥罗莫语",
        "osa": "奥萨格语",
        "oss": "奥塞梯语",
        "ota": "土耳其语（奥斯曼，1500-1928）",
        "pag": "邦阿西楠语",
        "pal": "钵罗钵语",
        "pam": "邦板牙语",
        "pan": "旁遮普语",
        "pap": "帕皮亚门托语",
        "pau": "帕劳语",
        "peo": "波斯语（古，公元前约 600-400）",
        "phn": "腓尼基语",
        "pli": "巴利语",
        "pol": "波兰语",
        "pon": "波纳佩语",
        "por": "葡萄牙语",
        "pro": "普罗旺斯语（古，至 1500）",
        "pus": "普什图语",
        "que": "克丘亚语",
        "raj": "拉贾斯坦语",
        "rap": "拉帕努伊语",
        "rar": "拉罗汤加语",
        "roh": "罗曼什语",
        "rom": "罗姆语",
        "ron": "罗马尼亚语",
        "run": "基隆迪语",
        "rup": "阿罗马尼亚语",
        "rus": "俄语",
        "sad": "桑达韦语",
        "sag": "桑戈语",
        "sah": "雅库特语",
        "sam": "阿拉米语（萨马利亚）",
        "san": "梵语",
        "sas": "萨萨克语",
        "sat": "桑塔利语",
        "scn": "西西里语",
        "sco": "苏格兰语",
        "sel": "塞尔库普语",
        "sga": "爱尔兰语（古，至 900）",
        "shn": "掸语",
        "sid": "锡达莫语",
        "sin": "僧加罗语",
        "slk": "斯洛伐克语",
        "slv": "斯洛文尼亚语",
        "sma": "萨米语（南）",
        "sme": "萨米语（北）",
        "smj": "律勒欧-萨米语",
        "smn": "伊纳里-萨米语",
        "smo": "萨摩亚语",
        "sms": "斯科特-萨米语",
        "sna": "修纳语",
        "snd": "信德语",
        "snk": "索宁克语",
        "sog": "粟特语",
        "som": "索马里语",
        "sot": "索托语（南）",
        "spa": "西班牙语",
        "sqi": "阿尔巴尼亚语",
        "srd": "撒丁语",
        "srn": "苏里南汤加语",
        "srp": "塞尔维亚语",
        "srr": "塞雷尔语",
        "ssw": "斯瓦特语",
        "suk": "苏库马语",
        "sun": "巽他语",
        "sus": "苏苏语",
        "sux": "苏美尔语",
        "swa": "斯瓦希里语族",
        "swe": "瑞典语",
        "syc": "叙利亚语（古典）",
        "syr": "古叙利亚语",
        "tah": "塔希提语",
        "tam": "泰米尔语",
        "tat": "塔塔尔语",
        "tel": "泰卢固语",
        "tem": "滕内语",
        "ter": "特列纳语",
        "tet": "特塔姆语",
        "tgk": "塔吉克语",
        "tgl": "塔加洛语",
        "tha": "泰语",
        "tig": "提格雷语",
        "tir": "提格里尼亚语",
        "tiv": "蒂夫语",
        "tkl": "托克劳语",
        "tlh": "克林贡语",
        "tli": "特林吉特语",
        "tmh": "塔马舍克语",
        "tog": "汤加语 (尼亚萨)",
        "ton": "汤加语（汤加岛）",
        "tpi": "托克皮辛语",
        "tsi": "钦西安语",
        "tsn": "茨瓦纳语",
        "tso": "聪加语",
        "tuk": "土库曼语",
        "tum": "奇图姆布卡语",
        "tur": "土耳其语",
        "tvl": "图瓦卢语",
        "twi": "契维语",
        "tyv": "图瓦语",
        "udm": "乌德穆尔特语",
        "uga": "乌加里特语",
        "uig": "维吾尔语",
        "ukr": "乌克兰语",
        "umb": "翁本杜语",
        "und": "未确定的语言",
        "urd": "乌尔都语",
        "uzb": "乌兹别克语",
        "vai": "瓦伊语",
        "ven": "文达语",
        "vie": "越南语",
        "vol": "沃拉普克语",
        "vot": "沃提克语",
        "wal": "瓦拉莫语",
        "war": "瓦赖语（菲律宾）",
        "was": "瓦肖语",
        "wln": "瓦龙语",
        "wol": "沃洛夫语",
        "xal": "卡尔梅克语",
        "xho": "科萨语",
        "yao": "瑶语",
        "yap": "雅浦语",
        "yid": "依地语",
        "yor": "约鲁巴语",
        "zap": "萨波特克语",
        "zbl": "布利斯符号",
        "zen": "哲纳加语",
        "zha": "壮语",
        "zho": "中文",
        "zul": "祖鲁语",
        "zun": "祖尼语",
        "zxx": "No linguistic content",
        "zza": "扎扎其语"
    },
    "zh_Hant_TW": {
        "abk": "Abkhazian",
        "ace": "亞齊語",
        "ach": "Acoli",
        "ada": "Adangme",
        "ady": "Adyghe",
        "aar": "Afar",
        "afh": "Afrihili",
        "afr": "南非荷蘭文",
        "ain": "愛奴語 ( 日本 )",
        "aka": "Akan",
        "akk": "Akkadian",
        "sqi": "阿爾巴尼亞文",
        "ale": "Aleut",
        "amh": "Amharic",
        "anp": "Angika",
        "ara": "阿拉伯",
        "arg": "Aragonese",
        "arp": "Arapaho",
        "arw": "Arawak",
        "hye": "Armenian",
        "asm": "Assamese",
        "ast": "Asturian",
        "ava": "Avaric",
        "ave": "Avestan",
        "awa": "Awadhi",
        "aym": "Aymara",
        "aze": "亞塞拜疆文",
        "ban": "Balinese",
        "bal": "Baluchi",
        "bam": "Bambara",
        "bas": "Basa (Cameroon)",
        "bak": "Bashkir",
        "eus": "巴斯克文",
        "bej": "Beja",
        "bel": "白俄羅斯文",
        "bem": "Bemba (Zambia)",
        "ben": "Bengali",
        "bit": "Berinomo",
        "bho": "Bhojpuri",
        "bik": "Bikol",
        "byn": "Bilin",
        "bin": "Bini",
        "bis": "Bislama",
        "zbl": "布利斯符號",
        "bos": "Bosnian",
        "bra": "Braj",
        "bre": "布列塔尼文",
        "bug": "Buginese",
        "bul": "保加利亞文",
        "bua": "Buriat",
        "mya": "Burmese",
        "cad": "Caddo",
        "cat": "加泰隆文",
        "ceb": "Cebuano",
        "chg": "Chagatai",
        "cha": "Chamorro",
        "che": "Chechen",
        "chr": "Cherokee",
        "chy": "Cheyenne",
        "chb": "Chibcha",
        "zho": "中文",
        "chn": "Chinook jargon",
        "chp": "Chipewyan",
        "cho": "Choctaw",
        "cht": "Cholón",
        "chk": "Chuukese",
        "chv": "Chuvash",
        "cop": "Coptic",
        "cor": "Cornish",
        "cos": "Corsican",
        "cre": "Cree",
        "mus": "Creek",
        "hrv": "克羅地亞文",
        "ces": "捷克文",
        "dak": "Dakota",
        "dan": "丹麥文",
        "dar": "Dargwa",
        "del": "Delaware",
        "div": "Dhivehi",
        "din": "Dinka",
        "doi": "Dogri (macrolanguage)",
        "dgr": "Dogrib",
        "dua": "Duala",
        "nld": "荷蘭文",
        "dse": "Dutch Sign Language",
        "dyu": "Dyula",
        "dzo": "Dzongkha",
        "efi": "Efik",
        "egy": "Egyptian (Ancient)",
        "eka": "Ekajuk",
        "elx": "Elamite",
        "eng": "英文",
        "enu": "Enu",
        "myv": "Erzya",
        "epo": "世界語",
        "est": "愛沙尼亞文",
        "ewe": "Ewe",
        "ewo": "Ewondo",
        "fan": "Fang (Equatorial Guinea)",
        "fat": "Fanti",
        "fao": "法羅文",
        "fij": "Fijian",
        "fil": "Filipino",
        "fin": "芬蘭文",
        "fon": "Fon",
        "fra": "法文",
        "fur": "Friulian",
        "ful": "Fulah",
        "gaa": "Ga",
        "glg": "Galician",
        "lug": "Ganda",
        "gay": "Gayo",
        "gba": "Gbaya (Central African Republic)",
        "hmj": "Ge",
        "gez": "Geez",
        "kat": "Georgian",
        "deu": "德文",
        "gil": "Gilbertese",
        "gon": "Gondi",
        "gor": "Gorontalo",
        "got": "Gothic",
        "grb": "Grebo",
        "grn": "Guarani",
        "guj": "古吉拉特語",
        "gwi": "Gwichʼin",
        "hai": "Haida",
        "hau": "Hausa",
        "haw": "Hawaiian",
        "heb": "希伯來",
        "her": "Herero",
        "hil": "Hiligaynon",
        "hin": "Hindi",
        "hmo": "Hiri Motu",
        "hit": "Hittite",
        "hmn": "Hmong",
        "hun": "匈牙利文",
        "hup": "Hupa",
        "iba": "Iban",
        "isl": "冰島文",
        "ido": "Ido",
        "ibo": "Igbo",
        "ilo": "Iloko",
        "ind": "印尼文",
        "inh": "Ingush",
        "ina": "Interlingua (International Auxiliary Language Association)",
        "ile": "Interlingue",
        "iku": "Inuktitut",
        "ipk": "Inupiaq",
        "gle": "愛爾蘭文",
        "ita": "意大利文",
        "jpn": "日本",
        "jav": "Javanese",
        "jrb": "Judeo-Arabic",
        "jpr": "Judeo-Persian",
        "kbd": "Kabardian",
        "kab": "Kabyle",
        "kac": "Kachin",
        "kal": "Kalaallisut",
        "xal": "Kalmyk",
        "kam": "Kamba (Kenya)",
        "kan": "Kannada",
        "kau": "Kanuri",
        "kaa": "Kara-Kalpak",
        "krc": "Karachay-Balkar",
        "krl": "Karelian",
        "kas": "Kashmiri",
        "csb": "Kashubian",
        "kaw": "Kawi",
        "kaz": "Kazakh",
        "kha": "Khasi",
        "kho": "Khotanese",
        "kik": "Kikuyu",
        "kmb": "Kimbundu",
        "kin": "Kinyarwanda",
        "kir": "Kirghiz",
        "tlh": "Klingon",
        "kom": "Komi",
        "kon": "Kongo",
        "kok": "Konkani (macrolanguage)",
        "kor": "韓國",
        "kos": "Kosraean",
        "kpe": "Kpelle",
        "kua": "Kuanyama",
        "kum": "Kumyk",
        "kur": "Kurdish",
        "kru": "Kurukh",
        "kut": "Kutenai",
        "lad": "Ladino",
        "lah": "Lahnda",
        "lam": "Lamba",
        "lao": "Lao",
        "lat": "Latin",
        "lav": "拉脫維亞文",
        "lez": "Lezghian",
        "lim": "Limburgan",
        "lin": "Lingala",
        "lit": "立陶宛文",
        "jbo": "Lojban",
        "loz": "Lozi",
        "lub": "Luba-Katanga",
        "lua": "Luba-Lulua",
        "lui": "Luiseno",
        "smj": "Lule Sami",
        "lun": "Lunda",
        "luo": "Luo (Kenya and Tanzania)",
        "lus": "Lushai",
        "ltz": "Luxembourgish",
        "mkd": "馬其頓文",
        "mad": "Madurese",
        "mag": "Magahi",
        "mai": "Maithili",
        "mak": "Makasar",
        "mlg": "Malagasy",
        "msa": "Malay (macrolanguage)",
        "mal": "Malayalam",
        "mlt": "Maltese",
        "mnc": "Manchu",
        "mdr": "Mandar",
        "man": "Mandingo",
        "mni": "Manipuri",
        "glv": "Manx",
        "mri": "Maori",
        "arn": "Mapudungun",
        "mar": "Marathi",
        "chm": "Mari (Russia)",
        "mah": "Marshallese",
        "mwr": "Marwari",
        "mas": "Masai",
        "men": "Mende (Sierra Leone)",
        "mic": "Mi'kmaq",
        "min": "Minangkabau",
        "mwl": "Mirandese",
        "moh": "Mohawk",
        "mdf": "Moksha",
        "lol": "Mongo",
        "mon": "Mongolian",
        "mos": "Mossi",
        "mul": "Multiple languages",
        "nqo": "N'Ko",
        "nau": "Nauru",
        "nav": "Navajo",
        "ndo": "Ndonga",
        "nap": "Neapolitan",
        "nia": "Nias",
        "niu": "Niuean",
        "zxx": "非語言內容",
        "nog": "Nogai",
        "nor": "挪威文",
        "nob": "Norwegian Bokmål",
        "nno": "Norwegian Nynorsk",
        "nym": "Nyamwezi",
        "nya": "Nyanja",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Occitan (post 1500)",
        "oji": "Ojibwa",
        "orm": "Oromo",
        "osa": "Osage",
        "oss": "Ossetian",
        "pal": "Pahlavi",
        "pau": "Palauan",
        "pli": "Pali",
        "pam": "Pampanga",
        "pag": "Pangasinan",
        "pan": "Panjabi",
        "pap": "Papiamento",
        "fas": "Persian",
        "phn": "Phoenician",
        "pon": "Pohnpeian",
        "pol": "波蘭文",
        "por": "葡萄牙文",
        "pus": "Pashto",
        "que": "Quechua",
        "raj": "Rajasthani",
        "rap": "Rapanui",
        "ron": "羅馬尼亞文",
        "roh": "Romansh",
        "rom": "Romany",
        "run": "Rundi",
        "rus": "俄羅斯文",
        "smo": "Samoan",
        "sad": "Sandawe",
        "sag": "Sango",
        "san": "Sanskrit",
        "sat": "Santali",
        "srd": "Sardinian",
        "sas": "Sasak",
        "sco": "Scots",
        "sel": "Selkup",
        "srp": "塞爾維亞文",
        "srr": "Serer",
        "shn": "Shan",
        "sna": "Shona",
        "scn": "Sicilian",
        "sid": "Sidamo",
        "bla": "Siksika",
        "snd": "Sindhi",
        "sin": "Sinhala",
        "den": "Slave (Athapascan)",
        "slk": "斯洛伐克文",
        "slv": "斯洛文尼亞文",
        "sog": "Sogdian",
        "som": "Somali",
        "snk": "Soninke",
        "spa": "西班牙文",
        "srn": "Sranan Tongo",
        "suk": "Sukuma",
        "sux": "Sumerian",
        "sun": "Sundanese",
        "sus": "Susu",
        "swa": "Swahili (macrolanguage)",
        "ssw": "Swati",
        "swe": "瑞典文",
        "syr": "Syriac",
        "tgl": "Tagalog",
        "tah": "Tahitian",
        "tgk": "Tajik",
        "tmh": "Tamashek",
        "tam": "Tamil",
        "tat": "Tatar",
        "tel": "Telugu",
        "ter": "Tereno",
        "tet": "Tetum",
        "tha": "泰國",
        "bod": "Tibetan",
        "tig": "Tigre",
        "tir": "Tigrinya",
        "tem": "Timne",
        "tiv": "Tiv",
        "tli": "Tlingit",
        "tpi": "Tok Pisin",
        "tkl": "Tokelau",
        "tog": "Tonga (Nyasa)",
        "ton": "Tonga (Tonga Islands)",
        "tsi": "Tsimshian",
        "tso": "Tsonga",
        "tsn": "Tswana",
        "tum": "Tumbuka",
        "tur": "土耳其",
        "tuk": "Turkmen",
        "tvl": "Tuvalu",
        "tyv": "Tuvinian",
        "twi": "Twi",
        "udm": "Udmurt",
        "uga": "Ugaritic",
        "uig": "Uighur",
        "ukr": "烏克蘭語",
        "umb": "Umbundu",
        "mis": "Uncoded languages",
        "und": "Undetermined",
        "urd": "烏爾都語",
        "uzb": "烏茲別克語",
        "vai": "Vai",
        "ven": "文達語",
        "vie": "越南語",
        "vol": "沃拉普克語",
        "vot": "Votic",
        "wln": "瓦隆語",
        "war": "Waray (Philippines)",
        "was": "Washo",
        "cym": "威爾斯語",
        "wal": "Wolaytta",
        "wol": "渥魯夫語",
        "xho": " 科薩語",
        "sah": "Yakut",
        "yao": "Yao",
        "yap": "雅浦語",
        "yid": "意第緒語",
        "yor": "約魯巴語",
        "zap": "薩波特克語",
        "zza": "扎扎其語",
        "zen": " 哲納加語",
        "zha": " 壯語",
        "zul": "祖魯語",
        "zun": "祖尼語"
    },
    "en": {
        "aar": "Afar",
        "abk": "Abkhazian",
        "ace": "Achinese",
        "ach": "Acoli",
        "ada": "Adangme",
        "ady": "Adyghe",
        "afh": "Afrihili",
        "afr": "Afrikaans",
        "ain": "Ainu (Japan)",
        "aka": "Akan",
        "akk": "Akkadian",
        "ale": "Aleut",
        "alt": "Altai; Southern",
        "amh": "Amharic",
        "ang": "English; Old (ca. 450-1100)",
        "anp": "Angika",
        "ara": "Arabic",
        "arc": "Aramaic; Official (700-300 BCE)",
        "arg": "Aragonese",
        "arn": "Mapudungun",
        "arp": "Arapaho",
        "arw": "Arawak",
        "asm": "Assamese",
        "ast": "Asturian",
        "ava": "Avaric",
        "ave": "Avestan",
        "awa": "Awadhi",
        "aym": "Aymara",
        "aze": "Azerbaijani",
        "bak": "Bashkir",
        "bal": "Baluchi",
        "bam": "Bambara",
        "ban": "Balinese",
        "bas": "Basa (Cameroon)",
        "bej": "Beja",
        "bel": "Belarusian",
        "bem": "Bemba (Zambia)",
        "ben": "Bengali",
        "bho": "Bhojpuri",
        "bik": "Bikol",
        "bin": "Bini",
        "bis": "Bislama",
        "bit": "Berinomo",
        "bla": "Siksika",
        "bod": "Tibetan",
        "bos": "Bosnian",
        "bra": "Braj",
        "bre": "Breton",
        "bua": "Buriat",
        "bug": "Buginese",
        "bul": "Bulgarian",
        "byn": "Bilin",
        "cad": "Caddo",
        "car": "Carib; Galibi",
        "cat": "Catalan",
        "ceb": "Cebuano",
        "ces": "Czech",
        "cha": "Chamorro",
        "chb": "Chibcha",
        "che": "Chechen",
        "chg": "Chagatai",
        "chk": "Chuukese",
        "chm": "Mari (Russia)",
        "chn": "Chinook jargon",
        "cho": "Choctaw",
        "chp": "Chipewyan",
        "chr": "Cherokee",
        "cht": "Cholón",
        "chu": "Slavonic; Old",
        "chv": "Chuvash",
        "chy": "Cheyenne",
        "cop": "Coptic",
        "cor": "Cornish",
        "cos": "Corsican",
        "cre": "Cree",
        "crh": "Turkish; Crimean",
        "csb": "Kashubian",
        "csl": "Chinese Sign Language",
        "cym": "Welsh",
        "dak": "Dakota",
        "dan": "Danish",
        "dar": "Dargwa",
        "del": "Delaware",
        "den": "Slave (Athapascan)",
        "deu": "German",
        "dgr": "Dogrib",
        "din": "Dinka",
        "div": "Dhivehi",
        "doi": "Dogri (macrolanguage)",
        "dsb": "Sorbian; Lower",
        "dse": "Dutch Sign Language",
        "dua": "Duala",
        "dum": "Dutch; Middle (ca. 1050-1350)",
        "dyu": "Dyula",
        "dzo": "Dzongkha",
        "efi": "Efik",
        "egy": "Egyptian (Ancient)",
        "eka": "Ekajuk",
        "ell": "Greek; Modern (1453-)",
        "elx": "Elamite",
        "eng": "English",
        "enm": "English; Middle (1100-1500)",
        "enu": "Enu",
        "epo": "Esperanto",
        "est": "Estonian",
        "eus": "Basque",
        "ewe": "Ewe",
        "ewo": "Ewondo",
        "fan": "Fang (Equatorial Guinea)",
        "fao": "Faroese",
        "fas": "Persian",
        "fat": "Fanti",
        "fij": "Fijian",
        "fil": "Filipino",
        "fin": "Finnish",
        "fon": "Fon",
        "fra": "French",
        "frm": "French; Middle (ca. 1400-1600)",
        "fro": "French; Old (842-ca. 1400)",
        "frr": "Frisian; Northern",
        "frs": "Frisian; Eastern",
        "fry": "Frisian; Western",
        "ful": "Fulah",
        "fur": "Friulian",
        "gaa": "Ga",
        "gay": "Gayo",
        "gba": "Gbaya (Central African Republic)",
        "gez": "Geez",
        "gil": "Gilbertese",
        "gla": "Gaelic; Scottish",
        "gle": "Irish",
        "glg": "Galician",
        "glv": "Manx",
        "gmh": "German; Middle High (ca. 1050-1500)",
        "goh": "German; Old High (ca. 750-1050)",
        "gon": "Gondi",
        "gor": "Gorontalo",
        "got": "Gothic",
        "grb": "Grebo",
        "grc": "Greek; Ancient (to 1453)",
        "grn": "Guarani",
        "gsw": "German; Swiss",
        "guj": "Gujarati",
        "gwi": "Gwichʼin",
        "hai": "Haida",
        "hat": "Creole; Haitian",
        "hau": "Hausa",
        "haw": "Hawaiian",
        "heb": "Hebrew",
        "her": "Herero",
        "hil": "Hiligaynon",
        "hin": "Hindi",
        "hit": "Hittite",
        "hmj": "Ge",
        "hmn": "Hmong",
        "hmo": "Hiri Motu",
        "hrv": "Croatian",
        "hsb": "Sorbian; Upper",
        "hun": "Hungarian",
        "hup": "Hupa",
        "hye": "Armenian",
        "iba": "Iban",
        "ibo": "Igbo",
        "ido": "Ido",
        "iii": "Yi; Sichuan",
        "iku": "Inuktitut",
        "ile": "Interlingue",
        "ilo": "Iloko",
        "ina": "Interlingua (International Auxiliary Language Association)",
        "ind": "Indonesian",
        "inh": "Ingush",
        "ipk": "Inupiaq",
        "isl": "Icelandic",
        "ita": "Italian",
        "jav": "Javanese",
        "jbo": "Lojban",
        "jpn": "Japanese",
        "jpr": "Judeo-Persian",
        "jrb": "Judeo-Arabic",
        "kaa": "Kara-Kalpak",
        "kab": "Kabyle",
        "kac": "Kachin",
        "kal": "Kalaallisut",
        "kam": "Kamba (Kenya)",
        "kan": "Kannada",
        "kas": "Kashmiri",
        "kat": "Georgian",
        "kau": "Kanuri",
        "kaw": "Kawi",
        "kaz": "Kazakh",
        "kbd": "Kabardian",
        "kha": "Khasi",
        "khm": "Khmer; Central",
        "kho": "Khotanese",
        "kik": "Kikuyu",
        "kin": "Kinyarwanda",
        "kir": "Kirghiz",
        "kmb": "Kimbundu",
        "kok": "Konkani (macrolanguage)",
        "kom": "Komi",
        "kon": "Kongo",
        "kor": "Korean",
        "kos": "Kosraean",
        "kpe": "Kpelle",
        "krc": "Karachay-Balkar",
        "krl": "Karelian",
        "kru": "Kurukh",
        "kua": "Kuanyama",
        "kum": "Kumyk",
        "kur": "Kurdish",
        "kut": "Kutenai",
        "lad": "Ladino",
        "lah": "Lahnda",
        "lam": "Lamba",
        "lao": "Lao",
        "lat": "Latin",
        "lav": "Latvian",
        "lez": "Lezghian",
        "lim": "Limburgan",
        "lin": "Lingala",
        "lit": "Lithuanian",
        "lol": "Mongo",
        "loz": "Lozi",
        "ltz": "Luxembourgish",
        "lua": "Luba-Lulua",
        "lub": "Luba-Katanga",
        "lug": "Ganda",
        "lui": "Luiseno",
        "lun": "Lunda",
        "luo": "Luo (Kenya and Tanzania)",
        "lus": "Lushai",
        "mad": "Madurese",
        "mag": "Magahi",
        "mah": "Marshallese",
        "mai": "Maithili",
        "mak": "Makasar",
        "mal": "Malayalam",
        "man": "Mandingo",
        "mar": "Marathi",
        "mas": "Masai",
        "mdf": "Moksha",
        "mdr": "Mandar",
        "men": "Mende (Sierra Leone)",
        "mga": "Irish; Middle (900-1200)",
        "mic": "Mi'kmaq",
        "min": "Minangkabau",
        "mis": "Uncoded languages",
        "mkd": "Macedonian",
        "mlg": "Malagasy",
        "mlt": "Maltese",
        "mnc": "Manchu",
        "mni": "Manipuri",
        "moh": "Mohawk",
        "mon": "Mongolian",
        "mos": "Mossi",
        "mri": "Maori",
        "msa": "Malay (macrolanguage)",
        "mul": "Multiple languages",
        "mus": "Creek",
        "mwl": "Mirandese",
        "mwr": "Marwari",
        "mya": "Burmese",
        "myv": "Erzya",
        "nap": "Neapolitan",
        "nau": "Nauru",
        "nav": "Navajo",
        "nbl": "Ndebele; South",
        "nde": "Ndebele; North",
        "ndo": "Ndonga",
        "nds": "German; Low",
        "nep": "Nepali",
        "new": "Bhasa; Nepal",
        "nia": "Nias",
        "niu": "Niuean",
        "nld": "Dutch",
        "nno": "Norwegian Nynorsk",
        "nob": "Norwegian Bokmål",
        "nog": "Nogai",
        "non": "Norse; Old",
        "nor": "Norwegian",
        "nqo": "N'Ko",
        "nso": "Sotho; Northern",
        "nwc": "Newari; Old",
        "nya": "Nyanja",
        "nym": "Nyamwezi",
        "nyn": "Nyankole",
        "nyo": "Nyoro",
        "nzi": "Nzima",
        "oci": "Occitan (post 1500)",
        "oji": "Ojibwa",
        "ori": "Oriya",
        "orm": "Oromo",
        "osa": "Osage",
        "oss": "Ossetian",
        "ota": "Turkish; Ottoman (1500-1928)",
        "pag": "Pangasinan",
        "pal": "Pahlavi",
        "pam": "Pampanga",
        "pan": "Panjabi",
        "pap": "Papiamento",
        "pau": "Palauan",
        "peo": "Persian; Old (ca. 600-400 B.C.)",
        "phn": "Phoenician",
        "pli": "Pali",
        "pol": "Polish",
        "pon": "Pohnpeian",
        "por": "Portuguese",
        "pro": "Provençal; Old (to 1500)",
        "pus": "Pashto",
        "que": "Quechua",
        "raj": "Rajasthani",
        "rap": "Rapanui",
        "rar": "Maori; Cook Islands",
        "roh": "Romansh",
        "rom": "Romany",
        "ron": "Romanian",
        "run": "Rundi",
        "rup": "Romanian; Macedo-",
        "rus": "Russian",
        "sad": "Sandawe",
        "sag": "Sango",
        "sah": "Yakut",
        "sam": "Aramaic; Samaritan",
        "san": "Sanskrit",
        "sas": "Sasak",
        "sat": "Santali",
        "scn": "Sicilian",
        "sco": "Scots",
        "sel": "Selkup",
        "sga": "Irish; Old (to 900)",
        "shn": "Shan",
        "sid": "Sidamo",
        "sin": "Sinhala",
        "slk": "Slovak",
        "slv": "Slovenian",
        "sma": "Sami; Southern",
        "sme": "Sami; Northern",
        "smj": "Lule Sami",
        "smn": "Sami; Inari",
        "smo": "Samoan",
        "sms": "Sami; Skolt",
        "sna": "Shona",
        "snd": "Sindhi",
        "snk": "Soninke",
        "sog": "Sogdian",
        "som": "Somali",
        "sot": "Sotho; Southern",
        "spa": "Spanish",
        "sqi": "Albanian",
        "srd": "Sardinian",
        "srn": "Sranan Tongo",
        "srp": "Serbian",
        "srr": "Serer",
        "ssw": "Swati",
        "suk": "Sukuma",
        "sun": "Sundanese",
        "sus": "Susu",
        "sux": "Sumerian",
        "swa": "Swahili (macrolanguage)",
        "swe": "Swedish",
        "syc": "Syriac; Classical",
        "syr": "Syriac",
        "tah": "Tahitian",
        "tam": "Tamil",
        "tat": "Tatar",
        "tel": "Telugu",
        "tem": "Timne",
        "ter": "Tereno",
        "tet": "Tetum",
        "tgk": "Tajik",
        "tgl": "Tagalog",
        "tha": "Thai",
        "tig": "Tigre",
        "tir": "Tigrinya",
        "tiv": "Tiv",
        "tkl": "Tokelau",
        "tlh": "Klingon",
        "tli": "Tlingit",
        "tmh": "Tamashek",
        "tog": "Tonga (Nyasa)",
        "ton": "Tonga (Tonga Islands)",
        "tpi": "Tok Pisin",
        "tsi": "Tsimshian",
        "tsn": "Tswana",
        "tso": "Tsonga",
        "tuk": "Turkmen",
        "tum": "Tumbuka",
        "tur": "Turkish",
        "tvl": "Tuvalu",
        "twi": "Twi",
        "tyv": "Tuvinian",
        "udm": "Udmurt",
        "uga": "Ugaritic",
        "uig": "Uighur",
        "ukr": "Ukrainian",
        "umb": "Umbundu",
        "und": "Undetermined",
        "urd": "Urdu",
        "uzb": "Uzbek",
        "vai": "Vai",
        "ven": "Venda",
        "vie": "Vietnamese",
        "vol": "Volapük",
        "vot": "Votic",
        "wal": "Wolaytta",
        "war": "Waray (Philippines)",
        "was": "Washo",
        "wln": "Walloon",
        "wol": "Wolof",
        "xal": "Kalmyk",
        "xho": "Xhosa",
        "yao": "Yao",
        "yap": "Yapese",
        "yid": "Yiddish",
        "yor": "Yoruba",
        "zap": "Zapotec",
        "zbl": "Blissymbols",
        "zen": "Zenaga",
        "zha": "Zhuang",
        "zho": "Chinese",
        "zul": "Zulu",
        "zun": "Zuni",
        "zxx": "No linguistic content",
        "zza": "Zaza"
    }
}