/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.swt;

import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.swt.SWTApplication;
import com.sun.glass.ui.swt.SWTCursor;
import com.sun.glass.ui.swt.SWTView;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

final class SWTWindow
extends Window {
    Shell shell;
    static SWTWindow focusWindow;

    protected SWTWindow(Window window, Screen screen, int n) {
        super(window, screen, n);
    }

    protected SWTWindow(long l) {
        super(l);
    }

    @Override
    protected long _createWindow(long l, long l2, int n) {
        Shell shell;
        int n2 = 0x140000;
        if ((n & 1) != 0) {
            if ((n & 0x10) != 0) {
                n2 |= 0x40;
            }
            if ((n & 0x20) != 0) {
                n2 |= 0x80;
            }
            if ((n & 0x40) != 0) {
                n2 |= 0x400;
            }
            n2 |= 0x10;
        } else {
            n2 |= 0x80008;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 8) != 0) {
            n2 |= 4;
        }
        if ((n & 0x80) != 0) {
            n2 |= 0x4000000;
        }
        this.shell = (shell = (Shell)SWTApplication.findWidget(l)) != null ? new Shell(shell, n2) : new Shell(Display.getDefault(), n2);
        if ((n & 2) != 0) {
            this.shell.setData("transparent", (Object)true);
        }
        int[] nArray = new int[]{26, 21, 27, 19, 20, 10, 11, 12};
        Listener listener = event -> this.handleShellEvent(event);
        for (int i = 0; i < nArray.length; ++i) {
            this.shell.addListener(nArray[i], listener);
        }
        this.shell.setData((Object)this);
        return SWTApplication.getHandle(this.shell);
    }

    void handleShellEvent(Event event) {
        switch (event.type) {
            case 26: {
                this.notifyFocus(542);
                break;
            }
            case 27: {
                if (focusWindow != null) break;
                this.notifyFocus(541);
                break;
            }
            case 19: {
                Rectangle rectangle = this.shell.getBounds();
                this.notifyResize(531, rectangle.width, rectangle.height);
                break;
            }
            case 20: {
                Rectangle rectangle = this.shell.getBounds();
                this.notifyResize(533, rectangle.width, rectangle.height);
                break;
            }
            case 10: {
                Rectangle rectangle = this.shell.getBounds();
                Rectangle rectangle2 = this.shell.computeTrim(0, 0, rectangle.width, rectangle.height);
                this.notifyMove(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y);
                break;
            }
            case 11: {
                Rectangle rectangle = this.shell.getBounds();
                this.notifyResize(511, rectangle.width, rectangle.height);
                Rectangle rectangle3 = this.shell.getClientArea();
                Control[] controlArray = this.shell.getChildren();
                for (int i = 0; i < controlArray.length; ++i) {
                    controlArray[i].setBounds(rectangle3);
                }
                break;
            }
            case 21: {
                this.notifyClose();
                event.doit = false;
                break;
            }
            case 12: {
                Image image = this.shell.getImage();
                if (image != null) {
                    this.shell.setImage(null);
                    image.dispose();
                }
                this.notifyDestroy();
                break;
            }
        }
    }

    @Override
    protected long _createChildWindow(long l) {
        return this._createWindow(l, 0L, 0);
    }

    @Override
    protected boolean _close(long l) {
        this.shell.dispose();
        return true;
    }

    @Override
    protected boolean _setView(long l, View view) {
        if (view == null) {
            return true;
        }
        Canvas canvas = ((SWTView)view).canvas;
        boolean bl = canvas.setParent((Composite)this.shell);
        if (bl) {
            canvas.setBounds(canvas.getParent().getClientArea());
            if (this.shell.getData("transparent") != null) {
                SWTApplication.setTransparent(this.shell);
            }
        }
        return bl;
    }

    @Override
    protected void _setBounds(long l, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, float f, float f2) {
        this.shell.getDisplay().syncExec(() -> {
            Rectangle rectangle = this.shell.getBounds();
            if (bl) {
                rectangle.x = n;
            }
            if (bl2) {
                rectangle.y = n2;
            }
            boolean bl3 = false;
            boolean bl4 = false;
            if (n3 != -1) {
                bl4 = true;
                rectangle.width = n3;
            } else if (n5 != -1) {
                bl4 = true;
                rectangle.width = n5;
            }
            if (n4 != -1) {
                bl3 = true;
                rectangle.height = n4;
            } else if (n6 != -1) {
                bl3 = true;
                rectangle.height = n6;
            }
            if (bl4 || bl3) {
                Rectangle rectangle2 = this.shell.computeTrim(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.shell.setBounds(rectangle.x, rectangle.y, rectangle2.width, rectangle2.height);
            } else {
                this.shell.setLocation(rectangle.x, rectangle.y);
            }
        });
    }

    @Override
    protected boolean _setMenubar(long l, long l2) {
        return true;
    }

    @Override
    protected boolean _minimize(long l, boolean bl) {
        this.shell.setMinimized(bl);
        return this.shell.getMinimized();
    }

    @Override
    protected boolean _maximize(long l, boolean bl, boolean bl2) {
        this.shell.setMaximized(bl);
        return this.shell.getMaximized();
    }

    @Override
    protected boolean _setVisible(long l, boolean bl) {
        this.shell.getDisplay().syncExec(() -> {
            if ((this.shell.getStyle() & 0x80000) != 0) {
                this.shell.setVisible(bl);
            } else if (bl) {
                this.shell.open();
                this.shell.setFocus();
            } else {
                this.shell.setVisible(false);
            }
        });
        return true;
    }

    @Override
    protected boolean _setResizable(long l, boolean bl) {
        return true;
    }

    @Override
    protected boolean _requestFocus(long l, int n) {
        this.shell.setFocus();
        return true;
    }

    @Override
    protected void _setFocusable(long l, boolean bl) {
    }

    @Override
    protected boolean _setTitle(long l, String string) {
        this.shell.setText(string);
        return true;
    }

    @Override
    protected void _setLevel(long l, int n) {
    }

    @Override
    protected void _setAlpha(long l, float f) {
        this.shell.setAlpha((int)(f * 255.0f));
    }

    @Override
    protected boolean _setBackground(long l, float f, float f2, float f3) {
        return true;
    }

    @Override
    protected void _setEnabled(long l, boolean bl) {
        this.shell.setEnabled(bl);
    }

    @Override
    protected boolean _setMinimumSize(long l, int n, int n2) {
        Point point = new Point(n, n2);
        this.shell.setMinimumSize(point);
        return point.equals((Object)this.shell.getMinimumSize());
    }

    @Override
    protected boolean _setMaximumSize(long l, int n, int n2) {
        return false;
    }

    @Override
    protected void _setIcon(long l, Pixels pixels) {
        Image image = this.shell.getImage();
        Image image2 = SWTApplication.createImage(pixels);
        this.shell.setImage(image2);
        if (image != null) {
            image.dispose();
        }
    }

    @Override
    protected void _toFront(long l) {
        this.shell.moveAbove(null);
    }

    @Override
    protected void _toBack(long l) {
        this.shell.moveBelow(null);
    }

    @Override
    protected void _enterModal(long l) {
    }

    @Override
    protected void _enterModalWithWindow(long l, long l2) {
    }

    @Override
    protected void _exitModal(long l) {
    }

    @Override
    protected boolean _grabFocus(long l) {
        focusWindow = this;
        return true;
    }

    @Override
    protected void _ungrabFocus(long l) {
        focusWindow = null;
    }

    @Override
    protected void _setCursor(long l, Cursor cursor) {
        Display display;
        int n = 0;
        switch (cursor.getType()) {
            case 1: {
                this.shell.setCursor(null);
                return;
            }
            case 3: {
                n = 2;
                break;
            }
            case 2: {
                n = 19;
                break;
            }
            case 14: {
                n = 1;
                break;
            }
            case 15: {
                n = 16;
                break;
            }
            case 16: {
                n = 15;
                break;
            }
            case 17: {
                n = 17;
                break;
            }
            case 18: {
                n = 14;
                break;
            }
            case 9: {
                n = 10;
                break;
            }
            case 10: {
                n = 11;
                break;
            }
            case 7: {
                n = 13;
                break;
            }
            case 8: {
                n = 12;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n = 21;
                break;
            }
            case 19: {
                n = 5;
                break;
            }
            case 13: {
                break;
            }
            case 11: {
                n = 9;
                break;
            }
            case 12: {
                n = 7;
                break;
            }
            case -1: {
                break;
            }
            case 0: {
                display = ((SWTCursor)cursor).cursor;
                if (display == null) break;
                this.shell.setCursor((org.eclipse.swt.graphics.Cursor)display);
                return;
            }
        }
        display = Display.getDefault();
        org.eclipse.swt.graphics.Cursor cursor2 = display.getSystemCursor(n);
        this.shell.setCursor(cursor2);
    }

    @Override
    protected native void _requestInput(long var1, String var3, int var4, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23, double var25, double var27, double var29, double var31);

    @Override
    protected native void _releaseInput(long var1);

    @Override
    protected int _getEmbeddedX(long l) {
        return 0;
    }

    @Override
    protected int _getEmbeddedY(long l) {
        return 0;
    }
}

